<?php 
$obj_resident = new MJ_amgt_ResidentialUnit();
if($obj_apartment->role=='member')
{
	$member_id = wp_get_current_user();
	$building_id = $member_id->building_id;
	$result=$obj_resident->MJ_amgt_member_by_building_id($building_id);
}else
{
	$result=$obj_resident->MJ_amgt_member_by_building();
}
$chart_array = array();
$chart_array[] = array(esc_html__('Building Name','apartment_mgt'),esc_html__('Number Of Member','apartment_mgt'));
foreach($result as $r)
{
	$chart_array[]=array( get_the_title($r['building_id']),(int)$r['no_of_member']);
}

 $options = Array(
			'title' => esc_html__('Member in Building','apartment_mgt'),
			'titleTextStyle' => Array('color' => '#66707e','fontSize' => 14,'bold'=>true,'italic'=>false,'fontName' =>'open sans'),
			'legend' =>Array('position' => 'right',
						'textStyle'=> Array('color' => '#66707e','fontSize' => 14,'bold'=>true,'italic'=>false,'fontName' =>'open sans')),
			
			'hAxis' => Array(
				'title' => esc_html__('Building Name','apartment_mgt'),
				'titleTextStyle' => Array('color' => '#66707e','fontSize' => 14,'bold'=>true,'italic'=>false,'fontName' =>'open sans'),
				'textStyle' => Array('color' => '#66707e','fontSize' => 11),
				'maxAlternation' => 2
				),
			'vAxis' => Array(
				'title' => esc_html__('Number Of Member','apartment_mgt'),
				 'minValue' => 0,
				'maxValue' => 5,
				 'format' => '#',
				'titleTextStyle' => Array('color' => '#66707e','fontSize' => 14,'bold'=>true,'italic'=>false,'fontName' =>'open sans'),
				'textStyle' => Array('color' => '#66707e','fontSize' => 12)
				),
 		    'colors' => array('#104B73')
			);
			require_once AMS_PLUGIN_DIR. '/lib/chart/GoogleCharts.class.php';

			$GoogleCharts = new GoogleCharts;

			$chart = $GoogleCharts->load( 'column' , 'chart_div' )->get( $chart_array , $options );
           ?>
		   
		 <?php if(empty($result))
		{?>
		<div class="nodata">
		
		  <?php  esc_html_e('Records Not Found','apartment_mgt');?>
		</div>
		<?php } ?>
		   
 <!-- <div id="chart_div" class="width_100_height_500"></div> -->
 <!-- Javascript --> 
    <script type="text/javascript">
		<?php if(!empty($result))
		{
			echo $chart;
		}?>
    </script>
<div class="page-inner min_height_1088"><!-- PAGE-INNER -->
	<div id="" class="ams_main_list"><!--MAIN-WRAPPER-->	
		<div class="row">
			<div class="padding_left_8px"><!--PANEL-WHITE-->
				<div class="panel-body padding_0"><!--PANEL BODY-->
					<!--NAV TAB WRAPPER -->
					<!-- <h2 class="nav-tab-wrapper report-tab"> -->
					<ul class="nav nav-tabs amgt_report_tab panel_tabs margin_left_1per list-unstyled mailbox-nav  flex-nowrap overflow-auto">
						<li <?php if(isset($_REQUEST['tab_1']) && $_REQUEST['tab_1'] == 'graph'){?>class="active"<?php }?>>
							<a href="?apartment-dashboard=user&page=report&tab=member_by_building&tab_1=graph" class="padding_left_0 tab  <?php echo esc_html($active_tab) == 'unit_by_building' ? 'nav-tab-active' : ''; ?>">
								<?php echo esc_html__('Graph', 'apartment_mgt'); ?>
							</a>
						<li>
						<li <?php if(isset($_REQUEST['tab_1']) && $_REQUEST['tab_1'] == 'datatable'){?>class="active"<?php }?>>
							<a href="?apartment-dashboard=user&page=report&tab=member_by_building&tab_1=datatable" class="padding_left_0 tab <?php echo esc_html($active_tab) == 'member_by_building' ? 'nav-tab-active' : ''; ?>">
								<?php echo esc_html__('Datatable', 'apartment_mgt'); ?>
							</a>
						<li>
					</ul> <!--END NAV TAB WRAPPER -->
					<script type="text/javascript" src=	"https://www.google.com/jsapi"></script> 
					<?php 
						require_once AMS_PLUGIN_DIR. '/lib/chart/GoogleCharts.class.php';	
						require_once AMS_PLUGIN_DIR.'/template/report/'.$active_tab.'.php';
					
						if(isset($_REQUEST['tab_1']) && $_REQUEST['tab_1'] == 'graph'){
							?>
 								<div id="chart_div" class="width_100_height_500"></div>

							<?php
						}
						if(isset($_REQUEST['tab_1']) && $_REQUEST['tab_1'] == 'datatable'){
							?>
							<script type="text/javascript">
								$(document).ready(function() 
								{   //MEMBER FORM VALIDATIONENGINE
									"use strict";
									<?php
									if (is_rtl())
									{
										?>	
										$('#ams_building_member').validationEngine({promptPosition : "bottomLeft",maxErrorsPerField: 1});
										<?php
									}
									else
									{
										?>
										$('#ams_building_member').validationEngine({promptPosition : "bottomLeft",maxErrorsPerField: 1});
										<?php
									}
									?>
									} );

							</script>
 							<form method="post" id="ams_building_member">  
								<div class="form-body user_form margin_top_20px padding_left_8px">
									<div class="row res_margin_top_20px">
										<div class="col-md-3 mb-3 input">
											<label class="ml-1 custom-top-label top" for="class_id"><?php esc_attr_e('Building','apartment_mgt');?><span class="require-field">*</span></label>			
												<select class="line_height_30px form-control date_type validate[required]" name="building_id" autocomplete="off">
													<option value=""><?php esc_html_e('Select Building','apartment_mgt');?></option>
													<?php 
													if($edit)
														$category =$result->building_id;
													elseif(isset($_REQUEST['building_id']))
														$category =$_REQUEST['building_id']; 
													elseif($obj_apartment->role=='member')
													{
														$member_id = wp_get_current_user();
														$category = $member_id->building_id;
													}
													else 
														$category = "";
													
													$activity_category=MJ_amgt_get_all_category('building_category');
												
													if(!empty($activity_category))
													{
														foreach ($activity_category as $retrive_data)
														{
															if($obj_apartment->role =='member')
															{
																$member_id = wp_get_current_user();
																$category = $member_id->building_id;
																if($category == $retrive_data->ID)
																{
																	echo '<option value="'.$retrive_data->ID.'" '.selected($category,$retrive_data->ID).'>'.$retrive_data->post_title.'</option>';
																}
															}else{
																echo '<option value="'.$retrive_data->ID.'" '.selected($category,$retrive_data->ID).'>'.$retrive_data->post_title.'</option>';
															}
														}
													} ?>
												</select>
										</div>
										<div class="col-md-3 mb-2">
											<input type="submit" name="building_member" Value="<?php esc_attr_e('Go','apartment_mgt');?>"  class="btn btn-info save_btn"/>
										</div>
									</div>
								</div>
							</form> 	

							<?php 
							//------------- export Member in csv ---------------//
							if(isset($_POST['export_csv']))
							{		
								foreach($_POST['selected_id'] as $m_id)
								{
									$member_list[] = get_userdata($m_id);
								}

								if(!empty($member_list))
								{
									$header = array();	
									$header[] = 'username';
									$header[] = 'email';
									$header[] = 'password';
									$header[] = 'building_name';
									$header[] = 'unit_category';			
									$header[] = 'unit_name';
									$header[] = 'first_name';
									$header[] = 'middle_name';
									$header[] = 'last_name';			
									$header[] = 'gender';
									$header[] = 'birth_date';
									$header[] = 'member_type';
									$header[] = 'occupied_date';
									$header[] = 'display_name';
									$header[] = 'address';
									$header[] = 'city_name';
									$header[] = 'state_name';
									$header[] = 'country_name';
									$header[] = 'zipcode';
									$header[] = 'mobile';
								
									
									
									$document_dir = WP_CONTENT_DIR;
									$document_dir .= '/uploads/export/';
									$document_path = $document_dir;
									if (!file_exists($document_path))
									{
										mkdir($document_path, 0777, true);		
									}
									
									$filename=$document_path.'export_member.csv';
									$fh = fopen($filename, 'w') or die("can't open file");
									fputcsv($fh, $header);
									foreach($member_list as $retrive_data)
									{
										$row = array();
										$user_info = get_userdata($retrive_data->ID);
									
										$building_id   = get_post($user_info->building_id); 
										$unit_id   = get_post($user_info->unit_cat_id);
									
										$row[] = $user_info->user_login;
										$row[] = $user_info->user_email;			
										$row[] = $user_info->user_pass;	
										$row[] = $building_id->post_title;
										$row[] = $unit_id->post_title;
										$row[] =  get_user_meta($retrive_data->ID, 'unit_name',true);
										$row[] =  get_user_meta($retrive_data->ID, 'first_name',true);
										$row[] =  get_user_meta($retrive_data->ID, 'middle_name',true);
										$row[] =  get_user_meta($retrive_data->ID, 'last_name',true);
										$row[] =  get_user_meta($retrive_data->ID, 'gender',true);
										$row[] =  get_user_meta($retrive_data->ID, 'birth_date',true);	
										$row[] =$user_info->member_type;
										$row[] =$user_info->occupied_date;
										$row[] = $user_info->display_name;
										// $row[] =  get_user_meta($retrive_data->ID, 'display_name',true);							
										$row[] =  get_user_meta($retrive_data->ID, 'address',true);				
										$row[] =  get_user_meta($retrive_data->ID, 'city_name',true);				
										$row[] =  get_user_meta($retrive_data->ID, 'state_name',true);				
										$row[] =  get_user_meta($retrive_data->ID, 'country_name',true);
										$row[] =$user_info->zipcode;
										$row[] =$user_info->mobile;				
																	
										fputcsv($fh, $row);
										
									}
									fclose($fh);

									//download csv file.
									ob_clean();
									$file=$document_path.'export_member.csv';//file location
									
									$mime = 'text/plain';
									header('Content-Type:application/force-download');
									header('Pragma: public');       // required
									header('Expires: 0');           // no cache
									header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
									header('Last-Modified: '.gmdate ('D, d M Y H:i:s', filemtime ($file)).' GMT');
									header('Cache-Control: private',false);
									header('Content-Type: '.$mime);
									header('Content-Disposition: attachment; filename="'.basename($file).'"');
									header('Content-Transfer-Encoding: binary');			
									header('Connection: close');
									readfile($file);		
									exit;				
								}
								else
								{
									?>
									<div id="message" class="updated below-h2 notice is-dismissible">
										<p>
										<?php esc_html_e('Records not found.','apartment_mgt');?>
										</p>
									</div>
									
									<?php	
								}		
							}

							if(isset($_POST['building_id'])){
								$building_id = $_POST['building_id'];
							}
							if(!empty($building_id)){
								$get_members = array('role' => 'member','meta_key' => 'building_id','meta_value'=> $building_id);
								$membersdata=get_users($get_members);
							}
							
							
							if(!empty($building_id))
							{
								?>
								<script type="text/javascript">
									$(document).ready(function() 
									{
										"use strict";
										var table = jQuery('#member_list').DataTable(
										{
											// "responsive":true,
											"order": [[ 1, "DESC" ]],
											dom: 'lifrtp',
											buttons:[
												{
													extend: 'csv',
													text:'<?php esc_html_e('CSV', 'apartment_mgt') ?>',
													title: '<?php esc_html_e('Member By Building Report', 'apartment_mgt') ?>',
													charset: 'UTF-8',
													bom: true,
												},
												{
													extend: 'print',
													text:'<?php esc_html_e('Print', 'apartment_mgt') ?>',
													title: '<?php esc_html_e('Member By Building Report', 'apartment_mgt') ?>',
												},
											],
											"aoColumns":[
														{"bSortable": true},
														{"bSortable": true},
														{"bSortable": true},
														{"bSortable": true},
														{"bSortable": true}
													],
														language:<?php echo MJ_amgt_datatable_multi_language();?>,
														responsive: {
															details: {
																display: $.fn.dataTable.Responsive.display.modal({
																	header: function (row) {
																		var data = row.data();
																		return 'Details for ' + data[1];
																	}
																}),
																renderer: $.fn.dataTable.Responsive.renderer.tableAll()
															}
														}
														
										});
										$('.btn-place').html(table.buttons().container()); 
										$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'apartment_mgt') ?>");
										$("#delete_selected_member").on('click', function()
										{	
											
											if ($('.select-checkbox:checked').length == 0 )
											{
												alert(language_translate.select_atleast_one_record);
												return false;
											}
											else
											{
												var alert_msg=confirm("<?php esc_html_e('Are you sure you want to delete this record?', 'apartment_mgt') ?>");
												if(alert_msg == false)
												{
													return false;
												}
												else
												{
													return true;
												}
											}
										});
										$('.select_all').on('click', function(e)
										{
												if($(this).is(':checked',true))  
												{
													$(".sub_chk").prop('checked', true); 
													$(".select_all").prop('checked', true);													
												}  
												else  
												{  
													$(".sub_chk").prop('checked',false); 
													$(".select_all").prop('checked', false);													
												} 
										});
										$('.sub_chk').on('change',function()
										{ 
											if(false == $(this).prop("checked"))
											{ 
												$(".select_all").prop('checked', false); 
											}
											if ($('.sub_chk:checked').length == $('.sub_chk').length )
											{
												$(".select_all").prop('checked', true);
											}
										});
									} );
								</script>
								<div class="panel-body padding_top_15px_res"> <!------  penal body  -------->
									<div class="btn-place"></div>
									<!-- <div class="table-responsive overflow_unset"> ----  table Responsive  ------ -->
										<form name="member_form" action="" method="post"><!--MEMBER FORM-->
											<div class="panel-body padding_0"><!--PANEL BODY-->
												<div class="table-responsive"><!---TABLE-RESPONSIVE--->
													<table id="member_list" class="display" cellspacing="0" width="100%">
														<thead class="<?php echo MJ_amgt_datatable_heder(); ?>">
															<tr>
																<th><?php esc_html_e('Name & Email ID', 'apartment_mgt' ) ;?></th>
																<th><?php esc_html_e('Member Type', 'apartment_mgt' ) ;?></th>
																<th><?php esc_html_e('Building Name', 'apartment_mgt' ) ;?></th>
																<th><?php esc_html_e('Unit Name', 'apartment_mgt' ) ;?></th>
																<th> <?php esc_html_e('Mobile No.', 'apartment_mgt' ) ;?></th>
															</tr>
														</thead>
														<tfoot>
															<tr>
																<th><?php esc_html_e('Name & Email ID', 'apartment_mgt' ) ;?></th>
																<th><?php esc_html_e('Member Type', 'apartment_mgt' ) ;?></th>
																<th><?php esc_html_e('Building Name', 'apartment_mgt' ) ;?></th>
																<th><?php esc_html_e('Unit Name', 'apartment_mgt' ) ;?></th>
																<th> <?php esc_html_e('Mobile No.', 'apartment_mgt' ) ;?></th>
															</tr>
															
														</tfoot>
														<tbody>
															<?php 
															if(!empty($membersdata))
															{
																foreach ($membersdata as $retrieved_data)
																{
																	$building_name=get_the_title($retrieved_data->building_id);
																	$role=MJ_amgt_get_user_role($retrieved_data->ID);
																	if($role == 'member')
																	{
																		$page='member';
																	}
																	
																	?>
																	<tr>
																		<?php
																		$data_member_id = Mj_amgt_retrived_data_id($retrieved_data->ID);
																		$view_action = mj_amgt_create_and_verify_nonce('view');
																		?>
																		<td class="name">
																			<a class="color_black" href="?apartment-dashboard=user&page=member&tab=viewmember&action=view&member_id=<?php echo esc_attr($data_member_id); ?>&_wpnonce=<?php echo $view_action; ?>">
																				<?php echo esc_html($retrieved_data->display_name); ?>
																			</a><br>
																			<label class="list_page_email"><?php echo $retrieved_data->user_email;?></label>
																		</td>
																		<td class="bnumber">
																			<?php 
																			if(!empty($retrieved_data->member_type))
																			{
																				echo esc_html(MJ_amgt_get_member_status_label($retrieved_data->member_type));
																			}
																			else
																			{
																				echo "N/A";
																			}
																			?></td> 
																		<td class="activitydate"><?php echo esc_html($building_name);?></td>
																		<td class="activitydate">
																			<?php if(!empty($retrieved_data->unit_name)){ echo MJ_amgt_get_member_assing_unit_name($retrieved_data->unit_name); }else{ echo "N/A"; } ?></td>
																		<td class="">+<?php echo MJ_amgt_get_countery_phonecode(get_option( 'amgt_contry' ));?> <?php echo esc_html($retrieved_data->mobile);?> </td>  
																	</tr>
																	<?php
																} 
															}
															?>
														</tbody>
													</table>
												</div>
											</div><!--END PANEL BODY-->
										</form><!--END MEMBER FORM-->
									<!-- </div> ----  table responsive  ------ -->
								</div> <!------  penal body  -------->
								<?php
							}
							else
							{
								?>
								<div class="calendar-event-new"> 
									<img class="no_data_img" src="<?php echo AMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
								</div>	
								<?php
							}
						}
					?>
				</div><!--END PANEL BODY-->
			</div><!--END PANEL-WHITE-->
        </div><!--END row Div-->	
    </div><!--END MAIN WRAPPER-->
</div><!--END  PAGE INNER DIV -->