<?php
$document_option = get_option('amgt_upload_document_type'); // Allowed file extensions
$document_type = explode(", ", $document_option);
$document_type_json = json_encode($document_type);
?>
<script type="text/javascript">
	function fileCheck(obj)
	{
		"use strict";
		var fileExtension = <?php echo $document_type_json; ?>;
		if ($.inArray($(obj).val().split('.').pop().toLowerCase(), fileExtension) == -1)
		{
			alert(language_translate.only + fileExtension.join(", ") + language_translate.formats_allowed);
			$(obj).val('');
		}	
	}
</script>
<style>
	.dropdown-menu {
   		min-width: 240px;
	}
</style>
<?php
  //-------- CHECK BROWSER JAVA SCRIPT ----------//
MJ_amgt_browser_javascript_check(); 
//--------------- ACCESS WISE ROLE -----------//
$user_access=MJ_amgt_get_userrole_wise_access_right_array();
if (isset ( $_REQUEST ['page'] ))
{	
	if($user_access['view']=='0')
	{	
		MJ_amgt_access_right_page_not_access_message();
		die;
	}
	if(!empty($_REQUEST['action']))
	{
		if (isset ( $_REQUEST ['page'] ) && $_REQUEST ['page'] == $user_access['page_link'] && ($_REQUEST['action']=='edit'))
		{
			if($user_access['edit']=='0')
			{	
				MJ_amgt_access_right_page_not_access_message();
				die;
			}			
		}
		if (isset ( $_REQUEST ['page'] ) && $_REQUEST ['page'] == $user_access['page_link'] && ($_REQUEST['action']=='delete'))
		{
			if($user_access['delete']=='0')
			{	
				MJ_amgt_access_right_page_not_access_message();
				die;
			}	
		}
		if (isset ( $_REQUEST ['page'] ) && $_REQUEST ['page'] == $user_access['page_link'] && ($_REQUEST['action']=='insert'))
		{
			if($user_access['add']=='0')
			{	
				MJ_amgt_access_right_page_not_access_message();
				die;
			}	
		} 
	}
}
$curr_user_id=get_current_user_id();
$obj_apartment=new MJ_amgt_Apartment_management($curr_user_id);
$obj_units=new MJ_amgt_ResidentialUnit;
$obj_notice=new MJ_amgt_NoticeEvents;
$active_tab = sanitize_text_field(isset($_GET['tab'])?$_GET['tab']:'notice_list');

if(isset($_POST['save_notice']))//SAVE NOTICE		
{
	$nonce = sanitize_text_field($_POST['_wpnonce']);
	if (wp_verify_nonce( $nonce, 'save_notice_nonce' ) )
	{
		if($_FILES['upload_file']['name'] != "" && $_FILES['upload_file']['size'] > 0)	
		{
			if($_FILES['upload_file']['size'] > 0)
			{
			$file_name=MJ_amgt_amgt_load_documets($_FILES['upload_file'],'upload_file','upload_file');
			}
		}
		else
		{
			if(isset($_REQUEST['hidden_upload_file']))
			{
				$file_name=$_REQUEST['hidden_upload_file'];
			}
		}
	
		if(isset($_REQUEST['action'])&& $_REQUEST['action']=='edit')
		{
			if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'edit_action')) {
				$result=$obj_notice->MJ_amgt_add_notice($_POST,$file_name);
				if($result)
				{
					wp_redirect ( home_url().'?apartment-dashboard=user&page=notice-event&tab=notice_list&message=2');
				}
			} else {
				wp_die('Security check failed!');
			}
		}
		else
		{
			$result=$obj_notice->MJ_amgt_add_notice($_POST,$file_name);
			if($result)
			{
				wp_redirect ( home_url().'?apartment-dashboard=user&page=notice-event&tab=notice_list&message=1');
			}
		}
	}
}
if(isset($_POST['save_event']))//SAVE EVENT 
{
	$nonce = sanitize_text_field($_POST['_wpnonce']);
	if (wp_verify_nonce( $nonce, 'save_event_nonce') )
	{
		if($_FILES['upload_file']['name'] != "" && $_FILES['upload_file']['size'] > 0)	
		{
			if($_FILES['upload_file']['size'] > 0)
			$file_name=MJ_amgt_amgt_load_documets($_FILES['upload_file'],'upload_file','upload_file');
		}
		else
		{
			if(isset($_REQUEST['hidden_upload_file']))
				$file_name=$_REQUEST['hidden_upload_file'];
		}
		
		$start_date=MJ_amgt_get_format_for_db($_POST['start_date']);
		$end_date=MJ_amgt_get_format_for_db($_POST['end_date']);
		$start_hour=date("H", strtotime($_POST['start_time']));
		$start_minute=date("i", strtotime($_POST['start_time']));
		$end_hour=date("H", strtotime($_POST['end_time']));
		$end_minute=date("i", strtotime($_POST['end_time']));
		if($start_date == $end_date )
		{				
			if($start_hour > $end_hour)
			{			
				echo '<script type="text/javascript">alert("End Time should be greater than Start Time");</script>';			
			}
			elseif($start_hour ==  $end_hour && $start_minute > $end_minute )
			{
				echo '<script type="text/javascript">alert("End Time should be greater than Start Time");</script>';		  
			}
			else
			{
				if(isset($_REQUEST['action'])&& $_REQUEST['action']=='edit')
				{
					if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'edit_action')) {
						$result=$obj_notice->MJ_amgt_add_event($_POST,$file_name);
						if($result)
						{
							wp_redirect ( home_url().'?apartment-dashboard=user&page=notice-event&tab=event_list&message=5');
						}
					} else {
						wp_die('Security check failed!');
					}
				}
				else
				{
					$result=$obj_notice->MJ_amgt_add_event($_POST,$file_name);
					if($result)
					{
						wp_redirect ( home_url().'?apartment-dashboard=user&page=notice-event&tab=event_list&message=4');
					}
				}
			}		
		}
		elseif($start_date > $end_date )
		{
			echo '<script type="text/javascript">alert("End Date should be greater than Start Date");</script>';	
		}
		else
		{
			if(isset($_REQUEST['action'])&& $_REQUEST['action']=='edit')
			{
				if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'edit_action')) {
					$result=$obj_notice->MJ_amgt_add_event($_POST,$file_name);
					if($result)
					{
						wp_redirect ( home_url().'?apartment-dashboard=user&page=notice-event&tab=event_list&message=2');
					}
				} else {
					wp_die('Security check failed!');
				}
			}
			else
			{
				$result=$obj_notice->MJ_amgt_add_event($_POST,$file_name);
				if($result)
				{
					wp_redirect ( home_url().'?apartment-dashboard=user&page=notice-event&tab=event_list&message=1');
				}
			}
		}	
	}
}
if(isset($_REQUEST['action'])&& $_REQUEST['action']=='delete')//DELETE NOTICE AND EVENT
{
	if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'delete_action')) {
		if(isset($_REQUEST['notice_id']))
		{
			$result=$obj_notice->MJ_amgt_delete_notice(Mj_amgt_decrypt_id($_REQUEST['notice_id']));
			if($result)
			{
				wp_redirect ( home_url().'?apartment-dashboard=user&page=notice-event&tab=notice_list&message=3');
			}
		}
		if(isset($_REQUEST['event_id']))
		{
			$result=$obj_notice->MJ_amgt_delete_event(Mj_amgt_decrypt_id($_REQUEST['event_id']));
			if($result)
			{
				wp_redirect ( home_url().'?apartment-dashboard=user&page=notice-event&tab=event_list&message=3');
			}
		}
	} else {
		wp_die('Security check failed!');
	}
}	
		
if(isset($_REQUEST['message']))
{
	$message =$_REQUEST['message'];
	if($message == 1)
	{
		$enable_apartment_enable_notifications=get_option("notice_event_approved_by_admin");
		if($enable_apartment_enable_notifications == 'yes' || $obj_apartment->role=='staff_member')
		{
			?>
			<div id="message" class="alert_msg alert alert-success alert-dismissible" role="alert">
				
				<?php
				esc_html_e('Notice inserted successfully.','apartment_mgt');
				?>
				<button type="button" class="close btn-default" data-bs-dismiss="alert" aria-label="Close"><img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/Close.png"?>" alt=""></button>
			</div>
			<?php 
		}
		else
		{
			?>
			<div id="message" class="alert_msg alert alert-success alert-dismissible" role="alert">
			
			<?php
				esc_html_e('Notice inserted successfully but display After Admin Approved','apartment_mgt');
				?>
				<button type="button" class="close btn-default" data-bs-dismiss="alert" aria-label="Close"><img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/Close.png"?>" alt=""></button>
			</div>
			<?php
		}
		
	}
	elseif($message == 2)
	{?>
		<div id="message" class="alert_msg alert alert-success alert-dismissible" role="alert">
			
			<?php
				_e("Notice updated successfully.",'apartment_mgt');
			?>
			<button type="button" class="close btn-default" data-bs-dismiss="alert" aria-label="Close"><img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/Close.png"?>" alt=""></button>
		</div>
		<?php 
	}
	elseif($message == 3) 
	{?>
		<div id="message" class="alert_msg alert alert-success alert-dismissible" role="alert">
			
			<?php
				esc_html_e('Notice deleted successfully','apartment_mgt');
			?>
			<button type="button" class="close btn-default" data-bs-dismiss="alert" aria-label="Close"><img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/Close.png"?>" alt=""></button>
		</div>
	<?php
	}
	if($message == 4)
	{
		$enable_apartment_enable_notifications=get_option("notice_event_approved_by_admin");
		if($enable_apartment_enable_notifications == 'yes' || $obj_apartment->role=='staff_member')
		{
			?>
			<div id="message" class="alert_msg alert alert-success alert-dismissible" role="alert">
				
				<?php
					esc_html_e('Event inserted successfully.','apartment_mgt');
				?>
				<button type="button" class="close btn-default" data-bs-dismiss="alert" aria-label="Close"><img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/Close.png"?>" alt=""></button>
			</div>
			<?php 
		}else{
			?>
			<div id="message" class="alert_msg alert alert-success alert-dismissible" role="alert">
				
				<?php
					esc_html_e('Event inserted successfully but display After Admin Approved','apartment_mgt');
				?>
				<button type="button" class="close btn-default" data-bs-dismiss="alert" aria-label="Close"><img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/Close.png"?>" alt=""></button>
			</div>
			<?php 
		}
	}
	elseif($message == 5)
	{?>
		<div id="message" class="alert_msg alert alert-success alert-dismissible" role="alert">
			
			<?php
				_e("Event updated successfully.",'apartment_mgt');
			?>
			<button type="button" class="close btn-default" data-bs-dismiss="alert" aria-label="Close"><img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/Close.png"?>" alt=""></button>
		</div>
	<?php 
	}
	
}
?>
<!-- VIEW POPUP CODE -->	
<div class="popup-bg">
    <div class="overlay-content">
       <div class="notice_content"></div>    
    </div> 
</div>	
<!-- END POP-UP CODE -->
<div class="panel-body ams_main_list padding_0"><!-- PANEL WHITE DIV -->
	<div class="tab-content padding_0">
	 <!---NOTICE LIST TAB--->
	<?php 
	if($active_tab == 'notice_list')
	{ 
		$user_id=get_current_user_id();
		//--- NOTICE DATA FOR MEMBER  ------//
		if($obj_apartment->role=='member')
		{
			$own_data=$user_access['own_data'];
			if($own_data == '1')
			{
				$noticedata=$obj_notice->MJ_amgt_get_own_notice($user_id);
			}
			else
			{
				$noticedata=$obj_notice->MJ_amgt_get_all_notice();
			}
		} 
		//--- NOTICE DATA FOR STAFF MEMBER  ------//
		elseif($obj_apartment->role=='staff_member')
		{
			$own_data=$user_access['own_data'];
			if($own_data == '1')
			{  
				$noticedata=$obj_notice->MJ_amgt_get_own_notice($user_id);
			}
			else
			{
				$noticedata=$obj_notice->MJ_amgt_get_all_notice();
			}
		}
		//--- NOTICE DATA FOR ACCOUNTANT  ------//
		elseif($obj_apartment->role=='accountant')
		{
			$own_data=$user_access['own_data'];
			if($own_data == '1')
			{ 
				$noticedata=$obj_notice->MJ_amgt_get_own_notice($user_id);
			}
			else
			{
				$noticedata=$obj_notice->MJ_amgt_get_all_notice();
			}
		}
		//--- NOTICE DATA FOR GATEKEEPER  ------//
		else
		{
			$own_data=$user_access['own_data'];
			if($own_data == '1')
			{ 
				$noticedata=$obj_notice->MJ_amgt_get_own_notice($user_id);
			}
			else
			{
				$noticedata=$obj_notice->MJ_amgt_get_all_notice();
			}
		}
		if(!empty($noticedata))
		{
			?>
			<script type="text/javascript">
				$(document).ready(function() 
				{
					"use strict";
					jQuery('#notice_list').DataTable(
					{
						//"responsive": true,
						dom: 'lifrtp',
						// "order": [[ 3, "desc" ]],
						"aoColumns":[
							{"bSortable": false},
							{"bSortable": true},
							{"bSortable": true},
							{"bSortable": true},
							{"bSortable": true},
							{"bSortable": true},
							{"bSortable": true},
							{"bSortable": true},
							{"bSortable": false}],
							language:<?php echo MJ_amgt_datatable_multi_language();?>,
							responsive: {
								details: {
									display: $.fn.dataTable.Responsive.display.modal({
										header: function (row) {
											var data = row.data();
											return 'Details for ' + data[1];
										}
									}),
									renderer: $.fn.dataTable.Responsive.renderer.tableAll()
								}
							}
					});
					$('.dataTable').on('click', 'td', function() 
					{
						var cellIndex = this.cellIndex; // Get the index of the clicked cell
						if (cellIndex === 0) 
						{ // Check if it's the first column
							$('.dataTable tbody td:first-child a').removeClass('view-notice');
							return; // Do nothing if it's the first column
						}
					});
					$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'apartment_mgt') ?>");
				} );
			</script>
			<div class="panel-body padding_0"><!--PANEL BODY DIV-->
				<div class="table-responsive"><!---TABLE-RESPONSIVE DIV--->
					<table id="notice_list" class="display" cellspacing="0" width="100%"><!--NOTICE LIST TABLE-->
						<thead class="<?php echo MJ_amgt_datatable_heder(); ?>">
							<tr>
								<th><?php esc_html_e('Image', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Title', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Notice To', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Start Date', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('End Date', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Type', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Status', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Description', 'apartment_mgt' ) ;?></th>
								<th class="text_align_end"><?php  esc_html_e('Action', 'apartment_mgt' ) ;?></th>
							</tr>
						</thead>
						<tfoot>
							<tr>
								<th><?php esc_html_e('Image', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Title', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Notice To', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Start Date', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('End Date', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Type', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Status', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Description', 'apartment_mgt' ) ;?></th>
								<th class="text_align_end"><?php  esc_html_e('Action', 'apartment_mgt' ) ;?></th>
							</tr>
						</tfoot>
						<tbody>
							<?php 
							if(!empty($noticedata))
							{
								foreach ($noticedata as $retrieved_data)
								{ 
									if($i == 10)
									{
										$i=0;
									}
									if($i == 0)
									{
										$color_class='smgt_class_color0';
									}
									elseif($i == 1)
									{
										$color_class='smgt_class_color1';
									}
									elseif($i == 2)
									{
										$color_class='smgt_class_color2';
									}
									elseif($i == 3)
									{
										$color_class='smgt_class_color3';
									}
									elseif($i == 4)
									{
										$color_class='smgt_class_color4';
									}
									elseif($i == 5)
									{
										$color_class='smgt_class_color5';
									}
									elseif($i == 6)
									{
										$color_class='smgt_class_color6';
									}
									elseif($i == 7)
									{
										$color_class='smgt_class_color7';
									}
									elseif($i == 8)
									{
										$color_class='smgt_class_color8';
									}
									elseif($i == 9)
									{
										$color_class='smgt_class_color9';
									}
									?>
									<tr>
										<td class="user_image width_50px profile_image_prescription padding_left_0">
											<a href="#" class="float_left_width_100 view-notice" id="<?php echo esc_attr($retrieved_data->id);?>"> 	
												<p class="prescription_tag padding_15px margin_bottom_0px <?php echo $color_class; ?>">	
													<img src="<?php echo  AMS_PLUGIN_URL."/assets/images/Sidemenu/Notice_and_Event-white.png"?>" alt="" class="massage_image center image_icon_height_25px margin_top_3px">
												</p>
											</a>
										</td>
										
										<td class="title">
											<a href="#" class="view-notice title_name" id="<?php echo esc_attr($retrieved_data->id);?>"><?php echo esc_html($retrieved_data->notice_title);?></a>
										</td>
										<td class="title">
											<?php $user=get_userdata($retrieved_data->notice_to); 
											if(!empty($user->display_name))
											{
												echo esc_html(ucfirst($user->display_name));
											}
											else
											{
												echo "N/A";
											}
											?> 
										</td>
										<td class="Notice Start Date">
											<?php if(!empty($retrieved_data->start_date)){ echo esc_html(date(MJ_amgt_date_formate(),strtotime($retrieved_data->start_date))); }else{ echo esc_html(date(MJ_amgt_date_formate(),strtotime($retrieved_data->created_date))); } ?>
										</td>
										<td class="valid date">
											<?php echo esc_html(date(MJ_amgt_date_formate(),strtotime($retrieved_data->valid_date)));?>
										</td>
										<td class="type">
											<?php 
											if($retrieved_data->notice_type=='Announcement')
											{
												echo esc_html_e('Announcement','apartment_mgt' ) ;
											}
											elseif($retrieved_data->notice_type=='Proposal')
											{
												echo esc_html_e('Proposal','apartment_mgt' ) ;
											}
											?>
										</td>
										<td class="status">
											<?php 
											if($retrieved_data->status=='Open')
											{ 
												?>
												<span class="fullpaid_status_color">
												<?php
												esc_html_e('Approved','apartment_mgt');
												?>
												</span>
												<?php
											}
											elseif($retrieved_data->status=='Not Approved')
											{  
												?>
												<span class="Unpaid_status_color">
												<?php
												esc_html_e('Not Approved','apartment_mgt');
												?>
												</span>
												<?php
											}
											?>
										</td>
										<td class="description">
											<?php echo wp_trim_words( $retrieved_data->description,5);?>
											<i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php echo $retrieved_data->description;?>" ></i>
										</td>
										<td class="action"> 
											<div class="amgt-user-dropdown">
												<ul class="" style="margin-bottom: 0px !important;">
													<li class="">
														<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
															<img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/More.png"?>" >
														</a>
														<ul class="dropdown-menu heder-dropdown-menu action_dropdawn" aria-labelledby="dropdownMenuLink">
															
															<li class="float_left_width_100">
																<a href="#" class="float_left_width_100 view-notice" id="<?php echo esc_attr($retrieved_data->id);?>"> 
																<i class="fa fa-eye"></i> <?php esc_html_e('View','apartment_mgt');?>
															</a>
															</li>
															<?php
															$data_notice_id = Mj_amgt_retrived_data_id($retrieved_data->id);
															$edit_action = mj_amgt_create_and_verify_nonce('edit');
															if($user_access['edit']=='1')
															{  ?>
																<li class="float_left_width_100 border_bottom_item">
																	<a href="?apartment-dashboard=user&page=notice-event&tab=add_notice&action=edit&notice_id=<?php echo esc_attr($data_notice_id); ?>&_wpnonce=<?php echo $edit_action; ?>" class="float_left_width_100">
																	<i class="fa fa-edit"></i> <?php esc_html_e('Edit', 'apartment_mgt' );?></a>
																</li>
																<?php
															}
															$delete_action = mj_amgt_create_and_verify_nonce('delete');
															if($user_access['delete']=='1')
															{
																?>
																<li class="float_left_width_100">
																	<a href="?apartment-dashboard=user&page=notice-event&tab=notice_list&action=delete&notice_id=<?php echo esc_attr($data_notice_id); ?>&_wpnonce=<?php echo $delete_action; ?>" class="float_left_width_100 list_delete_btn"
																		onclick="return confirm('<?php esc_html_e('Do you really want to delete this record?','apartment_mgt');?>');">
																		<i class="fa fa-trash"></i> <?php esc_html_e('Delete', 'apartment_mgt' ) ;?> 
																	</a>
																</li>
																<?php
															}
															?>
															
														</ul>
													</li>
												</ul>
											</div>	
										</td>
									</tr>
									<?php
									$i++;
								} 
							}?>
						</tbody>
					</table><!--END NOTICE LIST TABLE-->
				</div><!---END TABLE-RESPONSIVE DIV--->
			</div><!--END PANEL BODY DIV-->
			<?php 
		}
		else
		{
			if($user_access['add'] == 1)
			{
				?>
				<div class="no_data_list_div"> 
					<a href="<?php echo home_url().'?apartment-dashboard=user&page=notice-event&tab=add_notice';?>">
						<img class="width_100px" src="<?php echo get_option( 'amgt_no_data_img' ) ?>" >
					</a>
					<div class="col-md-12 dashboard_btn margin_top_20px">
						<label class="no_data_list_label"><?php esc_html_e('Tap on above icon to add your first Record.','apartment_mgt'); ?> </label>
					</div> 
				</div>
				<?php
			}
			else
			{
				?>
				<div class="calendar-event-new"> 
					<img class="no_data_img" src="<?php echo AMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
				</div>
				<?php
			}
		}
	}
	if($active_tab == 'add_notice')
	{ 
	  require_once AMS_PLUGIN_DIR.'/template/notice-event/add_notice.php' ;
	}
	if($active_tab == 'event_list')
	{ 
	  require_once AMS_PLUGIN_DIR.'/template/notice-event/event_list.php' ;
	}
	if($active_tab == 'add_event')
	{ 
	  require_once AMS_PLUGIN_DIR.'/template/notice-event/add_event.php' ;
	}
	?>
	</div>
</div>
<?php ?>