<?php 
//FACILITY-BOOKING-LIST
if($active_tab == 'facility-booking-list') { ?>
		<script type="text/javascript">
		$(document).ready(function() {
			"use strict";
			jQuery('#service_list').DataTable({
				//"responsive": true,
				"order": [[ 1, "desc" ]],
				dom: 'lifrtp',
				"aoColumns":[
							  {"bSortable": false},
							  {"bSortable": true},
							  {"bSortable": true},	                  
							  {"bSortable": true},
							  {"bSortable": true},
							  {"bSortable": true},
							  {"bSortable": true},
							  {"bSortable": true},
							  {"bSortable": true},
							  {"bSortable": true},
							  {"bSortable": true},
							  {"bSortable": false}],
							  language:<?php echo MJ_amgt_datatable_multi_language();?>,
									responsive: {
										details: {
											display: $.fn.dataTable.Responsive.display.modal({
												header: function (row) {
													var data = row.data();
													return 'Details for ' + data[1];
												}
											}),
											renderer: $.fn.dataTable.Responsive.renderer.tableAll()
										}
									}
				});
				$('.dataTable').on('click', 'td', function() 
				{
					var cellIndex = this.cellIndex; // Get the index of the clicked cell
					if (cellIndex === 0) 
					{ // Check if it's the first column
						$('.dataTable tbody td:first-child a').removeClass('view-book-facility');
						return; // Do nothing if it's the first column
					}
				});
				$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'apartment_mgt') ?>");
		} );
		</script>
		<?php
		$user_id=get_current_user_id();
		//--- Facility DATA FOR MEMBER  ------//
		if($obj_apartment->role=='member')
		{
			$own_data=$user_access['own_data'];
			if($own_data == '1')
			{
				$facility_data= $obj_facility->MJ_amgt_get_own_booked_facility($user_id);
			}
			else
			{
				$facility_data= $obj_facility->MJ_amgt_get_all_booked_facility();
			}
		} 
		//--- Facility DATA FOR STAFF MEMBER  ------//
		elseif($obj_apartment->role=='staff_member')
		{
			$own_data=$user_access['own_data'];
			if($own_data == '1')
			{  
				$facility_data= $obj_facility->MJ_amgt_get_own_booked_facility($user_id);
			}
			else
			{
				$facility_data= $obj_facility->MJ_amgt_get_all_booked_facility();
			}
		}
		//--- Facility DATA FOR ACCOUNTANT  ------//
		elseif($obj_apartment->role=='accountant')
		{
			$own_data=$user_access['own_data'];
			if($own_data == '1')
			{ 
				$facility_data= $obj_facility->MJ_amgt_get_own_booked_facility($user_id);
			}
			else
			{
				$facility_data= $obj_facility->MJ_amgt_get_all_booked_facility();
			}
		}
		//--- Facility DATA FOR GATEKEEPER  ------//
		else
		{
			$own_data=$user_access['own_data'];
			if($own_data == '1')
			{ 
				$facility_data= $obj_facility->MJ_amgt_get_own_booked_facility($user_id);
			}
			else
			{
				$facility_data= $obj_facility->MJ_amgt_get_all_booked_facility();
			}
		}
		if(!empty($facility_data))
		{ 
		?>
			<div class="panel-body padding_0 ams_main_list"><!--PANEL BODY-->
				<div class="table-responsive"><!---TABLE-RESPONSIVE--->
					<table id="service_list" class="display" cellspacing="0" width="100%"><!---SERVICE_LIST TAB--->
						<thead class="<?php echo MJ_amgt_datatable_heder(); ?>">
							<tr>
								<th class="padding_left_25px"><?php esc_html_e('Image', 'apartment_mgt' ) ;?></th>
								<th><?php  esc_html_e('Member Name', 'apartment_mgt' ) ;?></th>
								<th><?php  esc_html_e('Facility Name', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Book For', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Start Date', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('End Date', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Start Time', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('End Time', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Booking Date', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Booking Charge', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Booking Status', 'apartment_mgt' ) ;?></th>
								<th class="text_align_end"><?php  esc_html_e('Action', 'apartment_mgt' ) ;?></th>
							</tr>
						</thead>
						<tfoot>
							<tr>
								<th><?php esc_html_e('Image', 'apartment_mgt' ) ;?></th>
								<th><?php  esc_html_e('Member Name', 'apartment_mgt' ) ;?></th>
								<th><?php  esc_html_e('Facility Name', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Book For', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Start Date', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('End Date', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Start Time', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('End Time', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Booking Date', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Total Charge', 'apartment_mgt' ) ;?></th>
								<th><?php esc_html_e('Status', 'apartment_mgt' ) ;?></th>
								<th class="text_align_end"><?php  esc_html_e('Action', 'apartment_mgt' ) ;?></th>
							</tr>
						</tfoot>
						<tbody>
							<?php 
							$i=0;
							if(!empty($facility_data))
							{
								foreach ($facility_data as $retrieved_data)
								{
									if($i == 10)
										{
											$i=0;
										}
										if($i == 0)
										{
											$color_class='smgt_class_color0';
										}
										elseif($i == 1)
										{
											$color_class='smgt_class_color1';
										}
										elseif($i == 2)
										{
											$color_class='smgt_class_color2';
										}
										elseif($i == 3)
										{
											$color_class='smgt_class_color3';
										}
										elseif($i == 4)
										{
											$color_class='smgt_class_color4';
										}
										elseif($i == 5)
										{
											$color_class='smgt_class_color5';
										}
										elseif($i == 6)
										{
											$color_class='smgt_class_color6';
										}
										elseif($i == 7)
										{
											$color_class='smgt_class_color7';
										}
										elseif($i == 8)
										{
											$color_class='smgt_class_color8';
										}
										elseif($i == 9)
										{
											$color_class='smgt_class_color9';
										}
									?>
									<tr>
										<td class="user_image width_50px profile_image_prescription padding_left_0">	
											<a href="#" class="view-book-facility float_left_width_100" id="<?php echo $retrieved_data->id; ?>">
												<p class="prescription_tag padding_15px margin_bottom_0px <?php echo $color_class; ?> margin_left_25px">	
													<img src="<?php echo  AMS_PLUGIN_URL."/assets/images/Sidemenu/Facility-white.png"?>" alt="" class="massage_image center image_icon_height_25px margin_top_3px">
												</p>
											</a>
										</td>
										<td class="member_name">
											<a href="#" class="view-book-facility float_left_width_100" id="<?php echo $retrieved_data->id; ?>">
											<?php  
												// $user_info = get_userdata($retrieved_data->book_on_behalf_of);
											 	// echo esc_html($user_info->display_name);
											?> 

											<?php 
											$user_info = get_userdata($retrieved_data->book_on_behalf_of); 
											if(!empty($user_info->display_name))
											{
												echo esc_html($user_info->display_name);
											}
											else
											{
												echo "N/A";
											}
											?>
											</a>
										</td>
										<td class="facility_name"><?php echo esc_html(MJ_amgt_get_facility_name($retrieved_data->facility_id));?> </td>
										<td class="booked_for"><?php echo esc_html(get_the_title($retrieved_data->activity_id));?> </td>
										<td class="start_date"><?php echo esc_html(date(MJ_amgt_date_formate(),strtotime($retrieved_data->start_date)));?> </td>
										<td class="end_date"><?php if($retrieved_data->end_date!="0000-00-00" && "00/00/0000" && "00/00/0000"){ echo esc_html(date(MJ_amgt_date_formate(),strtotime($retrieved_data->end_date))); }else{ echo "N/A"; } ;?> </td>
											<td class="start_date"><?php if(!empty($retrieved_data->start_time))
										{
											echo esc_html($retrieved_data->start_time);
										}
										else
										{
											echo "N/A"; 
										}
										?>
										</td>
										
										<td class="start_date">
										<?php
										if(!empty($retrieved_data->end_time))
										{
											echo esc_html($retrieved_data->end_time);
										}
										else
										{
											echo "N/A";   
										}
										
										?>
										</td>
										<td class="booking_Date"><?php echo esc_html(date(MJ_amgt_date_formate(),strtotime($retrieved_data->created_date)));?> </td>
										<td class="booking_charge">
											<?php 
												echo esc_html(MJ_amgt_get_currency_symbol(get_option('apartment_currency_code'))); 
												echo esc_html(number_format((float)$retrieved_data->booking_cost, 2, '.', '')); 
											?>
										</td>
										<?php
										if($retrieved_data->status == '0')
										{
											$status=esc_html__('Pending', 'apartment_mgt' );
											$status_color_class ="pending_status_color";
										}
										elseif($retrieved_data->status == '1')
										{
											$status=esc_html__('Approved', 'apartment_mgt' );
											$status_color_class ="fullpaid_status_color";		
										}
										else
										{
											$status=esc_html__('Cancel', 'apartment_mgt' );
											$status_color_class ="Unpaid_status_color";
										}
										?>
										<td class="vehicle"><span class=<?php echo $status_color_class;?>><?php echo esc_html($status);?></span> </td>	
										<td class="action"> 
											<div class="amgt-user-dropdown">
												<ul class="" style="margin-bottom: 0px !important;">
													<li class="">
														<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
															<img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/More.png"?>" >
														</a>
														<ul class="dropdown-menu heder-dropdown-menu action_dropdawn" aria-labelledby="dropdownMenuLink">
															<li class="float_left_width_100">
																<a href="#" class="view-book-facility float_left_width_100" id="<?php echo $retrieved_data->id; ?>"><i class="fa fa-eye"></i> <?php esc_html_e('View', 'apartment_mgt' ) ;?></a>
															</li>
															<?php
															$facility_booking_id = Mj_amgt_retrived_data_id($retrieved_data->id);
															$edit_action = mj_amgt_create_and_verify_nonce('edit');
															if($user_access['edit']=='1')
															{  ?>
																<li class="float_left_width_100 border_bottom_item">
																	<a href="?apartment-dashboard=user&page=facility&tab=booking-facility&action=edit&facility_booking_id=<?php echo esc_attr($facility_booking_id); ?>&_wpnonce=<?php echo $edit_action; ?>" class="float_left_width_100"><i class="fa fa-edit"></i> <?php esc_html_e('Edit', 'apartment_mgt' ) ;?></a>
																</li>
																<?php
															}
															$delete_action = mj_amgt_create_and_verify_nonce('delete');
															if($user_access['delete']=='1')
															{
																?>
																<li class="float_left_width_100">
																	<a href="?apartment-dashboard=user&page=facility&tab=facility-list&action=delete&facility_booking_id=<?php echo esc_attr($facility_booking_id); ?>&_wpnonce=<?php echo $delete_action; ?>" class="float_left_width_100 list_delete_btn" onclick="return confirm('<?php esc_html_e('Do you really want to delete this record?','apartment_mgt');?>');"><i class="fa fa-trash"></i> <?php esc_html_e( 'Delete', 'apartment_mgt' ) ;?> </a>
																</li>
																<?php
															} ?>
														</ul>
													</li>
												</ul>
											</div>	
										</td>
									</tr>
								<?php 
								$i++ ;} 			
							}?>
						</tbody>
					</table><!---END SERVICE_LIST TAB--->
				</div><!---END TABLE-RESPONSIVE--->
			</div><!--END PANEL BODY-->
			<?php
		}
		else
		{
			if($user_access['add'] == 1)
			{
				?>
				<div class="no_data_list_div"> 
					<a href="<?php echo home_url().'?apartment-dashboard=user&page=facility&tab=booking-facility';?>">
						<img class="width_100px" src="<?php echo get_option( 'amgt_no_data_img' ) ?>" >
					</a>
					<div class="col-md-12 dashboard_btn margin_top_20px">
						<label class="no_data_list_label"><?php esc_html_e('Tap on above icon to add your first Record.','apartment_mgt'); ?> </label>
					</div> 
				</div>
				<?php
			}
			else
			{
				?>
				<div class="calendar-event-new"> 
					<img class="no_data_img" src="<?php echo AMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
				</div>
				<?php
			}
		}
	} ?>