<?php
$document_option = get_option('amgt_upload_document_type'); // Allowed file extensions
$document_type = explode(", ", $document_option);
$document_type_json = json_encode($document_type);
?>
<script type="text/javascript">
	function fileCheck(obj)
	{
		"use strict";
		var fileExtension = <?php echo $document_type_json; ?>;
		if ($.inArray($(obj).val().split('.').pop().toLowerCase(), fileExtension) == -1)
		{
			alert(language_translate.only + fileExtension.join(", ") + language_translate.formats_allowed);
			$(obj).val('');
		}	
	}
</script>
<?php 
//-------- CHECK BROWSER JAVA SCRIPT ----------//
MJ_amgt_browser_javascript_check(); 
//--------------- ACCESS WISE ROLE -----------//
$user_access=MJ_amgt_get_userrole_wise_access_right_array();
if (isset ( $_REQUEST ['page'] ))
{	
	if($user_access['view']=='0')
	{	
		MJ_amgt_access_right_page_not_access_message();
		die;
	}
	if(!empty($_REQUEST['action']))
	{
		if (isset ( $_REQUEST ['page'] ) && $_REQUEST ['page'] == $user_access['page_link'] && ($_REQUEST['action']=='edit'))
		{
			if($user_access['edit']=='0')
			{	
				MJ_amgt_access_right_page_not_access_message();
				die;
			}			
		}
		if (isset ( $_REQUEST ['page'] ) && $_REQUEST ['page'] == $user_access['page_link'] && ($_REQUEST['action']=='delete'))
		{
			if($user_access['delete']=='0')
			{	
				MJ_amgt_access_right_page_not_access_message();
				die;
			}	
		}
		if (isset ( $_REQUEST ['page'] ) && $_REQUEST ['page'] == $user_access['page_link'] && ($_REQUEST['action']=='insert'))
		{
			if($user_access['add']=='0')
			{	
				MJ_amgt_access_right_page_not_access_message();
				die;
			}	
		} 
	}
}
$curr_user_id=get_current_user_id();
$obj_apartment=new MJ_amgt_Apartment_management($curr_user_id);
$obj_document=new MJ_amgt_Document;
$obj_units=new MJ_amgt_ResidentialUnit;
$active_tab = sanitize_text_field(isset($_GET['tab'])?$_GET['tab']:'documentlist');

if(isset($_POST['save_document']))//SAVE DOCUMENT
{	
    $nonce = sanitize_text_field($_POST['_wpnonce']);
	if (wp_verify_nonce( $nonce, 'save_document_nonce' ) )
	{
		$upload_docs_array=array(); 
			
		if(isset($_REQUEST['action'])&& $_REQUEST['action']=='edit')
		{	
			if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'edit_action')) {
				if($_FILES['upload_file']['name'][0] != "" && $_FILES['upload_file']['size'] > 0)
				{ 
					$filename=MJ_amgt_load_documets($_FILES['upload_file'],$_FILES['upload_file'],'upload_file');
					$upload_docs_array=content_url().'/uploads/apartment_assets/'.$filename;
				}
				else
				{
					$upload_docs_array=$_REQUEST['hidden_upload_file'];
				} 
				// var_dump($_POST);
				// var_dump($upload_docs_array);
				// die;
				$result=$obj_document->MJ_amgt_add_document($_POST,$upload_docs_array);
			
				wp_redirect ( home_url().'?apartment-dashboard=user&page=documents&tab=documentlist&message=2');
			} else {
				wp_die('Security check failed!');
			}
			
		}
		else
		{
			if(!empty($_FILES['upload_file']['name']))
			{
				$count_array=count($_FILES['upload_file']['name']);

				for($a=0;$a<$count_array;$a++)
				{	
					foreach($_FILES['upload_file'] as $image_key=>$image_val)
					{	
						$document_array[$a]=array(
						'name'=>$_FILES['upload_file']['name'][$a],
						'type'=>$_FILES['upload_file']['type'][$a],
						'tmp_name'=>$_FILES['upload_file']['tmp_name'][$a],
						'error'=>$_FILES['upload_file']['error'][$a],
						'size'=>$_FILES['upload_file']['size'][$a]
						);	
					}
				}	
				foreach($document_array as $key=>$value)	
				{	
					$get_file_name=$document_array[$key]['name'];	

					$filename=MJ_amgt_load_documets($value,$value,$get_file_name);	
					$upload_docs_array[]=content_url().'/uploads/apartment_assets/'.$filename;
				} 
			}
			$result=$obj_document->MJ_amgt_add_document($_POST,$upload_docs_array);
			if($result)
			{
				wp_redirect ( home_url().'?apartment-dashboard=user&page=documents&tab=documentlist&message=1');
			}
		}
	}
}	
if(isset($_REQUEST['action'])&& $_REQUEST['action']=='delete')
{
	if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'delete_action')) {
		$result=$obj_document->MJ_amgt_delete_document(Mj_amgt_decrypt_id($_REQUEST['document_id']));
		if($result)
		{
			wp_redirect ( home_url().'?apartment-dashboard=user&page=documents&tab=documentlist&message=3');
		}
	} else {
		wp_die('Security check failed!');
	}
}
if(isset($_REQUEST['message']))//MESSAGES
{
	$message =$_REQUEST['message'];
	if($message == 1)
	{?>
		<div id="message" class="alert_msg alert alert-success alert-dismissible" role="alert">
			
			<?php
			esc_html_e('Document inserted successfully','apartment_mgt');
			?>
			<button type="button" class="close btn-default" data-bs-dismiss="alert" aria-label="Close"><img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/Close.png"?>" alt=""></button>
		</div>
	<?php 
	}
	elseif($message == 2)
	{?>
		<div id="message" class="alert_msg alert alert-success alert-dismissible" role="alert">
			
			<?php
			_e("Document updated successfully.",'apartment_mgt');
			?>
			<button type="button" class="close btn-default" data-bs-dismiss="alert" aria-label="Close"><img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/Close.png"?>" alt=""></button>
		</div>
		<?php 
	}
	elseif($message == 3) 
	{?>
		<div id="message" class="alert_msg alert alert-success alert-dismissible" role="alert">
			
			<?php
			esc_html_e('Document deleted successfully','apartment_mgt');
			?>
			<button type="button" class="close btn-default" data-bs-dismiss="alert" aria-label="Close"><img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/Close.png"?>" alt=""></button>
		</div>
	<?php
	}
}
?>
<!-- POP UP CODE -->
<div class="popup-bg">
    <div class="overlay-content">
		<div class="modal-content">
		    <div class="category_list"></div>
		</div>
    </div> 
</div>
<!-- END POP-UP CODE -->
<div class="panel-body ams_main_list padding_0"><!-- PANEL WHITE DIV -->
	<div class="tab-content padding_0">
		<?php 
		if($active_tab == 'documentlist')//DOCUMENTLIST LIST
		{ 
			$user_id=get_current_user_id();
			//--- Document DATA FOR MEMBER  ------//
			if($obj_apartment->role=='member')
			{
				$own_data=$user_access['own_data'];
				if($own_data == '1')
				{
					$unit_name = get_user_meta($user_id,'unit_name',true);
					$building_id=get_user_meta($user_id,'building_id',true);

					$is_json = is_json($unit_name,$return_data = false);
					
					if($is_json == "TRUE"){
						$documentdata=$obj_document->MJ_amgt_get_units_all_documents_new_json($unit_name);
						// var_dump($documentdata);
					}else{
						$documentdata=$obj_document->MJ_amgt_get_units_all_documents_new($unit_name,$building_id);
					}
				}
				else
				{
					$documentdata=$obj_document->MJ_amgt_get_all_documents();
				}
			} 
			//--- Document DATA FOR STAFF MEMBER  ------//
			elseif($obj_apartment->role=='staff_member')
			{
				$own_data=$user_access['own_data'];
				if($own_data == '1')
				{  
					$documentdata=$obj_document->MJ_amgt_get_own_documents($user_id);
				}
				else
				{
					$documentdata=$obj_document->MJ_amgt_get_all_documents();
				}
			}
			//--- Document DATA FOR ACCOUNTANT  ------//
			elseif($obj_apartment->role=='accountant')
			{
				$own_data=$user_access['own_data'];
				if($own_data == '1')
				{ 
					$documentdata=$obj_document->MJ_amgt_get_own_documents($user_id);
				}
				else
				{
					$documentdata=$obj_document->MJ_amgt_get_all_documents();
				}
			}
			//--- Document DATA FOR GATEKEEPER  ------//
			else
			{
				$own_data=$user_access['own_data'];
				if($own_data == '1')
				{ 
					$documentdata=$obj_document->MJ_amgt_get_own_documents($user_id);
				}
				else
				{
					$documentdata=$obj_document->MJ_amgt_get_all_documents();
				}
			}
			if(!empty($documentdata))
			{
				?>
				<script type="text/javascript">
					$(document).ready(function() 
					{
						"use strict";
						jQuery('#document_list').DataTable(
						{
							//"responsive": true,
							dom: 'lifrtp',
							"order": [[ 1, "desc" ]],
							"aoColumns":[
								{"bSortable": false},
								{"bSortable": true},
								{"bSortable": true},
								{"bSortable": true},
								{"bSortable": true},
								{"bSortable": true},
								{"bSortable": true},
								{"bSortable": false}],
								language:<?php echo MJ_amgt_datatable_multi_language();?>,
								responsive: {
									details: {
										display: $.fn.dataTable.Responsive.display.modal({
											header: function (row) {
												var data = row.data();
												return 'Details for ' + data[1];
											}
										}),
										renderer: $.fn.dataTable.Responsive.renderer.tableAll()
									}
								}
						});
						$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'apartment_mgt') ?>");
					} );
				</script>
				<div class="panel-body padding_0"><!-- PANEL BODY DIV -->
					<div class="table-responsive"><!---TABLE-RESPONSIVE--->
						<table id="document_list" class="display" cellspacing="0" width="100%"><!-- DOCUMENT_LIST TABLE -->
							<thead class="<?php echo MJ_amgt_datatable_heder(); ?>">
								<tr>
									<th><?php esc_html_e('Image', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Document Title', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Unit name', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Member Name', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Submitted Date', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Category', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Description', 'apartment_mgt' ) ;?></th>
									<th class="text_align_end"><?php  esc_html_e('Action', 'apartment_mgt' ) ;?></th>
								</tr>
							</thead>
							<tfoot>
								<tr>
									<th><?php esc_html_e('Image', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Document Title', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Unit name', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Member Name', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Submitted Date', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Category', 'apartment_mgt' ) ;?></th>
									<th><?php esc_html_e('Description', 'apartment_mgt' ) ;?></th>
									<th class="text_align_end"><?php  esc_html_e('Action', 'apartment_mgt' ) ;?></th>
								</tr>
							
							</tfoot>
							<tbody>
								<?php 
								if(!empty($documentdata))
								{
									// var_dump($documentdata);
									$i=0;
									foreach ($documentdata as $retrieved_data)
									{ 
										if(isset($retrieved_data->category_id))
										{	
											$document_category=MJ_amgt_get_all_category_by_id('document_category',$retrieved_data->category_id);
										}
										if($i == 10)
										{
											$i=0;
										}
										if($i == 0)
										{
											$color_class='smgt_class_color0';
										}
										elseif($i == 1)
										{
											$color_class='smgt_class_color1';
										}
										elseif($i == 2)
										{
											$color_class='smgt_class_color2';
										}
										elseif($i == 3)
										{
											$color_class='smgt_class_color3';
										}
										elseif($i == 4)
										{
											$color_class='smgt_class_color4';
										}
										elseif($i == 5)
										{
											$color_class='smgt_class_color5';
										}
										elseif($i == 6)
										{
											$color_class='smgt_class_color6';
										}
										elseif($i == 7)
										{
											$color_class='smgt_class_color7';
										}
										elseif($i == 8)
										{
											$color_class='smgt_class_color8';
										}
										elseif($i == 9)
										{
											$color_class='smgt_class_color9';
										}
										?>
										<tr>
											<td class="user_image width_50px profile_image_prescription padding_left_0">	
												<p class="prescription_tag padding_15px margin_bottom_0px <?php echo $color_class; ?>">	
													<a target="blank" href="<?php if(!empty($retrieved_data->document_content)){ echo $retrieved_data->document_content; }else{ echo "#"; } ?>" class="float_left_width_100">
														<img src="<?php echo  AMS_PLUGIN_URL."/assets/images/Sidemenu/Documents-white.png"?>" alt="" class="massage_image center image_icon_height_25px margin_top_3px">
													</a>
												</p>
											</td>
										
											<td class="title">
												<a href="#" class="title_name"	><?php echo esc_html($retrieved_data->doc_title);?></a>
											</td>
											<td class="unit">
												<?php  if(!empty($retrieved_data->unit_name)){ echo MJ_amgt_get_member_assing_unit_name($retrieved_data->unit_name); }?>
											</td>
											<td class="member">
												<?php 
												if(!empty($retrieved_data->member_id))
												{
													echo esc_html(MJ_amgt_get_display_name($retrieved_data->member_id));
												}
												else
												{
														echo "N/A";
												}
												?>
											</td>
											<td class="from">
												<?php echo esc_html(date(MJ_amgt_date_formate(),strtotime($retrieved_data->created_date)));?>
											</td>
											
											<td class="category">
												<?php
												if(!empty($retrieved_data->category_id))
												{
													// foreach($document_category as $document_category)
													// {
													// 	if($document_category->ID == $retrieved_data->category_id)
													// 	{	
													// 		echo $document_category->post_title;
													// 	}
													// }
													echo get_the_title($retrieved_data->category_id);
												}
												else{
													echo "N/A";
												}
												?>
												<!-- <?php echo esc_html(date(MJ_amgt_date_formate(),strtotime($retrieved_data->created_date)));?> -->
											</td>
											<td class="description">
												<?php
												if(!empty($retrieved_data->description))
												{
													echo esc_html(wp_trim_words( $retrieved_data->description,5));
												}
												else
												{
													echo "N/A";
												}
													
												?>
												<i class="fa fa-info-circle fa_information_bg" data-toggle="tooltip" data-placement="top" title="<?php echo $retrieved_data->description;?>" ></i>
											</td>
											<td class="action"> 
												<div class="amgt-user-dropdown">
													<ul class="" style="margin-bottom: 0px !important;">
														<li class="">
															<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
																<img src="<?php echo AMS_PLUGIN_URL."/assets/images/listpage_icon/More.png"?>" >
															</a>
															<ul class="dropdown-menu heder-dropdown-menu action_dropdawn" aria-labelledby="dropdownMenuLink">

																<?php 
																if($retrieved_data->document_content!='') 
																{ ?>
																	<li class="float_left_width_100">
																		<a target="blank" href="<?php echo $retrieved_data->document_content; ?>" class="float_left_width_100">
																			<i class="fa fa-eye"></i> <?php esc_html_e('View Document', 'apartment_mgt' ) ;?>
																		</a>
																	<?php 
																} ?>

																<?php
																$data_document_id = Mj_amgt_retrived_data_id($retrieved_data->id);
																$edit_action = mj_amgt_create_and_verify_nonce('edit');
																if($user_access['edit']=='1')
																{  ?>
																	<li class="float_left_width_100 border_bottom_item">
																		<a href="?apartment-dashboard=user&page=documents&tab=add_document&action=edit&document_id=<?php echo $data_document_id; ?>&_wpnonce=<?php echo $edit_action; ?>" class="float_left_width_100">
																			<i class="fa fa-edit"></i> <?php esc_html_e('Edit', 'apartment_mgt' ) ;?>
																		</a>
																	<?php
																}
																$delete_action = mj_amgt_create_and_verify_nonce('delete');
																if($user_access['delete']=='1')
																{
																	?>
																	<li class="float_left_width_100">
																		<a href="?apartment-dashboard=user&page=documents&tab=Activitylist&action=delete&document_id=<?php echo $data_document_id; ?>&_wpnonce=<?php echo $delete_action; ?>"  class="float_left_width_100 list_delete_btn" onclick="return confirm('<?php esc_html_e('Do you really want to delete this record?','apartment_mgt');?>');">
																			<i class="fa fa-trash"></i>	<?php esc_html_e('Delete', 'apartment_mgt' ) ;?> 
																		</a>
																	<?php
																}
																?>
															</ul>
														</li>
													</ul>
												</div>	
											</td>
										</tr>
										<?php 
										$i++; 
									}
								} ?>
							</tbody>
						</table>
					</div><!---END TABLE-RESPONSIVE--->
				</div><!-- END PANEL BODY DIV -->
				<?php
			}
			else
			{
				if($user_access['add'] == 1)
				{
					?>
					<div class="no_data_list_div"> 
						<a href="<?php echo home_url().'?apartment-dashboard=user&page=documents&tab=add_document';?>">
							<img class="width_100px" src="<?php echo get_option( 'amgt_no_data_img' ) ?>" >
						</a>
						<div class="col-md-12 dashboard_btn margin_top_20px">
							<label class="no_data_list_label"><?php esc_html_e('Tap on above icon to add your first Record.','apartment_mgt'); ?> </label>
						</div> 
					</div>
					<?php
				}
				else
				{
					?>
					<div class="calendar-event-new"> 
						<img class="no_data_img" src="<?php echo AMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
					</div>
					<?php
				}
			}
	}
	if($active_tab == 'add_document')
	{ 
		require_once AMS_PLUGIN_DIR.'/template/documents/add_documents.php' ;
	}
?>
	</div>
</div><!-- END PANEL WHITE DIV -->
<?php ?>
<script>
	// REMOVING INVOICE ENTRY
   	function deleteParentElement(n)
	{
		"use strict";
		if(confirm(language_translate.add_remove))
		{
			n.parentNode.parentNode.parentNode.removeChild(n.parentNode.parentNode);
		}	
   	}
</script>