<?php
require_once AMS_PLUGIN_DIR . '/amgt-function.php';
require_once AMS_PLUGIN_DIR . '/amgt-ajax-functions.php';
require_once AMS_PLUGIN_DIR . '/class/apartment-management.php';
require_once AMS_PLUGIN_DIR . '/class/residential-unit.php';
require_once AMS_PLUGIN_DIR . '/class/member.php';
require_once AMS_PLUGIN_DIR . '/class/complaint.php';
require_once AMS_PLUGIN_DIR . '/class/visiter-manage-class.php';
require_once AMS_PLUGIN_DIR . '/class/parking.php';
require_once AMS_PLUGIN_DIR . '/class/document.php';
require_once AMS_PLUGIN_DIR . '/class/service.php';
require_once AMS_PLUGIN_DIR . '/class/facility.php';
require_once AMS_PLUGIN_DIR . '/class/assets-inventory.php';
require_once AMS_PLUGIN_DIR . '/class/message.php';
require_once AMS_PLUGIN_DIR . '/class/notice-events.php';
require_once AMS_PLUGIN_DIR . '/class/account.php';
require_once AMS_PLUGIN_DIR . '/class/tax.php';
require_once AMS_PLUGIN_DIR . '/class/maintance_setting.php';
require_once AMS_PLUGIN_DIR . '/lib/paypal/paypal_class.php';
add_action('admin_head', 'amgt_admin_css');
function amgt_admin_css()
{
	?>
	<style>
		a.toplevel_page_amgt-apartment_system:hover,
		a.toplevel_page_amgt-apartment_system:focus,
		.toplevel_page_amgt-apartment_system.opensub a.wp-has-submenu {
			background: url("<?php echo AMS_PLUGIN_URL; ?>/assets/images/apartment-management-2.png") no-repeat scroll 8px 9px rgba(0, 0, 0, 0) !important;
		}

		.toplevel_page_amgt-apartment_system:hover .wp-menu-image.dashicons-before img {
			display: none;
		}

		.toplevel_page_amgt-apartment_system:hover .wp-menu-image.dashicons-before {
			min-width: 23px !important;
		}
	</style>
	<?php
}

if (is_admin()) {
	require_once AMS_PLUGIN_DIR . '/admin/admin.php';
	function MJ_amgt_apartment_install()
	{
		add_role('accountant', esc_html__('Accountant', 'apartment_mgt'), array('read' => true, 'level_1' => true));
		add_role('member', esc_html__('Member', 'apartment_mgt'), array('read' => true, 'level_0' => true));
		add_role('staff_member', esc_html__('Staff-Member', 'apartment_mgt'), array('read' => true, 'level_0' => true));
		add_role('committee_member', esc_html__('Committee Member', 'apartment_mgt'), array('read' => true, 'level_0' => true));
		add_role('gatekeeper', esc_html__('Gatekeeper', 'apartment_mgt'), array('read' => true, 'level_0' => true));
		add_role('management', esc_html__('Management', 'apartment_mgt'), array('read' => true, 'level_1' => true, 'upload_files' => true));
		MJ_amgt_install_tables();

		MJ_amgt_install_unit_category_post();

	}
	register_activation_hook(AMS_PLUGIN_BASENAME, 'MJ_amgt_apartment_install');
	function MJ_amgt_option()
	{
		$role_access_right_member = array();
		$role_access_right_member['member'] = [
			"resident_unit" => [
				"menu_icone" => plugins_url('apartment-management/assets/images/icon/resident-unit.png'),
				'menu_title' => 'Resident Unit',
				"page_link" => 'resident_unit',
				"own_data" => isset ($_REQUEST['resident_unit_own_data']) ? $_REQUEST['resident_unit_own_data'] : 1,
				"add" => isset ($_REQUEST['resident_unit_add']) ? $_REQUEST['resident_unit_add'] : 0,
				"edit" => isset ($_REQUEST['resident_unit_edit']) ? $_REQUEST['resident_unit_edit'] : 0,
				"view" => isset ($_REQUEST['resident_unit_view']) ? $_REQUEST['resident_unit_view'] : 1,
				"delete" => isset ($_REQUEST['resident_unit_delete']) ? $_REQUEST['resident_unit_delete'] : 0
			],

			"member" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/member.png'),
				'menu_title' => 'All User',
				"page_link" => 'member',
				"own_data" => isset ($_REQUEST['member_own_data']) ? $_REQUEST['member_own_data'] : 1,
				"add" => isset ($_REQUEST['member_add']) ? $_REQUEST['member_add'] : 0,
				"edit" => isset ($_REQUEST['member_edit']) ? $_REQUEST['member_edit'] : 0,
				"view" => isset ($_REQUEST['member_view']) ? $_REQUEST['member_view'] : 1,
				"delete" => isset ($_REQUEST['member_delete']) ? $_REQUEST['member_delete'] : 0
			],

			"committee-member" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Committee-Member.png'),
				'menu_title' => 'Committee Member',
				"page_link" => 'committee-member',
				"own_data" => isset ($_REQUEST['committee-member_own_data']) ? $_REQUEST['committee-member_own_data'] : 0,
				"add" => isset ($_REQUEST['committee-member_add']) ? $_REQUEST['committee-member_add'] : 0,
				"edit" => isset ($_REQUEST['committee-member_edit']) ? $_REQUEST['committee-member_edit'] : 0,
				"view" => isset ($_REQUEST['committee-member_view']) ? $_REQUEST['committee-member_view'] : 1,
				"delete" => isset ($_REQUEST['committee-member_delete']) ? $_REQUEST['committee-member_delete'] : 0
			],

			"accountant" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Accountant.png'),
				'menu_title' => 'Accountant',
				"page_link" => 'accountant',
				"own_data" => isset ($_REQUEST['accountant_own_data']) ? $_REQUEST['accountant_own_data'] : 0,
				"add" => isset ($_REQUEST['accountant_add']) ? $_REQUEST['accountant_add'] : 0,
				"edit" => isset ($_REQUEST['accountant_edit']) ? $_REQUEST['accountant_edit'] : 0,
				"view" => isset ($_REQUEST['accountant_view']) ? $_REQUEST['accountant_view'] : 1,
				"delete" => isset ($_REQUEST['accountant_delete']) ? $_REQUEST['accountant_delete'] : 0
			],

			"staff-members" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Staff-Management.png'),
				'menu_title' => 'Staff Management',
				"page_link" => 'staff-members',
				"own_data" => isset ($_REQUEST['staff-members_own_data']) ? $_REQUEST['staff-members_own_data'] : 0,
				"add" => isset ($_REQUEST['staff-members_add']) ? $_REQUEST['staff-members_add'] : 0,
				"edit" => isset ($_REQUEST['staff-members_edit']) ? $_REQUEST['staff-members_edit'] : 0,
				"view" => isset ($_REQUEST['staff-members_view']) ? $_REQUEST['staff-members_view'] : 1,
				"delete" => isset ($_REQUEST['staff-members_delete']) ? $_REQUEST['staff-members_delete'] : 0
			],
			"gatekeeper" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Gatekeeper.png'),
				'menu_title' => 'Gatekeeper',
				"page_link" => 'gatekeeper',
				"own_data" => isset ($_REQUEST['gatekeeper_own_data']) ? $_REQUEST['gatekeeper_own_data'] : 0,
				"add" => isset ($_REQUEST['gatekeeper_add']) ? $_REQUEST['gatekeeper_add'] : 0,
				"edit" => isset ($_REQUEST['gatekeeper_edit']) ? $_REQUEST['gatekeeper_edit'] : 0,
				"view" => isset ($_REQUEST['gatekeeper_view']) ? $_REQUEST['gatekeeper_view'] : 1,
				"delete" => isset ($_REQUEST['gatekeeper_delete']) ? $_REQUEST['gatekeeper_delete'] : 0
			],

			"report" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Report.png'),
				"menu_title" => 'Report',
				"page_link" => 'report',
				"own_data" => isset ($_REQUEST['report_own_data']) ? $_REQUEST['report_own_data'] : 0,
				"add" => isset ($_REQUEST['report_add']) ? $_REQUEST['report_add'] : 0,
				"edit" => isset ($_REQUEST['report_edit']) ? $_REQUEST['report_edit'] : 0,
				"view" => isset ($_REQUEST['report_view']) ? $_REQUEST['report_view'] : 1,
				"delete" => isset ($_REQUEST['report_delete']) ? $_REQUEST['report_delete'] : 0
			],

			"visitor-manage" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Visitor-Manage.png'),
				'menu_title' => 'Visitor Management',
				"page_link" => 'visitor-manage',
				"own_data" => isset ($_REQUEST['visitor-manage_own_data']) ? $_REQUEST['visitor-manage_own_data'] : 1,
				"add" => isset ($_REQUEST['visitor-manage_add']) ? $_REQUEST['visitor-manage_add'] : 1,
				"edit" => isset ($_REQUEST['visitor-manage_edit']) ? $_REQUEST['visitor-manage_edit'] : 0,
				"view" => isset ($_REQUEST['visitor-manage_view']) ? $_REQUEST['visitor-manage_view'] : 1,
				"delete" => isset ($_REQUEST['visitor-manage_delete']) ? $_REQUEST['visitor-manage_delete'] : 0
			],

			"notice-event" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Notice-And-Event.png'),
				'menu_title' => 'Notice And Event',
				"page_link" => 'notice-event',
				"own_data" => isset ($_REQUEST['notice-event_own_data']) ? $_REQUEST['notice-event_own_data'] : 0,
				"add" => isset ($_REQUEST['notice-event_add']) ? $_REQUEST['notice-event_add'] : 0,
				"edit" => isset ($_REQUEST['notice-event_edit']) ? $_REQUEST['notice-event_edit'] : 0,
				"view" => isset ($_REQUEST['notice-event_view']) ? $_REQUEST['notice-event_view'] : 1,
				"delete" => isset ($_REQUEST['notice-event_delete']) ? $_REQUEST['notice-event_delete'] : 0
			],
			"complaint" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Complaint.png'),
				'menu_title' => 'Complaint',
				"page_link" => 'complaint',
				"own_data" => isset ($_REQUEST['complaint_own_data']) ? $_REQUEST['complaint_own_data'] : 1,
				"add" => isset ($_REQUEST['complaint_add']) ? $_REQUEST['complaint_add'] : 1,
				"edit" => isset ($_REQUEST['complaint_edit']) ? $_REQUEST['complaint_edit'] : 1,
				"view" => isset ($_REQUEST['complaint_view']) ? $_REQUEST['complaint_view'] : 1,
				"delete" => isset ($_REQUEST['complaint_delete']) ? $_REQUEST['complaint_delete'] : 0
			],
			"parking-manager" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Parking-Manager.png'),
				'menu_title' => 'Parking Manager',
				"page_link" => 'parking-manager',
				"own_data" => isset ($_REQUEST['parking-manager_own_data']) ? $_REQUEST['parking-manager_own_data'] : 1,
				"add" => isset ($_REQUEST['parking-manager_add']) ? $_REQUEST['parking-manager_add'] : 0,
				"edit" => isset ($_REQUEST['parking-manager_edit']) ? $_REQUEST['parking-manager_edit'] : 0,
				"view" => isset ($_REQUEST['parking-manager_view']) ? $_REQUEST['parking-manager_view'] : 1,
				"delete" => isset ($_REQUEST['parking-manager_delete']) ? $_REQUEST['parking-manager_delete'] : 0
			],

			"services" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/services.png'),
				'menu_title' => 'Services',
				"page_link" => 'services',
				"own_data" => isset ($_REQUEST['services_own_data']) ? $_REQUEST['services_own_data'] : 0,
				"add" => isset ($_REQUEST['services_add']) ? $_REQUEST['services_add'] : 0,
				"edit" => isset ($_REQUEST['services_edit']) ? $_REQUEST['services_edit'] : 0,
				"view" => isset ($_REQUEST['services_view']) ? $_REQUEST['services_view'] : 1,
				"delete" => isset ($_REQUEST['services_delete']) ? $_REQUEST['services_delete'] : 0
			],

			"facility" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Facility.png'),
				'menu_title' => 'Facility',
				"page_link" => 'facility',
				"own_data" => isset ($_REQUEST['facility_own_data']) ? $_REQUEST['facility_own_data'] : 1,
				"add" => isset ($_REQUEST['facility_add']) ? $_REQUEST['facility_add'] : 1,
				"edit" => isset ($_REQUEST['facility_edit']) ? $_REQUEST['facility_edit'] : 0,
				"view" => isset ($_REQUEST['facility_view']) ? $_REQUEST['facility_view'] : 1,
				"delete" => isset ($_REQUEST['facility_delete']) ? $_REQUEST['facility_delete'] : 0
			],
			"accounts" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Accounts.png'),
				'menu_title' => 'Accounts',
				"page_link" => 'accounts',
				"own_data" => isset ($_REQUEST['accounts_own_data']) ? $_REQUEST['accounts_own_data'] : 1,
				"add" => isset ($_REQUEST['accounts_add']) ? $_REQUEST['accounts_add'] : 0,
				"edit" => isset ($_REQUEST['accounts_edit']) ? $_REQUEST['accounts_edit'] : 0,
				"view" => isset ($_REQUEST['accounts_view']) ? $_REQUEST['accounts_view'] : 1,
				"delete" => isset ($_REQUEST['accounts_delete']) ? $_REQUEST['accounts_delete'] : 0
			],
			"documents" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/document.png'),
				'menu_title' => 'Documents',
				"page_link" => 'documents',
				"own_data" => isset ($_REQUEST['documents_own_data']) ? $_REQUEST['documents_own_data'] : 1,
				"add" => isset ($_REQUEST['documents_add']) ? $_REQUEST['documents_add'] : 1,
				"edit" => isset ($_REQUEST['documents_edit']) ? $_REQUEST['documents_edit'] : 0,
				"view" => isset ($_REQUEST['documents_view']) ? $_REQUEST['documents_view'] : 1,
				"delete" => isset ($_REQUEST['documents_delete']) ? $_REQUEST['documents_delete'] : 0
			],
			"assets-inventory-tracker" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Assets--Inventory-Tracker.png'),
				'menu_title' => 'Assets / Inventory Tracker',
				"page_link" => 'assets-inventory-tracker',
				"own_data" => isset ($_REQUEST['assets-inventory-tracker_own_data']) ? $_REQUEST['assets-inventory-tracker_own_data'] : 0,
				"add" => isset ($_REQUEST['assets-inventory-tracker_add']) ? $_REQUEST['assets-inventory-tracker_add'] : 0,
				"edit" => isset ($_REQUEST['assets-inventory-tracker_edit']) ? $_REQUEST['assets-inventory-tracker_edit'] : 0,
				"view" => isset ($_REQUEST['assets-inventory-tracker_view']) ? $_REQUEST['assets-inventory-tracker_view'] : 1,
				"delete" => isset ($_REQUEST['assets-inventory-tracker_delete']) ? $_REQUEST['assets-inventory-tracker_delete'] : 0
			],

			"message" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/message.png'),
				"menu_title" => 'Message',
				"page_link" => 'message',
				"own_data" => isset ($_REQUEST['message_own_data']) ? $_REQUEST['message_own_data'] : 1,
				"add" => isset ($_REQUEST['message_add']) ? $_REQUEST['message_add'] : 1,
				"edit" => isset ($_REQUEST['message_edit']) ? $_REQUEST['message_edit'] : 0,
				"view" => isset ($_REQUEST['message_view']) ? $_REQUEST['message_view'] : 1,
				"delete" => isset ($_REQUEST['message_delete']) ? $_REQUEST['message_delete'] : 1
			],
			"report" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Report.png'),
				"menu_title" => 'Report',
				"page_link" => 'report',
				"own_data" => isset ($_REQUEST['report_own_data']) ? $_REQUEST['report_own_data'] : 1,
				"add" => isset ($_REQUEST['report_add']) ? $_REQUEST['report_add'] : 0,
				"edit" => isset ($_REQUEST['report_edit']) ? $_REQUEST['report_edit'] : 0,
				"view" => isset ($_REQUEST['report_view']) ? $_REQUEST['report_view'] : 1,
				"delete" => isset ($_REQUEST['report_delete']) ? $_REQUEST['report_delete'] : 0
			],

			"profile" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/account.png'),
				'menu_title' => 'Profile',
				"page_link" => 'profile',
				"own_data" => isset ($_REQUEST['profile_own_data']) ? $_REQUEST['profile_own_data'] : 1,
				"add" => isset ($_REQUEST['profile_add']) ? $_REQUEST['profile_add'] : 0,
				"edit" => isset ($_REQUEST['profile_edit']) ? $_REQUEST['profile_edit'] : 0,
				"view" => isset ($_REQUEST['profile_view']) ? $_REQUEST['profile_view'] : 1,
				"delete" => isset ($_REQUEST['profile_delete']) ? $_REQUEST['profile_delete'] : 0
			],

			"faq" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/faq.png'),
				'menu_title' => 'FAQ',
				"page_link" => 'faq',
				"own_data" => isset ($_REQUEST['faq_own_data']) ? $_REQUEST['faq_own_data'] : 0,
				"add" => isset ($_REQUEST['faq_add']) ? $_REQUEST['faq_add'] : 0,
				"edit" => isset ($_REQUEST['faq_edit']) ? $_REQUEST['faq_edit'] : 0,
				"view" => isset ($_REQUEST['faq_view']) ? $_REQUEST['faq_view'] : 1,
				"delete" => isset ($_REQUEST['faq_delete']) ? $_REQUEST['faq_delete'] : 0
			],

			"society_rules" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Society-Rules.png'),
				'menu_title' => 'Rules',
				"page_link" => 'society_rules',
				"own_data" => isset ($_REQUEST['society_rules_own_data']) ? $_REQUEST['society_rules_own_data'] : 0,
				"add" => isset ($_REQUEST['society_rules_add']) ? $_REQUEST['society_rules_add'] : 0,
				"edit" => isset ($_REQUEST['society_rules_edit']) ? $_REQUEST['society_rules_edit'] : 0,
				"view" => isset ($_REQUEST['society_rules_view']) ? $_REQUEST['society_rules_view'] : 1,
				"delete" => isset ($_REQUEST['society_rules_delete']) ? $_REQUEST['society_rules_delete'] : 0
			],
			"gallery" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/gallery.png'),
				'menu_title' => 'Gallery',
				"page_link" => 'gallery',
				"own_data" => isset ($_REQUEST['gallery_own_data']) ? $_REQUEST['gallery_own_data'] : 0,
				"add" => isset ($_REQUEST['gallery_add']) ? $_REQUEST['gallery_add'] : 0,
				"edit" => isset ($_REQUEST['gallery_edit']) ? $_REQUEST['gallery_edit'] : 0,
				"view" => isset ($_REQUEST['gallery_view']) ? $_REQUEST['gallery_view'] : 1,
				"delete" => isset ($_REQUEST['gallery_delete']) ? $_REQUEST['gallery_delete'] : 0
			]
		];
		$role_access_right_staff_member = array();
		$role_access_right_staff_member['staff_member'] = [
			"resident_unit" => [
				"menu_icone" => plugins_url('apartment-management/assets/images/icon/resident-unit.png'),
				'menu_title' => 'Resident Unit',
				"page_link" => 'resident_unit',
				"own_data" => isset ($_REQUEST['resident_unit_own_data']) ? $_REQUEST['resident_unit_own_data'] : 1,
				"add" => isset ($_REQUEST['resident_unit_add']) ? $_REQUEST['resident_unit_add'] : 1,
				"edit" => isset ($_REQUEST['resident_unit_edit']) ? $_REQUEST['resident_unit_edit'] : 1,
				"view" => isset ($_REQUEST['resident_unit_view']) ? $_REQUEST['resident_unit_view'] : 1,
				"delete" => isset ($_REQUEST['resident_unit_delete']) ? $_REQUEST['resident_unit_delete'] : 1
			],

			"member" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/member.png'),
				'menu_title' => 'All User',
				"page_link" => 'member',
				"own_data" => isset ($_REQUEST['member_own_data']) ? $_REQUEST['member_own_data'] : 0,
				"add" => isset ($_REQUEST['member_add']) ? $_REQUEST['member_add'] : 1,
				"edit" => isset ($_REQUEST['member_edit']) ? $_REQUEST['member_edit'] : 1,
				"view" => isset ($_REQUEST['member_view']) ? $_REQUEST['member_view'] : 1,
				"delete" => isset ($_REQUEST['member_delete']) ? $_REQUEST['member_delete'] : 1
			],

			"committee-member" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Committee-Member.png'),
				'menu_title' => 'Committee Member',
				"page_link" => 'committee-member',
				"own_data" => isset ($_REQUEST['committee-member_own_data']) ? $_REQUEST['committee-member_own_data'] : 0,
				"add" => isset ($_REQUEST['committee-member_add']) ? $_REQUEST['committee-member_add'] : 0,
				"edit" => isset ($_REQUEST['committee-member_edit']) ? $_REQUEST['committee-member_edit'] : 0,
				"view" => isset ($_REQUEST['committee-member_view']) ? $_REQUEST['committee-member_view'] : 1,
				"delete" => isset ($_REQUEST['committee-member_delete']) ? $_REQUEST['committee-member_delete'] : 0
			],

			"accountant" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Accountant.png'),
				'menu_title' => 'Accountant',
				"page_link" => 'accountant',
				"own_data" => isset ($_REQUEST['accountant_own_data']) ? $_REQUEST['accountant_own_data'] : 0,
				"add" => isset ($_REQUEST['accountant_add']) ? $_REQUEST['accountant_add'] : 1,
				"edit" => isset ($_REQUEST['accountant_edit']) ? $_REQUEST['accountant_edit'] : 1,
				"view" => isset ($_REQUEST['accountant_view']) ? $_REQUEST['accountant_view'] : 1,
				"delete" => isset ($_REQUEST['accountant_delete']) ? $_REQUEST['accountant_delete'] : 1
			],

			"staff-members" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Staff-Management.png'),
				'menu_title' => 'Staff Management',
				"page_link" => 'staff-members',
				"own_data" => isset ($_REQUEST['staff-members_own_data']) ? $_REQUEST['staff-members_own_data'] : 1,
				"add" => isset ($_REQUEST['staff-members_add']) ? $_REQUEST['staff-members_add'] : 1,
				"edit" => isset ($_REQUEST['staff-members_edit']) ? $_REQUEST['staff-members_edit'] : 1,
				"view" => isset ($_REQUEST['staff-members_view']) ? $_REQUEST['staff-members_view'] : 1,
				"delete" => isset ($_REQUEST['staff-members_delete']) ? $_REQUEST['staff-members_delete'] : 1
			],
			"gatekeeper" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Gatekeeper.png'),
				'menu_title' => 'Gatekeeper',
				"page_link" => 'gatekeeper',
				"own_data" => isset ($_REQUEST['gatekeeper_own_data']) ? $_REQUEST['gatekeeper_own_data'] : 0,
				"add" => isset ($_REQUEST['gatekeeper_add']) ? $_REQUEST['gatekeeper_add'] : 1,
				"edit" => isset ($_REQUEST['gatekeeper_edit']) ? $_REQUEST['gatekeeper_edit'] : 1,
				"view" => isset ($_REQUEST['gatekeeper_view']) ? $_REQUEST['gatekeeper_view'] : 1,
				"delete" => isset ($_REQUEST['gatekeeper_delete']) ? $_REQUEST['gatekeeper_delete'] : 1
			],

			"report" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Report.png'),
				"menu_title" => 'Report',
				"page_link" => 'report',
				"own_data" => isset ($_REQUEST['report_own_data']) ? $_REQUEST['report_own_data'] : 0,
				"add" => isset ($_REQUEST['report_add']) ? $_REQUEST['report_add'] : 0,
				"edit" => isset ($_REQUEST['report_edit']) ? $_REQUEST['report_edit'] : 0,
				"view" => isset ($_REQUEST['report_view']) ? $_REQUEST['report_view'] : 1,
				"delete" => isset ($_REQUEST['report_delete']) ? $_REQUEST['report_delete'] : 0
			],

			"visitor-manage" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Visitor-Manage.png'),
				'menu_title' => 'Visitor Management',
				"page_link" => 'visitor-manage',
				"own_data" => isset ($_REQUEST['visitor-manage_own_data']) ? $_REQUEST['visitor-manage_own_data'] : 0,
				"add" => isset ($_REQUEST['visitor-manage_add']) ? $_REQUEST['visitor-manage_add'] : 1,
				"edit" => isset ($_REQUEST['visitor-manage_edit']) ? $_REQUEST['visitor-manage_edit'] : 1,
				"view" => isset ($_REQUEST['visitor-manage_view']) ? $_REQUEST['visitor-manage_view'] : 1,
				"delete" => isset ($_REQUEST['visitor-manage_delete']) ? $_REQUEST['visitor-manage_delete'] : 1
			],


			"notice-event" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Notice-And-Event.png'),
				'menu_title' => 'Notice And Event',
				"page_link" => 'notice-event',
				"own_data" => isset ($_REQUEST['notice-event_own_data']) ? $_REQUEST['notice-event_own_data'] : 0,
				"add" => isset ($_REQUEST['notice-event_add']) ? $_REQUEST['notice-event_add'] : 1,
				"edit" => isset ($_REQUEST['notice-event_edit']) ? $_REQUEST['notice-event_edit'] : 1,
				"view" => isset ($_REQUEST['notice-event_view']) ? $_REQUEST['notice-event_view'] : 1,
				"delete" => isset ($_REQUEST['notice-event_delete']) ? $_REQUEST['notice-event_delete'] : 1
			],
			"complaint" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Complaint.png'),
				'menu_title' => 'Complaint',
				"page_link" => 'complaint',
				"own_data" => isset ($_REQUEST['complaint_own_data']) ? $_REQUEST['complaint_own_data'] : 0,
				"add" => isset ($_REQUEST['complaint_add']) ? $_REQUEST['complaint_add'] : 1,
				"edit" => isset ($_REQUEST['complaint_edit']) ? $_REQUEST['complaint_edit'] : 1,
				"view" => isset ($_REQUEST['complaint_view']) ? $_REQUEST['complaint_view'] : 1,
				"delete" => isset ($_REQUEST['complaint_delete']) ? $_REQUEST['complaint_delete'] : 1
			],
			"parking-manager" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Parking-Manager.png'),
				'menu_title' => 'Parking Manager',
				"page_link" => 'parking-manager',
				"own_data" => isset ($_REQUEST['parking-manager_own_data']) ? $_REQUEST['parking-manager_own_data'] : 0,
				"add" => isset ($_REQUEST['parking-manager_add']) ? $_REQUEST['parking-manager_add'] : 1,
				"edit" => isset ($_REQUEST['parking-manager_edit']) ? $_REQUEST['parking-manager_edit'] : 1,
				"view" => isset ($_REQUEST['parking-manager_view']) ? $_REQUEST['parking-manager_view'] : 1,
				"delete" => isset ($_REQUEST['parking-manager_delete']) ? $_REQUEST['parking-manager_delete'] : 1
			],

			"services" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/services.png'),
				'menu_title' => 'Services',
				"page_link" => 'services',
				"own_data" => isset ($_REQUEST['services_own_data']) ? $_REQUEST['services_own_data'] : 0,
				"add" => isset ($_REQUEST['services_add']) ? $_REQUEST['services_add'] : 1,
				"edit" => isset ($_REQUEST['services_edit']) ? $_REQUEST['services_edit'] : 1,
				"view" => isset ($_REQUEST['services_view']) ? $_REQUEST['services_view'] : 1,
				"delete" => isset ($_REQUEST['services_delete']) ? $_REQUEST['services_delete'] : 1
			],

			"facility" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Facility.png'),
				'menu_title' => 'Facility',
				"page_link" => 'facility',
				"own_data" => isset ($_REQUEST['facility_own_data']) ? $_REQUEST['facility_own_data'] : 0,
				"add" => isset ($_REQUEST['facility_add']) ? $_REQUEST['facility_add'] : 1,
				"edit" => isset ($_REQUEST['facility_edit']) ? $_REQUEST['facility_edit'] : 1,
				"view" => isset ($_REQUEST['facility_view']) ? $_REQUEST['facility_view'] : 1,
				"delete" => isset ($_REQUEST['facility_delete']) ? $_REQUEST['facility_delete'] : 1
			],
			"accounts" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Accounts.png'),
				'menu_title' => 'Accounts',
				"page_link" => 'accounts',
				"own_data" => isset ($_REQUEST['accounts_own_data']) ? $_REQUEST['accounts_own_data'] : 0,
				"add" => isset ($_REQUEST['accounts_add']) ? $_REQUEST['accounts_add'] : 1,
				"edit" => isset ($_REQUEST['accounts_edit']) ? $_REQUEST['accounts_edit'] : 1,
				"view" => isset ($_REQUEST['accounts_view']) ? $_REQUEST['accounts_view'] : 1,
				"delete" => isset ($_REQUEST['accounts_delete']) ? $_REQUEST['accounts_delete'] : 1
			],
			"documents" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/document.png'),
				'menu_title' => 'Documents',
				"page_link" => 'documents',
				"own_data" => isset ($_REQUEST['documents_own_data']) ? $_REQUEST['documents_own_data'] : 0,
				"add" => isset ($_REQUEST['documents_add']) ? $_REQUEST['documents_add'] : 1,
				"edit" => isset ($_REQUEST['documents_edit']) ? $_REQUEST['documents_edit'] : 1,
				"view" => isset ($_REQUEST['documents_view']) ? $_REQUEST['documents_view'] : 1,
				"delete" => isset ($_REQUEST['documents_delete']) ? $_REQUEST['documents_delete'] : 1
			],
			"assets-inventory-tracker" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Assets--Inventory-Tracker.png'),
				'menu_title' => 'Assets / Inventory Tracker',
				"page_link" => 'assets-inventory-tracker',
				"own_data" => isset ($_REQUEST['assets-inventory-tracker_own_data']) ? $_REQUEST['assets-inventory-tracker_own_data'] : 0,
				"add" => isset ($_REQUEST['assets-inventory-tracker_add']) ? $_REQUEST['assets-inventory-tracker_add'] : 1,
				"edit" => isset ($_REQUEST['assets-inventory-tracker_edit']) ? $_REQUEST['assets-inventory-tracker_edit'] : 1,
				"view" => isset ($_REQUEST['assets-inventory-tracker_view']) ? $_REQUEST['assets-inventory-tracker_view'] : 1,
				"delete" => isset ($_REQUEST['assets-inventory-tracker_delete']) ? $_REQUEST['assets-inventory-tracker_delete'] : 1
			],

			"message" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/message.png'),
				"menu_title" => 'Message',
				"page_link" => 'message',
				"own_data" => isset ($_REQUEST['message_own_data']) ? $_REQUEST['message_own_data'] : 1,
				"add" => isset ($_REQUEST['message_add']) ? $_REQUEST['message_add'] : 1,
				"edit" => isset ($_REQUEST['message_edit']) ? $_REQUEST['message_edit'] : 0,
				"view" => isset ($_REQUEST['message_view']) ? $_REQUEST['message_view'] : 1,
				"delete" => isset ($_REQUEST['message_delete']) ? $_REQUEST['message_delete'] : 1
			],

			"profile" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/account.png'),
				'menu_title' => 'Profile',
				"page_link" => 'profile',
				"own_data" => isset ($_REQUEST['profile_own_data']) ? $_REQUEST['profile_own_data'] : 1,
				"add" => isset ($_REQUEST['profile_add']) ? $_REQUEST['profile_add'] : 0,
				"edit" => isset ($_REQUEST['profile_edit']) ? $_REQUEST['profile_edit'] : 0,
				"view" => isset ($_REQUEST['profile_view']) ? $_REQUEST['profile_view'] : 1,
				"delete" => isset ($_REQUEST['profile_delete']) ? $_REQUEST['profile_delete'] : 0
			],

			"faq" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/faq.png'),
				'menu_title' => 'FAQ',
				"page_link" => 'faq',
				"own_data" => isset ($_REQUEST['faq_own_data']) ? $_REQUEST['faq_own_data'] : 0,
				"add" => isset ($_REQUEST['faq_add']) ? $_REQUEST['faq_add'] : 0,
				"edit" => isset ($_REQUEST['faq_edit']) ? $_REQUEST['faq_edit'] : 0,
				"view" => isset ($_REQUEST['faq_view']) ? $_REQUEST['faq_view'] : 1,
				"delete" => isset ($_REQUEST['faq_delete']) ? $_REQUEST['faq_delete'] : 0
			],

			"society_rules" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Society-Rules.png'),
				'menu_title' => 'Rules',
				"page_link" => 'society_rules',
				"own_data" => isset ($_REQUEST['society_rules_own_data']) ? $_REQUEST['society_rules_own_data'] : 0,
				"add" => isset ($_REQUEST['society_rules_add']) ? $_REQUEST['society_rules_add'] : 0,
				"edit" => isset ($_REQUEST['society_rules_edit']) ? $_REQUEST['society_rules_edit'] : 0,
				"view" => isset ($_REQUEST['society_rules_view']) ? $_REQUEST['society_rules_view'] : 1,
				"delete" => isset ($_REQUEST['society_rules_delete']) ? $_REQUEST['society_rules_delete'] : 0
			],
			"gallery" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/gallery.png'),
				'menu_title' => 'Gallery',
				"page_link" => 'gallery',
				"own_data" => isset ($_REQUEST['gallery_own_data']) ? $_REQUEST['gallery_own_data'] : 0,
				"add" => isset ($_REQUEST['gallery_add']) ? $_REQUEST['gallery_add'] : 0,
				"edit" => isset ($_REQUEST['gallery_edit']) ? $_REQUEST['gallery_edit'] : 0,
				"view" => isset ($_REQUEST['gallery_view']) ? $_REQUEST['gallery_view'] : 1,
				"delete" => isset ($_REQUEST['gallery_delete']) ? $_REQUEST['gallery_delete'] : 0
			]
		];
		$role_access_right_accountant = array();
		$role_access_right_accountant['accountant'] = [
			"resident_unit" => [
				"menu_icone" => plugins_url('apartment-management/assets/images/icon/resident-unit.png'),
				'menu_title' => 'Resident Unit',
				"page_link" => 'resident_unit',
				"own_data" => isset ($_REQUEST['resident_unit_own_data']) ? $_REQUEST['resident_unit_own_data'] : 0,
				"add" => isset ($_REQUEST['resident_unit_add']) ? $_REQUEST['resident_unit_add'] : 0,
				"edit" => isset ($_REQUEST['resident_unit_edit']) ? $_REQUEST['resident_unit_edit'] : 0,
				"view" => isset ($_REQUEST['resident_unit_view']) ? $_REQUEST['resident_unit_view'] : 1,
				"delete" => isset ($_REQUEST['resident_unit_delete']) ? $_REQUEST['resident_unit_delete'] : 0
			],

			"member" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/member.png'),
				'menu_title' => 'All User',
				"page_link" => 'member',
				"own_data" => isset ($_REQUEST['member_own_data']) ? $_REQUEST['member_own_data'] : 0,
				"add" => isset ($_REQUEST['member_add']) ? $_REQUEST['member_add'] : 0,
				"edit" => isset ($_REQUEST['member_edit']) ? $_REQUEST['member_edit'] : 0,
				"view" => isset ($_REQUEST['member_view']) ? $_REQUEST['member_view'] : 1,
				"delete" => isset ($_REQUEST['member_delete']) ? $_REQUEST['member_delete'] : 0
			],

			"committee-member" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Committee-Member.png'),
				'menu_title' => 'Committee Member',
				"page_link" => 'committee-member',
				"own_data" => isset ($_REQUEST['committee-member_own_data']) ? $_REQUEST['committee-member_own_data'] : 0,
				"add" => isset ($_REQUEST['committee-member_add']) ? $_REQUEST['committee-member_add'] : 0,
				"edit" => isset ($_REQUEST['committee-member_edit']) ? $_REQUEST['committee-member_edit'] : 0,
				"view" => isset ($_REQUEST['committee-member_view']) ? $_REQUEST['committee-member_view'] : 1,
				"delete" => isset ($_REQUEST['committee-member_delete']) ? $_REQUEST['committee-member_delete'] : 0
			],

			"accountant" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Accountant.png'),
				'menu_title' => 'Accountant',
				"page_link" => 'accountant',
				"own_data" => isset ($_REQUEST['accountant_own_data']) ? $_REQUEST['accountant_own_data'] : 1,
				"add" => isset ($_REQUEST['accountant_add']) ? $_REQUEST['accountant_add'] : 0,
				"edit" => isset ($_REQUEST['accountant_edit']) ? $_REQUEST['accountant_edit'] : 0,
				"view" => isset ($_REQUEST['accountant_view']) ? $_REQUEST['accountant_view'] : 1,
				"delete" => isset ($_REQUEST['accountant_delete']) ? $_REQUEST['accountant_delete'] : 0
			],

			"staff-members" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Staff-Management.png'),
				'menu_title' => 'Staff Management',
				"page_link" => 'staff-members',
				"own_data" => isset ($_REQUEST['staff-members_own_data']) ? $_REQUEST['staff-members_own_data'] : 0,
				"add" => isset ($_REQUEST['staff-members_add']) ? $_REQUEST['staff-members_add'] : 0,
				"edit" => isset ($_REQUEST['staff-members_edit']) ? $_REQUEST['staff-members_edit'] : 0,
				"view" => isset ($_REQUEST['staff-members_view']) ? $_REQUEST['staff-members_view'] : 1,
				"delete" => isset ($_REQUEST['staff-members_delete']) ? $_REQUEST['staff-members_delete'] : 0
			],
			"gatekeeper" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Gatekeeper.png'),
				'menu_title' => 'Gatekeeper',
				"page_link" => 'gatekeeper',
				"own_data" => isset ($_REQUEST['gatekeeper_own_data']) ? $_REQUEST['gatekeeper_own_data'] : 0,
				"add" => isset ($_REQUEST['gatekeeper_add']) ? $_REQUEST['gatekeeper_add'] : 0,
				"edit" => isset ($_REQUEST['gatekeeper_edit']) ? $_REQUEST['gatekeeper_edit'] : 0,
				"view" => isset ($_REQUEST['gatekeeper_view']) ? $_REQUEST['gatekeeper_view'] : 1,
				"delete" => isset ($_REQUEST['gatekeeper_delete']) ? $_REQUEST['gatekeeper_delete'] : 0
			],

			"report" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Report.png'),
				"menu_title" => 'Report',
				"page_link" => 'report',
				"own_data" => isset ($_REQUEST['report_own_data']) ? $_REQUEST['report_own_data'] : 0,
				"add" => isset ($_REQUEST['report_add']) ? $_REQUEST['report_add'] : 0,
				"edit" => isset ($_REQUEST['report_edit']) ? $_REQUEST['report_edit'] : 0,
				"view" => isset ($_REQUEST['report_view']) ? $_REQUEST['report_view'] : 1,
				"delete" => isset ($_REQUEST['report_delete']) ? $_REQUEST['report_delete'] : 0
			],

			"visitor-manage" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Visitor-Manage.png'),
				'menu_title' => 'Visitor Management',
				"page_link" => 'visitor-manage',
				"own_data" => isset ($_REQUEST['visitor-manage_own_data']) ? $_REQUEST['visitor-manage_own_data'] : 1,
				"add" => isset ($_REQUEST['visitor-manage_add']) ? $_REQUEST['visitor-manage_add'] : 0,
				"edit" => isset ($_REQUEST['visitor-manage_edit']) ? $_REQUEST['visitor-manage_edit'] : 0,
				"view" => isset ($_REQUEST['visitor-manage_view']) ? $_REQUEST['visitor-manage_view'] : 1,
				"delete" => isset ($_REQUEST['visitor-manage_delete']) ? $_REQUEST['visitor-manage_delete'] : 0
			],


			"notice-event" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Notice-And-Event.png'),
				'menu_title' => 'Notice And Event',
				"page_link" => 'notice-event',
				"own_data" => isset ($_REQUEST['notice-event_own_data']) ? $_REQUEST['notice-event_own_data'] : 0,
				"add" => isset ($_REQUEST['notice-event_add']) ? $_REQUEST['notice-event_add'] : 0,
				"edit" => isset ($_REQUEST['notice-event_edit']) ? $_REQUEST['notice-event_edit'] : 0,
				"view" => isset ($_REQUEST['notice-event_view']) ? $_REQUEST['notice-event_view'] : 1,
				"delete" => isset ($_REQUEST['notice-event_delete']) ? $_REQUEST['notice-event_delete'] : 0
			],
			"complaint" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Complaint.png'),
				'menu_title' => 'Complaint',
				"page_link" => 'complaint',
				"own_data" => isset ($_REQUEST['complaint_own_data']) ? $_REQUEST['complaint_own_data'] : 0,
				"add" => isset ($_REQUEST['complaint_add']) ? $_REQUEST['complaint_add'] : 0,
				"edit" => isset ($_REQUEST['complaint_edit']) ? $_REQUEST['complaint_edit'] : 0,
				"view" => isset ($_REQUEST['complaint_view']) ? $_REQUEST['complaint_view'] : 1,
				"delete" => isset ($_REQUEST['complaint_delete']) ? $_REQUEST['complaint_delete'] : 0
			],
			"parking-manager" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Parking-Manager.png'),
				'menu_title' => 'Parking Manager',
				"page_link" => 'parking-manager',
				"own_data" => isset ($_REQUEST['parking-manager_own_data']) ? $_REQUEST['parking-manager_own_data'] : 1,
				"add" => isset ($_REQUEST['parking-manager_add']) ? $_REQUEST['parking-manager_add'] : 0,
				"edit" => isset ($_REQUEST['parking-manager_edit']) ? $_REQUEST['parking-manager_edit'] : 0,
				"view" => isset ($_REQUEST['parking-manager_view']) ? $_REQUEST['parking-manager_view'] : 0,
				"delete" => isset ($_REQUEST['parking-manager_delete']) ? $_REQUEST['parking-manager_delete'] : 0
			],

			"services" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/services.png'),
				'menu_title' => 'Services',
				"page_link" => 'services',
				"own_data" => isset ($_REQUEST['services_own_data']) ? $_REQUEST['services_own_data'] : 0,
				"add" => isset ($_REQUEST['services_add']) ? $_REQUEST['services_add'] : 0,
				"edit" => isset ($_REQUEST['services_edit']) ? $_REQUEST['services_edit'] : 0,
				"view" => isset ($_REQUEST['services_view']) ? $_REQUEST['services_view'] : 1,
				"delete" => isset ($_REQUEST['services_delete']) ? $_REQUEST['services_delete'] : 0
			],

			"facility" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Facility.png'),
				'menu_title' => 'Facility',
				"page_link" => 'facility',
				"own_data" => isset ($_REQUEST['facility_own_data']) ? $_REQUEST['facility_own_data'] : 1,
				"add" => isset ($_REQUEST['facility_add']) ? $_REQUEST['facility_add'] : 0,
				"edit" => isset ($_REQUEST['facility_edit']) ? $_REQUEST['facility_edit'] : 0,
				"view" => isset ($_REQUEST['facility_view']) ? $_REQUEST['facility_view'] : 1,
				"delete" => isset ($_REQUEST['facility_delete']) ? $_REQUEST['facility_delete'] : 0
			],
			"accounts" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Accounts.png'),
				'menu_title' => 'Accounts',
				"page_link" => 'accounts',
				"own_data" => isset ($_REQUEST['accounts_own_data']) ? $_REQUEST['accounts_own_data'] : 0,
				"add" => isset ($_REQUEST['accounts_add']) ? $_REQUEST['accounts_add'] : 1,
				"edit" => isset ($_REQUEST['accounts_edit']) ? $_REQUEST['accounts_edit'] : 1,
				"view" => isset ($_REQUEST['accounts_view']) ? $_REQUEST['accounts_view'] : 1,
				"delete" => isset ($_REQUEST['accounts_delete']) ? $_REQUEST['accounts_delete'] : 1
			],
			"documents" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/document.png'),
				'menu_title' => 'Documents',
				"page_link" => 'documents',
				"own_data" => isset ($_REQUEST['documents_own_data']) ? $_REQUEST['documents_own_data'] : 1,
				"add" => isset ($_REQUEST['documents_add']) ? $_REQUEST['documents_add'] : 0,
				"edit" => isset ($_REQUEST['documents_edit']) ? $_REQUEST['documents_edit'] : 0,
				"view" => isset ($_REQUEST['documents_view']) ? $_REQUEST['documents_view'] : 1,
				"delete" => isset ($_REQUEST['documents_delete']) ? $_REQUEST['documents_delete'] : 0
			],
			"assets-inventory-tracker" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Assets--Inventory-Tracker.png'),
				'menu_title' => 'Assets / Inventory Tracker',
				"page_link" => 'assets-inventory-tracker',
				"own_data" => isset ($_REQUEST['assets-inventory-tracker_own_data']) ? $_REQUEST['assets-inventory-tracker_own_data'] : 0,
				"add" => isset ($_REQUEST['assets-inventory-tracker_add']) ? $_REQUEST['assets-inventory-tracker_add'] : 0,
				"edit" => isset ($_REQUEST['assets-inventory-tracker_edit']) ? $_REQUEST['assets-inventory-tracker_edit'] : 0,
				"view" => isset ($_REQUEST['assets-inventory-tracker_view']) ? $_REQUEST['assets-inventory-tracker_view'] : 1,
				"delete" => isset ($_REQUEST['assets-inventory-tracker_delete']) ? $_REQUEST['assets-inventory-tracker_delete'] : 0
			],

			"message" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/message.png'),
				"menu_title" => 'Message',
				"page_link" => 'message',
				"own_data" => isset ($_REQUEST['message_own_data']) ? $_REQUEST['message_own_data'] : 1,
				"add" => isset ($_REQUEST['message_add']) ? $_REQUEST['message_add'] : 1,
				"edit" => isset ($_REQUEST['message_edit']) ? $_REQUEST['message_edit'] : 0,
				"view" => isset ($_REQUEST['message_view']) ? $_REQUEST['message_view'] : 1,
				"delete" => isset ($_REQUEST['message_delete']) ? $_REQUEST['message_delete'] : 1
			],

			"profile" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/account.png'),
				'menu_title' => 'Profile',
				"page_link" => 'profile',
				"own_data" => isset ($_REQUEST['profile_own_data']) ? $_REQUEST['profile_own_data'] : 1,
				"add" => isset ($_REQUEST['profile_add']) ? $_REQUEST['profile_add'] : 0,
				"edit" => isset ($_REQUEST['profile_edit']) ? $_REQUEST['profile_edit'] : 0,
				"view" => isset ($_REQUEST['profile_view']) ? $_REQUEST['profile_view'] : 1,
				"delete" => isset ($_REQUEST['profile_delete']) ? $_REQUEST['profile_delete'] : 0
			],

			"faq" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/faq.png'),
				'menu_title' => 'FAQ',
				"page_link" => 'faq',
				"own_data" => isset ($_REQUEST['faq_own_data']) ? $_REQUEST['faq_own_data'] : 0,
				"add" => isset ($_REQUEST['faq_add']) ? $_REQUEST['faq_add'] : 0,
				"edit" => isset ($_REQUEST['faq_edit']) ? $_REQUEST['faq_edit'] : 0,
				"view" => isset ($_REQUEST['faq_view']) ? $_REQUEST['faq_view'] : 1,
				"delete" => isset ($_REQUEST['faq_delete']) ? $_REQUEST['faq_delete'] : 0
			],

			"society_rules" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Society-Rules.png'),
				'menu_title' => 'Rules',
				"page_link" => 'society_rules',
				"own_data" => isset ($_REQUEST['society_rules_own_data']) ? $_REQUEST['society_rules_own_data'] : 0,
				"add" => isset ($_REQUEST['society_rules_add']) ? $_REQUEST['society_rules_add'] : 0,
				"edit" => isset ($_REQUEST['society_rules_edit']) ? $_REQUEST['society_rules_edit'] : 0,
				"view" => isset ($_REQUEST['society_rules_view']) ? $_REQUEST['society_rules_view'] : 1,
				"delete" => isset ($_REQUEST['society_rules_delete']) ? $_REQUEST['society_rules_delete'] : 0
			],
			"gallery" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/gallery.png'),
				'menu_title' => 'Gallery',
				"page_link" => 'gallery',
				"own_data" => isset ($_REQUEST['gallery_own_data']) ? $_REQUEST['gallery_own_data'] : 0,
				"add" => isset ($_REQUEST['gallery_add']) ? $_REQUEST['gallery_add'] : 0,
				"edit" => isset ($_REQUEST['gallery_edit']) ? $_REQUEST['gallery_edit'] : 0,
				"view" => isset ($_REQUEST['gallery_view']) ? $_REQUEST['gallery_view'] : 1,
				"delete" => isset ($_REQUEST['gallery_delete']) ? $_REQUEST['gallery_delete'] : 0
			]
		];
		$role_access_right_gatekeeper = array();
		$role_access_right_gatekeeper['gatekeeper'] = [
			"resident_unit" => [
				"menu_icone" => plugins_url('apartment-management/assets/images/icon/resident-unit.png'),
				'menu_title' => 'Resident Unit',
				"page_link" => 'resident_unit',
				"own_data" => isset ($_REQUEST['resident_unit_own_data']) ? $_REQUEST['resident_unit_own_data'] : 0,
				"add" => isset ($_REQUEST['resident_unit_add']) ? $_REQUEST['resident_unit_add'] : 0,
				"edit" => isset ($_REQUEST['resident_unit_edit']) ? $_REQUEST['resident_unit_edit'] : 0,
				"view" => isset ($_REQUEST['resident_unit_view']) ? $_REQUEST['resident_unit_view'] : 1,
				"delete" => isset ($_REQUEST['resident_unit_delete']) ? $_REQUEST['resident_unit_delete'] : 0
			],

			"member" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/member.png'),
				'menu_title' => 'All User',
				"page_link" => 'member',
				"own_data" => isset ($_REQUEST['member_own_data']) ? $_REQUEST['member_own_data'] : 0,
				"add" => isset ($_REQUEST['member_add']) ? $_REQUEST['member_add'] : 0,
				"edit" => isset ($_REQUEST['member_edit']) ? $_REQUEST['member_edit'] : 0,
				"view" => isset ($_REQUEST['member_view']) ? $_REQUEST['member_view'] : 1,
				"delete" => isset ($_REQUEST['member_delete']) ? $_REQUEST['member_delete'] : 0
			],

			"committee-member" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Committee-Member.png'),
				'menu_title' => 'Committee Member',
				"page_link" => 'committee-member',
				"own_data" => isset ($_REQUEST['committee-member_own_data']) ? $_REQUEST['committee-member_own_data'] : 0,
				"add" => isset ($_REQUEST['committee-member_add']) ? $_REQUEST['committee-member_add'] : 0,
				"edit" => isset ($_REQUEST['committee-member_edit']) ? $_REQUEST['committee-member_edit'] : 0,
				"view" => isset ($_REQUEST['committee-member_view']) ? $_REQUEST['committee-member_view'] : 1,
				"delete" => isset ($_REQUEST['committee-member_delete']) ? $_REQUEST['committee-member_delete'] : 0
			],

			"accountant" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Accountant.png'),
				'menu_title' => 'Accountant',
				"page_link" => 'accountant',
				"own_data" => isset ($_REQUEST['accountant_own_data']) ? $_REQUEST['accountant_own_data'] : 0,
				"add" => isset ($_REQUEST['accountant_add']) ? $_REQUEST['accountant_add'] : 0,
				"edit" => isset ($_REQUEST['accountant_edit']) ? $_REQUEST['accountant_edit'] : 0,
				"view" => isset ($_REQUEST['accountant_view']) ? $_REQUEST['accountant_view'] : 1,
				"delete" => isset ($_REQUEST['accountant_delete']) ? $_REQUEST['accountant_delete'] : 0
			],

			"staff-members" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Staff-Management.png'),
				'menu_title' => 'Staff Management',
				"page_link" => 'staff-members',
				"own_data" => isset ($_REQUEST['staff-members_own_data']) ? $_REQUEST['staff-members_own_data'] : 0,
				"add" => isset ($_REQUEST['staff-members_add']) ? $_REQUEST['staff-members_add'] : 0,
				"edit" => isset ($_REQUEST['staff-members_edit']) ? $_REQUEST['staff-members_edit'] : 0,
				"view" => isset ($_REQUEST['staff-members_view']) ? $_REQUEST['staff-members_view'] : 1,
				"delete" => isset ($_REQUEST['staff-members_delete']) ? $_REQUEST['staff-members_delete'] : 0
			],
			"gatekeeper" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Gatekeeper.png'),
				'menu_title' => 'Gatekeeper',
				"page_link" => 'gatekeeper',
				"own_data" => isset ($_REQUEST['gatekeeper_own_data']) ? $_REQUEST['gatekeeper_own_data'] : 1,
				"add" => isset ($_REQUEST['gatekeeper_add']) ? $_REQUEST['gatekeeper_add'] : 0,
				"edit" => isset ($_REQUEST['gatekeeper_edit']) ? $_REQUEST['gatekeeper_edit'] : 0,
				"view" => isset ($_REQUEST['gatekeeper_view']) ? $_REQUEST['gatekeeper_view'] : 1,
				"delete" => isset ($_REQUEST['gatekeeper_delete']) ? $_REQUEST['gatekeeper_delete'] : 0
			],

			"report" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Report.png'),
				"menu_title" => 'Report',
				"page_link" => 'report',
				"own_data" => isset ($_REQUEST['report_own_data']) ? $_REQUEST['report_own_data'] : 0,
				"add" => isset ($_REQUEST['report_add']) ? $_REQUEST['report_add'] : 0,
				"edit" => isset ($_REQUEST['report_edit']) ? $_REQUEST['report_edit'] : 0,
				"view" => isset ($_REQUEST['report_view']) ? $_REQUEST['report_view'] : 1,
				"delete" => isset ($_REQUEST['report_delete']) ? $_REQUEST['report_delete'] : 0
			],

			"visitor-manage" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Visitor-Manage.png'),
				'menu_title' => 'Visitor Management',
				"page_link" => 'visitor-manage',
				"own_data" => isset ($_REQUEST['visitor-manage_own_data']) ? $_REQUEST['visitor-manage_own_data'] : 0,
				"add" => isset ($_REQUEST['visitor-manage_add']) ? $_REQUEST['visitor-manage_add'] : 1,
				"edit" => isset ($_REQUEST['visitor-manage_edit']) ? $_REQUEST['visitor-manage_edit'] : 0,
				"view" => isset ($_REQUEST['visitor-manage_view']) ? $_REQUEST['visitor-manage_view'] : 1,
				"delete" => isset ($_REQUEST['visitor-manage_delete']) ? $_REQUEST['visitor-manage_delete'] : 0
			],


			"notice-event" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Notice-And-Event.png'),
				'menu_title' => 'Notice And Event',
				"page_link" => 'notice-event',
				"own_data" => isset ($_REQUEST['notice-event_own_data']) ? $_REQUEST['notice-event_own_data'] : 0,
				"add" => isset ($_REQUEST['notice-event_add']) ? $_REQUEST['notice-event_add'] : 0,
				"edit" => isset ($_REQUEST['notice-event_edit']) ? $_REQUEST['notice-event_edit'] : 0,
				"view" => isset ($_REQUEST['notice-event_view']) ? $_REQUEST['notice-event_view'] : 1,
				"delete" => isset ($_REQUEST['notice-event_delete']) ? $_REQUEST['notice-event_delete'] : 0
			],
			"complaint" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Complaint.png'),
				'menu_title' => 'Complaint',
				"page_link" => 'complaint',
				"own_data" => isset ($_REQUEST['complaint_own_data']) ? $_REQUEST['complaint_own_data'] : 0,
				"add" => isset ($_REQUEST['complaint_add']) ? $_REQUEST['complaint_add'] : 0,
				"edit" => isset ($_REQUEST['complaint_edit']) ? $_REQUEST['complaint_edit'] : 0,
				"view" => isset ($_REQUEST['complaint_view']) ? $_REQUEST['complaint_view'] : 1,
				"delete" => isset ($_REQUEST['complaint_delete']) ? $_REQUEST['complaint_delete'] : 0
			],
			"parking-manager" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Parking-Manager.png'),
				'menu_title' => 'Parking Manager',
				"page_link" => 'parking-manager',
				"own_data" => isset ($_REQUEST['parking-manager_own_data']) ? $_REQUEST['parking-manager_own_data'] : 0,
				"add" => isset ($_REQUEST['parking-manager_add']) ? $_REQUEST['parking-manager_add'] : 1,
				"edit" => isset ($_REQUEST['parking-manager_edit']) ? $_REQUEST['parking-manager_edit'] : 1,
				"view" => isset ($_REQUEST['parking-manager_view']) ? $_REQUEST['parking-manager_view'] : 1,
				"delete" => isset ($_REQUEST['parking-manager_delete']) ? $_REQUEST['parking-manager_delete'] : 1
			],

			"services" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/services.png'),
				'menu_title' => 'Services',
				"page_link" => 'services',
				"own_data" => isset ($_REQUEST['services_own_data']) ? $_REQUEST['services_own_data'] : 0,
				"add" => isset ($_REQUEST['services_add']) ? $_REQUEST['services_add'] : 0,
				"edit" => isset ($_REQUEST['services_edit']) ? $_REQUEST['services_edit'] : 0,
				"view" => isset ($_REQUEST['services_view']) ? $_REQUEST['services_view'] : 1,
				"delete" => isset ($_REQUEST['services_delete']) ? $_REQUEST['services_delete'] : 0
			],

			"facility" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Facility.png'),
				'menu_title' => 'Facility',
				"page_link" => 'facility',
				"own_data" => isset ($_REQUEST['facility_own_data']) ? $_REQUEST['facility_own_data'] : 1,
				"add" => isset ($_REQUEST['facility_add']) ? $_REQUEST['facility_add'] : 0,
				"edit" => isset ($_REQUEST['facility_edit']) ? $_REQUEST['facility_edit'] : 0,
				"view" => isset ($_REQUEST['facility_view']) ? $_REQUEST['facility_view'] : 1,
				"delete" => isset ($_REQUEST['facility_delete']) ? $_REQUEST['facility_delete'] : 0
			],
			"accounts" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Accounts.png'),
				'menu_title' => 'Accounts',
				"page_link" => 'accounts',
				"own_data" => isset ($_REQUEST['accounts_own_data']) ? $_REQUEST['accounts_own_data'] : 0,
				"add" => isset ($_REQUEST['accounts_add']) ? $_REQUEST['accounts_add'] : 0,
				"edit" => isset ($_REQUEST['accounts_edit']) ? $_REQUEST['accounts_edit'] : 0,
				"view" => isset ($_REQUEST['accounts_view']) ? $_REQUEST['accounts_view'] : 1,
				"delete" => isset ($_REQUEST['accounts_delete']) ? $_REQUEST['accounts_delete'] : 0
			],
			"documents" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/document.png'),
				'menu_title' => 'Documents',
				"page_link" => 'documents',
				"own_data" => isset ($_REQUEST['documents_own_data']) ? $_REQUEST['documents_own_data'] : 0,
				"add" => isset ($_REQUEST['documents_add']) ? $_REQUEST['documents_add'] : 0,
				"edit" => isset ($_REQUEST['documents_edit']) ? $_REQUEST['documents_edit'] : 0,
				"view" => isset ($_REQUEST['documents_view']) ? $_REQUEST['documents_view'] : 0,
				"delete" => isset ($_REQUEST['documents_delete']) ? $_REQUEST['documents_delete'] : 0
			],
			"assets-inventory-tracker" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Assets--Inventory-Tracker.png'),
				'menu_title' => 'Assets / Inventory Tracker',
				"page_link" => 'assets-inventory-tracker',
				"own_data" => isset ($_REQUEST['assets-inventory-tracker_own_data']) ? $_REQUEST['assets-inventory-tracker_own_data'] : 0,
				"add" => isset ($_REQUEST['assets-inventory-tracker_add']) ? $_REQUEST['assets-inventory-tracker_add'] : 0,
				"edit" => isset ($_REQUEST['assets-inventory-tracker_edit']) ? $_REQUEST['assets-inventory-tracker_edit'] : 0,
				"view" => isset ($_REQUEST['assets-inventory-tracker_view']) ? $_REQUEST['assets-inventory-tracker_view'] : 1,
				"delete" => isset ($_REQUEST['assets-inventory-tracker_delete']) ? $_REQUEST['assets-inventory-tracker_delete'] : 0
			],

			"message" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/message.png'),
				"menu_title" => 'Message',
				"page_link" => 'message',
				"own_data" => isset ($_REQUEST['message_own_data']) ? $_REQUEST['message_own_data'] : 1,
				"add" => isset ($_REQUEST['message_add']) ? $_REQUEST['message_add'] : 1,
				"edit" => isset ($_REQUEST['message_edit']) ? $_REQUEST['message_edit'] : 0,
				"view" => isset ($_REQUEST['message_view']) ? $_REQUEST['message_view'] : 1,
				"delete" => isset ($_REQUEST['message_delete']) ? $_REQUEST['message_delete'] : 1
			],

			"profile" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/account.png'),
				'menu_title' => 'Profile',
				"page_link" => 'profile',
				"own_data" => isset ($_REQUEST['profile_own_data']) ? $_REQUEST['profile_own_data'] : 1,
				"add" => isset ($_REQUEST['profile_add']) ? $_REQUEST['profile_add'] : 0,
				"edit" => isset ($_REQUEST['profile_edit']) ? $_REQUEST['profile_edit'] : 0,
				"view" => isset ($_REQUEST['profile_view']) ? $_REQUEST['profile_view'] : 1,
				"delete" => isset ($_REQUEST['profile_delete']) ? $_REQUEST['profile_delete'] : 0
			],

			"faq" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/faq.png'),
				'menu_title' => 'FAQ',
				"page_link" => 'faq',
				"own_data" => isset ($_REQUEST['faq_own_data']) ? $_REQUEST['faq_own_data'] : 0,
				"add" => isset ($_REQUEST['faq_add']) ? $_REQUEST['faq_add'] : 0,
				"edit" => isset ($_REQUEST['faq_edit']) ? $_REQUEST['faq_edit'] : 0,
				"view" => isset ($_REQUEST['faq_view']) ? $_REQUEST['faq_view'] : 1,
				"delete" => isset ($_REQUEST['faq_delete']) ? $_REQUEST['faq_delete'] : 0
			],

			"society_rules" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Society-Rules.png'),
				'menu_title' => 'Rules',
				"page_link" => 'society_rules',
				"own_data" => isset ($_REQUEST['society_rules_own_data']) ? $_REQUEST['society_rules_own_data'] : 0,
				"add" => isset ($_REQUEST['society_rules_add']) ? $_REQUEST['society_rules_add'] : 0,
				"edit" => isset ($_REQUEST['society_rules_edit']) ? $_REQUEST['society_rules_edit'] : 0,
				"view" => isset ($_REQUEST['society_rules_view']) ? $_REQUEST['society_rules_view'] : 1,
				"delete" => isset ($_REQUEST['society_rules_delete']) ? $_REQUEST['society_rules_delete'] : 0
			],
			"gallery" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/gallery.png'),
				'menu_title' => 'Gallery',
				"page_link" => 'gallery',
				"own_data" => isset ($_REQUEST['gallery_own_data']) ? $_REQUEST['gallery_own_data'] : 0,
				"add" => isset ($_REQUEST['gallery_add']) ? $_REQUEST['gallery_add'] : 0,
				"edit" => isset ($_REQUEST['gallery_edit']) ? $_REQUEST['gallery_edit'] : 0,
				"view" => isset ($_REQUEST['gallery_view']) ? $_REQUEST['gallery_view'] : 1,
				"delete" => isset ($_REQUEST['gallery_delete']) ? $_REQUEST['gallery_delete'] : 0
			]
		];
		$role_access_right_management = array();
		$role_access_right_management['management'] = [
			"resident_unit" => [
				"menu_icone" => plugins_url('apartment-management/assets/images/icon/resident-unit.png'),
				'menu_title' => 'Resident Unit',
				"page_link" => 'resident_unit',
				"own_data" => isset ($_REQUEST['resident_unit_own_data']) ? $_REQUEST['resident_unit_own_data'] : 0,
				"add" => isset ($_REQUEST['resident_unit_add']) ? $_REQUEST['resident_unit_add'] : 1,
				"edit" => isset ($_REQUEST['resident_unit_edit']) ? $_REQUEST['resident_unit_edit'] : 1,
				"view" => isset ($_REQUEST['resident_unit_view']) ? $_REQUEST['resident_unit_view'] : 1,
				"delete" => isset ($_REQUEST['resident_unit_delete']) ? $_REQUEST['resident_unit_delete'] : 1
			],

			"member" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/member.png'),
				'menu_title' => 'All User',
				"page_link" => 'member',
				"own_data" => isset ($_REQUEST['member_own_data']) ? $_REQUEST['member_own_data'] : 0,
				"add" => isset ($_REQUEST['member_add']) ? $_REQUEST['member_add'] : 1,
				"edit" => isset ($_REQUEST['member_edit']) ? $_REQUEST['member_edit'] : 1,
				"view" => isset ($_REQUEST['member_view']) ? $_REQUEST['member_view'] : 1,
				"delete" => isset ($_REQUEST['member_delete']) ? $_REQUEST['member_delete'] : 1
			],

			"committee-member" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Committee-Member.png'),
				'menu_title' => 'Committee Member',
				"page_link" => 'committee-member',
				"own_data" => isset ($_REQUEST['committee-member_own_data']) ? $_REQUEST['committee-member_own_data'] : 0,
				"add" => isset ($_REQUEST['committee-member_add']) ? $_REQUEST['committee-member_add'] : 0,
				"edit" => isset ($_REQUEST['committee-member_edit']) ? $_REQUEST['committee-member_edit'] : 0,
				"view" => isset ($_REQUEST['committee-member_view']) ? $_REQUEST['committee-member_view'] : 1,
				"delete" => isset ($_REQUEST['committee-member_delete']) ? $_REQUEST['committee-member_delete'] : 1
			],

			"accountant" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Accountant.png'),
				'menu_title' => 'Accountant',
				"page_link" => 'accountant',
				"own_data" => isset ($_REQUEST['accountant_own_data']) ? $_REQUEST['accountant_own_data'] : 0,
				"add" => isset ($_REQUEST['accountant_add']) ? $_REQUEST['accountant_add'] : 1,
				"edit" => isset ($_REQUEST['accountant_edit']) ? $_REQUEST['accountant_edit'] : 1,
				"view" => isset ($_REQUEST['accountant_view']) ? $_REQUEST['accountant_view'] : 1,
				"delete" => isset ($_REQUEST['accountant_delete']) ? $_REQUEST['accountant_delete'] : 1
			],

			"staff-members" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Staff-Management.png'),
				'menu_title' => 'Staff Management',
				"page_link" => 'staff-members',
				"own_data" => isset ($_REQUEST['staff-members_own_data']) ? $_REQUEST['staff-members_own_data'] : 0,
				"add" => isset ($_REQUEST['staff-members_add']) ? $_REQUEST['staff-members_add'] : 1,
				"edit" => isset ($_REQUEST['staff-members_edit']) ? $_REQUEST['staff-members_edit'] : 1,
				"view" => isset ($_REQUEST['staff-members_view']) ? $_REQUEST['staff-members_view'] : 1,
				"delete" => isset ($_REQUEST['staff-members_delete']) ? $_REQUEST['staff-members_delete'] : 1
			],
			"gatekeeper" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Gatekeeper.png'),
				'menu_title' => 'Gatekeeper',
				"page_link" => 'gatekeeper',
				"own_data" => isset ($_REQUEST['gatekeeper_own_data']) ? $_REQUEST['gatekeeper_own_data'] : 0,
				"add" => isset ($_REQUEST['gatekeeper_add']) ? $_REQUEST['gatekeeper_add'] : 1,
				"edit" => isset ($_REQUEST['gatekeeper_edit']) ? $_REQUEST['gatekeeper_edit'] : 1,
				"view" => isset ($_REQUEST['gatekeeper_view']) ? $_REQUEST['gatekeeper_view'] : 1,
				"delete" => isset ($_REQUEST['gatekeeper_delete']) ? $_REQUEST['gatekeeper_delete'] : 1
			],
			"documents" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/document.png'),
				'menu_title' => 'Documents',
				"page_link" => 'documents',
				"own_data" => isset ($_REQUEST['documents_own_data']) ? $_REQUEST['documents_own_data'] : 0,
				"add" => isset ($_REQUEST['documents_add']) ? $_REQUEST['documents_add'] : 1,
				"edit" => isset ($_REQUEST['documents_edit']) ? $_REQUEST['documents_edit'] : 1,
				"view" => isset ($_REQUEST['documents_view']) ? $_REQUEST['documents_view'] : 1,
				"delete" => isset ($_REQUEST['documents_delete']) ? $_REQUEST['documents_delete'] : 1
			],
			"complaint" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/Complaint.png'),
				'menu_title' => 'Complaint',
				"page_link" => 'complaint',
				"own_data" => isset ($_REQUEST['complaint_own_data']) ? $_REQUEST['complaint_own_data'] : 0,
				"add" => isset ($_REQUEST['complaint_add']) ? $_REQUEST['complaint_add'] : 1,
				"edit" => isset ($_REQUEST['complaint_edit']) ? $_REQUEST['complaint_edit'] : 1,
				"view" => isset ($_REQUEST['complaint_view']) ? $_REQUEST['complaint_view'] : 1,
				"delete" => isset ($_REQUEST['complaint_delete']) ? $_REQUEST['complaint_delete'] : 1
			],
			"slot" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Slot',
				"page_link" => 'slot',
				"own_data" => isset ($_REQUEST['slot_own_data']) ? $_REQUEST['slot_own_data'] : 0,
				"add" => isset ($_REQUEST['slot_add']) ? $_REQUEST['slot_add'] : 1,
				"edit" => isset ($_REQUEST['slot_edit']) ? $_REQUEST['slot_edit'] : 1,
				"view" => isset ($_REQUEST['slot_view']) ? $_REQUEST['slot_view'] : 1,
				"delete" => isset ($_REQUEST['slot_delete']) ? $_REQUEST['slot_delete'] : 1
			],
			"assignslot" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Assign Slot',
				"page_link" => 'assignslot',
				"own_data" => isset ($_REQUEST['assignslot_own_data']) ? $_REQUEST['assignslot_own_data'] : 0,
				"add" => isset ($_REQUEST['assignslot_add']) ? $_REQUEST['assignslot_add'] : 1,
				"edit" => isset ($_REQUEST['assignslot_edit']) ? $_REQUEST['assignslot_edit'] : 1,
				"view" => isset ($_REQUEST['assignslot_view']) ? $_REQUEST['assignslot_view'] : 1,
				"delete" => isset ($_REQUEST['assignslot_delete']) ? $_REQUEST['assignslot_delete'] : 1
			],
			"managegate" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Manage Gate',
				"page_link" => 'managegate',
				"own_data" => isset ($_REQUEST['managegate_own_data']) ? $_REQUEST['managegate_own_data'] : 0,
				"add" => isset ($_REQUEST['managegate_add']) ? $_REQUEST['managegate_add'] : 1,
				"edit" => isset ($_REQUEST['managegate_edit']) ? $_REQUEST['managegate_edit'] : 1,
				"view" => isset ($_REQUEST['managegate_view']) ? $_REQUEST['managegate_view'] : 1,
				"delete" => isset ($_REQUEST['managegate_delete']) ? $_REQUEST['managegate_delete'] : 1
			],
			"visitorrequest" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Visitor Request',
				"page_link" => 'visitorrequest',
				"own_data" => isset ($_REQUEST['visitorrequest_own_data']) ? $_REQUEST['visitorrequest_own_data'] : 0,
				"add" => isset ($_REQUEST['visitorrequest_add']) ? $_REQUEST['visitorrequest_add'] : 1,
				"edit" => isset ($_REQUEST['visitorrequest_edit']) ? $_REQUEST['visitorrequest_edit'] : 1,
				"view" => isset ($_REQUEST['visitorrequest_view']) ? $_REQUEST['visitorrequest_view'] : 1,
				"delete" => isset ($_REQUEST['visitorrequest_delete']) ? $_REQUEST['visitorrequest_delete'] : 1
			],
			"staffcheckin" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Staff Checkin',
				"page_link" => 'staffcheckin',
				"own_data" => isset ($_REQUEST['staffcheckin_own_data']) ? $_REQUEST['staffcheckin_own_data'] : 0,
				"add" => isset ($_REQUEST['staffcheckin_add']) ? $_REQUEST['staffcheckin_add'] : 1,
				"edit" => isset ($_REQUEST['staffcheckin_edit']) ? $_REQUEST['staffcheckin_edit'] : 1,
				"view" => isset ($_REQUEST['staffcheckin_view']) ? $_REQUEST['staffcheckin_view'] : 1,
				"delete" => isset ($_REQUEST['staffcheckin_delete']) ? $_REQUEST['staffcheckin_delete'] : 1
			],
			"notice" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Notice',
				"page_link" => 'notice',
				"own_data" => isset ($_REQUEST['notice_own_data']) ? $_REQUEST['notice_own_data'] : 0,
				"add" => isset ($_REQUEST['notice_add']) ? $_REQUEST['notice_add'] : 1,
				"edit" => isset ($_REQUEST['notice_edit']) ? $_REQUEST['notice_edit'] : 1,
				"view" => isset ($_REQUEST['notice_view']) ? $_REQUEST['notice_view'] : 1,
				"delete" => isset ($_REQUEST['notice_delete']) ? $_REQUEST['notice_delete'] : 1
			],
			"event" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Event',
				"page_link" => 'event',
				"own_data" => isset ($_REQUEST['event_own_data']) ? $_REQUEST['event_own_data'] : 0,
				"add" => isset ($_REQUEST['event_add']) ? $_REQUEST['event_add'] : 1,
				"edit" => isset ($_REQUEST['event_edit']) ? $_REQUEST['event_edit'] : 1,
				"view" => isset ($_REQUEST['event_view']) ? $_REQUEST['event_view'] : 1,
				"delete" => isset ($_REQUEST['event_delete']) ? $_REQUEST['event_delete'] : 1
			],
			"message" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Message',
				"page_link" => 'message',
				"own_data" => isset ($_REQUEST['message_own_data']) ? $_REQUEST['message_own_data'] : 0,
				"add" => isset ($_REQUEST['message_add']) ? $_REQUEST['message_add'] : 1,
				"edit" => isset ($_REQUEST['message_edit']) ? $_REQUEST['message_edit'] : 1,
				"view" => isset ($_REQUEST['message_view']) ? $_REQUEST['message_view'] : 1,
				"delete" => isset ($_REQUEST['message_delete']) ? $_REQUEST['message_delete'] : 1
			],
			"service" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Service',
				"page_link" => 'service',
				"own_data" => isset ($_REQUEST['service_own_data']) ? $_REQUEST['service_own_data'] : 0,
				"add" => isset ($_REQUEST['service_add']) ? $_REQUEST['service_add'] : 1,
				"edit" => isset ($_REQUEST['service_edit']) ? $_REQUEST['service_edit'] : 1,
				"view" => isset ($_REQUEST['service_view']) ? $_REQUEST['service_view'] : 1,
				"delete" => isset ($_REQUEST['service_delete']) ? $_REQUEST['service_delete'] : 1
			],
			"facility" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Facility',
				"page_link" => 'facility',
				"own_data" => isset ($_REQUEST['facility_own_data']) ? $_REQUEST['facility_own_data'] : 0,
				"add" => isset ($_REQUEST['facility_add']) ? $_REQUEST['facility_add'] : 1,
				"edit" => isset ($_REQUEST['facility_edit']) ? $_REQUEST['facility_edit'] : 1,
				"view" => isset ($_REQUEST['facility_view']) ? $_REQUEST['facility_view'] : 1,
				"delete" => isset ($_REQUEST['facility_delete']) ? $_REQUEST['facility_delete'] : 1
			],
			"bookingfacility" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Booking Facility',
				"page_link" => 'bookingfacility',
				"own_data" => isset ($_REQUEST['bookingfacility_own_data']) ? $_REQUEST['bookingfacility_own_data'] : 0,
				"add" => isset ($_REQUEST['bookingfacility_add']) ? $_REQUEST['bookingfacility_add'] : 1,
				"edit" => isset ($_REQUEST['bookingfacility_edit']) ? $_REQUEST['bookingfacility_edit'] : 1,
				"view" => isset ($_REQUEST['bookingfacility_view']) ? $_REQUEST['bookingfacility_view'] : 1,
				"delete" => isset ($_REQUEST['bookingfacility_delete']) ? $_REQUEST['bookingfacility_delete'] : 1
			],
			"tax" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Tax',
				"page_link" => 'tax',
				"own_data" => isset ($_REQUEST['tax_own_data']) ? $_REQUEST['tax_own_data'] : 0,
				"add" => isset ($_REQUEST['tax_add']) ? $_REQUEST['tax_add'] : 1,
				"edit" => isset ($_REQUEST['tax_edit']) ? $_REQUEST['tax_edit'] : 1,
				"view" => isset ($_REQUEST['tax_view']) ? $_REQUEST['tax_view'] : 1,
				"delete" => isset ($_REQUEST['tax_delete']) ? $_REQUEST['tax_delete'] : 1
			],
			"invoice" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Invoice',
				"page_link" => 'invoice',
				"own_data" => isset ($_REQUEST['invoice_own_data']) ? $_REQUEST['invoice_own_data'] : 0,
				"add" => isset ($_REQUEST['invoice_add']) ? $_REQUEST['invoice_add'] : 1,
				"edit" => isset ($_REQUEST['invoice_edit']) ? $_REQUEST['invoice_edit'] : 1,
				"view" => isset ($_REQUEST['invoice_view']) ? $_REQUEST['invoice_view'] : 1,
				"delete" => isset ($_REQUEST['invoice_delete']) ? $_REQUEST['invoice_delete'] : 1
			],
			"charges" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Charges',
				"page_link" => 'charges',
				"own_data" => isset ($_REQUEST['charges_own_data']) ? $_REQUEST['charges_own_data'] : 0,
				"add" => isset ($_REQUEST['charges_add']) ? $_REQUEST['charges_add'] : 1,
				"edit" => isset ($_REQUEST['charges_edit']) ? $_REQUEST['charges_edit'] : 1,
				"view" => isset ($_REQUEST['charges_view']) ? $_REQUEST['charges_view'] : 1,
				"delete" => isset ($_REQUEST['charges_delete']) ? $_REQUEST['charges_delete'] : 1
			],
			"expense" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Expense',
				"page_link" => 'expense',
				"own_data" => isset ($_REQUEST['expense_own_data']) ? $_REQUEST['expense_own_data'] : 0,
				"add" => isset ($_REQUEST['expense_add']) ? $_REQUEST['expense_add'] : 1,
				"edit" => isset ($_REQUEST['expense_edit']) ? $_REQUEST['expense_edit'] : 1,
				"view" => isset ($_REQUEST['expense_view']) ? $_REQUEST['expense_view'] : 1,
				"delete" => isset ($_REQUEST['expense_delete']) ? $_REQUEST['expense_delete'] : 1
			],
			"asset" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Asset',
				"page_link" => 'asset',
				"own_data" => isset ($_REQUEST['asset_own_data']) ? $_REQUEST['asset_own_data'] : 0,
				"add" => isset ($_REQUEST['asset_add']) ? $_REQUEST['asset_add'] : 1,
				"edit" => isset ($_REQUEST['asset_edit']) ? $_REQUEST['asset_edit'] : 1,
				"view" => isset ($_REQUEST['asset_view']) ? $_REQUEST['asset_view'] : 1,
				"delete" => isset ($_REQUEST['asset_delete']) ? $_REQUEST['asset_delete'] : 1
			],
			"inventory" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Inventory',
				"page_link" => 'inventory',
				"own_data" => isset ($_REQUEST['inventory_own_data']) ? $_REQUEST['inventory_own_data'] : 0,
				"add" => isset ($_REQUEST['inventory_add']) ? $_REQUEST['inventory_add'] : 1,
				"edit" => isset ($_REQUEST['inventory_edit']) ? $_REQUEST['inventory_edit'] : 1,
				"view" => isset ($_REQUEST['inventory_view']) ? $_REQUEST['inventory_view'] : 1,
				"delete" => isset ($_REQUEST['inventory_delete']) ? $_REQUEST['inventory_delete'] : 1
			],
			"unitbuilding" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Unit By Building',
				"page_link" => 'unitbuilding',
				"own_data" => isset ($_REQUEST['unitbuilding_own_data']) ? $_REQUEST['unitbuilding_own_data'] : 0,
				"add" => isset ($_REQUEST['unitbuilding_add']) ? $_REQUEST['unitbuilding_add'] : 0,
				"edit" => isset ($_REQUEST['unitbuilding_edit']) ? $_REQUEST['unitbuilding_edit'] : 0,
				"view" => isset ($_REQUEST['unitbuilding_view']) ? $_REQUEST['unitbuilding_view'] : 1,
				"delete" => isset ($_REQUEST['unitbuilding_delete']) ? $_REQUEST['unitbuilding_delete'] : 0
			],
			"memberbuilding" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Member By Building',
				"page_link" => 'memberbuilding',
				"own_data" => isset ($_REQUEST['memberbuilding_own_data']) ? $_REQUEST['memberbuilding_own_data'] : 0,
				"add" => isset ($_REQUEST['memberbuilding_add']) ? $_REQUEST['memberbuilding_add'] : 0,
				"edit" => isset ($_REQUEST['memberbuilding_edit']) ? $_REQUEST['memberbuilding_edit'] : 0,
				"view" => isset ($_REQUEST['memberbuilding_view']) ? $_REQUEST['memberbuilding_view'] : 1,
				"delete" => isset ($_REQUEST['memberbuilding_delete']) ? $_REQUEST['memberbuilding_delete'] : 0
			],
			"financepayment" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Finance Payment',
				"page_link" => 'financepayment',
				"own_data" => isset ($_REQUEST['financepayment_own_data']) ? $_REQUEST['financepayment_own_data'] : 0,
				"add" => isset ($_REQUEST['financepayment_add']) ? $_REQUEST['financepayment_add'] : 0,
				"edit" => isset ($_REQUEST['financepayment_edit']) ? $_REQUEST['financepayment_edit'] : 0,
				"view" => isset ($_REQUEST['financepayment_view']) ? $_REQUEST['financepayment_view'] : 1,
				"delete" => isset ($_REQUEST['financepayment_delete']) ? $_REQUEST['financepayment_delete'] : 0
			],
			"reportcomplaint" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Report Complaint',
				"page_link" => 'reportcomplaint',
				"own_data" => isset ($_REQUEST['reportcomplaint_own_data']) ? $_REQUEST['reportcomplaint_own_data'] : 0,
				"add" => isset ($_REQUEST['reportcomplaint_add']) ? $_REQUEST['reportcomplaint_add'] : 0,
				"edit" => isset ($_REQUEST['reportcomplaint_edit']) ? $_REQUEST['reportcomplaint_edit'] : 0,
				"view" => isset ($_REQUEST['reportcomplaint_view']) ? $_REQUEST['reportcomplaint_view'] : 1,
				"delete" => isset ($_REQUEST['reportcomplaint_delete']) ? $_REQUEST['reportcomplaint_delete'] : 0
			],
			"emailtemplate" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Email Template',
				"page_link" => 'emailtemplate',
				"own_data" => isset ($_REQUEST['emailtemplate_own_data']) ? $_REQUEST['emailtemplate_own_data'] : 0,
				"add" => isset ($_REQUEST['emailtemplate_add']) ? $_REQUEST['emailtemplate_add'] : 1,
				"edit" => isset ($_REQUEST['emailtemplate_edit']) ? $_REQUEST['emailtemplate_edit'] : 0,
				"view" => isset ($_REQUEST['emailtemplate_view']) ? $_REQUEST['emailtemplate_view'] : 1,
				"delete" => isset ($_REQUEST['emailtemplate_delete']) ? $_REQUEST['emailtemplate_delete'] : 0
			],
			"generalsetting" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'General Setting',
				"page_link" => 'generalsetting',
				"own_data" => isset ($_REQUEST['generalsetting_own_data']) ? $_REQUEST['generalsetting_own_data'] : 0,
				"add" => isset ($_REQUEST['generalsetting_add']) ? $_REQUEST['generalsetting_add'] : 1,
				"edit" => isset ($_REQUEST['generalsetting_edit']) ? $_REQUEST['generalsetting_edit'] : 0,
				"view" => isset ($_REQUEST['generalsetting_view']) ? $_REQUEST['generalsetting_view'] : 1,
				"delete" => isset ($_REQUEST['generalsetting_delete']) ? $_REQUEST['generalsetting_delete'] : 0
			],
			"accessright" => [
				'menu_icone' => plugins_url('apartment-management/assets/images/icon/slot.png'),
				'menu_title' => 'Access Right',
				"page_link" => 'accessright',
				"own_data" => isset ($_REQUEST['accessright_own_data']) ? $_REQUEST['accessright_own_data'] : 0,
				"add" => isset ($_REQUEST['accessright_add']) ? $_REQUEST['accessright_add'] : 0,
				"edit" => isset ($_REQUEST['accessright_edit']) ? $_REQUEST['accessright_edit'] : 0,
				"view" => isset ($_REQUEST['accessright_view']) ? $_REQUEST['accessright_view'] : 1,
				"delete" => isset ($_REQUEST['accessright_delete']) ? $_REQUEST['accessright_delete'] : 0
			],
		];


		$amgt_setup_wizard_steps = array(
			"step1_general_setting" => "no",
			"step2_residental_unit" => "no",
			"step3_add_member" => "no",
			"step4_add_document" => "no",
			"step5_add_invoice" => "no"
		);

		$wizard_option = get_option('amgt_setup_wizard_step');

		if (empty ($wizard_option)) {
			$wizard_option = add_option('amgt_setup_wizard_step', $amgt_setup_wizard_steps);
		}
		$amgt_setup_wizard_status = 'no';

		$dashboard_card_access_for_member = array();
		$dashboard_card_access_for_member = [
			"amgt_member" => isset ($_REQUEST['member_card_member']) ? esc_attr($_REQUEST['member_card_member']) : "yes",
			"amgt_gatekeeper" => isset ($_REQUEST['gatekeeper_card_member']) ? esc_attr($_REQUEST['gatekeeper_card_member']) : "yes",
			"amgt_accountant" => isset ($_REQUEST['accountant_card_member']) ? esc_attr($_REQUEST['accountant_card_member']) : "yes",
			"amgt_staffmember" => isset ($_REQUEST['supportstaff_card_member']) ? esc_attr($_REQUEST['supportstaff_card_member']) : "yes",
			"amgt_notice" => isset ($_REQUEST['notice_card_member']) ? esc_attr($_REQUEST['notice_card_member']) : "yes",
			"amgt_message" => isset ($_REQUEST['message_card_member']) ? esc_attr($_REQUEST['message_card_member']) : "yes",
			"amgt_complaint" => isset ($_REQUEST['complaint_card_member']) ? esc_attr($_REQUEST['complaint_card_member']) : "yes",
			"amgt_compound" => isset ($_REQUEST['compound_card_member']) ? esc_attr($_REQUEST['compound_card_member']) : "yes",
			"amgt_today_visitor_chart" => isset ($_REQUEST['today_visitor_member']) ? esc_attr($_REQUEST['today_visitor_member']) : "yes",
		];

		$dashboard_card_access_for_staffmember = array();
		$dashboard_card_access_for_staffmember = [
			"amgt_member" => isset ($_REQUEST['member_card_staffmember']) ? esc_attr($_REQUEST['member_card_staffmember']) : "yes",
			"amgt_gatekeeper" => isset ($_REQUEST['gatekeeper_card_staffmember']) ? esc_attr($_REQUEST['gatekeeper_card_staffmember']) : "yes",
			"amgt_accountant" => isset ($_REQUEST['accountant_card_staffmember']) ? esc_attr($_REQUEST['accountant_card_staffmember']) : "yes",
			"amgt_staffmember" => isset ($_REQUEST['supportstaff_card_staffmember']) ? esc_attr($_REQUEST['supportstaff_card_staffmember']) : "yes",
			"amgt_notice" => isset ($_REQUEST['notice_card_staffmember']) ? esc_attr($_REQUEST['notice_card_staffmember']) : "yes",
			"amgt_message" => isset ($_REQUEST['message_card_staffmember']) ? esc_attr($_REQUEST['message_card_staffmember']) : "yes",
			"amgt_complaint" => isset ($_REQUEST['complaint_card_staffmember']) ? esc_attr($_REQUEST['complaint_card_staffmember']) : "yes",
			"amgt_compound" => isset ($_REQUEST['compound_card_staffmember']) ? esc_attr($_REQUEST['compound_card_staffmember']) : "yes",
			"amgt_today_visitor_chart" => isset ($_REQUEST['today_visitor_staffmember']) ? esc_attr($_REQUEST['today_visitor_staffmember']) : "yes",
		];

		$dashboard_card_access_for_accountant = array();
		$dashboard_card_access_for_accountant = [
			"amgt_member" => isset ($_REQUEST['member_card_accountant']) ? esc_attr($_REQUEST['member_card_accountant']) : "yes",
			"amgt_gatekeeper" => isset ($_REQUEST['gatekeeper_card_accountant']) ? esc_attr($_REQUEST['gatekeeper_card_accountant']) : "yes",
			"amgt_accountant" => isset ($_REQUEST['accountant_card_accountant']) ? esc_attr($_REQUEST['accountant_card_accountant']) : "yes",
			"amgt_staffmember" => isset ($_REQUEST['supportstaff_card_accountant']) ? esc_attr($_REQUEST['supportstaff_card_accountant']) : "yes",
			"amgt_notice" => isset ($_REQUEST['notice_card_accountant']) ? esc_attr($_REQUEST['notice_card_accountant']) : "yes",
			"amgt_message" => isset ($_REQUEST['message_card_accountant']) ? esc_attr($_REQUEST['message_card_accountant']) : "yes",
			"amgt_complaint" => isset ($_REQUEST['complaint_card_accountant']) ? esc_attr($_REQUEST['complaint_card_accountant']) : "yes",
			"amgt_compound" => isset ($_REQUEST['compound_card_accountant']) ? esc_attr($_REQUEST['compound_card_accountant']) : "yes",
			"amgt_today_visitor_chart" => isset ($_REQUEST['today_visitor_accountant']) ? esc_attr($_REQUEST['today_visitor_accountant']) : "yes",
		];

		$dashboard_card_access_for_gatekeeper = array();
		$dashboard_card_access_for_gatekeeper = [
			"amgt_member" => isset ($_REQUEST['member_card_gatekeeper']) ? esc_attr($_REQUEST['member_card_gatekeeper']) : "yes",
			"amgt_gatekeeper" => isset ($_REQUEST['gatekeeper_card_gatekeeper']) ? esc_attr($_REQUEST['gatekeeper_card_gatekeeper']) : "yes",
			"amgt_accountant" => isset ($_REQUEST['accountant_card_gatekeeper']) ? esc_attr($_REQUEST['accountant_card_gatekeeper']) : "yes",
			"amgt_staffmember" => isset ($_REQUEST['supportstaff_card_gatekeeper']) ? esc_attr($_REQUEST['supportstaff_card_gatekeeper']) : "yes",
			"amgt_notice" => isset ($_REQUEST['notice_card_gatekeeper']) ? esc_attr($_REQUEST['notice_card_gatekeeper']) : "yes",
			"amgt_message" => isset ($_REQUEST['message_card_gatekeeper']) ? esc_attr($_REQUEST['message_card_gatekeeper']) : "yes",
			"amgt_complaint" => isset ($_REQUEST['complaint_card_gatekeeper']) ? esc_attr($_REQUEST['complaint_card_gatekeeper']) : "yes",
			"amgt_compound" => isset ($_REQUEST['compound_card_gatekeeper']) ? esc_attr($_REQUEST['compound_card_gatekeeper']) : "yes",
			"amgt_today_visitor_chart" => isset ($_REQUEST['today_visitor_gatekeeper']) ? esc_attr($_REQUEST['today_visitor_gatekeeper']) : "yes",
		];

		// $dashboard_card_access_for_committee_member = array();
		// $dashboard_card_access_for_committee_member =[
		// 	"amgt_member" => isset($_REQUEST['member_card_committee_member'])?esc_attr($_REQUEST['member_card_committee_member']):"yes",
		// 	"amgt_gatekeeper" => isset($_REQUEST['gatekeeper_card_committee_member'])?esc_attr($_REQUEST['gatekeeper_card_committee_member']):"yes",
		// 	"amgt_accountant" => isset($_REQUEST['accountant_card_committee_member'])?esc_attr($_REQUEST['accountant_card_committee_member']):"yes",
		// 	"amgt_staffmember" => isset($_REQUEST['supportstaff_card_committee_member'])?esc_attr($_REQUEST['supportstaff_card_committee_member']):"yes",
		// 	"amgt_notice" => isset($_REQUEST['notice_card_committee_member'])?esc_attr($_REQUEST['notice_card_committee_member']):"yes",
		// 	"amgt_message" => isset($_REQUEST['message_card_committee_member'])?esc_attr($_REQUEST['message_card_committee_member']):"yes",
		// 	"amgt_complaint" => isset($_REQUEST['complaint_card_committee_member'])?esc_attr($_REQUEST['complaint_card_committee_member']):"yes",
		// 	"amgt_compound" => isset($_REQUEST['compound_card_committee_member'])?esc_attr($_REQUEST['compound_compound_card_committee_membercard']):"yes",
		// 	"amgt_today_visitor_chart" => isset($_REQUEST['today_visitor_committee_member'])?esc_attr($_REQUEST['today_visitor_committee_member']):"yes",
		// ];

		$options = array(
			"amgt_system_name" => esc_html__('Apartment Management System', 'apartment_mgt'),
			"amgt_staring_year" => "2024",
			"amgt_apartment_address" => "Near cross road-5",
			"amgt_contact_number" => "9999999999",
			"amgt_contry" => "United States",
			"amgt_state" => '',
			"amgt_city" => '',
			"amgt_email" => get_option('admin_email'),
			"amgt_system_logo" => AMS_PLUGIN_URL . '/assets/images/dashboard_icon/Thumbnail-img.png',
			"amgt_apartment_background_image" => AMS_PLUGIN_URL . '/assets/images/apartment-background.png',
			"amgt_member_thumb" => AMS_PLUGIN_URL . '/assets/images/Thumbnail-img.png',
			"amgt_ams_other_data_logo" => AMS_PLUGIN_URL . '/assets/images/Other_Logo.png',
			"amgt_apartment_app_icon" => AMS_PLUGIN_URL . '/assets/images/Other_Logo.png',
			//------------- NEW THUMB IMAGE --------------//
			"amgt_member_new_thumb" => AMS_PLUGIN_URL . '/assets/images/thumb_image/Member.png',
			"amgt_accountant_new_thumb" => AMS_PLUGIN_URL . '/assets/images/thumb_image/Accountant.png',
			"amgt_committee_new_thumb" => AMS_PLUGIN_URL . '/assets/images/thumb_image/Committee_member.png',
			"amgt_gatekeeper_new_thumb" => AMS_PLUGIN_URL . '/assets/images/thumb_image/Gatekeeper.png',
			"amgt_staffmember_new_thumb" => AMS_PLUGIN_URL . '/assets/images/thumb_image/Staff-Member.png',
			"amgt_no_data_img" => AMS_PLUGIN_URL . '/assets/images/thumb_image/Plus-icon.png',
			//------------- NEW THUMB IMAGE --------------//

			//---------------Dashboard card setting-----------------//
			"amgt_dashboard_card_for_member" => $dashboard_card_access_for_member,
			"amgt_dashboard_card_for_staffmember" => $dashboard_card_access_for_staffmember,
			"amgt_dashboard_card_for_accountant" => $dashboard_card_access_for_accountant,
			"amgt_dashboard_card_for_gatekeeper" => $dashboard_card_access_for_gatekeeper,
			// "amgt_dashboard_card_for_committee_member" => $dashboard_card_access_for_committee_member,
			//---------------Dashboard card setting-----------------//

			"apartment_enable_complaintlist_for_allmember" => 'yes',
			"apartment_paypal_email" => '',
			"apartment_enable_sandbox" => 'yes',
			"apartment_currency_code" => 'USD',
			//PAY MASTER OPTION//
			"amgt_paymaster_pack" => "no",
			"amgt_apartment_type" => 'Residential',
			"amgt_unit_measerment_type" => 'square_meter',
			"maitenance_charge" => '',
			"amgt_access_right_member" => $role_access_right_member,
			"amgt_access_right_staff_member" => $role_access_right_staff_member,
			"amgt_access_right_accountant" => $role_access_right_accountant,
			"amgt_access_right_gatekeeper" => $role_access_right_gatekeeper,
			"amgt_access_right_management" => $role_access_right_management,
			"amgt_maintenance_charge_period" => '1',
			"apartment_enable_maintenance" => 'no',
			"apartment_enable_chargis" => 'no',
			"allow_member_to_multiple_units" => 'no',
			"apartment_member_approval" => 'no',
			"notice_event_approved_by_admin" => 'no',
			"send_push_notifications" => 'no',
			"amgt_notification_fcm_key" => '',
			"apartment_enable_notifications" => 'yes',
			"amgt_date_formate" => 'Y-m-d',
			"invoice_prefix" => 'INV-',
			"amgt_gst_number" => '',
			"amgt_tax_id" => '',
			"amgt_corporate_id" => '',
			"amgt_bank_name" => '',
			"amgt_account_holder_name" => '',
			"amgt_account_number" => '',
			"amgt_account_type" => '',
			"amgt_ifsc_code" => '',
			"amgt_swift_code" => '',
			"apartment_heder_enable" => 'yes',
			"invoice_penalty_enable" => 'no',
			"invoice_penalty_days" => '',
			"invoice_penalty_charge" => '',
			"amgt_system_color_code" => '#104B73',
			"amgt_clickatell_sms_service" => array(),
			"amgt_twillo_sms_service" => array(),
			"amgt_sms_service" => "",
			"amgt_sms_service_enable" => 0,
			"add_owner_tenant_enable" => 'no',
			"create_invoice_for_tenant_enable" => 'no',
			"owner_can_collect_tenant_payment" => 'no',
			"apartment_enable_video_popup_show" => 'yes',
			"payment_reminder_day_before" => '',

			"amgt_setup_wizard_status" => $amgt_setup_wizard_status,

			// ---------------- DOCUMENT SETTING ---------------
			'amgt_upload_document_type' => 'pdf, doc, docx, ppt, pptx, gif, png, jpg, jpeg, webp',
            'amgt_upload_profile_extention' => 'gif, png, jpg, jpeg, webp',
            'amgt_upload_document_size' => '30',
            'amgt_upload_profile_size' => '10',
			// ---------------- DOCUMENT SETTING ---------------
			
			//------------ NEW OPTION ADD --------------//
			'amgt_footer_description' => esc_html__('Copyright ©2024 Mojoomla. All rights reserved.', 'apartment_mgt'),
			//------------ NEW OPTION ADD --------------//

			'wp_amgt_Member_Registration' => 'You are successfully registered at {{apartment_name}}',
			'wp_amgt_registration_email_template' => 'Dear {{member_name}},
		You are successfully registered at {{apartment_name}}. Your have register for property at {{unit_name}} for {{building_name}}.
		You can access system using your Email and password.  You can signin using this link. {{loginlink}}

Email    : {{email}}
Password : {{password}}
	
 Regards From {{apartment_name}}.',

			'wp_amgt_Member_approve_subject' => 'You profile has been approved by admin at {{apartment_name}}',
			'wp_amgt_Member_approve_email_template' => 'Hello {{member_name}},
        You are successfully registered at Apartment Name. You profile has been approved by admin. and you can signin this link {{loginlink}}
	
 Regards From {{apartment_name}}.',
			'wp_amgt_Member_Become_committee_subject' => 'You have been appointed as committee member of Committee, {{apartment_name}}',
			'wp_amgt_Member_Become_committee_email_template' => 'Dear {{member_name}},
        Congratulations!! You have been appointed as committee member of Committee, {{apartment_name}}.click on this link {{loginlink}}
		
 Regards From {{apartment_name}}.',

			'wp_amgt_Member_removed_committee_subject' => 'You have been removed from Commitee in {{apartment_name}}',
			'wp_amgt_Member_removed_committee_email_template' => 'Dear {{member_name}},
        You have been removes from Committee in {{apartment_name}}.
		
 Regards From {{apartment_name}}.',

			'wp_amgt_add_user_subject' => 'Your have been assigned role of {{rolename}} in {{apartment_name}}',
			'wp_amgt_add_user_email_template' => 'Dear {{member_name}},
					
        You are Added by admin of {{apartment_name}} . Your have been assigned role of {{rolename}} in {{apartment_name}}. You can access system using your email and password.  You can signin using this link. {{loginlink}}

 Email : {{email}}
 Password : {{password}}
 
 Regards From {{apartment_name}}.',

			'wp_amgt_add_notice_subject' => 'new Notice from {{member_name}} From {{apartment_name}}',
			'wp_amgt_add_notice_email_template' => 'Dear {{member_name}},
        Title : {{notice_title}}.
        Type :  {{notice_type}}.
        Notice Valid upto : {{notice_valid_date}}.
        Description : {{notice_content}}.
	{{Notice_Link}}
 
 Regards From {{apartment_name}}.',

			'wp_amgt_add_event_subject' => 'New Event From {{apartment_name}}',
			'wp_amgt_add_event_email_template' => 'Dear {{member_name}},
        Title : {{event_title}}.
        Event Start Date : {{event_start_date}}.
        Event End Date : {{event_end_date}}.
        Event Start Time: {{event_start_time}}.
        Event End Time: {{event_end_time}}.
        Description : {{event_description}}.
	{{Event_Link}}
 
 Regards From {{apartment_name}}.',

			'wp_amgt_add_complaint_subject' => 'New Complaint From {{member_name}} at {{apartment_name}}',
			'wp_amgt_add_complaint_email_template' => 'Dear {{member_name}},
        Nature: {{nature}}.
        Type : {{noticetype}}.
        Category  : {{noticecategory}} .
        Status : {{complaintstatus}}.
        Description : {{description}}.
        Apartment Number: {{apartmentnumber}}
        Complaint From :{{complainfrom}}.
	{{Complain_Link}}
	
Regards From {{apartment_name}}.',

			'wp_amgt_Admin_Complain' => 'New Complaint From {{member_name}} at {{apartment_name}}',
			'wp_amgt_admin_complain_email_template' => 'Dear {{admin_name}},
        Nature: {{nature}}.
        Type : {{noticetype}}.
        Category  : {{noticecategory}} .
        Status : {{complaintstatus}}.
        Description : {{description}}.
        Apartment Number: {{apartmentnumber}}
        Complaint From :{{complainfrom}}.
		Complaint To :{{complainto}}.
	   {{Admin_Complain_Link}}	
	
 Regards From {{apartment_name}}.',

			'wp_amgt_add_assign_sloat_subject' => 'Parking sloat has been assigned to you in {{apartment_name}}',
			'wp_amgt_add_assign_sloat_email_template' => 'Dear {{member_name}},
        Parking slot has been assigned to you in {{apartment_name}}. Your parking slot is {{slotname}}. You have assigned this slot from {{startdate}}  to {{enddate}}.
        Vehicle Number : {{vehiclenumber}} 
        Vehicle Model : {{vehiclemodel}}
        Vehicle Type : {{vehicletype}}
        RFID :  {{RFID}}.
	{{Sloat_Link}}
 
 Regards From {{member_name}}.',

			'wp_amgt_book_facility_subject' => 'Facility Successfully booked by {{booked_user_name}} for {{activity_name}} on {{from_date}} And {{from_time}}',
			'wp_amgt_book_facility_email_template' => 'Dear {{member_name}},
        {{facility_name}} has been successfully booked for you. This facility booked by {{booked_user_name}} for {{activity_name}} on {{from_date}}. Charges of this facility is {{facility_charge}}. 
        Start Date : {{from_date}}
        End Date : {{to_date}}
        Start Time: {{from_time}}
        End Time: {{to_time}}.
	{{facility_link}}
 
 Regards From {{apartment_name}}.',

			'wp_amgt_book_facility_subject_admin' => 'New Facility Booking Request From {{member_name}} at {{apartment_name}} .',
			'wp_amgt_book_facility_email_template_admin' => 'Dear {{admin_name}},

       New  {{facility_name}} Facility Booking Request Form {{member_name}} at {{apartment_name}}.

      Activity Name: {{activity_name}}
    
      Facility Charge: {{facility_charge}}

      Start Date : {{from_date}}

      End Date : {{to_date}}

      Start Time: {{from_time}}

      End Time: {{to_time}}.

	{{facility_link}}
 
 Regards From {{apartment_name}}.',

			'wp_amgt_generate_invoice_subject' => 'Your have a new invoice from {{apartment_name}}',
			'wp_amgt_generate_invoice_email_template' => 'Dear {{member_name}},
        Your have a new invoice. You can check the invoice attached here.{{Payment Link}}',

			'wp_amgt_Message_Received_subject' => 'You have received new message from {{Sender Name}} at {{Apartment Name}}',
			'wp_amgt_Message_Received_Template' => 'Dear {{Receiver Name}},
        You have received new message from {{Sender Name}}.{{Message Content}}.
	{{Message_Link}}
		
 Regards From {{Apartment Name}}.',

			'wp_amgt_paid_invoice_subject' => 'Your have successfully paid your invoice {{invoiceno}}',
			'wp_amgt_paid_invoice_email_template' => 'Dear {{member_name}},
        Your have successfully paid your invoice {{invoiceno}}. You can check the invoice attached here.',

			'wp_amgt_add_charges_subject' => 'Your have a new Charges Invoice raised by Admin',
			'wp_amgt_add_charges_email_template' => 'Dear {{member_name}},
        Your have a new Charges Invoice raised by Admin. You can check the Charges Invoice attached here.
		
 Regards From {{apartment_name}}.',

			'wp_amgt_visitor_request_aproved_subject' => 'You visitor request has been approved by admin at {{apartment_name}}',
			'wp_amgt_visitor_request_aproved_content' => 'Hello {{member_name}},
			
       Your visitor request has been approved by admin.
	   
       Regards From {{apartment_name}} .',

			'wp_amgt_visitor_request_subject' => 'You visitor request has been approved by admin at {{apartment_name}}',
			'wp_amgt_visitor_request_content' => 'Hello {{admin_name}}
		
        New Visitor Request From {{member_name}} at {{apartment_name}} .
		
         Reson For Visit : {{visit_reson}}.

         Visit Time : {{visit_time}}.
		
         Visit Date : {{visit_date}}.

		Regards From {{apartment_name}} .',

			'wp_amgt_visitor_request_forMember_subject' => 'You have receive new visitor request at {{apartment_name}}',
			'wp_amgt_visitor_request_content_forMember' => 'Hello {{member_name}}
		New Visitor Request From {{visitor_name}} at {{apartment_name}} .
			  
			   Reson For Visit : {{visit_reson}}.
	  
			   Visit Time : {{visit_time}}.
			  
			   Visit Date : {{visit_date}}.

			  Approve your visitor request.

			  Regards From {{apartment_name}} .',


			'wp_amgt_approved_facility_subject' => 'Your facility booking request has been approved by {{admin_name}} at {{apartment_name}}.',
			'wp_amgt_approved_facility_email_template' => 'Hello {{member_name}},

                 Your facility booking request has been approved by {{admin_name}}.

                Regards From {{apartment_name}}.',

			// ----------------------- Due Invoice Reminder for Patient ------//
			'wp_amgt_due_invoice_reminder_subject'=>'Due Invoice reminder of invoice id is {{Invoice Number}}.',
			'wp_amgt_due_invoice_reminder_template'=>'Dear {{Member Name}},

This is a reminder of your {{Building Name}} due invoice. the invoice id is {{Invoice Number}} , and total due amount is {{Due Amount}}.',
				
		);
		return $options;
	}
	add_action('init', "MJ_amgt_register_rules_post_type");
	add_action('init', "MJ_amgt_register_faq_post_type");
	add_action('init', "MJ_amgt_register_photogallary_post_type");
	add_action('admin_init', 'MJ_amgt_general_setting');
	function MJ_amgt_general_setting()
	{
		$options = MJ_amgt_option();
		foreach ($options as $key => $val) {
			add_option($key, $val);
		}
	}
	//ADMIN BAR CSS FUNCTION
	function MJ_amgt_change_adminbar_css($hook)
	{
		$current_page = $_REQUEST['page'];
		$pos = strrpos($current_page, "amgt-");
		if ($pos !== false) {
			wp_enqueue_script('jquery-ui-datepicker');
			wp_enqueue_script('MJgmgt-popper-js', plugins_url('/assets/js/popper.min.js', __FILE__));
			wp_register_script('MJ_gmgt_jquery-3-6-0', plugins_url('/assets/js/jquery-3-6-0.js', __FILE__), array('jquery'));

			wp_enqueue_script('MJ_gmgt_jquery-3-6-0');

			wp_enqueue_style('accordian-jquery-ui-css', plugins_url('/assets/accordian/jquery-ui.css', __FILE__));
			wp_enqueue_script('accordian-jquery-ui', plugins_url('/assets/accordian/jquery-ui.js', __FILE__));
			wp_enqueue_style('amgt-calender-css', plugins_url('/assets/css/fullcalendar.css', __FILE__));
			wp_enqueue_style('amgt-datatable-css', plugins_url('/assets/css/datatable/dataTables.css', __FILE__));
			wp_enqueue_style('amgt-datatable-select-css', plugins_url('/assets/css/select-dataTables.css', __FILE__));
			wp_enqueue_style('amgt-dataTables-responsive-css', plugins_url('/assets/css/datatable/dataTables.responsive.css', __FILE__));
			wp_enqueue_style('amgt-style-newversion', plugins_url('/assets/css/newversion.css', __FILE__));
			wp_enqueue_style('amgt-style-css', plugins_url('/assets/css/style.css', __FILE__));
			wp_enqueue_style('amgt-popup-css', plugins_url('/assets/css/popup.css', __FILE__));
			wp_enqueue_style('amgt-custom-css', plugins_url('/assets/css/custom.css', __FILE__));
			wp_enqueue_style('amgt-select2-css', plugins_url('/lib/select2-3.5.3/select2.css', __FILE__));
			wp_enqueue_script('amgt-select2', plugins_url('/lib/select2-3.5.3/select2-default.js', __FILE__), array('jquery'), '4.1.1', true);

			//------------------------- NEW DESIGN CSS -----------------//

			wp_enqueue_style('amgt-new-style-css', plugins_url('/assets/css/new_design.css', __FILE__));
			wp_enqueue_style('amgt-new-responsive-style-css', plugins_url('/assets/css/responsive_new_design.css', __FILE__));
			wp_enqueue_style('amgt-poppins-fontfamily-css', plugins_url('/assets/css/popping_font.css', __FILE__));

			//--------------------- NEW DESIGN CSS END -------------------//

			//------------------- Material Design------------------//

			wp_enqueue_style('MJgmgt-bootstrap-inputs', plugins_url('/assets/css/material/bootstrap-inputs.css', __FILE__));
			wp_enqueue_script('MJ_gmgt_material-min-js', plugins_url('/assets/js/material/material.min.js', __FILE__));

			//------------------ Material Design ------------------------//

			wp_enqueue_script('amgt-datatable', plugins_url('/assets/js/datatable/jquery-dataTables.min.js', __FILE__), array('jquery'), '4.1.1', true);

			wp_enqueue_script('amgt-datatable-tools', plugins_url('/assets/js/datatable/dataTables-tableTools.js', __FILE__), array('jquery'), '4.1.1', true);

			wp_enqueue_script('amgt-datatable-editor', plugins_url('/assets/js/datatable/dataTables-editor.min.js', __FILE__), array('jquery'), '4.1.1', true);

			wp_enqueue_script('amgt-dataTables-responsive', plugins_url('/assets/js/datatable/dataTables-responsive.min.js', __FILE__), array('jquery'), '4.1.1', true);


			wp_enqueue_script('amgt-popup', plugins_url('/assets/js/popup.js', __FILE__), array('jquery'), '4.1.1', false);

			//popup file alert msg languages translation				
			wp_localize_script(
				'amgt-popup',
				'language_translate',
				array(
					'select_unit_name' => esc_html__('Select Unit Name', 'apartment_mgt'),
					'select_all' => esc_html__('Select All', 'apartment_mgt'),
					'all_selected' => esc_html__('All Selected', 'apartment_mgt'),
					'Select_Member' => esc_html__('Select Member', 'apartment_mgt'),
					'count_facility_popup' => esc_html__('End Time should be greater than Start Time', 'apartment_mgt'),
					'category_alert' => esc_html__('You must fill out the field', 'apartment_mgt'),
					'end_time_facility' => esc_html__('End Time should be greater than Start Time', 'apartment_mgt'),
					'enter_category_alert' => esc_html__('Please enter Category Name.', 'apartment_mgt'),
					'discount_amount__alert' => esc_html__('discount amount can not greater than total amount', 'apartment_mgt'),
					'add_remove' => esc_html__('Are you sure want to delete this record?', 'apartment_mgt'),
					'no_record_found' => esc_html__('No Records Found !', 'apartment_mgt'),
					'select_atleast_one_record' => esc_html__('Please Select Atleast One Record', 'apartment_mgt'),
					'allow_file_alert' => esc_html__('Please Select JPG , jpeg and png File', 'apartment_mgt'),
					'end_time_notice_event' => esc_html__('End Time should be greater than Start Time', 'apartment_mgt'),
					'Add_Visitor_Req_alert_Visitor_Name' => esc_html__("Please Enter the Visitor's Name.", 'apartment_mgt'),
					'only' => esc_html__('Only ', 'apartment_mgt'),
					'formats_allowed' => esc_html__(' formats are allowed.', 'apartment_mgt'),
					'larger_file' => esc_html__('Too large file Size. Only file smaller than ', 'apartment_mgt'),
					'mb_uploaded' => esc_html__(' MB can be uploaded.', 'apartment_mgt'),
				)
			);
			wp_localize_script('amgt-popup', 'amgt', array('ajax' => admin_url('admin-ajax.php')));
			wp_enqueue_script('jquery');
			wp_enqueue_media();
			wp_enqueue_script('thickbox');
			wp_enqueue_style('thickbox');
			wp_enqueue_script('amgt-image-upload', plugins_url('/assets/js/image-upload.js', __FILE__), array('jquery'), '4.1.1', true);

			wp_enqueue_style('amgt-bootstrap-css', plugins_url('/assets/css/bootstrap/bootstrap.min.css', __FILE__));

			wp_enqueue_style('amgt-bootstrap-multiselect-css', plugins_url('/assets/css/bootstrap/bootstrap-multiselect.min.css', __FILE__));

			wp_enqueue_style('amgt-time-css', plugins_url('/assets/css/time.css', __FILE__));
			wp_enqueue_style('amgt-font-awesome-css', plugins_url('/assets/css/font-awesome-dafault.css', __FILE__));
			wp_enqueue_style('amgt-white-css', plugins_url('/assets/css/white.css', __FILE__));
			wp_enqueue_style('amgt-apartment-min-css', plugins_url('/assets/css/apartment.css', __FILE__));
			wp_enqueue_style('amgt-custom-admin-css', plugins_url('/assets/css/bootstrap/custom-admin.css', __FILE__));
			wp_enqueue_style('amgt-dynamic_css-css', plugins_url('/assets/css/dynamic_css.php', __FILE__));

			if (is_rtl()) {
				wp_enqueue_style('amgt-new-rtl-style-css', plugins_url('/assets/css/new_design_rtl.css', __FILE__));
				wp_enqueue_style('amgt-bootstrap-rtl-css', plugins_url('/assets/css/bootstrap/bootstrap.rtl.min.css', __FILE__));
				wp_enqueue_style('amgt-custom-rtl-css', plugins_url('/assets/css/bootstrap/custom-rtl.css', __FILE__));
			}

			/*--------Full calendar multilanguage---------*/
			wp_enqueue_script('amgt-calender_moment', plugins_url('/assets/js/moment.js', __FILE__));
			wp_enqueue_script('amgt-fullcalendar', plugins_url('/assets/js/fullcalendar.js', __FILE__));

			$lancode = get_locale();
			$code = substr($lancode, 0, 2);

			wp_enqueue_script('amgt-calender-es', plugins_url('/assets/js/calendar-lang/' . $code . '.js', __FILE__), array('jquery'), '4.1.1', true);

			wp_enqueue_style('amgt-apart-responsive-css', plugins_url('/assets/css/apart-responsive.css', __FILE__));

			wp_enqueue_script('amgt-bootstrap-js', plugins_url('/assets/js/bootstrap/bootstrap.bundle.min.js', __FILE__));

			wp_enqueue_script('amgt-bootstrap-multiselect-js', plugins_url('/assets/js/bootstrap/bootstrap-multiselect.min.js', __FILE__));

			wp_enqueue_script('amgt-time-js', plugins_url('/assets/js/time.js', __FILE__));
			wp_enqueue_script('amgt-timeago-js', plugins_url('/assets/js/jquery-timeago.js', __FILE__));
			//Validation style And Script CALL
			//validation lib CALL
			wp_enqueue_style('amgt-validate-css', plugins_url('/lib/validationEngine/css/validationEngine-jquery.css', __FILE__));
			wp_register_script('jquery-validationEngine-' . $code . '', plugins_url('/lib/validationEngine/js/languages/jquery.validationEngine-' . $code . '.js', __FILE__), array('jquery'));
			wp_enqueue_script('jquery-validationEngine-' . $code . '');
			wp_register_script('jquery-validationEngine', plugins_url('/lib/validationEngine/js/jquery-validationEngine.js', __FILE__), array('jquery'));
			wp_enqueue_script('jquery-validationEngine');
			wp_enqueue_script('apart_custom_confilict_obj', plugins_url('/assets/js/apart_custom_confilict_obj.js', __FILE__), array('jquery'), '4.1.1', false);

			//--------- Print and PDF ------------------//
			wp_enqueue_script('amgt-dataTables-buttons-min', plugins_url('/assets/js/dataTables-buttons-min.js', __FILE__), array('jquery'), '4.1.1', true);
			wp_enqueue_script('amgt-buttons-print-min', plugins_url('/assets/js/gmgt-buttons-print-min.js', __FILE__), array('jquery'), '4.1.1', true);

			wp_enqueue_script('pdfmake-min', plugins_url('/assets/js/pdfmake-min.js', __FILE__));
			wp_enqueue_script('vfs_fonts', plugins_url('/assets/js/vfs_fonts.js', __FILE__));
			//--------- Print and PDF ------------------//

			wp_enqueue_script('bootstrap-timepicker.min', plugins_url('/assets/js/bootstrap-timepicker.min.js', __FILE__));

			//Print pdf and column visible start
			wp_enqueue_script('amgt-dataTables-buttons-min', plugins_url('/assets/js/gmgt-dataTables-buttons-min.js', __FILE__), array('jquery'), '4.1.1', true);
			wp_enqueue_style('amgt-buttons-dataTables-min-css', plugins_url('/assets/css/buttons.dataTables.min.css', __FILE__));

			wp_enqueue_script('jszip.min', plugins_url('/assets/js/jszip.min.js', __FILE__), array('jquery'), '3.1.3', true);

			wp_enqueue_script('dataTables.fixedColumns.min', plugins_url('/assets/js/dataTables.fixedColumns.min.js', __FILE__), array('jquery'), '3.3.2', true);
			wp_enqueue_script('amgt-buttons-html5', plugins_url('/assets/js/buttons.html5.min.js', __FILE__), array('jquery'), '1.6.5', true);
			wp_enqueue_script('amgt-buttons-colVis-min', plugins_url('/assets/js/buttons.colVis.min.js', __FILE__), array('jquery'), '1.7.0', true);
			//Print pdf and column visible end

			// CHART CSS & JS
			wp_enqueue_script('amgt-chart-js', plugins_url('/assets/js/Chart.min.js', __FILE__));
			wp_enqueue_style('amgt-chart-css', plugins_url('/assets/css/Chart.min.css', __FILE__));

		}
	}
	if (isset ($_REQUEST['page']))
		add_action('admin_enqueue_scripts', 'MJ_amgt_change_adminbar_css');
}
//INSTALL LOGIN PAGE FOR FRONTEN SIDE //
function MJ_amgt_install_login_page()
{
	if (!get_option('amgt_login_page')) {
		$curr_page = array(
			'post_title' => esc_html__('Apartment Management Login Page', 'apartment_mgt'),
			'post_content' => '[amgt_login]',
			'post_status' => 'publish',
			'post_type' => 'page',
			'comment_status' => 'closed',
			'ping_status' => 'closed',
			'post_category' => array(1),
			'post_parent' => 0
		);
		$curr_created = wp_insert_post($curr_page);
		update_option('amgt_login_page', $curr_created);
	}
}
//user dashboard function
function MJ_amgt_user_dashboard()
{
	if (isset ($_REQUEST['apartment-dashboard'])) {
		require_once AMS_PLUGIN_DIR . '/fronted_template.php';
		exit;
	}

}
//REMOVE ALL THEAME STYLES //
function MJ_amgt_remove_all_theme_styles()
{
	global $wp_styles;
	$wp_styles->queue = array();
}
if (isset ($_REQUEST['apartment-dashboard']) && $_REQUEST['apartment-dashboard'] == 'user') {
	add_action('wp_print_styles', 'MJ_amgt_remove_all_theme_styles', 100);
}
//LOAD DOMAI NAMAE FUNCTION //
function MJ_amgt_domain_load()
{
	load_plugin_textdomain('apartment_mgt', false, dirname(plugin_basename(__FILE__)) . '/languages/');
}
add_action('plugins_loaded', 'MJ_amgt_domain_load');
add_action('wp_head', 'MJ_amgt_user_dashboard');
add_action('wp_login_failed', 'MJ_amgt_login_failed'); // hook failed login //
// HANDLE LOGIN FAILD ACTIONS//
function MJ_amgt_login_failed($user)
{
	// check what page the login attempt is coming from
	$referrer = $_SERVER['HTTP_REFERER'];

	$curr_args = array(
		'page_id' => get_option('amgt_login_page'),
		'login' => 'failed'
	);
	print_r($curr_args);
	$referrer_faild = add_query_arg($curr_args, get_permalink(get_option('amgt_login_page')));
	// check that were not on the default login page
	if (!empty ($referrer) && !strstr($referrer, 'wp-login') && !strstr($referrer, 'wp-admin') && $user != null) {
		// make sure we don't already have a failed login attempt
		if (!strstr($referrer, 'login=failed')) {
			// Redirect to the login page and append a query string of login failed
			wp_redirect($referrer_faild);
		} else {
			wp_redirect($referrer);
		}
		exit;
	}
}
$current_theme = wp_get_theme();

if ($current_theme != "Twenty Twenty Child") {
	if (isset ($_GET['login']) && $_GET['login'] == 'empty') {
		?>
		<div id="login-error" class="login-error username_password_msg">
			<p>
				<?php esc_html_e('Login Failed: Username and/or Password is empty, please try again.', 'apartment_mgt'); ?>
			</p>
		</div>
		<?php
	}
}

//FRONTEND SIDE LOGIN PAGE VALIDATION FUNCTION //
function MJ_amgt_login_form()
{
	$current_theme = wp_get_theme();
	if ($current_theme == 'Twenty Twenty-Four' || $current_theme == 'Twenty Twenty-Five') {
		?>
		<style>
			.wp-block-post-title {
				position: relative !important;
				bottom: 130px !important;
			}
			.registration_form_custom_div.custom_login_form {
				position: absolute;
				z-index: 1;
			}
		</style>
		<?php
	}
	if ($current_theme == 'Twenty Twenty-Five') {
		?>
		<style>
			.registration_form_custom_div {
				position: absolute;
				top: 35% !important;
			}
			.wp-block-group-is-layout-flow{
				margin-top: 3%;
			}
		</style>
		<?php
	}
	if ($current_theme == 'Twenty Twenty-Two' || $current_theme == 'Twenty Twenty-Three' || $current_theme == 'Twenty Twenty-Four' || $current_theme == 'Twenty Twenty-Five') {
		?>
		<style>
			.wp-block-group.alignwide.is-content-justification-space-between.is-layout-flex.wp-container-9 {
				margin-top: 160px !important;
			}

			#login-error {
				left: 3%;
				position: absolute;
				top: -18%;
				margin: 0 10%;
				width: 75%;
				margin-top: 15px;
				text-align: center;
			}

			.login-password label {
				display: inline-flex !important;
				width: auto !important;
				margin-top: 10px !important;
			}

			.wp-block-template-part .wp-block-group .alignfull .alignwide p {
				display: none;
			}

			.registration_form_custom_div {
				position: absolute;
				top: 50%;
				margin: 0 10%;
				width: 75%;
				margin-top: 15px;
			}

			.login-password input {
				height: 30px;
			}

			.login-username input {
				height: 30px;
			}

			.login-password label {
				padding-left: 43px;
			}

			.login-username label {
				padding-left: 52px;
			}

			.wp-site-blocks .wp-block-group .wp-block-post-title {
				margin-bottom: 0 !important;
			}

			.wp-block-group .alignwide {
				padding-bottom: 0 !important;
				padding-top: 0 !important;
			}

			.wp-embed-responsive .login-username {
				width: 100%;
			}

			.user-choice-area {
				position: absolute;
				top: 37%;
				margin: 0 40%;
			}

			.wp-embed-responsive #loginform {
				text-align: center;
			}

			.wp-embed-responsive .avada_wifth_100 {
				text-align: center;
			}

			.wp-embed-responsive .user-choice-block {
				float: left;
				width: 17% !important;
			}

			.wp-embed-responsive .user-choice-area {
				margin-left: 36%;
				/* margin-top: 3%; */
			}

			#registration_form .form-group {
				display: inline-flex;
			}

			#registration_form .form-group .col-sm-8 {
				width: 40% !important;
				padding-top: 5px;
			}

			#registration_form .form-group .col-sm-7 {
				width: 32% !important;
				padding-top: 5px;
			}

			#registration_form .form-group .col-sm-1 {
				width: 6% !important;
				padding-top: 5px;
			}

			#registration_form .form-group .col-sm-7 input {
				height: 35px;
			}

			#registration_form .form-group .col-sm-1 input {
				height: 35px;
			}

			#registration_form .form-group .col-sm-8 input {
				height: 35px;
			}

			#registration_form .form-group .col-sm-8 .radio-inline input {
				height: 15px;
			}

			.header h3 {
				text-align: center;
			}
			@media only screen and (min-width : 768px) {
			#loginform{
					margin-top: 50px;
				}
			}

			@media only screen and (max-width : 768px) {

				.login-username label,
				.login-username input,
				.login-password label,
				.login-password input {
					padding-left: 0px;
					width: 198px;
					margin-top: 10px;
				}
				

				#loginform .login-submit input {
					width: 220px;
				}

				.wp-block-group.alignwide.is-content-justification-space-between.is-layout-flex.wp-container-9 {
					margin-top: 382px !important;
				}

				.registration_form_custom_div {
					top: 35%;
				}

				#login-error {
					left: 0%;
					top: -35%;
					width: 88%;
				}

				.wp-block-group.has-global-padding {
					padding-bottom: 0px;
				}
			}

			@media only screen and (min-width: 375px) {
				.registration_form_custom_div {
					top: 50%;
				}
			}

			.login_div_Twenty {
				position: absolute;
				top: 60%;
				margin: 0px 13%;
				/* width: 74%; */
				margin-top: 15px;
			}
		</style>
		<?php
	}
	if ($current_theme == 'Twenty Twenty-One' || $current_theme == 'Twenty Twenty-Four') {
		?>
		<style>
			.site-header {
				padding-top: 0 !important;
				padding-bottom: 0 !important;
			}

			header.entry-header.alignwide {
				margin-bottom: 0;
			}

			.entry-title {
				font-size: 68px !important;
			}

			.login-username label {
				margin-right: 10px;
			}
		</style>
		<?php
	}
	if ($current_theme == 'Avada') {
		?>
		<style>
			.registration_form_custom_div #loginform {
				margin: auto;
				width: 50%;
			}

			.registration_form_custom_div #loginform input {
				border: 1px solid #ced4da;
				background: #F2F5FA;
			}

			.avada_wifth_100 {
				width: 50%;
			}
		</style>
		<?php
	}
	?>
	<style>
		#loginform .login-submit input {
			border-radius: 28px;
			padding: 8px 94px !important;
			background-color:
				<?php echo get_option('amgt_system_color_code'); ?>
			;
			border: 0px !important;
			color: #ffffff !important;
			font-size: 20px !important;
			text-transform: uppercase !important;
			text-decoration: none !important;
			cursor: pointer;
			margin-left: 46px;
		}

		.login-remember {
			margin-left: 67px;
		}
	</style>
	<div class="registration_form_custom_div  custom_login_form">
		<?php
		echo '
    <style>
	#loginform p{
		margin-bottom: 10px;
	}
	
	
	</style>';
		$args = array('redirect' => site_url());
		if (isset ($_GET['login']) && $_GET['login'] == 'failed') {
			?>
			<div id="login-error" class="login_css">
				<p>
					<?php esc_html_e('Login failed: You have entered an incorrect Username or password, please try again.', 'apartment_mgt'); ?>
				</p>
			</div>
			<?php
		}

		if (isset ($_GET['login']) && $_GET['login'] == 'empty') { ?>

			<div id="login-error" class="login-error username_password_msg">
				<p>
					<?php esc_html_e('Login Failed: Username or Password is empty, please try again.', 'apartment_mgt'); ?>
				</p>
			</div>
			<?php
		}
		global $reg_errors;
		$reg_errors = new WP_Error;
		if (is_wp_error($reg_errors)) {
			foreach ($reg_errors->get_error_messages() as $error) {
				echo '<div>';
				echo '<strong>' . esc_html__('ERROR', 'apartment_mgt') . '</strong>:';
				echo $error . '<br/>';
				echo '</div>';
			}
		}
		$args = array(
			'echo' => true,
			'redirect' => site_url($_SERVER['REQUEST_URI']),
			'form_id' => 'loginform',
			'label_username' => esc_html__('Username', 'apartment_mgt'),
			'label_password' => esc_html__('Password', 'apartment_mgt'),
			'label_remember' => esc_html__('Remember Me', 'apartment_mgt'),
			'label_log_in' => esc_html__('Log In', 'apartment_mgt'),
			'id_username' => 'user_login',
			'id_password' => 'user_pass',
			'id_remember' => 'rememberme',
			'id_submit' => 'wp-submit',
			'remember' => true,
			'value_username' => NULL,
			'value_remember' => false
		);

		$args = array('redirect' => site_url('/?apartment-dashboard=user'));
		if (is_user_logged_in()) {

			?>
			<a style="margin-left: 2%;" href="<?php echo home_url('/') . "?apartment-dashboard=user"; ?>">
				<?php esc_html_e('Dashboard', 'apartment_mgt'); ?>
			</a>
			<br /><a style="margin-left: 2%;" href="<?php echo wp_logout_url(); ?>">
				<?php esc_html_e('Logout', 'apartment_mgt'); ?>
			</a>
			<?php
		} else {
			wp_login_form($args);
			echo '<a style="margin: auto;display: block;" href="' . wp_lostpassword_url() . '" class="avada_wifth_100 amgt_chile_theme_forgot_pass" title="Lost Password">' . esc_html__('Forgot your password?', 'apartment_mgt') . '</a> ';
		}
		?>
	</div>
	<?php

}
function add_custom_nonce_to_login_form() {
    // Add a nonce field for security
    wp_nonce_field('custom_login_form_nonce', 'custom_login_form_nonce_field');
}
add_action('login_form', 'add_custom_nonce_to_login_form');
function verify_custom_login_nonce($user, $username, $password) 
{
    // Check if the nonce is set and valid
    if (isset($_POST['custom_login_form_nonce_field']) && !wp_verify_nonce($_POST['custom_login_form_nonce_field'], 'custom_login_form_nonce')) {
        // If nonce verification fails, prevent login and return an error
		return new WP_Error('nonce_verification_failed', __('Nonce verification failed. Please try again.'));
    }
    return $user;
}
add_filter('authenticate', 'verify_custom_login_nonce', 30, 3);

//add user authenticate filter
add_filter('wp_authenticate_user', function ($user) {
	$havemeta = get_user_meta($user->ID, 'amgt_hash', true);
	if ($havemeta) {
		$WP_Error = new WP_Error();
		$WP_Error->add('my_error', '<strong>Error</strong>: Your account is inactive. Contact your administrator to activate it.');
		return $WP_Error;
	}
	return $user;
}, 10, 2);
add_action('admin_print_scripts-post-new.php', 'MJ_amgt_post_admin_script');
add_action('admin_print_scripts-post.php', 'MJ_amgt_post_admin_script');

function MJ_amgt_post_admin_script()
{
	global $post_type;
	if ('amgt_photo_gallery' == $post_type) {
		wp_enqueue_style('amgt-custom-image-uploader-css', plugins_url('/assets/css/custom-image-uploader.css', __FILE__));
		wp_enqueue_script('amgt-custom-image-upload-js', plugins_url('/assets/js/custom-image-uploader.js', __FILE__), array('jquery'), '4.1.1', true);
	}
}
//INSTALL MEMERRAGISTATION PAGE FOR FRONTEN SIDE
function MJ_amgt_install_member_registration_page()
{
	if (!get_option('amgt_member_registration_page')) {
		$curr_page = array(
			'post_title' => esc_html__('Apartment Management Member Registration Page', 'apartment_mgt'),
			'post_content' => '[amgt_member_registration]',
			'post_status' => 'publish',
			'post_type' => 'page',
			'comment_status' => 'closed',
			'ping_status' => 'closed',
			'post_category' => array(1),
			'post_parent' => 0
		);
		$curr_created = wp_insert_post($curr_page);
		update_option('amgt_member_registration_page', $curr_created);
	}
}
//member registration short code
function MJ_amgt_member_registration_shortcode()
{
	ob_start();
	MJ_amgt_member_registration_function();
	return ob_get_clean();
}
//member registration function
function MJ_amgt_member_registration_function()
{
	global $building_id, $unit_cat_id, $unit_name, $member_type, $occupied_date, $committee_member, $first_name, $middle_name, $last_name, $gender, $birth_date, $address, $city_name, $mobile, $email, $username, $password, $amgt_user_avatar;
	if (isset ($_POST['registration_front_member'])) {
		MJ_amgt_registration_validation(
			$_POST['building_id'],
			$_POST['unit_cat_id'],
			$_POST['unit_name'],
			$_POST['member_type'],
			$_POST['first_name'],
			$_POST['last_name'],
			$_POST['gender'],
			$_POST['birth_date'],
			$_POST['mobile'],
			$_POST['email'],
			$_POST['password']
		);

		$building_id = sanitize_text_field($_POST['building_id']);
		$unit_cat_id = sanitize_text_field($_POST['unit_cat_id']);
		$unit_name = sanitize_text_field($_POST['unit_name']);
		$member_type = sanitize_text_field($_POST['member_type']);
		$occupied_date = sanitize_text_field($_POST['occupied_date']);
		$committee_member = isset ($_POST['committee_member']) ? $_POST['committee_member'] : '';

		$first_name = sanitize_text_field($_POST['first_name']);
		$middle_name = sanitize_text_field($_POST['middle_name']);
		$last_name = sanitize_text_field($_POST['last_name']);
		$gender = sanitize_text_field($_POST['gender']);
		$birth_date = sanitize_text_field($_POST['birth_date']);
		$address = sanitize_text_field($_POST['address']);
		$mobile = sanitize_text_field($_POST['mobile']);
		$email = sanitize_text_field($_POST['email']);
		$username = sanitize_text_field($_POST['email']);
		$password = sanitize_text_field($_POST['password']);

		$family_data = array();
		foreach ($_POST['family_type'] as $key => $value) {
			$family_data[] = array(
				'first_name' => $_POST['family_first_name'][$key],
				'last_name' => $_POST['family_last_name'][$key],
				'birth_date' => $_POST['family_birth_date'][$key],
				'gender' => $_POST['family_gender_' . $key],
				'mobile' => $_POST['family_mobile'][$key],
				'type' => $_POST['family_type'][$key]
			);
		}


		MJ_amgt_complete_registration($building_id, $unit_cat_id, $unit_name, $member_type, $occupied_date, $committee_member, $first_name, $middle_name, $last_name, $gender, $birth_date, $address, $mobile, $email, $username, $password, $amgt_user_avatar, $family_data);
	}
	MJ_amgt_registration_form($building_id, $unit_cat_id, $unit_name, $member_type, $committee_member, $first_name, $middle_name, $last_name, $gender, $birth_date, $address, $mobile, $email, $username, $password, $amgt_user_avatar);
}


function MJ_amgt_complete_registration($building_id, $unit_cat_id, $unit_name, $member_type, $occupied_date, $committee_member, $first_name, $middle_name, $last_name, $gender, $birth_date, $address, $mobile, $email, $username, $password, $amgt_user_avatar, $family_data)
{
	global $reg_errors;
	global $wpdb;
	global $building_id, $unit_cat_id, $unit_name, $member_type, $committee_member, $first_name, $middle_name, $last_name, $gender, $birth_date, $address, $mobile, $email, $username, $password, $amgt_user_avatar;
	$amgt_user_avatar = '';

	if (1 > count($reg_errors->get_error_messages())) {
		$userdata = array(
			'user_login' => $username,
			'user_email' => $email,
			'user_pass' => $password,
			'user_url' => NULL,
			'first_name' => $first_name,
			'last_name' => $last_name,
			'nickname' => NULL
		);

		$user_id = wp_insert_user($userdata);


		$member_image_url = '';

		if (!empty ($_FILES['amgt_user_avatar']) && $_FILES['amgt_user_avatar']['size'] > 0) {
			$member_image = MJ_amgt_amgt_load_documets($_FILES['amgt_user_avatar'], 'amgt_user_avatar', 'pimg');
			$member_image_url = content_url() . '/uploads/apartment_assets/' . $member_image;
		}

		$user = new WP_User($user_id);
		$user->set_role('member');
		$usermetadata = array(
			'building_id' => sanitize_text_field($building_id),
			'unit_cat_id' => sanitize_text_field($unit_cat_id),
			'unit_name' => sanitize_text_field($unit_name),
			'unit_status' => 'active',
			'member_type' => sanitize_text_field($member_type),
			'occupied_date' => sanitize_text_field($occupied_date),
			'committee_member' => sanitize_text_field($committee_member),
			'middle_name' => sanitize_text_field($middle_name),
			'gender' => sanitize_text_field($gender),
			'birth_date' => sanitize_text_field($birth_date),
			'address' => sanitize_text_field($address),
			'mobile' => sanitize_text_field($mobile),
			'amgt_user_avatar' => $member_image_url
		);


		foreach ($usermetadata as $key => $val) {
			update_user_meta(intval($user_id), $key, $val);
		}
		$returnans = update_user_meta(intval($user_id), 'first_name', $first_name);
		$returnans = update_user_meta(intval($user_id), 'last_name', $last_name);

		if (!empty ($user_id)) {
			foreach ($family_data as $key => $family_member) {

				$member_email = explode('@', $email);
				$family_email = $member_email[0] . '+' . $family_member['first_name'] . '@' . $member_email[1];

				$familyUserdata = array();
				$familyUserdata['user_email'] = $family_email;
				$familyUserdata['user_login'] = $family_email;
				$familyUserdata['display_name'] = sanitize_text_field($family_member['first_name'] . " " . $family_member['last_name']);
				$familyUserdata['user_pass'] = $password . '' . $family_member['first_name'];

				$familyusermetadata = array();
				$familyusermetadata['first_name'] = sanitize_text_field($family_member['first_name']);
				$familyusermetadata['last_name'] = sanitize_text_field($family_member['last_name']);
				$familyusermetadata['birth_date'] = sanitize_text_field($family_member['birth_date']);
				$familyusermetadata['gender'] = sanitize_text_field($family_member['gender']);
				$familyusermetadata['mobile'] = sanitize_text_field($family_member['mobile']);

				$familyusermetadata['building_id'] = sanitize_text_field($building_id);
				$familyusermetadata['unit_cat_id'] = sanitize_text_field($unit_cat_id);
				$familyusermetadata['unit_name'] = sanitize_text_field($unit_name);

				if (isset ($family_member['type'])) {
					$familyusermetadata['member_type'] = sanitize_text_field($family_member['type']);
				}
				if (!empty ($familyUserdata)) {
					$familyUser_id = wp_insert_user($familyUserdata);

					if (!is_wp_error($familyUser_id)) {
						$familyusermetadata['member_id'] = intval($user_id);
						$family_member_ids[] = intval($familyUser_id);

						foreach ($familyusermetadata as $meta_key => $meta_val) {
							update_user_meta($familyUser_id, $meta_key, $meta_val);
						}

						$family_user = new WP_User($familyUser_id);
						$family_user->set_role($family_data['role']);
					}
				}

			}
			if (!empty ($family_member_ids)) {
				update_user_meta(intval($user_id), 'family_member_id', $family_member_ids);
			}
		}
		
		$table_amgt_unit_occupied_history = $wpdb->prefix . 'amgt_unit_occupied_history';
		$historydata['building_id'] = sanitize_text_field($building_id);
		$historydata['unit_cat_id'] = sanitize_text_field($unit_cat_id);
		$historydata['member_name'] = sanitize_text_field($first_name.' '.$last_name);
		$entry_data = array();

		$entry_data[] = array('email' => sanitize_email($email), 'mobile' => sanitize_text_field($mobile), 'address' => sanitize_text_field($address));
		$member_contact_details = json_encode($entry_data);
		$historydata['member_contact_details'] = $member_contact_details;
		$historydata['occupied_from_date'] = MJ_amgt_get_format_for_db($occupied_date);
		$historydata['unit_name'] = MJ_amgt_strip_tags_and_stripslashes($unit_name);

		$result = $wpdb->insert($table_amgt_unit_occupied_history, $historydata);

		if (get_option('allow_member_to_multiple_units') == "no") {
			$usermetadata['unit_status'] = "active";
		}

		if (get_option('apartment_member_approval') == 'no') {
			$hash = md5(rand(0, 1000));
			update_user_meta(intval($user_id), 'amgt_hash', $hash);
		}
		//---------------- SEND  SMS ------------------//
		include_once (ABSPATH . 'wp-admin/includes/plugin.php');
		if (is_plugin_active('sms-pack/sms-pack.php')) {
			if (!empty (get_user_meta(intval($user_id), 'phonecode', true))) {
				$phone_code = get_user_meta(intval($user_id), 'phonecode', true);
			} else {
				$phone_code = '+' . MJ_amgt_get_countery_phonecode(get_option('amgt_contry'));
			}

			$user_number[] = $phone_code . get_user_meta(intval($user_id), 'mobile', true);

			$apartmentname = get_option('amgt_system_name');
			$message_content = "You are successfully registered at $apartmentname .";
			$current_sms_service = get_option('smgt_sms_service');
			$args = array();
			$args['mobile'] = $user_number;
			$args['message_from'] = "Registration";
			$args['message'] = $message_content;
			if ($current_sms_service == 'telerivet' || $current_sms_service == "MSG91" || $current_sms_service == 'bulksmsgateway.in' || $current_sms_service == 'textlocal.in' || $current_sms_service == 'bulksmsnigeria' || $current_sms_service == 'africastalking' || $current_sms_service == 'clickatell') {
				$send = send_sms($args);
			}
		}

		$user_info = get_userdata(intval($user_id));
		$to = $user_info->user_email;
		$username = $user_info->user_login;
		$subject = get_option('wp_amgt_Member_Registration');
		$apartmentname = get_option('amgt_system_name');
		$message_content = get_option('wp_amgt_registration_email_template');
		$loginlink = home_url() . '/apartment-management/';
		$building = get_post(intval($building_id));
		$buildingname = "";
		if (!empty ($building))
			$buildingname = sanitize_text_field($building->post_title);
		$subject_search = array('{{apartment_name}}');
		$subject_replace = array($apartmentname);
		$search = array('{{member_name}}', '{{apartment_name}}', '{{unit_name}}', '{{building_name}}', '{{loginlink}}', '{{username}}', '{{email}}', '{{password}}');
		$replace = array(sanitize_text_field($user_info->display_name), sanitize_text_field($apartmentname), sanitize_text_field($unit_name), sanitize_text_field($buildingname), $loginlink, $username, $to, $password);
		$message_content = str_replace($search, $replace, $message_content);
		$subject = str_replace($subject_search, $subject_replace, $subject);
		$apartment = get_option('amgt_system_name');
		$headers = "";
		$headers .= 'From: ' . $apartment . ' <noreplay@gmail.com>' . "\r\n";
		$headers .= "MIME-Version: 1.0\r\n";
		$headers .= "Content-Type: text/plain; charset=iso-8859-1\r\n";
		$headers .= 'Content-Type: text/html; charset=UTF-8';
		$enable_notofication = get_option('apartment_enable_notifications'); {
			$messagecontent = MJ_amgt_get_mail_content_with_template_design('<pre>'.$message_content.'</pre>');
			wp_mail($to, $subject, $messagecontent, $headers);
		}
		$page_id = get_option('amgt_member_registration_page');
		$referrer_ipn = array(
			'page_id' => $page_id,
			'action' => 'reg_success'
		);
		$referrer_ipn = add_query_arg($referrer_ipn, home_url());
		wp_redirect($referrer_ipn);
		exit;
	}
}


function MJ_amgt_registration_form($building_id, $unit_cat_id, $unit_name, $member_type, $committee_member, $first_name, $middle_name, $last_name, $gender, $birth_date, $address, $mobile, $email, $username, $password, $amgt_user_avatar)
{
	$edit = 0;
	$obj_units = new MJ_amgt_ResidentialUnit;
	$role = 'member';

	$lancode = get_locale();
	$code = substr($lancode, 0, 2);
	wp_enqueue_style('amgt-validate-css', plugins_url('/lib/validationEngine/css/validationEngine-jquery.css', __FILE__));
	wp_register_script('jquery-validationEngine-' . $code . '', plugins_url('/lib/validationEngine/js/languages/jquery.validationEngine-' . $code . '.js', __FILE__), array('jquery'));
	wp_enqueue_script('jquery-validationEngine-' . $code . '');
	wp_register_script('jquery-validationEngine', plugins_url('/lib/validationEngine/js/jquery-validationEngine.js', __FILE__), array('jquery'));
	wp_enqueue_script('jquery-validationEngine');
	//wp_enqueue_script( 'amgt-jquery', plugins_url( '/assets/js/jquery.min.js', __FILE__), array( 'jquery' ) );
	wp_enqueue_script('amgt-bootstrap-js', plugins_url('/assets/js/bootstrap/bootstrap.min.js', __FILE__));

	if (is_rtl()) {
		wp_enqueue_style('amgt-bootstrap-rtl-css', plugins_url('/assets/css/bootstrap/bootstrap.rtl.min.css', __FILE__));
	}

	wp_enqueue_style('accordian-jquery-ui-css', plugins_url('/assets/accordian/jquery-ui.css', __FILE__));

	// wp_enqueue_script('amgt-popup', plugins_url( '/assets/js/popup.js', __FILE__ ), array( 'jquery' ), '4.1.1', false );
	wp_localize_script('amgt-popup', 'amgt', array('ajax' => admin_url('admin-ajax.php')));

	wp_enqueue_style('amgt-bootstrap-css', plugins_url('/assets/css/bootstrap/bootstrap.min.css', __FILE__));
	wp_enqueue_style('amgt-datepicker1-min-css', plugins_url('/assets/css/datepicker-default.css', __FILE__));
	//popup file alert msg languages translation				
	wp_localize_script(
		'amgt-popup',
		'language_translate',
		array(
			'select_unit_name' => esc_html__('Select Unit Name', 'apartment_mgt'),
			'category_alert' => esc_html__('You must fill out the field', 'apartment_mgt'),
			'Select_Member' => esc_html__('Select Member', 'apartment_mgt'),
			'count_facility_popup' => esc_html__('End Time should be greater than Start Time', 'apartment_mgt'),
			'end_time_facility' => esc_html__('End Time should be greater than Start Time', 'apartment_mgt'),
			'enter_category_alert' => esc_html__('Please enter Category Name.', 'apartment_mgt'),
			'discount_amount__alert' => esc_html__('discount amount can not greater than total amount', 'apartment_mgt'),
			'add_remove' => esc_html__('Are you sure want to delete this record?', 'apartment_mgt'),

		)
	);

	//---------------------- NEW DESIGN CSS --------------------//
	wp_enqueue_style('amgt-new-style-css', plugins_url('/assets/css/new_design.css', __FILE__));

	//------------------- Material Design------------------//
	$current_theme_new = wp_get_theme();

	if ($current_theme_new != "Avada") {
		wp_enqueue_script('MJ_gmgt_material-min-js', plugins_url('/assets/js/material/material.min.js', __FILE__));
	}
	wp_enqueue_style('MJgmgt-bootstrap-inputs', plugins_url('/assets/css/material/bootstrap-inputs.css', __FILE__));

	//------------------ Material Design ------------------------//
	if ($current_theme_new == "Twenty Twenty Child") {
		?>
		<link rel="stylesheet" href="<?php echo AMS_PLUGIN_URL . '/assets/css/bootstrap/bootstrap.min.css'; ?>">

		<?php
	}
	?>

	<link rel="stylesheet" href="<?php echo AMS_PLUGIN_URL . '/assets/css/datepicker-default.css'; ?>">
	<?php
	echo '
		<style>
			
			.amgt_registraion_form .form-group .form-control {
				font-size: 16px;
			}
				// .amgt_registraion_form .form-group,.amgt_registraion_form .form-group .form-control{float:left;width:100%}
				.amgt_registraion_form .form-group .require-field{color:red;}
				.amgt_registraion_form select.form-control,.amgt_registraion_form input[type="file"] {
				padding: 0.5278em;
				margin-bottom: -3px;
				border: 0;
			}
			.amgt_registraion_form .radio-inline {
				float: left;
				// margin-bottom: 10px;
				// margin-top: 10px;
				margin-right: 15px;
			}
			.amgt_registraion_form .form-control.checkbox-input {
				margin-top: 15px;
			}
			.amgt_registraion_form  .radio-inline .tog {
				margin-right: 5px;
			}
			.amgt_registraion_form .col-sm-2.control-label {
				text-align: right;
			}
				.amgt_registraion_form .form-group .col-sm-2 {width: 32.667%;}
				.amgt_registraion_form .form-group .col-sm-8 {     width: 66.66666667%;}
				.amgt_registraion_form .form-group .col-sm-7{  width: 53.33333333%;}
				.amgt_registraion_form .form-group .col-sm-1{  width: 13.33333333%;}
				.amgt_registraion_form .form-group .col-sm-8, .amgt_registraion_form .form-group .col-sm-2,.amgt_registraion_form .form-group .col-sm-7,.amgt_registraion_form .form-group .col-sm-1{      
				padding-left: 15px;
				padding-right: 15px;
				float:left;}
				.amgt_registraion_form .form-group .col-sm-8, .amgt_registraion_form .form-group .col-sm-2,.amgt_registraion_form .amgt_registraion_form .form-group .col-sm-7
				{
					position: relative;
					min-height: 1px;   
				}
			
				
				
				.amgt_registraion_form .col-sm-offset-2.col-sm-8 {
				float: left;
				margin-left: 35%;
				margin-top: 15px;
			}
			.amgt_registraion_form .form-control {
				line-height: 22px;
			}
				.student_reg_error .error{color:red;}
			.amgt_registraion_form .occupied_div
			{
				display:none;
			}
			.amgt_registraion_form .menu,.amgt_registraion_form .entry-title,.amgt_registraion_form .submit_btn
			{
				font-size: 14px!important;
			}
			.amgt_registraion_form select 
			{
				height: 48px;
				font-size: 13px;
				// background: #F2F5FA!important;
				color: #818386;
				border: 1px solid #ccc;
			}
			.width_auto
			{
				width: auto !important;
			}
			.save_btn {
				height: 46px;
				background-color: ' . get_option('amgt_system_color_code') . ' !important;
				color: #fff !important;
				width: 100% !important;
				font-weight: 500 !important;
				font-size: 16px !important;
				line-height: 24px;
				text-align: center;
				color: #FFFFFF;
				text-transform: uppercase;
				border: 0px solid ' . get_option('amgt_system_color_code') . ' !important;
			}
			.width_48
			{
				width: 48% !important;
			}
			.width_100px
			{
				width:100px !important;
			}
			
			#member_form .control-label
			{

				font-size: 14px!important;
			}

			input[type=radio]:checked {
				border: 1px solid !important;
			}
			/* input[type=checkbox], input[type=radio] {
				-webkit-appearance: none;
				-moz-appearance: none;
				position: relative;
				width: 20px;
				height: 20px;
				border: 1px solid;
				background: var(--global--color-white);
			} */
			input[type=radio]:checked:after {
				opacity: 1;
			}
			.width_100
			{
				width:100%;
			}
			/* input[type=radio]:after {
				content: "";
				opacity: 0;
				display: block;
				left: 5px;
				top: 5px;
				position: absolute;
				width: 8px;
				height: 8px;
				border-radius: 50%;
				background: var(--form--color-text);
			} */
		</style>';
	?>
	<script type="text/javascript" src="<?php echo AMS_PLUGIN_URL . '/assets/js/jquery.min.js'; ?>"></script>
	<script type="text/javascript"
		src="<?php echo esc_url(plugins_url() . '/apartment-management/assets/accordian/jquery-ui.js'); ?>"></script>
	<!--- Validation Message Demo page registration --->
<script type="text/javascript"
	src="<?php echo AMS_PLUGIN_URL . '/lib/validationEngine/js/jquery-validationEngine.js'; ?>"></script>
<script type="text/javascript"
	src="<?php echo AMS_PLUGIN_URL . '/lib/validationEngine/js/languages/jquery.validationEngine-' . $code . '.js'; ?>"></script>
<script type="text/javascript" id="amgt-popup-js" src="<?php echo AMS_PLUGIN_URL . '/assets/js/popup.js'; ?>"></script>
<script id="amgt-popup-front">
	var amgt = {
		"ajax": "<?php echo admin_url('admin-ajax.php'); ?>"
	};
	var language_translate2 =
	{
		"edit_record_alert": "Are you sure want to edit this record?",
		"category_alert": "You must fill out the field!",
		"class_limit_alert": "Class Limit Is Full.",
		"enter_room_alert": "Please Enter Room Category Name.",
		"enter_value_alert": "Please Enter Value.",
		"delete_record_alert": "Are you sure want to delete this record?",
		"select_hall_alert": "Please Select Exam Hall",
		"one_record_alert": "Please Checked Atleast One Student"
	};	
</script>
<!--- Validation Message Demo page registration end  --->

<div class="amgt_registraion_form">

	<script type="text/javascript">
		jQuery(document).ready(function ($) {

			"use strict";
			<?php
			if (is_rtl()) {
				?>
					$('#member_form ').validationEngine({ promptPosition: " bottomLeft ", maxErrorsPerField: 1 });
					<?php
			} else {
				?>
					$('#member_form ').validationEngine({ promptPosition: " bottomLeft ", maxErrorsPerField: 1 });
						<?php
			}
			?>

				$('#birth_date').datepicker({
					dateFormat: "yy-mm-dd",
					maxDate: 0,
					changeMonth: true,
					changeYear: true,
					yearRange: '-120:+25',
					beforeShow: function (textbox, instance) {
						instance.dpDiv.css({
							marginTop: (-textbox.offsetHeight) + 'px'
						});
					},
					onChangeMonthYear: function (year, month, inst) {
						jQuery(this).val(month + "/" + year);
					}
				});

			$('#occupied_date').datepicker({
				//autoclose: true
				maxDate: 0,
				changeMonth: true,
				changeYear: true
			});
			$("body").on("change", ".file", function () {

				"use strict";
				var fileExtension = ['jpg', 'jpeg', 'png'];
				// var obj = $(this).val();
				if ($.inArray($(this).val().split('.').pop().toLowerCase(), fileExtension) == -1) {
					alert("<?php esc_html_e('Only jpg,jpeg,png File allowed', 'apartment_mgt') ?>");
					$(this).val('');
				}
			});
			//username not  allow space validation
			$('#username').keypress(function (e) {
				"use strict";
				if (e.which === 32)
					return false;
			});

			jQuery('#family_birth_date').datepicker({
				dateFormat: "yy-mm-dd",
				maxDate: 0,
				changeMonth: true,
				changeYear: true,
				yearRange: '-120:+25',
				beforeShow: function (textbox, instance) {
					instance.dpDiv.css({
						marginTop: (-textbox.offsetHeight) + 'px'
					});
				},
				onChangeMonthYear: function (year, month, inst) {
					jQuery(this).val(month + "/" + year);
				}
			});


		});
		function deleteformBodyElement(n) {
			if (confirm('Are you sure want to delete this record?')) {
				$(n).closest('.form-body.user_form').remove();
			}
		}
	</script>
	<?php
	$current_theme = wp_get_theme();

	if ($current_theme == 'Twenty Twenty Child') {
		?>
	<style>
		.ragistaion_message {
			font-size: 14px;
			font-weight: 500;
		}

		.child_theme_padding_left_0 {
			padding-left: 0 !important;
		}

		.child_theme_padding_right_0 {
			padding-right: 0 !important;
		}

		.amgt_registraion_form select {
			height: 40px;
		}

		.amgt_registraion_form .col-md-12 {
			height: 41px;
		}

		.form-control {
			height: 30px;
			box-shadow: inset 0 1px 1px rgb(0 0 0 / 0%);
		}

		#member_form input[type=text],
		#member_form .text-input,
		#member_form .password {
			border: 0px solid #ccc !important;
		}

		.md-form label.active {
			top: 5px;
		}
	</style>
	<?php
	}
	if ($current_theme == 'Avada') {

		?>

	<style>
		.avada_margin_bottom_15px {
			margin-bottom: 15px;
		}

		.fusion-header {
			height: 100px !important;
		}

		.collapse {

			display: block;

		}



		/* .gym_registration_according
	
				{
	
					width: 50% !important;
	
				} */

		/* .avada_width_100_per .save_btn
	
				{
	
					width: 25% !important;
	
				} */

		.avada_width_100_per {

			width: 100% !important;

			padding-left: 0px !important;

			padding-right: 0px !important;

		}

		#loginform input {

			/* width: 50% !important; */

			border: 1px solid;

			/* margin-left: 20px; */

		}

		.login-password label {

			width: 160px !important;

		}

		.avada-responsive p.login-submit {

			width: 50%;

		}
	</style>

	<?php

	}
	if ($current_theme == 'Twenty Twenty-One') {
		?>
	<style>
		.site-header {
			padding-top: 0 !important;
			padding-bottom: 0 !important;
		}

		header.entry-header.alignwide {
			margin-bottom: 0;
		}

		.entry-title {
			font-size: 68px !important;
		}

		.login-username label {
			margin-right: 10px;
		}

		.radio_btn_margin_set label {
			margin-bottom: 0 !important;
		}

		input[type=checkbox],
		input[type=radio] {
			width: 19px;
			height: 19px;
		}

		.gender_line_height_24px {
			line-height: 20px !important;
		}
	</style>
	<?php
	}
	if ($current_theme == 'Twenty Twenty-Two') {
		?>
	<style>
		.wp-block-group .wp-block-spacer {
			height: 0 !important;
		}

		.wp-block-group .alignwide {
			padding-bottom: 0 !important;
			padding-top: 0 !important;
		}

		.wp-site-blocks .wp-block-group .wp-block-post-title {
			margin-bottom: 0 !important;
		}

		.wp-block-group .is-content-justification-space-between .wp-block-site-title a {
			display: none;
		}

		.wp-block-group .is-content-justification-space-between .has-text-align-right {
			display: none;
		}

		.student_registraion_form {
			margin-top: 15px;
		}

		.gym_registration_according {
			float: left;
			width: 60% !important;

			margin-top: 20px;

			margin: 0 22% !important;

		}

		.save_btn_line_height_14px {

			margin: 0 44% !important;

		}
	</style>

	<?php

	}

	if ($current_theme == 'Twenty Twenty') {

		?>

	<style>
		.singular .entry-header {

			padding: 0 !important;

		}

		.accordion-item:first-of-type .accordion-button {

			text-decoration: none;



		}

		.accordion-button {

			font-size: 16px !important;

		}

		a {

			text-decoration: none;

		}

		.entry-content>*:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.is-style-wide) {
			max-width: 80rem !important;
		}

		.post-inner {

			padding-top: 4rem !important;

		}

		.entry-content h2 {

			margin: 0 !important;

		}
	</style>

	<?php

	}
	if ($current_theme == 'Twenty Twenty-Two') {
		?>
	<style>
		#content-area {
			padding-top: 10px !important;
		}
	</style>
	<?php

	}
	if ($current_theme == 'Twenty Twenty-Three') {
		?>
	<style>
		.registration_form_custom_div.amgt_child_login_reg {
			position: absolute;
			top: 400px;
			left: 422px;

		}
	</style>
	<?php

	}
	?>
	<style>
		.dropdown-menu {
			min-width: 265px !important;
		}

		.occupied_status_color {
			color: red;
		}

		.float_left {
			float: left !important;
		}
	</style>
	<?php
	if (isset ($_REQUEST['action']) == "reg_success") {
		if (get_option('apartment_member_approval') == 'no') {
			?>
	<p class="success_message_reg_form ragistaion_message">
		<?php esc_html_e('Your registration is complete. Your account will active after admin will approve.', 'apartment_mgt'); ?>
	</p>
	<?php
		} else {
			?>
	<p class="success_message_reg_form ragistaion_message">
		<?php esc_html_e('Your registration is complete. You can access system using your Email ID and password.', 'apartment_mgt'); ?>
	</p>
	<?php
		}
	}
	?>

	<?php $action = sanitize_text_field(isset ($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'); ?>
	<input type="hidden" name="action" value="<?php echo esc_attr($action); ?>">
	<input type="hidden" name="role" value="<?php echo esc_attr($role); ?>" />
	<div class="panel-body">
		<form name="member_form" action="" method="post" class="form-horizontal" id="member_form"
			enctype="multipart/form-data">
			<?php $action = sanitize_text_field(isset ($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'); ?>
			<input id="action" type="hidden" name="action" value="<?php echo esc_attr($action); ?>">
			<input type="hidden" name="user_id" value="<?php echo isset ($member_id) ? $member_id : ''; ?>" />
			<input type="hidden" name="role" value="<?php echo esc_attr($role); ?>" />
			<?php
			$current_page = get_queried_object();
			$pagename = $current_page->post_title;
			// var_dump($pagename);
			?>
			<input type="hidden" name="page_name" class="page_name" value="<?php echo $pagename; ?>">
			<div class=" form-body user_form"> <!-- user_form Strat-->
					<div class="row"><!--Row Div Strat-->
						<div id="hello"></div>
						<div class="header mb-3">
							<h3 class="first_hed">
								<?php esc_html_e('Building Information', 'apartment_mgt'); ?>
							</h3>
						</div>
						<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
							<!-- <label class="ml-1 custom-top-label top" for="role_type"><?php esc_html_e('Building', 'apartment_mgt'); ?><span class="require-field">*</span></label> -->
							<select
								class="font_size_1rem_registration_form form-select validate[required] building_category width_100"
								name="building_id">
								<option value="">
									<?php esc_html_e('Select Building', 'apartment_mgt'); ?>
								</option>
								<?php
								if ($edit) {
									$category = $result->building_id;
								} elseif (isset ($_REQUEST['building_id'])) {
									$category = $_REQUEST['building_id'];
								} else {
									$category = "";
								}
								$activity_category = MJ_amgt_get_all_category('building_category');
								if (!empty ($activity_category)) {
									foreach ($activity_category as $retrive_data) {
										echo '<option value="' . $retrive_data->ID . '" ' . selected($category, $retrive_data->ID) . '>' . $retrive_data->post_title . '</option>';
									}
								} ?>
							</select>
						</div>
						<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
							<!-- <label class="ml-1 custom-top-label top" for="role_type"><?php esc_html_e('Unit Category', 'apartment_mgt'); ?><span
							class="require-field">*</span></label> -->
							<select
								class="font_size_1rem_registration_form form-select validate[required] unit_category_for_member width_100"
								name="unit_cat_id">
								<option value="">
									<?php esc_html_e('Select Unit Category', 'apartment_mgt'); ?>
								</option>
								<?php
								if ($edit)
									$category = $result->unit_cat_id;
								elseif (isset ($_REQUEST['unit_cat_id']))
									$category = $_REQUEST['unit_cat_id'];
								else
									$category = "";

								$activity_category = MJ_amgt_get_all_category('unit_category');
								if (!empty ($activity_category)) {
									foreach ($activity_category as $retrive_data) {
										echo '<option value="' . $retrive_data->ID . '" ' . selected($category, $retrive_data->ID) . '>' . $retrive_data->post_title . '</option>';
									}
								}
								?>
							</select>
						</div>
						<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
							<!-- <label class="ml-1 custom-top-label top" for="role_type"><?php esc_html_e('Unit', 'apartment_mgt'); ?><span
								class="require-field">*</span></label> -->
							<select
								class="font_size_1rem_registration_form form-select validate[required] unit_name width_100"
								name="unit_name">
								<option value="">
									<?php esc_html_e('Select Unit Name', 'apartment_mgt'); ?>
								</option>

							</select>
						</div>
						<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
							<input type="hidden" name="member_type" value="Owner">
							<!-- <label class="ml-1 custom-top-label top" for="role_type"><?php esc_html_e('Member Type', 'apartment_mgt'); ?><span class="require-field">*</span></label> -->
							<select class="form-select validate[required] width_100" name="member_type" id="member_type" disabled>
								<option value="">
									<?php esc_html_e('Select Member Type', 'apartment_mgt'); ?>
								</option>
								<?php
								if ($edit)
									$category = $result->member_type;
								elseif (isset ($_POST['member_type']))
									$category = $_POST['member_type'];
								else
									$category = ""; ?>
								<option value="Owner" <?php selected('Owner', 'Owner'); ?>>
									<?php esc_html_e('Owner', 'apartment_mgt'); ?>
								</option>
								<option value="tenant" <?php selected($category, 'tenant'); ?>>
									<?php esc_html_e('Tenant', 'apartment_mgt'); ?>
								</option>
								<!-- <option value="owner_family" <?php selected($category, 'owner_family'); ?>>
									<?php esc_html_e('Owner Family', 'apartment_mgt'); ?>
								</option>
								<option value="tenant_family" <?php selected($category, 'tenant_family'); ?>>
									<?php esc_html_e('Tenant Family', 'apartment_mgt'); ?>
								</option>
								<option value="care_taker" <?php selected($category, 'care_taker'); ?>>
									<?php esc_html_e('Care Taker', 'apartment_mgt'); ?>
								</option> -->
							</select>
						</div>
						<!-- <div class="occupied_div">
							<div class="form-body user_form">  
								<div class="row"> -->
						<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input occupied_div1">
							<!-- <label class="ml-1 custom-top-label top" for="role_type"><?php esc_html_e('Occupied By', 'apartment_mgt'); ?><span class="require-field">*</span></label> -->
							<select class="form-select validate[required] allready_occupied_new width_100"
								name="occupied_by">
								<option value="">
									<?php esc_html_e('Select Occupied By', 'apartment_mgt'); ?>
								</option>
								<?php
								if ($edit)
									$occupied_by = $result->occupied_by;
								elseif (isset ($_POST['occupied_by']))
									$occupied_by = $_POST['occupied_by'];
								else
									$occupied_by = ""; ?>
								<option value="Owner" <?php selected($occupied_by, 'Owner'); ?>>
									<?php esc_html_e('Owner', 'apartment_mgt'); ?>
								</option>
								<option value="tenant" <?php selected($occupied_by, 'tenant'); ?>>
									<?php esc_html_e('Tenant', 'apartment_mgt'); ?>
								</option>
							</select>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="occupied_date" class="form-control validate[required]" autocomplete="off"
										type="text" name="occupied_date" value="<?php if ($edit) {
											echo esc_attr(date(MJ_amgt_date_formate(), strtotime($result->occupied_date)));
										} elseif (isset ($_POST['occupied_date']))
											echo esc_attr($_POST['occupied_date']);
										else {
											echo date(MJ_amgt_date_formate());
										} ?>">
									<label class="" for="middle_name">
										<?php esc_html_e('Occupied Date', 'apartment_mgt'); ?><span
											class=" require-field">*</span>
									</label>
								</div>
							</div>
						</div>
						<div class="header mb-3">
							<h3 class="first_hed">
								<?php esc_html_e('Member Information', 'apartment_mgt'); ?>
							</h3>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="first_name"
										class="form-control validate[required,custom[onlyLetter_specialcharacter]] text-input"
										maxlength="50" type="text" value="<?php if ($edit) {
											echo esc_attr($result->first_name);
										} elseif (isset ($_POST['first_name']))
											echo esc_attr($_POST['first_name']); ?>" name="first_name">
									<label class="" for="middle_name">
										<?php esc_html_e('First Name', 'apartment_mgt'); ?><span
											class=" require-field">*</span>
									</label>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="middle_name"
										class="form-control validate[custom[onlyLetter_specialcharacter]]" type="text"
										maxlength="50" value="<?php if ($edit) {
											echo esc_attr($result->middle_name);
										} elseif (isset ($_POST['middle_name']))
											echo esc_attr($_POST['middle_name']); ?>" name="middle_name">
									<label class="" for="middle_name">
										<?php esc_html_e('Middle Name', 'apartment_mgt'); ?>
									</label>
								</div>
							</div>
						</div>
						<div class=" col-sm-6 col-md-6 col-lg-6 col-xl-6 avada_margin_bottom_15px">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="last_name"
										class="form-control validate[required,custom[onlyLetter_specialcharacter]] text-input"
										maxlength="50" type="text" value="<?php if ($edit) {
											echo esc_attr($result->last_name);
										} elseif (isset ($_POST['last_name']))
											echo esc_attr($_POST['last_name']); ?>" name="last_name">
									<label class="" for="middle_name">
										<?php esc_html_e('Last Name', 'apartment_mgt'); ?><span
											class=" require-field">*</span>
									</label>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="birth_date" class="form-control validate[required]" autocomplete="off"
										type="text" name="birth_date" value="<?php if ($edit) {
											echo esc_attr($result->birth_date);
										} elseif (isset ($_POST['birth_date']))
											echo esc_attr($_POST['birth_date']);
										else {
											echo date(MJ_amgt_date_formate());
										} ?>">
									<label class="birthdate_label" for="middle_name">
										<?php esc_html_e('Date of Birth', 'apartment_mgt'); ?><span
											class=" require-field">*</span>
									</label>
								</div>
							</div>
						</div>
						<div
							class="col-sm-6 col-md-6 col-lg-6 col-xl-6 res_margin_bottom_20px rtl_margin_top_15px radio_btn_margin_set">
							<div class="form-group">
								<div class="col-md-12 form-control">
									<div class="row padding_radio">
										<div class="input-group">
											<label class="custom-top-label" for="gender">
												<?php esc_html_e('Gender', 'apartment_mgt'); ?><span
													class="require-field">*</span>
											</label>
											<div class="d-inline-block gender_line_height_24px">
												<?php $genderval = "male";
												if ($edit) {
													$genderval = $result->gender;
												} elseif (isset ($_POST['gender'])) {
													$genderval = $_POST['gender'];
												} ?>
												<label class="radio-inline custom_radio">
													<input type="radio" value="male" class="tog" name="gender" <?php checked('male', $genderval); ?> style="margin-bottom: -4px;" />
													<?php esc_html_e('Male', 'apartment_mgt'); ?>
												</label>
												<label class="radio-inline custom_radio">
													<input type="radio" value="female" class="tog" name="gender" <?php checked('female', $genderval); ?> style="margin-bottom: -4px;" />
													<?php esc_html_e('Female', 'apartment_mgt'); ?>
												</label>

											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="email"
										class="amgt_email_id_validation form-control validate[required,custom[email]] text-input"
										maxlength="50" type="text" name="email" value="<?php if ($edit) {
											echo esc_attr($result->user_email);
										} elseif (isset ($_POST['email']))
											echo esc_attr($_POST['email']); ?>">
									<label class="" for="middle_name">
										<?php esc_html_e('Email', 'apartment_mgt'); ?><span class=" require-field">*</span>
									</label>
								</div>
								<div class="email_validation_div">
									<div class="formError"
										style="opacity: 0.87; position: absolute; top: 33px; left: 482.5px; margin-top: 0px; display: block;">
										<div class="formErrorArrow formErrorArrowBottom">
											<div class="line1"><!-- --></div>
											<div class="line2"><!-- --></div>
											<div class="line3"><!-- --></div>
											<div class="line4"><!-- --></div>
											<div class="line5"><!-- --></div>
											<div class="line6"><!-- --></div>
											<div class="line7"><!-- --></div>
											<div class="line8"><!-- --></div>
											<div class="line9"><!-- --></div>
											<div class="line10"><!-- --></div>
										</div>
										<div class="formErrorContent">
											<?php esc_html_e('Email id Already Exist.', 'apartment_mgt'); ?><br>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 avada_margin_bottom_15px">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="password" class="form-control <?php if (!$edit)
										echo 'validate[required]'; ?> password" type="password" minlength="8" maxlength="12" name="password"
										value="">
									<label class="" for="middle_name">
										<?php esc_html_e('Password', 'apartment_mgt'); ?><span
											class="require-field">*</span>
									</label>
								</div>
							</div>
						</div>
						<div class="col-md-6">
							<div class="row">
								<div class="col-md-4 child_theme_padding_left_0">
									<div class="form-group input margin_bottom_0">
										<div class="col-md-12 form-control">
											<input type="text" readonly
												value="+<?php echo esc_attr(MJ_amgt_get_countery_phonecode(get_option('amgt_contry'))); ?>"
												class="form-control" name="phonecode">
											<label for="phonecode" class="pl-2 popup_countery_code_css">
												<?php esc_html_e('Code', 'apartment_mgt'); ?><span
													class="required red">*</span>
											</label>
										</div>
									</div>
								</div>
								<div class="col-md-8 child_theme_padding_right_0">
									<div class="form-group input margin_bottom_0">
										<div class="col-md-12 form-control">
											<input id="mobile" style="height:34px;"
												class="form-control validate[required,custom[phone]] text-input"
												type="number" min="0" onKeyPress="if(this.value.length==15) return false;"
												name="mobile" value="<?php if ($edit) {
													echo esc_attr($result->mobile);
												} elseif (isset ($_POST['mobile']))
													echo esc_attr($_POST['mobile']); ?>">
											<label class="" for="mobile">
												<?php esc_html_e('Mobile Number', 'apartment_mgt'); ?><span
													class=" require-field">*</span>
											</label>
										</div>
									</div>
								</div>
							</div>
						</div>
					
						
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 avada_margin_bottom_15px">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="address" class="form-control" type="text" maxlength="150" name="address"
										value="<?php if ($edit) {
											echo esc_attr($result->address);
										} elseif (isset ($_POST['address']))
											echo esc_attr($_POST['address']); ?>">
									<label class="" for="middle_name">
										<?php esc_html_e('Address', 'apartment_mgt'); ?>
									</label>
								</div>
							</div>
						</div>

						<div class=" col-sm-6 col-md-6 col-lg-6 col-xl-6">
							<div class="form-group input">
								<div class="col-md-12 form-control upload-profile-image-patient">
									<label class="ustom-control-label custom-top-label ml-2" for="photo">
										<?php esc_html_e('Image', 'apartment_mgt'); ?>
									</label>
									<div class="col-sm-12">
										<input type="file" class="form-control file height_45" name="amgt_user_avatar">
									</div>
								</div>
							</div>
						</div>

						<div class="row mb-1"  style="padding :0px;">
							<div class="header col-5 col-md-4">
								<h3 class="first_hed">
									<?php esc_html_e('Family Information', 'apartment_mgt'); ?>
								</h3>
							</div>
							<div class="col-1 col-md-2 symptoms_deopdown_div mb-3 rtl_margin_top_15px">
								<img src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/Add_new_Button.png" ?>"
									id="add_new_family_member" name="add_new_entry" alt="" class="">
							</div>

						</div>
						<div class="form-body user_form"  style="padding :0px;">
							<div class="row"><!--Row Div Strat-->
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="first_name"
												class="form-control validate[custom[onlyLetter_specialcharacter]] text-input"
												maxlength="50" type="text" value="<?php if ($edit) {
													echo esc_attr($result->family_first_name);
												} elseif (isset ($_POST['first_name']))
													echo esc_attr($_POST['first_name']); ?>" name="family_first_name[]">
											<label class="" for="middle_name">
												<?php esc_html_e('First Name', 'apartment_mgt'); ?><span
													class=" require-field"></span>
											</label>
										</div>
									</div>
								</div>
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="last_name"
												class="form-control validate[custom[onlyLetter_specialcharacter]] text-input"
												maxlength="50" type="text" value="<?php if ($edit) {
													echo esc_attr($result->family_last_name);
												} elseif (isset ($_POST['last_name']))
													echo esc_attr($_POST['last_name']); ?>" name="family_last_name[]">
											<label class="" for="middle_name">
												<?php esc_html_e('Last Name', 'apartment_mgt'); ?><span
													class=" require-field"></span>
											</label>
										</div>
									</div>
								</div>
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="family_birth_date" class="form-control label_overlp"
												autocomplete="off" type="text" name="family_birth_date[]" value="<?php if ($edit) {
													echo esc_attr(date("Y-m-d", strtotime($result->birth_date)));
												} elseif (isset ($_POST['birth_date']))
													echo esc_attr($_POST['birth_date']); ?>" readonly>
											<label class="birthdate_label active" id="my_label_add" for="middle_name">
												<?php esc_html_e('Date of Birth', 'apartment_mgt'); ?><span
													class="require-field"></span>
											</label>
										</div>
									</div>
								</div>
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 res_margin_bottom_20px rtl_margin_top_15px">
									<div class="form-group">
										<div class="col-md-12 form-control">
											<div class="row padding_radio">
												<div class="input-group">
													<label class="custom-top-label" for="gender">
														<?php esc_html_e('Gender', 'apartment_mgt'); ?><span
															class="require-field"></span>
													</label>
													<div class="d-inline-block gender_line_height_24px">
														<?php $genderval = "male";
														if ($edit) {
															$genderval = $result->gender;
														} elseif (isset ($_POST['gender'])) {
															$genderval = $_POST['gender'];
														} ?>
														<label class="radio-inline custom_radio admin_radio">
															<input type="radio" value="male" class="tog"
																name="family_gender_0" <?php checked('male', $genderval); ?> />
															<?php esc_html_e('Male', 'apartment_mgt'); ?>
														</label>
														<label class="radio-inline custom_radio admin_radio">
															<input type="radio" value="female" class="tog"
																name="family_gender_0" <?php checked('female', $genderval); ?> />
															<?php esc_html_e('Female', 'apartment_mgt'); ?>
														</label>

													</div>
												</div>
											</div>
										</div>
									</div>
								</div>

							</div>
							<div class="row">
								<div class="col-md-6">
									<div class="row">
										<div class="col-md-4" style="padding :0px;">
											<div class="form-group input margin_bottom_0">
												<div class="col-md-12 form-control">
													<input type="text" readonly
														value="+<?php echo MJ_amgt_get_countery_phonecode(get_option('amgt_contry')); ?>"
														class="form-control" name="phonecode">
													<label for="family_phonecode" class="pl-2
																popup_countery_code_css">
														<?php esc_html_e('Code', 'apartment_mgt'); ?><span
															class="required red"></span>
													</label>
												</div>
											</div>
										</div>
										<div class="col-md-8 child_theme_padding_right_0">
											<div class="form-group input margin_bottom_0">
												<div class="col-md-12 form-control">
													<input id="family_mobile" style="height:34px;"
														class="form-control validate[custom[phone]] text-input"
														type="number" min="0"
														onKeyPress="if(this.value.length==15) return false;"
														name="family_mobile[]" value="<?php if ($edit) {
															echo esc_attr($result->mobile);
														} elseif (isset ($_POST['mobile']))
															echo esc_attr($_POST['mobile']); ?>">
													<label class="" for="family_mobile">
														<?php esc_html_e('Mobile Number', 'apartment_mgt'); ?><span
															class=" require-field"></span>
													</label>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
									<label class="ml-1 custom-top-label top" for="role_type">
										<?php esc_html_e('Family Type', 'apartment_mgt'); ?><span
											class="require-field"></span>
									</label>
									<select class="form-select" name="family_type[]" id="family_type">
										<option value="">
											<?php esc_html_e('Select Family Type', 'apartment_mgt'); ?>
										</option>
										<?php
										if ($edit) {
											$category = $result->member_type;
										} elseif (isset ($_POST['member_type'])) {
											$category = $_POST['member_type'];
										} else {
											$category = "";
										} ?>
										<option value="owner_family" <?php selected($category, 'owner_family'); ?>>
											<?php esc_html_e('Owner Family', 'apartment_mgt'); ?>
										</option>
										<option value="tenant_family" <?php selected($category, 'tenant_family'); ?>>
											<?php esc_html_e('Tenant Family', 'apartment_mgt'); ?>
										</option>
										<option value="care_taker" <?php selected($category, 'care_taker'); ?>>
											<?php esc_html_e('Care Taker', 'apartment_mgt'); ?>
										</option>
									</select>
								</div>

							</div>
						</div>
						<div id="family_member_entry"></div>
					</div>
				</div>
				<div class="form-body user_form"> <!-- user_form Strat-->
					<div class="row"><!--Row Div Strat-->
						<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 float_left">
							<input type="submit" value="<?php esc_html_e('Member Registration', 'apartment_mgt'); ?>"
								name="registration_front_member" class="save_btn btn btn-success" />
						</div>
					</div>
				</div>
			</form>
		</div>
		<?php
}
function MJ_amgt_registration_validation($building_id, $unit_cat_id, $unit_name, $member_type, $first_name, $last_name, $gender, $birth_date, $mobile, $email, $password)
{
	global $reg_errors;
	$reg_errors = new WP_Error;
	if (empty ($building_id) || empty ($unit_cat_id) || empty ($unit_name) || empty ($member_type) || empty ($first_name) || empty ($last_name) || empty ($birth_date) || empty ($email) || empty ($password)) {
		$reg_errors->add('field', 'Required form field is missing');
	}

	if (!is_email($email)) {
		$reg_errors->add('email_invalid', 'Email is not valid');
	}
	if (email_exists($email)) {
		$reg_errors->add('email', 'Email Already in use');
	}

	if (is_wp_error($reg_errors)) {

		foreach ($reg_errors->get_error_messages() as $error) {
			echo '<div class="student_reg_error">';
			echo '<strong>ERROR</strong> : ';
			echo '<span class="error"> ' . esc_html__($error, "apartment_mgt") . ' </span><br/>';
			echo '</div>';
		}
	}
}
add_shortcode('amgt_faq_list', 'MJ_amgt_faq_list_page');
add_action('init', 'MJ_amgt_install_faq_page');
add_shortcode('amgt_society_rules', 'MJ_amgt_society_rules_page');
add_action('init', 'MJ_amgt_install_society_rules_page');
add_shortcode('photogallaryCode', 'MJ_amgt_photo_gallary_page');

add_shortcode('amgt_login', 'MJ_amgt_login_form');
add_action('init', 'MJ_amgt_install_login_page');
add_action('init', 'MJ_amgt_output_ob_start');
add_action('init', 'MJ_amgt_install_member_registration_page');
add_shortcode('amgt_member_registration', 'MJ_amgt_member_registration_shortcode');
function MJ_amgt_output_ob_start()
{
	ob_start();
}
//GET FAQ LIST FUNCTION //
function MJ_amgt_faq_list_page()
{
	?>
		<link rel="stylesheet" href="<?php echo AMS_PLUGIN_URL . '/assets/css/bootstrap/bootstrap.min.css'; ?>">
		<link rel="stylesheet" href="<?php echo AMS_PLUGIN_URL . '/assets/css/custom.css'; ?>">
		<script type="text/javascript"
			src=" <?php echo AMS_PLUGIN_URL . '/assets/js/bootstrap/bootstrap.min.js'; ?>"></script>
		<?php
		$args = array('post_type' => 'amgt_FAQ', 'post_status' => 'publish');
		$faq_array = get_posts($args);
		$current_theme = wp_get_theme();
		if ($current_theme == 'Twenty Twenty-Two') {
			?>
			<style>
				.FAQ_main_div {
					position: absolute;
					top: 40%;
					margin: 0 15%;
					width: 70%;
				}

				.wp-block-site-title a {
					display: none;
				}

				.has-text-align-right {
					display: none;
				}

				.wp-block-spacer {
					display: none;
				}

				.wp-block-group .alignwide {
					padding-bottom: 0 !important;
					padding-top: 0 !important;
				}

				.wp-site-blocks .wp-block-group .wp-block-post-title {
					margin-bottom: 0 !important;
				}
			</style>
			<?php
		}
		if ($current_theme == 'Twenty Twenty-One') {
			?>
			<style>
				.site-header {
					padding-top: 0 !important;
					padding-bottom: 0 !important;
				}

				button:not(:hover):not(:active):not(.has-background) {
					background-color:
						<?php echo get_option('amgt_system_color_code'); ?>
						!important;
				}

				header.entry-header.alignwide {
					margin-bottom: 0;
				}
			</style>
			<?php
		}
		if ($current_theme == 'Divi') {
			?>
			<style>
				.panel-heading .accordion-header {
					padding-bottom: 0 !important;
				}
			</style>
			<?php
		}
		if ($current_theme == 'Twenty Twenty') {
			?>
			<style>
				.entry-content h4 {
					margin: 0 !important;
				}

				.singular .entry-header {
					padding: 0 !important;
				}

				.post-inner {
					padding: 0 !important;
				}

				.panel-heading h4 button {
					font-size: 16px !important;
				}

				.entry-content>*:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.is-style-wide) {
					max-width: 80rem !important;
				}
			</style>
			<?php
		}
		?>
		<style>
			.admin_dashboard .accordion-button:focus {
				border-color:
					<?php echo get_option('amgt_system_color_code'); ?>
					!important;
			}

			.admin_dashboard .accordion-button {
				background-color:
					<?php echo get_option('amgt_system_color_code'); ?>
				;
				color: #fff;
			}

			.admin_dashboard .accordion-button:not(.collapsed) {
				background-color:
					<?php echo get_option('amgt_system_color_code'); ?>
				;
				color: #fff;
			}

			.collapse {
				display: block;
			}

			.FAQ_main_div h3 {
				margin-top: 0 !important;
				margin-bottom: 0 !important;
				color: #fff;
				font-weight: 400;
				background:
					<?php echo get_option('amgt_system_color_code'); ?>
				;
				padding: 10px;
			}
		</style>
		<div class="FAQ_main_div panel-body padding_0 admin_dashboard society_rules_again"><!-- PANEL WHITE DIV -->
			<div class="tab-content padding_0"><!-- TAB CONTENT DIV -->
				<?php

				if (!empty ($faq_array)) {
					?>
					<div class="panel-body padding_0 main_email_template"><!--PANEL BODY-->
						<div class="panel-group accordion" id="accordionExample">
							<?php
							$i = 0;

							foreach ($faq_array as $faq) {
								$i++;
								?>
								<div class="accordion-item panel panel-default"> <!---PANEL-DEFAULT--->
						<div class="panel-heading">
							<h4 class="accordion-header panel-title" id="headingone">
								<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
									data-bs-target="#collapse<?php echo $i; ?>" aria-expanded="false"
									aria-controls="collapse<?php echo $i; ?>">
									<?php echo esc_html($faq->post_title); ?>
								</button>
							</h4>
						</div>
						<div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse"
							aria-labelledby="headingOne" data-bs-parent="#accordionExample">
							<div class="accordion-body panel-body">
								<?php echo $faq->post_content; //POST_CONTENT                 ?>
							</div>
						</div>
					</div>
					<?php
							}
							?>
				</div>
			</div><!--END PANEL BODY-->
					<?php
				}

				?>
			</div><!-- END TAB CONTENT DIV -->
		</div><!-- END PANEL WHITE DIV -->
		<?php
}
//INSTAL FAQ PAGE FUNCTION
function MJ_amgt_install_faq_page()
{


	if (!get_option('amgt_faq_page')) {
		$curr_page = array(
			'post_title' => esc_html__('Apartment FAQ Page', 'apartment_mgt'),
			'post_content' => '[amgt_faq_list]',
			'post_status' => 'publish',
			'post_type' => 'page',
			'comment_status' => 'closed',
			'ping_status' => 'closed',
			'post_category' => array(1),
			'post_parent' => 0
		);

		$curr_created = wp_insert_post($curr_page);
		update_option('amgt_faq_page', $curr_created);
	}
}
//INSTALL Society RULES FUNCTION //
function MJ_amgt_install_society_rules_page()
{
	if (!get_option('amgt_rules_page')) {

		$curr_page = array(
			'post_title' => esc_html__('Apartment Society Rules', 'apartment_mgt'),
			'post_content' => '[amgt_society_rules]',
			'post_status' => 'publish',
			'post_type' => 'page',
			'comment_status' => 'closed',
			'ping_status' => 'closed',
			'post_category' => array(1),
			'post_parent' => 0
		);

		$curr_created = wp_insert_post($curr_page);
		update_option('amgt_rules_page', $curr_created);

	}
}

//GET SOCITY RULES PAGE FUNCTION //
function MJ_amgt_society_rules_page()
{
	?>
		<link rel="stylesheet" href="<?php echo AMS_PLUGIN_URL . '/assets/css/bootstrap/bootstrap.min.css'; ?>">
		<link rel="stylesheet" href="<?php echo AMS_PLUGIN_URL . '/assets/css/custom.css'; ?>">
		<script type="text/javascript"
			src="<?php echo AMS_PLUGIN_URL . '/assets/js/bootstrap/bootstrap.min.js'; ?>"></script>
		<?php
		$args = array('post_type' => 'amgt_society_rules', 'post_status' => 'publish');
		$rules_array = get_posts($args);
		$current_theme = wp_get_theme();

		if ($current_theme == 'Twenty Twenty-Two') {
			?>
			<style>
				.society_rule_main_div {
					position: absolute;
					top: 40%;
					margin: 0 15%;
					width: 70%;
				}

				.wp-block-site-title a {
					display: none;
				}

				.has-text-align-right {
					display: none;
				}

				.wp-block-spacer {
					display: none;
				}

				.wp-block-group .alignwide {
					padding-bottom: 0 !important;
					padding-top: 0 !important;
				}

				.wp-site-blocks .wp-block-group .wp-block-post-title {
					margin-bottom: 0 !important;
				}
			</style>
			<?php
		}
		if ($current_theme == 'Twenty Twenty-One') {
			?>
			<style>
				.site-header {
					padding-top: 0 !important;
					padding-bottom: 0 !important;
				}

				button:not(:hover):not(:active):not(.has-background) {
					background-color:
						<?php echo get_option('amgt_system_color_code'); ?>
						!important;
				}

				header.entry-header.alignwide {
					margin-bottom: 0;
				}
			</style>
			<?php
		}
		if ($current_theme == 'Divi') {
			?>
			<style>
				.panel-heading .accordion-header {
					padding-bottom: 0 !important;
				}
			</style>
			<?php
		}
		if ($current_theme == 'Twenty Twenty') {
			?>
			<style>
				.singular .entry-header {
					padding: 0 !important;
				}

				.post-inner {
					padding: 0 !important;
				}

				.panel-heading h4 button {
					font-size: 16px !important;
				}

				.entry-content>*:not(.alignwide):not(.alignfull):not(.alignleft):not(.alignright):not(.is-style-wide) {
					max-width: 80rem !important;
				}
			</style>
			<?php
		}
		?>
		<style>
			.admin_dashboard .accordion-button:focus {
				border-color: #104B73 !important;
			}

			.admin_dashboard .accordion-button {
				background-color: #104B73;
				color: #fff;
			}

			.admin_dashboard .accordion-button:not(.collapsed) {
				background-color: #104B73;
				color: #fff;
			}

			.collapse {
				display: block;
			}

			.society_rule_main_div h4 {
				margin-top: 0 !important;
				margin-bottom: 0 !important;
				color: #fff;
				font-weight: 400;
				background: #104B73;

			}
		</style>
		<div class="society_rule_main_div panel-body padding_0 admin_dashboard society_rules_again"><!--PANEL WHITE-->
			<div class="tab-content padding_0">
				<!--RULE LIST TAB-->
				<?php
				if (!empty ($rules_array)) {
					?>
					<div class="panel-body padding_0 main_email_template"><!--PANEL BODY DIV-->
						<div class="panel-group accordion" id="accordionExample"><!--PANEL GROUP DIV-->
							<?php
							$i = 0;

							foreach ($rules_array as $faq) {
								$i++; ?>
								<div class="accordion-item panel panel-default">
									<div class="panel-heading"><!--PANEL HEADING DIV-->
										<h4 class="accordion-header panel-title" id="headingone">
											<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
												data-bs-target="#collapse<?php echo esc_attr($i); ?>" aria-expanded="false"
												aria-controls="collapse<?php echo esc_attr($i); ?>">
												<?php echo esc_html($faq->post_title); ?>
											</button>
										</h4>
									</div>
									<div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse"
										aria-labelledby="headingOne" data-bs-parent="#accordionExample">
										<div class="accordion-body panel-body"><!--END PANEL BODY DIV-->
											<?php echo $faq->post_content; ?>

										</div><!--END PANEL BODY DIV-->
									</div>
								</div>
							<?php } ?>
						</div><!--END PANEL GROUP DIV-->
					</div><!--END PANEL BODY DIV-->
					<?php
				}
				?>
			</div>
		</div>

		<?php
}
//INSTALL GALLARY PAGE FUNCTION//
function MJ_amgt_install_gallary_page()
{
	if (!get_option('amgt_gallary_page')) {

		$curr_page = array(
			'post_title' => esc_html__('Apartment Gallery', 'apartment_mgt'),
			'post_content' => '[amgt_photo_gallary]',
			'post_status' => 'publish',
			'post_type' => 'page',
			'comment_status' => 'closed',
			'ping_status' => 'closed',
			'post_category' => array(1),
			'post_parent' => 0
		);


		$curr_created = wp_insert_post($curr_page);
		update_option('	', $curr_created);

	}
}

function MJ_amgt_photo_gallary_page($atts)
{
	?>
		<style>
			.fancybox.col-md-4.amgt-gallary-images {
				border-bottom: 0 none !important;
			}
		</style>
		<script>
			jQuery(document).ready(function ($) {
				$('a.fancybox').fancybox();
				/* Apply fancybox to multiple items */
			});
		</script>
		<?php if (!empty ($atts)) {
			$atts = shortcode_atts(
				array(
					'id' => $atts['id']
				),
				$atts,
				'photogallaryCode'
			);
			$gallary = get_post($atts['id']);
			?>
			<ol>
				<div class="col-md-10">
					<h4>
						<?php //echo $gallary->post_title;                ?>
					</h4>
					<p>
						<?php $gallary_photos = get_post_meta(intval($gallary->ID), 'amgtfld_gallery', true); ?>
						<?php array_pop($gallary_photos['image_url']); ?>
						<?php $i = 0;
						foreach ($gallary_photos['image_url'] as $photo_url) { ?>

							<a href="<?php echo $photo_url; ?>" class="fancybox col-md-4 amgt-gallary-images" rel="group_1">
								<img src="<?php echo $photo_url; ?>">
							</a>
							<?php
							$i += 1;
						} ?>
					</p>

				</div>
			</ol>
			<?php
		} else {
			$args = array('post_type' => 'amgt_photo_gallary', 'post_status' => 'publish');
			$gallary_array = get_posts($args);
			?>
			<ol>
				<?php foreach ($gallary_array as $gallary) { ?>
					<div class="col-sm-10">
						<li>
							<h4>
								<?php echo esc_html($gallary->post_title); ?>
							</h4>
							<p>
								<?php $gallary_photos = get_post_meta(intval($gallary->ID), 'amgtfld_gallery', true);

								?>
							<table>
								<tr>
									<?php
									foreach ($gallary_photos['image_url'] as $photo_url) { ?>
										<td><img src="<?php echo $photo_url; ?>"></td>
									<?php } ?>
								</tr>
							</table>
							</p>
						</li>

					</div>
					<?php
				} ?>

			</ol>
			<?php
		}
}
add_action('init', 'MJ_amgt_session_manager');
function MJ_amgt_session_manager()
{
	if (!session_id()) {
		session_start();
		if (!isset ($_SESSION['amgt_verify'])) {
			$_SESSION['amgt_verify'] = '';
		}
	}
	session_write_close();
}

function amgt_logout()
{
	if (isset ($_SESSION['amgt_verify'])) {
		unset($_SESSION['amgt_verify']);
	}
}
add_action('wp_logout', 'amgt_logout');
add_action('init', 'amgt_setup'); 
function amgt_setup()
{

	$is_cmgt_pluginpage = amgt_is_amgtpage();
	$is_verify = false;
	if (!isset ($_SESSION['amgt_verify']))
		$_SESSION['amgt_verify'] = '';
	$server_name = $_SERVER['SERVER_NAME'];
	$is_localserver = amgt_chekserver($server_name);
	if ($is_localserver) {
		return true;
	}
	if ($is_cmgt_pluginpage) {
		if ($_SESSION['amgt_verify'] == '') {
			if (get_option('licence_key') && get_option('amgt_setup_email')) {
				$domain_name = $_SERVER['SERVER_NAME'];
				$licence_key = get_option('licence_key');
				$email = get_option('amgt_setup_email');
				$result = amgt_check_productkey($domain_name, $licence_key, $email);
				$is_server_running = amgt_check_ourserver();
				if ($is_server_running)
					$_SESSION['amgt_verify'] = $result;
				else
					$_SESSION['amgt_verify'] = '0';
				$is_verify = amgt_check_verify_or_not($result);
			}
		}
	}
	$is_verify = amgt_check_verify_or_not($_SESSION['amgt_verify']);
	if ($is_cmgt_pluginpage)
		if (!$is_verify) {
			$_SESSION['amgt_verify'] == '';
			if ($_REQUEST['page'] != 'amgt-amgt_setup')
				wp_redirect(admin_url() . 'admin.php?page=amgt-amgt_setup');
		}
}
//-------------- UNIT CATEGORY POST -------------------//
function MJ_amgt_install_unit_category_post()
{
	global $wpdb;
	$post_office = $wpdb->get_var($wpdb->prepare("SELECT count(post_title) FROM $wpdb->posts WHERE post_title LIKE %s AND post_type LIKE %s", '%office%', 'unit_category'));
	if ($post_office == '0') {
		$result = wp_insert_post(
			array(

				'post_status' => 'publish',

				'post_type' => 'unit_category',

				'post_title' => 'Office'
			)
		);
	}
	$post_residential = $wpdb->get_var($wpdb->prepare("SELECT count(post_title) FROM $wpdb->posts WHERE post_title LIKE %s AND post_type LIKE %s", '%residential%', 'unit_category'));
	if ($post_residential == '0') {
		$result = wp_insert_post(
			array(

				'post_status' => 'publish',

				'post_type' => 'unit_category',

				'post_title' => 'Residential'
			)
		);
	}
	$post_unit_member = $wpdb->get_var($wpdb->prepare("SELECT count(post_title) FROM $wpdb->posts WHERE post_title LIKE %s AND post_type LIKE %s", '%Owner%', 'member_category'));
	if ($post_unit_member == '0') {
		$result = wp_insert_post(
			array(

				'post_status' => 'publish',

				'post_type' => 'member_category',

				'post_title' => 'Owner'
			)
		);
	}
	$post_member = $wpdb->get_var($wpdb->prepare("SELECT count(post_title) FROM $wpdb->posts WHERE post_title LIKE %s AND post_type LIKE %s", '%Tenant%', 'member_category'));
	if ($post_member == '0') {
		$result = wp_insert_post(
			array(

				'post_status' => 'publish',

				'post_type' => 'member_category',

				'post_title' => 'Tenant'
			)
		);
	}


}

//Inatall Table FUNCTION 
function MJ_amgt_install_tables()
{
	require_once (ABSPATH . 'wp-admin/includes/upgrade.php');
	global $wpdb;
	$table_amgt_assets = $wpdb->prefix . 'amgt_assets';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_assets . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `assets_no` varchar(100) NOT NULL,
				  `assets_name` varchar(100) NOT NULL,
				  `vender_name` varchar(100) NOT NULL,
				  `assets_cat_id` int(11) NOT NULL,
				  `location` varchar(255) NOT NULL,
				  `purchage_date` date NOT NULL,
				  `assets_cost` varchar(20) NOT NULL,
				  `status` varchar(20) NOT NULL,
				  `created_by` int(11) NOT NULL,
				  `created_date` date NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";

	$wpdb->query($sql);

	$table_amgt_charges_payments = $wpdb->prefix . 'amgt_charges_payments';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_charges_payments . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `recuring_charges_id` int(11) NOT NULL,
				  `building_id` int(11) NOT NULL,
				  `unit_cat_id` int(11) NOT NULL,
				  `unit_name` varchar(100) NOT NULL,
				  `member_id` int(11) NOT NULL,
				  `charges_type_id` int(11) NOT NULL,
				  `charges_payment` text NOT NULL,
				  `description` text NOT NULL,
				  `discount_amount` varchar(10) NOT NULL,
				  `amount` varchar(10) NOT NULL,
				  `tax_amount` varchar(10) NOT NULL,
				  `total_amount` varchar(10) NOT NULL,
				  `created_date` date NOT NULL,
				  `created_by` int(11) NOT NULL,
				  `chargis_status` varchar(20),
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);


	$amgt_recuring_charges_payments = $wpdb->prefix . 'amgt_recuring_charges_payments';
	$sql = "CREATE TABLE IF NOT EXISTS " . $amgt_recuring_charges_payments . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `building_id` int(11) NOT NULL,
				  `unit_cat_id` int(11) NOT NULL,
				  `unit_name` varchar(100) NOT NULL,
				  `member_id` int(11) NOT NULL,
				  `invoice_options` varchar(100) NOT NULL,
				  `charges_type_id` int(11) NOT NULL,
				  `charges_payment` text NOT NULL,
				  `description` text NOT NULL,
				  `amount` varchar(10) NOT NULL,
				  `discount_amount` varchar(10) NOT NULL,
				  `tax_amount` varchar(10) NOT NULL,
				  `total_amount` varchar(10) NOT NULL,
				  `amgt_charge_period` varchar(10) NOT NULL,
				  `start_date` date NOT NULL,
				  `end_date` date NOT NULL,
				  `created_date` date NOT NULL,
				  `created_by` int(11) NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_checkin_entry = $wpdb->prefix . 'amgt_checkin_entry';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_checkin_entry . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `gate_id` int(11) NOT NULL,
				  `exit_gate_id` int(11) NOT NULL,
				  `checkin_type` varchar(50) NOT NULL,
				  `visitor_name` varchar(255) NOT NULL,
				  `member_id` int(11) NOT NULL,
				  `badge_id` varchar(100) NOT NULL,
				  `mobile` int(11) NOT NULL,
				  `vehicle_number` varchar(100) NOT NULL,
				  `reason_id` int(11) NOT NULL,
				  `building_id` int(11) NOT NULL,
				  `unit_cat` int(11) NOT NULL,
				  `unit_name` varchar(50) NOT NULL,
				  `checkin_date` date NOT NULL,
				  `checkin_time` varchar(50) NOT NULL,
				  `checkout_time` varchar(100) NOT NULL,
				  `description` text NOT NULL,
				  `created_by` int(11) NOT NULL,
				  `created_date` date NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);




	$table_amgt_complaints = $wpdb->prefix . 'amgt_complaints';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_complaints . " (
				 `id` int(11) NOT NULL AUTO_INCREMENT,
				  `complaint_nature` varchar(50) NOT NULL,
				  `complaint_member_id` int(11) NOT NULL,
				  `complaint_type` varchar(50) NOT NULL,
				  `complaint_cat` varchar(50) NOT NULL,
				  `complaint_status` varchar(50) NOT NULL,
				  `complaint_description` text NOT NULL,
				  `time` varchar(50),
				  `resolution` text NOT NULL,
				  `created_date` date NOT NULL,
				  `created_by` int(11) NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_created_invoice_list = $wpdb->prefix . 'amgt_created_invoice_list';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_created_invoice_list . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `charges_id` int(11) NOT NULL,				  
				  `member_id` int(11) NOT NULL,
				  `invoice_no` varchar(10) NOT NULL,
				  `charges_type_id` int(11) NOT NULL,				  
				  `description` text NOT NULL,
				  `discount_amount` varchar(10) NOT NULL,
				  `amount` varchar(10) NOT NULL,
				  `tax_amount` varchar(10) NOT NULL,
				  `total_amount` varchar(10) NOT NULL,
				  `due_amount` varchar(10) NOT NULL,
				  `paid_amount` varchar(10) NOT NULL,
				  `payment_status` varchar(10) NOT NULL,				 
				  `amgt_charge_period` varchar(10) NOT NULL,
				  `charges_payment` text NOT NULL,
				  `start_date` date NOT NULL,
				  `end_date` date NOT NULL,
				  `created_date` date NOT NULL,
				  `created_by` int(11) NOT NULL,
				  `status` varchar(20) NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_invoice_payment_history = $wpdb->prefix . 'amgt_invoice_payment_history';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_invoice_payment_history . " (
				 `id` int(11) NOT NULL AUTO_INCREMENT,		
				 `invoice_id` int(11),	
				  `member_id` int(11) NOT NULL,
				  `date` date,	
				 `amount` double,				 
				 `payment_method` varchar(255),
				  PRIMARY KEY (`id`)
				)DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_document = $wpdb->prefix . 'amgt_document';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_document . " (
				 `id` int(11) NOT NULL AUTO_INCREMENT,
				  `doc_title` varchar(255) NOT NULL,
				  `building_id` int(11) NOT NULL,
				  `unit_cat_id` int(11) NOT NULL,
				  `unit_name` varchar(100) NOT NULL,
				  `member_id` int(11) NOT NULL,
				  `document_content` varchar(255) NOT NULL,
				  `visibility` varchar(100) NOT NULL,
				  `description` text NOT NULL,
				  `created_by` int(11) NOT NULL,
				  `created_date` date NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_events = $wpdb->prefix . 'amgt_events';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_events . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `event_title` varchar(100) NOT NULL,
				  `description` text NOT NULL,
				  `start_date` date NOT NULL,
				  `start_time` varchar(100) NOT NULL,
				  `end_date` date NOT NULL,
				  `end_time` varchar(100) NOT NULL,
				  `visibility` varchar(100) NOT NULL,
				  `event_doc` varchar(255) NOT NULL,
				  `publish_status` varchar(20) NOT NULL,
				  `created_by` int(11) NOT NULL,
				  `created_date` date NOT NULL,				  
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_facility = $wpdb->prefix . 'amgt_facility';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_facility . " (
				 `facility_id` bigint(20) NOT NULL AUTO_INCREMENT,
				  `facility_name` varchar(500) NOT NULL,
				  `facility_charge` double NOT NULL,
				  `charge_per` varchar(20) NOT NULL,
				  `allow_booking_multiple_base` int(11) NOT NULL,
				  `created_date` datetime NOT NULL,
				  `created_by` bigint(20) NOT NULL,
				  PRIMARY KEY (`facility_id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_facility_booking = $wpdb->prefix . 'amgt_facility_booking';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_facility_booking . " (
				 `id` int(11) NOT NULL AUTO_INCREMENT,
				  `facility_id` int(11) NOT NULL,
				  `activity_id` int(11) NOT NULL,
				  `period_type` varchar(20) NOT NULL,
				  `start_date` date NOT NULL,
				  `end_date` date NOT NULL,
				  `start_time` varchar(20) NOT NULL,
				  `end_time` varchar(20) NOT NULL,
				  `booking_cost` varchar(20) NOT NULL,
				  `book_on_behalf_of` varchar(255) NOT NULL,
				  `status` int(11) NOT NULL,
				  `created_by` int(11) NOT NULL,
				  `created_date` date NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);
	$table_amgt_gates = $wpdb->prefix . 'amgt_gates';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_gates . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `gate_name` varchar(100) NOT NULL,
				  `for_entry` varchar(50) DEFAULT NULL,
				  `for_exit` varchar(50) DEFAULT NULL,
				  `created_date` date NOT NULL,
				  `created_by` int(11) NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);


	$table_amgt_generat_invoice = $wpdb->prefix . 'amgt_generat_invoice';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_generat_invoice . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `building_id` int(11) NOT NULL,
				  `unit_cat_id` int(11) NOT NULL,
				  `unit_name` varchar(100) NOT NULL,
				  `member_id` int(11) NOT NULL,
				  `invoice_options` varchar(100) NOT NULL,
				  `charges_type_id` int(11) NOT NULL,
				  `charges_calculate_by` text NOT NULL,
				  `charges_payment` text NOT NULL,
				  `description` text NOT NULL,
				  `amount` varchar(10) NOT NULL,
				  `discount_amount` varchar(10) NOT NULL,
				  `tax_amount` varchar(10) NOT NULL,
				  `total_amount` varchar(10) NOT NULL,
				  `amgt_charge_period` varchar(10) NOT NULL,				 
				  `delete_status` varchar(10) NOT NULL,				 
				  `created_date` date NOT NULL,
				  `invoice_start_date` date NOT NULL,
				  `invoice_end_date` date NOT NULL,
				  `created_by` int(11) NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);


	$table_amgt_income_expense = $wpdb->prefix . 'amgt_income_expense';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_income_expense . " (
				 `id` int(11) NOT NULL AUTO_INCREMENT,
				  `type` varchar(10) NOT NULL,
				  `type_id` int(11) NOT NULL,
				  `bill_date` date NOT NULL,
				  `payment_date` date NOT NULL,
				  `amount` varchar(10) NOT NULL,
				  `vender_name` varchar(255) NOT NULL,
				  `invoice_id` int(11) NOT NULL,
				  `member_id` int(11) NOT NULL,
				  `description` text NOT NULL,
				  `created_date` date NOT NULL,
				  `created_by` int(11) NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_inventory = $wpdb->prefix . 'amgt_inventory';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_inventory . " (
				 `id` int(11) NOT NULL AUTO_INCREMENT,
				  `inventory_name` varchar(100) NOT NULL,
				  `inventory_unit_cat` int(11) NOT NULL,
				  `quentity` varchar(20) NOT NULL,
				  `created_date` date NOT NULL,
				  `created_by` int(11) NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_message = $wpdb->prefix . 'amgt_message';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_message . " (
				 `message_id` int(11) NOT NULL AUTO_INCREMENT,
				  `sender` int(11) NOT NULL,
				  `receiver` int(11) NOT NULL,
				  `msg_date` datetime NOT NULL,
				  `msg_subject` varchar(150) NOT NULL,
				  `message_body` text NOT NULL,
				  `post_id` int(11) NOT NULL,
				  `msg_status` int(11) NOT NULL,
				  PRIMARY KEY (`message_id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_message_replies = $wpdb->prefix . 'amgt_message_replies';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_message_replies . " (
				 `id` int(11) NOT NULL AUTO_INCREMENT,
				  `message_id` int(11) NOT NULL,
				  `sender_id` int(11) NOT NULL,
				  `receiver_id` int(11) NOT NULL,
				  `message_comment` text NOT NULL,
				  `created_date` datetime NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_notice = $wpdb->prefix . 'amgt_notice';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_notice . " (
				 `id` int(11) NOT NULL AUTO_INCREMENT,
				  `notice_title` varchar(255) NOT NULL,
				  `notice_type` varchar(50) NOT NULL,
				  `notice_doc` varchar(255) NOT NULL,
				  `description` text NOT NULL,
				  `valid_date` date NOT NULL,
				  `status` varchar(50) NOT NULL,
				  `created_by` int(11) NOT NULL,
				  `created_date` date NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_parking = $wpdb->prefix . 'amgt_parking';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_parking . " (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				  `sloat_id` int(11) NOT NULL,
				  `vehicle_number` varchar(100) NOT NULL,
				  `vehicle_model` varchar(100) NOT NULL,
				  `RFID` varchar(100) NOT NULL,
				  `vehicle_type` int(11) NOT NULL,
				  `building_id` int(11) NOT NULL,
				  `unit_cat_id` int(11) NOT NULL,
				  `unit_name` varchar(100) NOT NULL,
				  `member_id` int(11) NOT NULL,
				  `from_date` date NOT NULL,
				  `to_date` date NOT NULL,
				  `status` varchar(20) NOT NULL,
				  `description` text NOT NULL,
				  `created_date` date NOT NULL,
				  `created_by` int(11) NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_residential_units = $wpdb->prefix . 'amgt_residential_units';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_residential_units . " (
				 `id` int(11) NOT NULL AUTO_INCREMENT,
				  `building_id` int(11) NOT NULL,
				  `unit_cat_id` int(11) NOT NULL,				  
				  `units` text NOT NULL,
				  `created_date` date NOT NULL,
				  `created_by` int(11) NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_serivce = $wpdb->prefix . 'amgt_serivce';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_serivce . " (
				 `service_id` bigint(20) NOT NULL AUTO_INCREMENT,
				  `service_name` varchar(500) NOT NULL,
				  `service_provider` varchar(500) NOT NULL,
				  `contact_number` varchar(50) NOT NULL,
				  `mobile_number` varchar(50) NOT NULL,
				  `email` varchar(200) NOT NULL,
				  `address` text NOT NULL,
				  `created_date` datetime NOT NULL,
				  `created_by` bigint(20) NOT NULL,
				  `status` int(11) NOT NULL,
				  PRIMARY KEY (`service_id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_sloats = $wpdb->prefix . 'amgt_sloats';

	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_sloats . " (
				`id` int(11) NOT NULL AUTO_INCREMENT,
			  `sloat_name` varchar(100) NOT NULL,
			  `sloat_type` varchar(20) NOT NULL,
			  `comment` text NOT NULL,
			  `created_date` date NOT NULL,
			  `created_by` int(11) NOT NULL,
			  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";

	$wpdb->query($sql);


	$table_amgt_taxes = $wpdb->prefix . 'amgt_taxes';

	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_taxes . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `tax_title` varchar(255) NOT NULL,
				  `tax` int(11) NOT NULL,
				  `created_at` int(11) NOT NULL,
				  `is_deleted` int(11) NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";

	$wpdb->query($sql);

	$table_amgt_invoice_tax = $wpdb->prefix . 'amgt_invoice_tax';

	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_invoice_tax . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `invoice_id` int(11) NOT NULL,
				  `member_id` int(11) NOT NULL,
				  `tax_id` int(11) NOT NULL,
				  `tax` float NOT NULL,
				  `tax_amount` double NOT NULL,
				  `created_by` int(11) NOT NULL,
				  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";

	$wpdb->query($sql);


	$table_amgt_building_cat = $wpdb->prefix . 'amgt_building_cat';

	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_building_cat . " (
			  `id` int(11) NOT NULL AUTO_INCREMENT,
			  `building_id` int(11) NOT NULL,
			  `building_cat_id` int(11) NOT NULL,
			  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
			  `created_by` int(11) NOT NULL,
			  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";

	$wpdb->query($sql);


	$table_maintenance_settings = $wpdb->prefix . 'maintenance_settings';
	$sql = "CREATE TABLE IF NOT EXISTS " . $table_maintenance_settings . " (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				  `building_id` int(11) NOT NULL,
				  `maintenance_title` varchar(100) NOT NULL,
				  `maintenance_charges` varchar(100) NOT NULL,
				  `maintenance_charge_period` varchar(100) NOT NULL,
				  `created_date` date NOT NULL,
				  `created_by` int(11) NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_maintence_tax = $wpdb->prefix . 'amgt_maintence_tax';

	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_maintence_tax . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `maintence_setings_id` int(11) NOT NULL,
				  `building_id` int(11) NOT NULL,
				  `tax_id` int(11) NOT NULL,
				  `tax` float NOT NULL,
				  `created_by` int(11) NOT NULL,
				  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";

	$wpdb->query($sql);

	$table_amgt_unit_occupied_history = $wpdb->prefix . 'amgt_unit_occupied_history';

	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_unit_occupied_history . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `building_id` int(11) NOT NULL,
				  `unit_cat_id` int(11) NOT NULL,
				  `unit_name` varchar(50) NOT NULL,
				  `member_name` varchar(50) NOT NULL,
				  `member_contact_details` varchar(255) NOT NULL,
				  `occupied_from_date` date NOT NULL,
				  `occupied_to_date` date,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";

	$wpdb->query($sql);

	$table_amgt_invoice_penalty_charges = $wpdb->prefix . 'amgt_invoice_penalty_charges';

	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_invoice_penalty_charges . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `invoice_id` int(11) NOT NULL,
				  `member_id` int(11) NOT NULL,
				  `penalty_charge` varchar(50) NOT NULL,
				  `end_date` date NOT NULL,
				  `created_date` date NOT NULL,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";

	$wpdb->query($sql);

	$table_amgt_tenant_unit_occupied_history = $wpdb->prefix . 'amgt_tenant_unit_occupied_history';

	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_tenant_unit_occupied_history . " (
				  `id` int(11) NOT NULL AUTO_INCREMENT,
				  `building_id` int(11) NOT NULL,
				  `unit_cat_id` int(11) NOT NULL,
				  `unit_name` varchar(50) NOT NULL,
				  `member_id` int(11) NOT NULL,
				  `member_name` varchar(50) NOT NULL,
				  `member_contact_details` varchar(255) NOT NULL,
				  `occupied_from_date` date NOT NULL,
				  `occupied_to_date` date,
				  PRIMARY KEY (`id`)
				) DEFAULT CHARSET=utf8";

	$wpdb->query($sql);
	$table_amgt_user_log = $wpdb->prefix . 'amgt_user_log'; //register transport table

	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_user_log . " (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`user_login` text NOT NULL,
				`role` text NOT NULL,
				`ip_address` text NOT NULL,
				`created_at` date NOT NULL,
				`date_time` datetime NOT NULL,
				`deleted_status` boolean NOT NULL,
				PRIMARY KEY (`id`)
		) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$table_amgt_audit_log = $wpdb->prefix . 'amgt_audit_log'; //register transport table

	$sql = "CREATE TABLE IF NOT EXISTS " . $table_amgt_audit_log . " (
				`id` int(11) NOT NULL AUTO_INCREMENT,
				`audit_action` text NOT NULL,
				`user_id` int(11) NULL,
				`action` text NOT NULL,
				`module` text NOT NULL,
				`ip_address` text NOT NULL,
				`created_by` int(11) NOT NULL,
				`created_at` date NOT NULL,
				`date_time` datetime NOT NULL,
				`deleted_status` boolean NOT NULL,
				`updated_by` 	int(11) NULL,
				`updated_date` datetime NULL,
				PRIMARY KEY (`id`)
		) DEFAULT CHARSET=utf8";
	$wpdb->query($sql);

	$amgt_building_cat = $wpdb->get_results("SELECT *from $table_amgt_building_cat");
	if (empty ($amgt_building_cat)) {
		$table_postmeta = $wpdb->prefix . 'postmeta';
		$unit_catdatalist = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_postmeta WHERE meta_key = %s", 'related_building_id'));
		if (!empty ($unit_catdatalist)) {
			foreach ($unit_catdatalist as $retrieve_data) {
				$created_by = get_current_user_id();

				$success = $wpdb->insert(
					$table_amgt_building_cat,
					array(
						'building_id' => $retrieve_data->meta_value,
						'building_cat_id' => $retrieve_data->post_id,
						'created_by' => $created_by
					)
				);
			}
		}
	}
	$table_amgt_events = $wpdb->prefix . 'amgt_events';
	$entery_event_to = 'event_to';
	if (!in_array($entery_event_to, $wpdb->get_col("DESC " . $table_amgt_events, 0))) {
		$result = $wpdb->query($wpdb->prepare("ALTER TABLE $table_amgt_events  ADD   $entery_event_to  text")
		);
	}
	$table_amgt_notice = $wpdb->prefix . 'amgt_notice';
	$entery_notice_to = 'notice_to';
	if (!in_array($entery_notice_to, $wpdb->get_col("DESC " . $table_amgt_notice, 0))) {
		$result = $wpdb->query($wpdb->prepare("ALTER TABLE $table_amgt_notice  ADD   $entery_notice_to  text")
		);
	}
	
	$table_amgt_checkin_entry = $wpdb->prefix . 'amgt_checkin_entry';

	$sql = "ALTER TABLE " . $table_amgt_checkin_entry . " CHANGE `mobile` `mobile` VARCHAR(20) NOT NULL";
	$wpdb->query($sql);

	//aded new filed in add visitor//
	$visiters_value = 'visiters_value';
	if (!in_array($visiters_value, $wpdb->get_col("DESC " . $table_amgt_checkin_entry, 0))) {
		$result = $wpdb->query($wpdb->prepare("ALTER TABLE $table_amgt_checkin_entry  ADD   $visiters_value  text")
		);
	}
	
	$entery_status = 'status';
	if (!in_array($entery_status, $wpdb->get_col("DESC " . $table_amgt_checkin_entry, 0))) {
		$result = $wpdb->query($wpdb->prepare("ALTER TABLE $table_amgt_checkin_entry  ADD   $entery_status  int(11)")
		);
	}
	//end//
	$table_amgt_created_invoice_list = $wpdb->prefix . 'amgt_created_invoice_list';
	$sql = "ALTER TABLE " . $table_amgt_created_invoice_list . " CHANGE `payment_status` `payment_status` VARCHAR(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL";
	$wpdb->query($sql);
	$table_amgt_invoice_payment_history = $wpdb->prefix . 'amgt_invoice_payment_history';
	$description_history = 'description';
	if (!in_array($description_history, $wpdb->get_col("DESC " . $table_amgt_invoice_payment_history, 0))) {
		$result = $wpdb->query(
			"ALTER TABLE $table_amgt_invoice_payment_history  ADD   $description_history  text"
		);
	}
	$table_amgt_invoice_payment_history = $wpdb->prefix . 'amgt_invoice_payment_history';
	$payment_by = 'payment_by';
	if (!in_array($payment_by, $wpdb->get_col("DESC " . $table_amgt_invoice_payment_history, 0))) {
		$result = $wpdb->query(
			"ALTER TABLE $table_amgt_invoice_payment_history  ADD   $payment_by  int(11)"
		);
	}

	$table_amgt_created_invoice_list = $wpdb->prefix . 'amgt_created_invoice_list';
	$transaction_id =sanitize_text_field('transaction_id');
	$charges_id = sanitize_text_field('charges_id');
	$payment_method = sanitize_text_field('payment_method');

	$charges_type_id = sanitize_text_field('charges_type_id');
	$description = sanitize_text_field('description');
	$discount_amount = sanitize_text_field('discount_amount');
	$amount = sanitize_text_field('amount');
	$tax_amount = sanitize_text_field('tax_amount');
	$total_amount = sanitize_text_field('total_amount');
	$due_amount = sanitize_text_field('due_amount');
	$amgt_charge_period = sanitize_text_field('amgt_charge_period');
	$charges_payment = 'charges_payment';
	$start_date = sanitize_text_field('start_date');
	$end_date = sanitize_text_field('end_date');

	if (!in_array($charges_type_id, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query($wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $charges_type_id  int(11)")
		);
	}

	if (!in_array($description, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $description   text")
		);
	}

	if (!in_array($discount_amount, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $discount_amount   varchar(10)")
		);
	}

	if (!in_array($amount, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $amount   varchar(10)")
		);
	}

	if (!in_array($tax_amount, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $tax_amount   varchar(10)")
		);
	}

	if (!in_array($total_amount, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $total_amount  varchar(10)")
		);
	}

	if (!in_array($due_amount, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $due_amount   varchar(10)")
		);
	}

	if (!in_array($amgt_charge_period, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $amgt_charge_period   varchar(10)")
		);
	}

	if (!in_array($charges_payment, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $charges_payment text")
		);
	}

	if (!in_array($start_date, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $start_date   date")
		);
	}

	if (!in_array($end_date, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $end_date  date")
		);
	}


	if (!in_array($transaction_id, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $transaction_id   varchar(255)")
		);
	}

	if (!in_array($payment_method, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $payment_method   varchar(255)")
		);
	}

	if (!in_array($charges_id, $wpdb->get_col("DESC " . $table_amgt_created_invoice_list, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_created_invoice_list  ADD   $charges_id   int(11)")
		);
	}

	//add fild inganrate invoice_amount
	$table_amgt_generat_invoice = $wpdb->prefix . 'amgt_generat_invoice';
	$tax_amount = 'tax_amount';
	$total_amount = 'total_amount';
	$tax = 'tax';
	$member_id = 'member_id';
	$invoice_options = 'invoice_options';
	$charges_type_id = 'charges_type_id';
	$charges_calculate_by = 'charges_calculate_by';
	$charges_payment = 'charges_payment';
	$discount_amount = 'discount_amount';
	$amgt_charge_period = 'amgt_charge_period';
	$delete_status = 'delete_status';
	$invoice_start_date = 'invoice_start_date';
	$invoice_end_date = 'invoice_end_date';

	if (!in_array($invoice_start_date, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $invoice_start_date   date")
		);
	}

	if (!in_array($invoice_end_date, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $invoice_end_date   date")
		);
	}

	if (!in_array($delete_status, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $delete_status   varchar(10)")
		);
	}

	if (!in_array($amgt_charge_period, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $amgt_charge_period   varchar(10)")
		);
	}

	if (!in_array($discount_amount, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $discount_amount  varchar(10)")
		);
	}

	if (!in_array($member_id, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $member_id   int(11)")
		);
	}

	if (!in_array($invoice_options, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $invoice_options   varchar(100)")
		);
	}

	if (!in_array($charges_type_id, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $charges_type_id   int(11)")
		);
	}

	if (!in_array($charges_calculate_by, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $charges_calculate_by   text")
		);
	}

	if (!in_array($charges_payment, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $charges_payment   text")
		);
	}

	if (!in_array($tax_amount, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $tax_amount   float(6)")
		);
	}

	if (!in_array($total_amount, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $total_amount   float(6)")
		);
	}

	if (!in_array($tax, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_generat_invoice  ADD   $tax   varchar(255)")
		);
	}

	$start_date_one_charge = 'start_date_one_charge';
	if (!in_array($start_date_one_charge, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER   TABLE $table_amgt_generat_invoice  ADD   $start_date_one_charge   date")
		);
	}

	$end_date_one_charge = 'end_date_one_charge';
	if (!in_array($end_date_one_charge, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER   TABLE $table_amgt_generat_invoice  ADD   $end_date_one_charge   date")
		);
	}

	$one_time_recurring_option = 'one_time_recurring_option';
	if (!in_array($one_time_recurring_option, $wpdb->get_col("DESC " . $table_amgt_generat_invoice, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER   TABLE $table_amgt_generat_invoice ADD $one_time_recurring_option tinyint(4) DEFAULT 0 ")
		);
	}



	$complaint_member_id_field = 'complaint_member_id';
	$table_amgt_complaints = $wpdb->prefix . 'amgt_complaints';
	if (!in_array($complaint_member_id_field, $wpdb->get_col("DESC " . $table_amgt_complaints, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_complaints  ADD   $complaint_member_id_field   int(11)")
		);
	}

	$complaint_time = 'time';

	if (!in_array($complaint_time, $wpdb->get_col("DESC " . $table_amgt_complaints, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_complaints  ADD   $complaint_time   varchar(50)")
		);
	}

	$complain_date = 'complain_date';
	if (!in_array($complain_date, $wpdb->get_col("DESC " . $table_amgt_complaints, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_complaints  ADD   $complain_date  date NOT NULL")
		);
	}
	$resolution = 'resolution';
	if (!in_array($resolution, $wpdb->get_col("DESC " . $table_amgt_complaints, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_complaints  ADD   $resolution  text NOT NULL")
		);
	}

	$complain_doc = 'complain_doc';
	if (!in_array($complain_doc, $wpdb->get_col("DESC " . $table_amgt_complaints, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_complaints  ADD   $complain_doc  varchar(500) NULL")
		);
	}

	$unit_name = 'unit_name';
	$table_amgt_charges_payments = $wpdb->prefix . 'amgt_charges_payments';
	if (!in_array($unit_name, $wpdb->get_col("DESC " . $table_amgt_charges_payments, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_charges_payments  ADD   $unit_name  varchar(100)")
		);
	}

	$recuring_charges_id = 'recuring_charges_id';
	if (!in_array($recuring_charges_id, $wpdb->get_col("DESC " . $table_amgt_charges_payments, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_charges_payments  ADD   $recuring_charges_id  int(11)")
		);
	}

	$member_id = 'member_id';
	$table_amgt_invoice_tax = $wpdb->prefix . 'amgt_invoice_tax';
	if (!in_array($member_id, $wpdb->get_col("DESC " . $table_amgt_invoice_tax, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_invoice_tax  ADD   $member_id   int(11)")
		);
	}

	$complain_title = 'complain_title';
	$table_amgt_complain = $wpdb->prefix . 'amgt_complaints';
	if (!in_array($complain_title, $wpdb->get_col("DESC " . $table_amgt_complain, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_complain  ADD   $complain_title   varchar(255)")
		);
	}

	$gst_no = 'gst_no';
	$table_amgt_gst = $wpdb->prefix . 'amgt_unit_occupied_history';
	if (!in_array($gst_no, $wpdb->get_col("DESC " . $table_amgt_gst, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_gst  ADD   $gst_no   varchar(255)")
		);
	}


	$table_amgt_events = $wpdb->prefix . 'amgt_events';
	$event_doc = 'event_doc';

	if (!in_array($event_doc, $wpdb->get_col("DESC " . $table_amgt_events, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_events  ADD   $event_doc  varchar(255)")
		);
	}


	$facility_status = 'status';
	if (!in_array($facility_status, $wpdb->get_col("DESC " . $table_amgt_facility_booking, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_facility_booking  ADD   $facility_status  int(11)")
		);
	}

	$tbl_amgt_message_replies = $wpdb->prefix . 'amgt_message_replies';
	$status_msg = 'msg_status';
	if (!in_array($status_msg, $wpdb->get_col("DESC " . $tbl_amgt_message_replies, 0))) {
		$result = $wpdb->query($wpdb->prepare("ALTER TABLE $tbl_amgt_message_replies  ADD   $status_msg   tinyint(4) NOT NULL"));
	}

	$table_amgt_document = $wpdb->prefix . 'amgt_document';
	$category_id = 'category_id';
	if (!in_array($category_id, $wpdb->get_col("DESC " . $table_amgt_document, 0))) {
		$result = $wpdb->query($wpdb->prepare("ALTER TABLE $table_amgt_document  ADD   $category_id  varchar(100)"));
	}

	$table_amgt_serivce = $wpdb->prefix . 'amgt_serivce';
	$contact_name = 'contact_name';
	if (!in_array($contact_name, $wpdb->get_col("DESC " . $table_amgt_serivce, 0))) {
		$result = $wpdb->query($wpdb->prepare("ALTER TABLE $table_amgt_serivce  ADD   $contact_name  varchar(100)"));
	}

	//----------------------  NOTICE ALTER QUERY ---------------------//
	$table_amgt_notice = $wpdb->prefix . 'amgt_notice';
	$notice_start_date = 'start_date';

	if (!in_array($notice_start_date, $wpdb->get_col("DESC " . $table_amgt_notice, 0))) {
		$result = $wpdb->query($wpdb->prepare("ALTER TABLE $table_amgt_notice  ADD   $notice_start_date  date"));
	}
}

//---------create cronjob  FUNCTION code----------------
add_filter('cron_schedules', 'MJ_amgt_minute_remainder');
function MJ_amgt_minute_remainder($schedules)
{
	$schedules['every_minute'] = array(
		'interval' => 60,
		'display' => esc_html__('Every minute', 'textdomain')
	);
	return $schedules;
}
if (!wp_next_scheduled('MJ_amgt_minute_remainder')) {
	wp_schedule_event(time(), 'every_minute', 'MJ_amgt_minute_remainder');
}
add_action('MJ_amgt_minute_remainder', 'MJ_amgt_member_charges_invoice_regenerate');
//add_action( 'init', 'MJ_amgt_member_charges_invoice_regenerate' );
function MJ_amgt_member_charges_invoice_regenerate()
{
	set_time_limit(0);
	$chargis_option = get_option('apartment_enable_chargis');
	$result = "";
	if ($chargis_option == 'yes') {
		$obj_accounts = new MJ_amgt_Accounts;
		$current = strtotime(date('Y-m-d'));
		$time_minus_1day = $current - (3600 * 24);
		$curent_1day_minus = date("Y-m-d", $time_minus_1day);

		$one_time = $obj_accounts->MJ_amgt_get_chargis_one_time('0', $curent_1day_minus);
		$monthaly = $obj_accounts->MJ_amgt_get_chargis_monthaly('1', $curent_1day_minus);
		$quarterly = $obj_accounts->MJ_amgt_get_chargis_quarterly('3', $curent_1day_minus);
		$yearly = $obj_accounts->MJ_amgt_get_chargis_yearly('12', $curent_1day_minus);

		// REGENGENERATE CHARGIS INVOICE FOR ONE TIME//
		if (!empty ($one_time)) {

			//$invoice_generate_date=array();
			foreach ($one_time as $recuring_chargis_data) {

				global $wpdb;
				$amgt_amgt_created_invoice_list = $wpdb->prefix . 'amgt_created_invoice_list';
				$amgt_generat_invoice = $wpdb->prefix . 'amgt_generat_invoice';
				$amgt_amgt_invoice_tax = $wpdb->prefix . 'amgt_invoice_tax';
				$obj_account = new MJ_amgt_Accounts;

				if ($recuring_chargis_data->invoice_options == 'all_member') {
					$member_data = MJ_amgt_get_all_member_data();
				} elseif ($recuring_chargis_data->invoice_options == 'Building') {
					$building_id = $recuring_chargis_data->building_id;

					$member_data = MJ_amgt_get_all_member_data_by_building_id($building_id);
				} elseif ($recuring_chargis_data->invoice_options == 'Unit Category') {
					$building_id = $recuring_chargis_data->building_id;
					$unit_id = $recuring_chargis_data->unit_cat_id;

					$member_data = MJ_amgt_get_all_member_data_by_building_unit_id($building_id, $unit_id);
				} elseif ($recuring_chargis_data->invoice_options == 'one_member') {
					$member_data = array();
					$member_id_by_unit_name = MJ_amgt_get_member_id_by_unit_name($recuring_chargis_data->unit_name);
					$member_data[] = $member_id_by_unit_name;
				}

				if (!empty ($member_data)) {

					foreach ($member_data as $retrieved_data) {

						$invoice_data['charges_id'] = sanitize_text_field($recuring_chargis_data->id);
						$result_invoice_no = $wpdb->get_results("SELECT * FROM $amgt_amgt_created_invoice_list");

						if (empty ($result_invoice_no)) {
							$invoice_no = '00001';
						} else {
							$result_no = $wpdb->get_row($wpdb->prepare("SELECT invoice_no FROM $amgt_amgt_created_invoice_list WHERE id = (SELECT MAX(id) FROM $amgt_amgt_created_invoice_list)"));

							$last_invoice_number = sanitize_text_field($result_no->invoice_no);

							$invoice_length = strlen($result_no->invoice_no);
							if ($invoice_length == '9') {
								$invoice_no = '00001';
							} else {
								$invoice_no = str_pad($last_invoice_number + 1, 5, 0, STR_PAD_LEFT);
							}
						}
						if ($recuring_chargis_data->invoice_options == 'one_member') {
							$invoice_data['member_id'] = sanitize_text_field($retrieved_data);
						} else {
							$invoice_data['member_id'] = sanitize_text_field($retrieved_data->ID);
						}

						$invoice_data['charges_type_id'] = sanitize_text_field($recuring_chargis_data->charges_type_id);
						$invoice_data['invoice_no'] = sanitize_text_field($invoice_no);
						$invoice_data['description'] = sanitize_text_field($recuring_chargis_data->description);
						$invoice_data['discount_amount'] = sanitize_text_field($recuring_chargis_data->discount_amount);
						$invoice_data['charges_payment'] = sanitize_text_field($recuring_chargis_data->charges_payment);
						$invoice_data['paid_amount'] = 0;
						$invoice_data['payment_status'] = 'Unpaid';
						$invoice_data['created_date'] = date('Y-m-d');
						$invoice_data['amgt_charge_period'] = sanitize_text_field($recuring_chargis_data->amgt_charge_period);
						$start_date = date('Y-m-d');
						$invoice_data['start_date'] = $start_date;
						$add_month_to_date = date('Y-m-d', strtotime("+1 months", strtotime($start_date)));
						$end_date = date('Y-m-d', strtotime("-1 days", strtotime($add_month_to_date)));

						if ($recuring_chargis_data->end_date_one_charge <= $end_date) {
							$invoice_data['end_date'] = sanitize_text_field($recuring_chargis_data->end_date_one_charge);
						} else {
							$invoice_data['end_date'] = sanitize_text_field($end_date);
						}


						if ($recuring_chargis_data->charges_calculate_by == 'fix_charge') {
							$invoice_data['amount'] = sanitize_text_field($recuring_chargis_data->amount);
							$invoice_data['tax_amount'] = sanitize_text_field($recuring_chargis_data->tax_amount);
							$invoice_data['total_amount'] = sanitize_text_field($recuring_chargis_data->total_amount);
							$invoice_data['due_amount'] = sanitize_text_field($recuring_chargis_data->total_amount);
						} elseif ($recuring_chargis_data->charges_calculate_by == 'measurement_charge') {

							$income_amount = json_decode($recuring_chargis_data->charges_payment);
							$amount = 0;
							$member_id = $invoice_data['member_id'];
							$unit = MJ_amgt_get_single_member_unit_size(intval($member_id));

							foreach ($income_amount as $retrieved_data) {
								$amount = $retrieved_data->amount * $unit;
							}

							$amount_after_discount = $amount - $recuring_chargis_data->discount_amount;
							$id_invoice = intval($recuring_chargis_data->id);
							$tax_entry = $wpdb->get_results($wpdb->prepare("SELECT tax FROM $amgt_amgt_invoice_tax WHERE invoice_id = %d", $id_invoice));
							$tax_amount = 0;
							foreach ($tax_entry as $tax_data) {
								$tax_amount += $amount_after_discount / 100 * $tax_data->tax;
							}
							$total_amount = (int) $amount_after_discount + (int) $tax_amount;
							$invoice_data['amount'] = sanitize_text_field($amount_after_discount);
							$invoice_data['tax_amount'] = sanitize_text_field($tax_amount);
							$invoice_data['total_amount'] = sanitize_text_field($total_amount);
							$invoice_data['due_amount'] = sanitize_text_field($total_amount);
						}


						//Check All ready Generated//
						$check_allready_generated = $obj_accounts->MJ_amgt_member_invoice_allready_generated
						($invoice_data['member_id'], date('Y-m-d'), $end_date);

						if ($check_allready_generated == '0') {
							$result = $wpdb->insert($amgt_amgt_created_invoice_list, $invoice_data);

							global $wpdb;
							$user_invoiceid = $wpdb->insert_id;
							//---------Notification send mail code---------------------
							$payment_link = '<a href=' . home_url() . '?apartment-dashboard=user&page=accounts>Payment</a>';
							$retrieved_data = get_userdata($invoice_data['member_id']);
							$to = array();
							$to[] = sanitize_email($retrieved_data->user_email);
							$subject = get_option('wp_amgt_generate_invoice_subject');
							$apartmentname = get_option('amgt_system_name');
							$subject_search = array('{{apartment_name}}');
							$subject_replace = array($apartmentname);
							$subject = str_replace($subject_search, $subject_replace, $subject);
							$message_content = get_option('wp_amgt_generate_invoice_email_template');
							$search = array('{{member_name}}', '{{apartment_name}}', '{{Payment Link}}');
							$replace = array($retrieved_data->display_name, $apartmentname, $payment_link);
							$message_content = str_replace($search, $replace, $message_content);

							$enable_notofication = get_option('apartment_enable_notifications');
							if ($enable_notofication == 'yes') {
								MJ_amgt_send_invoice_generate_mail($to, $subject, $message_content, $user_invoiceid);
							}

						}
						
						// ================= SEND PUSH NOTIFICATION==========================
			
						$send_data['type']="new_invoice";
						$send_data['invoice_no']=$user_invoiceid;
						$send_push_notification = MJ_amgt_send_push_notification($invoice_data['member_id'],$send_data);
					}
				}

				if ($result) {
					//insert start and end date
					$whereid['id'] = $recuring_chargis_data->id;
					$invoice_generate_date['invoice_start_date'] = date('Y-m-d');
					$invoice_generate_date['invoice_end_date'] = sanitize_text_field($end_date);
					$result_update_generate_date = $wpdb->update($amgt_generat_invoice, $invoice_generate_date, $whereid);
				}
			}
		}
		// REGENGENERATE CHARGIS INVOICE FOR MONTHALY//
		if (!empty ($monthaly)) {
			//$invoice_generate_date=array();
			foreach ($monthaly as $recuring_chargis_data) {
				global $wpdb;
				$amgt_amgt_created_invoice_list = $wpdb->prefix . 'amgt_created_invoice_list';
				$amgt_generat_invoice = $wpdb->prefix . 'amgt_generat_invoice';
				$amgt_amgt_invoice_tax = $wpdb->prefix . 'amgt_invoice_tax';
				$obj_account = new MJ_amgt_Accounts;

				if ($recuring_chargis_data->invoice_options == 'all_member') {
					$member_data = MJ_amgt_get_all_member_data();
				} elseif ($recuring_chargis_data->invoice_options == 'Building') {
					$building_id = intval($recuring_chargis_data->building_id);

					$member_data = MJ_amgt_get_all_member_data_by_building_id($building_id);
				} elseif ($recuring_chargis_data->invoice_options == 'Unit Category') {
					$building_id = intval($recuring_chargis_data->building_id);
					$unit_id = intval($recuring_chargis_data->unit_cat_id);

					$member_data = MJ_amgt_get_all_member_data_by_building_unit_id($building_id, $unit_id);
				} elseif ($recuring_chargis_data->invoice_options == 'one_member') {
					$member_data = array();
					$member_id_by_unit_name = MJ_amgt_get_member_id_by_unit_name($recuring_chargis_data->unit_name);
					$member_data[] = $member_id_by_unit_name;
				}

				if (!empty ($member_data)) {

					foreach ($member_data as $retrieved_data) {
						$invoice_data['charges_id'] = intval($recuring_chargis_data->id);
						$result_invoice_no = $wpdb->get_results("SELECT * FROM $amgt_amgt_created_invoice_list");

						if (empty ($result_invoice_no)) {
							$invoice_no = '00001';
						} else {
							$result_no = $wpdb->get_row($wpdb->prepare("SELECT invoice_no FROM $amgt_amgt_created_invoice_list WHERE id = (SELECT MAX(id) FROM $amgt_amgt_created_invoice_list)"));

							$last_invoice_number = $result_no->invoice_no;

							$invoice_length = strlen($result_no->invoice_no);
							if ($invoice_length == '9') {
								$invoice_no = '00001';
							} else {
								$invoice_no = str_pad($last_invoice_number + 1, 5, 0, STR_PAD_LEFT);
							}
						}
						if ($recuring_chargis_data->invoice_options == 'one_member') {
							$invoice_data['member_id'] = sanitize_text_field($retrieved_data);
						} else {
							$invoice_data['member_id'] = sanitize_text_field($retrieved_data->ID);
						}

						$invoice_data['charges_type_id'] = sanitize_text_field($recuring_chargis_data->charges_type_id);
						$invoice_data['invoice_no'] = sanitize_text_field($invoice_no);
						$invoice_data['description'] = sanitize_text_field($recuring_chargis_data->description);
						$invoice_data['discount_amount'] = sanitize_text_field($recuring_chargis_data->discount_amount);
						$invoice_data['charges_payment'] = sanitize_text_field($recuring_chargis_data->charges_payment);
						$invoice_data['paid_amount'] = 0;
						$invoice_data['payment_status'] = 'Unpaid';
						$invoice_data['created_date'] = date('Y-m-d');
						$invoice_data['amgt_charge_period'] = sanitize_text_field($recuring_chargis_data->amgt_charge_period);
						$start_date = date('Y-m-d');
						$invoice_data['start_date'] = $start_date;
						$add_month_to_date = date('Y-m-d', strtotime("+1 months", strtotime($start_date)));
						$end_date = date('Y-m-d', strtotime("-1 days", strtotime($add_month_to_date)));
						$invoice_data['end_date'] = $end_date;
						if ($recuring_chargis_data->charges_calculate_by == 'fix_charge') {
							$invoice_data['amount'] = sanitize_text_field($recuring_chargis_data->amount);
							$invoice_data['tax_amount'] = sanitize_text_field($recuring_chargis_data->tax_amount);
							$invoice_data['total_amount'] = sanitize_text_field($recuring_chargis_data->total_amount);
							$invoice_data['due_amount'] = sanitize_text_field($recuring_chargis_data->total_amount);
						} elseif ($recuring_chargis_data->charges_calculate_by == 'measurement_charge') {

							$income_amount = json_decode($recuring_chargis_data->charges_payment);
							$amount = 0;
							$member_id = $invoice_data['member_id'];
							$unit = MJ_amgt_get_single_member_unit_size($member_id);

							foreach ($income_amount as $retrieved_data) {
								$amount = $retrieved_data->amount * $unit;
							}

							$amount_after_discount = $amount - $recuring_chargis_data->discount_amount;
							$id_invoice = $recuring_chargis_data->id;
							$tax_entry = $wpdb->get_results($wpdb->prepare("SELECT tax FROM $amgt_amgt_invoice_tax WHERE invoice_id = %d", $id_invoice));

							$tax_amount = 0;

							foreach ($tax_entry as $tax_data) {
								$tax_amount += $amount_after_discount / 100 * $tax_data->tax;
							}
							$total_amount = $amount_after_discount + $tax_amount;
							$invoice_data['amount'] = sanitize_text_field($amount_after_discount);
							$invoice_data['tax_amount'] = sanitize_text_field($tax_amount);
							$invoice_data['total_amount'] = sanitize_text_field($total_amount);
							$invoice_data['due_amount'] = sanitize_text_field($total_amount);
						}

						//Check All ready Generated//
						$check_allready_generated = $obj_accounts->MJ_amgt_member_invoice_allready_generated($invoice_data['member_id'], date('Y-m-d'), $end_date);

						if ($check_allready_generated == '0') {
							$result = $wpdb->insert($amgt_amgt_created_invoice_list, $invoice_data);

							global $wpdb;
							$user_invoiceid = $wpdb->insert_id;
							//---------Notification send mail code---------------------
							$payment_link = '<a href=' . home_url() . '?apartment-dashboard=user&page=accounts>Payment</a>';
							$retrieved_data = get_userdata($invoice_data['member_id']);
							$to = sanitize_email($retrieved_data->user_email);
							$subject = get_option('wp_amgt_generate_invoice_subject');
							$apartmentname = get_option('amgt_system_name');
							$subject_search = array('{{apartment_name}}');
							$subject_replace = array($apartmentname);
							$subject = str_replace($subject_search, $subject_replace, $subject);
							$message_content = get_option('wp_amgt_generate_invoice_email_template');
							$search = array('{{member_name}}', '{{apartment_name}}', '{{Payment Link}}');
							$replace = array($retrieved_data->display_name, $apartmentname, $payment_link);
							$message_content = str_replace($search, $replace, $message_content);

							$enable_notofication = get_option('apartment_enable_notifications');
							if ($enable_notofication == 'yes') {
								MJ_amgt_send_invoice_generate_mail($to, $subject, $message_content, $user_invoiceid);
							}

						}
						// ================= SEND PUSH NOTIFICATION==========================
			
						$send_data['type']="new_invoice";
						$send_data['invoice_no']=$user_invoiceid;
						$send_push_notification = MJ_amgt_send_push_notification($invoice_data['member_id'],$send_data);
					}
				}

				if ($result) {
					//insert start and end date
					$whereid['id'] = $recuring_chargis_data->id;
					$invoice_generate_date['invoice_start_date'] = date('Y-m-d');
					$invoice_generate_date['invoice_end_date'] = $end_date;
					$result_update_generate_date = $wpdb->update($amgt_generat_invoice, $invoice_generate_date, $whereid);
				}
			}
		}
		// REGENGENERATE CHARGIS INVOICE FOR QUARTERLY
		if (!empty ($quarterly)) {
			foreach ($quarterly as $recuring_chargis_data) {
				global $wpdb;
				$amgt_amgt_created_invoice_list = $wpdb->prefix . 'amgt_created_invoice_list';
				$amgt_generat_invoice = $wpdb->prefix . 'amgt_generat_invoice';
				$amgt_amgt_invoice_tax = $wpdb->prefix . 'amgt_invoice_tax';
				$obj_account = new MJ_amgt_Accounts;

				if ($recuring_chargis_data->invoice_options == 'all_member') {
					$member_data = MJ_amgt_get_all_member_data();
				} elseif ($recuring_chargis_data->invoice_options == 'Building') {
					$building_id = $recuring_chargis_data->building_id;

					$member_data = MJ_amgt_get_all_member_data_by_building_id($building_id);
				} elseif ($recuring_chargis_data->invoice_options == 'Unit Category') {
					$building_id = $recuring_chargis_data->building_id;
					$unit_id = $recuring_chargis_data->unit_cat_id;

					$member_data = MJ_amgt_get_all_member_data_by_building_unit_id($building_id, $unit_id);
				} elseif ($recuring_chargis_data->invoice_options == 'one_member') {
					$member_data = array();
					$member_id_by_unit_name = MJ_amgt_get_member_id_by_unit_name($recuring_chargis_data->unit_name);
					$member_data[] = $member_id_by_unit_name;
				}

				if (!empty ($member_data)) {
					//require AMS_PLUGIN_DIR. '/lib/mpdf/mpdf.php';
					foreach ($member_data as $retrieved_data) {
						$invoice_data['charges_id'] = $recuring_chargis_data->id;
						$result_invoice_no = $wpdb->get_results($wpdb->prepare("SELECT * FROM %s", $amgt_amgt_created_invoice_list));

						if (empty ($result_invoice_no)) {
							$invoice_no = '00001';
						} else {
							$result_no = $wpdb->get_row($wpdb->prepare("SELECT invoice_no FROM $amgt_amgt_created_invoice_list WHERE id = (SELECT MAX(id) FROM $amgt_amgt_created_invoice_list)"));

							$last_invoice_number = $result_no->invoice_no;

							$invoice_length = strlen($result_no->invoice_no);
							if ($invoice_length == '9') {
								$invoice_no = '00001';
							} else {
								$invoice_no = str_pad($last_invoice_number + 1, 5, 0, STR_PAD_LEFT);
							}
						}

						if ($recuring_chargis_data->invoice_options == 'one_member') {
							$invoice_data['member_id'] = sanitize_text_field($retrieved_data);
						} else {
							$invoice_data['member_id'] = sanitize_text_field($retrieved_data->ID);
						}

						$invoice_data['charges_type_id'] = sanitize_text_field($recuring_chargis_data->charges_type_id);
						$invoice_data['invoice_no'] = sanitize_text_field($invoice_no);
						$invoice_data['description'] = sanitize_text_field($recuring_chargis_data->description);
						$invoice_data['discount_amount'] = sanitize_text_field($recuring_chargis_data->discount_amount);
						$invoice_data['charges_payment'] = sanitize_text_field($recuring_chargis_data->charges_payment);
						$invoice_data['paid_amount'] = 0;
						$invoice_data['payment_status'] = 'Unpaid';
						$invoice_data['created_date'] = date('Y-m-d');
						$invoice_data['amgt_charge_period'] = sanitize_text_field($recuring_chargis_data->amgt_charge_period);

						$start_date = date('Y-m-d');
						$invoice_data['start_date'] = sanitize_text_field($start_date);
						$add_month_to_date = date('Y-m-d', strtotime("+3 months", strtotime($start_date)));
						$end_date = date('Y-m-d', strtotime("-1 days", strtotime($add_month_to_date)));
						$invoice_data['end_date'] = sanitize_text_field($end_date);

						if ($recuring_chargis_data->charges_calculate_by == 'fix_charge') {
							$invoice_data['amount'] = sanitize_text_field($recuring_chargis_data->amount);
							$invoice_data['tax_amount'] = sanitize_text_field($recuring_chargis_data->tax_amount);
							$invoice_data['total_amount'] = sanitize_text_field($recuring_chargis_data->total_amount);
							$invoice_data['due_amount'] = sanitize_text_field($recuring_chargis_data->total_amount);
						} elseif ($recuring_chargis_data->charges_calculate_by == 'measurement_charge') {
							$income_amount = json_decode($recuring_chargis_data->charges_payment);
							$amount = 0;
							$member_id = intval($invoice_data['member_id']);
							$unit = MJ_amgt_get_single_member_unit_size($member_id);

							foreach ($income_amount as $retrieved_data) {
								$amount = $retrieved_data->amount * $unit;
							}

							$amount_after_discount = $amount - $recuring_chargis_data->discount_amount;
							$id_invoice = $recuring_chargis_data->id;
							$tax_entry = $wpdb->get_results($wpdb->prepare("SELECT tax FROM $amgt_amgt_invoice_tax WHERE invoice_id = %d", $id_invoice));

							$tax_amount = 0;

							foreach ($tax_entry as $tax_data) {
								$tax_amount += $amount_after_discount / 100 * $tax_data->tax;
							}
							$total_amount = $amount_after_discount + $tax_amount;
							$invoice_data['amount'] = sanitize_text_field($amount_after_discount);
							$invoice_data['tax_amount'] = sanitize_text_field($tax_amount);
							$invoice_data['total_amount'] = sanitize_text_field($total_amount);
							$invoice_data['due_amount'] = sanitize_text_field($total_amount);
						}
						//Check All ready Generated//
						$check_allready_generated = $obj_accounts->MJ_amgt_member_invoice_allready_generated($invoice_data['member_id'], date('Y-m-d'), $end_date);

						if ($check_allready_generated == '0') {
							$result = $wpdb->insert($amgt_amgt_created_invoice_list, $invoice_data);

							global $wpdb;
							$user_invoiceid = $wpdb->insert_id;
							//---------Notification send mail code---------------------
							$payment_link = '<a href=' . home_url() . '?apartment-dashboard=user&page=accounts>Payment</a>';
							$retrieved_data = get_userdata(intval($invoice_data['member_id']));
							$to = sanitize_email($retrieved_data->user_email);
							$subject = get_option('wp_amgt_generate_invoice_subject');
							$apartmentname = get_option('amgt_system_name');
							$subject_search = array('{{apartment_name}}');
							$subject_replace = array($apartmentname);
							$subject = str_replace($subject_search, $subject_replace, $subject);
							$message_content = get_option('wp_amgt_generate_invoice_email_template');
							$search = array('{{member_name}}', '{{apartment_name}}', '{{Payment Link}}');
							$replace = array($retrieved_data->display_name, $apartmentname, $payment_link);
							$message_content = str_replace($search, $replace, $message_content);

							$enable_notofication = get_option('apartment_enable_notifications');
							if ($enable_notofication == 'yes') {
								MJ_amgt_send_invoice_generate_mail($to, $subject, $message_content, $user_invoiceid);
							}

						}
						// ================= SEND PUSH NOTIFICATION==========================
			
						$send_data['type']="new_invoice";
						$send_data['invoice_no']=$user_invoiceid;
						$send_push_notification = MJ_amgt_send_push_notification($invoice_data['member_id'],$send_data);
					}
				}
				if ($result) {
					//insert start and end date
					$whereid['id'] = $recuring_chargis_data->id;
					$invoice_generate_date['invoice_start_date'] = sanitize_text_field(date('Y-m-d'));

					$invoice_generate_date['invoice_end_date'] = sanitize_text_field($end_date);

					$result_update_generate_date = $wpdb->update($amgt_generat_invoice, $invoice_generate_date, $whereid);
				}
			}
		}
		// REGENGENERATE CHARGIS INVOICE FOR YEARLY
		if (!empty ($yearly)) {
			foreach ($yearly as $recuring_chargis_data) {
				global $wpdb;
				$amgt_amgt_created_invoice_list = $wpdb->prefix . 'amgt_created_invoice_list';
				$amgt_generat_invoice = $wpdb->prefix . 'amgt_generat_invoice';
				$amgt_amgt_invoice_tax = $wpdb->prefix . 'amgt_invoice_tax';
				$obj_account = new MJ_amgt_Accounts;

				if ($recuring_chargis_data->invoice_options == 'all_member') {
					$member_data = MJ_amgt_get_all_member_data();
				} elseif ($recuring_chargis_data->invoice_options == 'Building') {
					$building_id = $recuring_chargis_data->building_id;

					$member_data = MJ_amgt_get_all_member_data_by_building_id($building_id);
				} elseif ($recuring_chargis_data->invoice_options == 'Unit Category') {
					$building_id = $recuring_chargis_data->building_id;
					$unit_id = $recuring_chargis_data->unit_cat_id;

					$member_data = MJ_amgt_get_all_member_data_by_building_unit_id($building_id, $unit_id);
				} elseif ($recuring_chargis_data->invoice_options == 'one_member') {
					$member_data = array();
					$member_data[] = $recuring_chargis_data->member_id;
					$member_id_by_unit_name = MJ_amgt_get_member_id_by_unit_name($recuring_chargis_data->unit_name);
					$member_data[] = $member_id_by_unit_name;
				}

				if (!empty ($member_data)) {
					//require AMS_PLUGIN_DIR. '/lib/mpdf/mpdf.php';
					foreach ($member_data as $retrieved_data) {
						$invoice_data['charges_id'] = $recuring_chargis_data->id;
						$result_invoice_no = $wpdb->get_results("SELECT * FROM $amgt_amgt_created_invoice_list");

						if (empty ($result_invoice_no)) {
							$invoice_no = '00001';
						} else {
							$result_no = $wpdb->get_row($wpdb->prepare("SELECT invoice_no FROM $amgt_amgt_created_invoice_list WHERE id=(SELECT max(id) FROM $amgt_amgt_created_invoice_list)"));

							$last_invoice_number = $result_no->invoice_no;

							$invoice_length = strlen($result_no->invoice_no);
							if ($invoice_length == '9') {
								$invoice_no = '00001';
							} else {
								$invoice_no = str_pad($last_invoice_number + 1, 5, 0, STR_PAD_LEFT);
							}
						}

						if ($recuring_chargis_data->invoice_options == 'one_member') {
							$invoice_data['member_id'] = sanitize_text_field($retrieved_data);
						} else {
							$invoice_data['member_id'] = sanitize_text_field($retrieved_data->ID);
						}

						$invoice_data['charges_type_id'] = sanitize_text_field($recuring_chargis_data->charges_type_id);
						$invoice_data['invoice_no'] = sanitize_text_field($invoice_no);
						$invoice_data['description'] = sanitize_text_field($recuring_chargis_data->description);
						$invoice_data['discount_amount'] = sanitize_text_field($recuring_chargis_data->discount_amount);
						$invoice_data['charges_payment'] = sanitize_text_field($recuring_chargis_data->charges_payment);
						$invoice_data['paid_amount'] = 0;
						$invoice_data['payment_status'] = 'Unpaid';
						$invoice_data['created_date'] = date('Y-m-d');
						$invoice_data['amgt_charge_period'] = sanitize_text_field($recuring_chargis_data->amgt_charge_period);

						$start_date = date('Y-m-d');
						$invoice_data['start_date'] = $start_date;
						$add_month_to_date = date('Y-m-d', strtotime("+12 months", strtotime($start_date)));
						$end_date = date('Y-m-d', strtotime("-1 days", strtotime($add_month_to_date)));
						$invoice_data['end_date'] = $end_date;

						if ($recuring_chargis_data->charges_calculate_by == 'fix_charge') {
							$invoice_data['amount'] = sanitize_text_field($recuring_chargis_data->amount);
							$invoice_data['tax_amount'] = sanitize_text_field($recuring_chargis_data->tax_amount);
							$invoice_data['total_amount'] = sanitize_text_field($recuring_chargis_data->total_amount);
							$invoice_data['due_amount'] = sanitize_text_field($recuring_chargis_data->total_amount);
						} elseif ($recuring_chargis_data->charges_calculate_by == 'measurement_charge') {

							$income_amount = json_decode($recuring_chargis_data->charges_payment);
							$amount = 0;
							$member_id = $invoice_data['member_id'];
							$unit = MJ_amgt_get_single_member_unit_size($member_id);

							foreach ($income_amount as $retrieved_data) {
								$amount = $retrieved_data->amount * $unit;
							}

							$amount_after_discount = $amount - $recuring_chargis_data->discount_amount;
							$id_invoice = $recuring_chargis_data->id;
							$tax_entry = $wpdb->get_results($wpdb->prepare("SELECT tax FROM $amgt_amgt_invoice_tax WHERE invoice_id = %d", $id_invoice));

							$tax_amount = 0;

							foreach ($tax_entry as $tax_data) {
								$tax_amount += $amount_after_discount / 100 * $tax_data->tax;
							}
							$total_amount = $amount_after_discount + $tax_amount;
							$invoice_data['amount'] = $amount_after_discount;
							$invoice_data['tax_amount'] = $tax_amount;
							$invoice_data['total_amount'] = $total_amount;
							$invoice_data['due_amount'] = $total_amount;
						}
						//Check All ready Generated//
						$check_allready_generated = $obj_accounts->MJ_amgt_member_invoice_allready_generated($invoice_data['member_id'], date('Y-m-d'), $end_date);

						if ($check_allready_generated == '0') {
							$result = $wpdb->insert($amgt_amgt_created_invoice_list, $invoice_data);

							global $wpdb;
							$user_invoiceid = $wpdb->insert_id;
							//---------Notification send mail code---------------------
							$payment_link = '<a href=' . home_url() . '?apartment-dashboard=user&page=accounts>Payment</a>';
							$retrieved_data = get_userdata($invoice_data['member_id']);
							$to = sanitize_email($retrieved_data->user_email);
							$subject = get_option('wp_amgt_generate_invoice_subject');
							$apartmentname = get_option('amgt_system_name');
							$subject_search = array('{{apartment_name}}');
							$subject_replace = array($apartmentname);
							$subject = str_replace($subject_search, $subject_replace, $subject);
							$message_content = get_option('wp_amgt_generate_invoice_email_template');
							$search = array('{{member_name}}', '{{apartment_name}}', '{{Payment Link}}');
							$replace = array($retrieved_data->display_name, $apartmentname, $payment_link);
							$message_content = str_replace($search, $replace, $message_content);

							$enable_notofication = get_option('apartment_enable_notifications');
							if ($enable_notofication == 'yes') {
								MJ_amgt_send_invoice_generate_mail($to, $subject, $message_content, $user_invoiceid);
							}

						}
						// ================= SEND PUSH NOTIFICATION==========================
			
						$send_data['type']="new_invoice";
						$send_data['invoice_no']=$user_invoiceid;
						$send_push_notification = MJ_amgt_send_push_notification($invoice_data['member_id'],$send_data);
					}
				}
				if ($result) {
					//insert start and end date
					$whereid['id'] = $recuring_chargis_data->id;
					$invoice_generate_date['invoice_start_date'] = date('Y-m-d');
					$invoice_generate_date['invoice_end_date'] = $end_date;
					$result_update_generate_date = $wpdb->update($amgt_generat_invoice, $invoice_generate_date, $whereid);
				}
			}
		}
	}
}
add_action('init', 'MJ_amgt_old_user_occupied_by');
function MJ_amgt_old_user_occupied_by()
{
	$get_members = array('role' => 'member');
	$membersdata = get_users($get_members);

	if (!empty ($membersdata)) {
		foreach ($membersdata as $retrieved_data) {

			if (empty ($retrieved_data->occupied_by)) {
				$user_id = $retrieved_data->ID;
				$member_type = $retrieved_data->member_type;

				if ($member_type == 'Owner' || $member_type == 'tenant') {
					update_user_meta($user_id, 'occupied_by', $member_type);
				}
			}
		}
	}

}
add_action('init', 'MJ_amgt_old_chargis_add_into_invoice_table');
function MJ_amgt_old_chargis_add_into_invoice_table()
{
	global $wpdb;
	$table_amgt_created_invoice_list = $wpdb->prefix . 'amgt_created_invoice_list';
	$table_amgt_charges_payments = $wpdb->prefix . 'amgt_charges_payments';

	$chargis_status = 'chargis_status';

	if (!in_array($chargis_status, $wpdb->get_col("DESC " . $table_amgt_charges_payments, 0))) {
		$result = $wpdb->query(
			$wpdb->prepare("ALTER TABLE $table_amgt_charges_payments  ADD   $chargis_status  varchar(20)")
		);
	}

	$query = "INSERT INTO $table_amgt_created_invoice_list (member_id,charges_payment,payment_status,description,discount_amount,charges_type_id,created_date)
	SELECT member_id,charges_payment,'Fully Paid',description,discount_amount,charges_type_id,created_date FROM $table_amgt_charges_payments where chargis_status IS NULL";

	$result = $wpdb->query($query);

	if ($result) {
		$sql = $wpdb->prepare("UPDATE $table_amgt_charges_payments	SET chargis_status='1'");
		$wpdb->query($sql);
	}

}
//add_action( 'init', 'the_dramatist_fire_on_wp_initialization' );
//// Header Not Set﻿//
function MJ_amgt_block_frames()
{
	header('X-FRAME-OPTIONS: SAMEORIGIN');
	header('X-Content-Type-Options: nosniff');
	header('X-XSS-Protection: 1; mode=block');
}
add_action('send_headers', 'MJ_amgt_block_frames', 10);
//-------------------- REMOVE HEADER -----------------//
function MJ_amgt_header_remove_function()
{

	header_remove("X-Powered-By");
}
/**
 * Authenticate a user, confirming the username and password are valid.
 *
 * @since 2.8.0
 *
 * @param WP_User|WP_Error|null $user     WP_User or WP_Error object from a previous callback. Default null.
 * @param string                $username Username for authentication.
 * @param string                $password Password for authentication.
 * @return WP_User|WP_Error WP_User on success, WP_Error on failure.
 */
add_filter('authenticate', 'wp_authenticate_username_password_new', 20, 3);

function wp_authenticate_username_password_new($user, $username, $password)
{
	if ($user instanceof WP_User) {
		return $user;
	}

	if (empty ($username) || empty ($password)) {
		if (is_wp_error($user)) {
			return $user;
		}

		$error = new WP_Error();

		if (empty ($username)) {
			$error->add('empty_username', _e('<strong>ERROR</strong>: The username field is empty.'));
		}

		if (empty ($password)) {
			$error->add('empty_password', _e('<strong>ERROR</strong>: The password field is empty.'));
		}

		return $error;
	}

	$user = get_user_by('login', $username);

	if (!$user) {
		return new WP_Error(
			'invalid_username',
			_e('<strong>ERROR</strong>: Invalid username.') .
			' <a href="' . wp_lostpassword_url() . '">' .
			_e('Lost your password?') .
			'</a>'
		);
	}

	/**
	 * Filters whether the given user can be authenticated with the provided $password.
	 *
	 * @since 2.5.0
	 *
	 * @param WP_User|WP_Error $user     WP_User or WP_Error object if a previous
	 *                                   callback failed authentication.
	 * @param string           $password Password to check against the user.
	 */
	$user = apply_filters('wp_authenticate_user', $user, $password);
	if (is_wp_error($user)) {
		return $user;
	}

	if (!wp_check_password($password, $user->user_pass, $user->ID)) {
		return new WP_Error(
			'incorrect_password',
			sprintf(
				/* translators: %s: user name */
				_e('<strong>ERROR</strong>: No such username or password.'),
				'<strong>' . $username . '</strong>'
			) .
			' <a href="' . wp_lostpassword_url() . '">' .
			_e('Lost your password?') .
			'</a>'
		);
	}

	return $user;
}

add_filter('auth_cookie_expiration', 'MJ_amgt_keep_me_logged_in_60_minutes');
function MJ_amgt_keep_me_logged_in_60_minutes($expirein)
{
	return 7200; // 1 hours
}
//Auto Fill Feature is Enabled  wp login page//
add_action('login_form', function ($args) {
	$login = ob_get_contents();
	ob_clean();
	$login = str_replace('id="user_pass"', 'id="user_pass" autocomplete="off"', $login);
	$login = str_replace('id="user_login"', 'id="user_login" autocomplete="off"', $login);
	echo $login;
}, 9999);
if (!empty ($_SERVER['HTTPS'])) {
	function MJ_amgt_add_hsts_header($headers)
	{
		$headers['strict-transport-security'] = 'max-age=31536000; includeSubDomains';
		return $headers;
	}
	add_filter('wp_headers', 'MJ_amgt_add_hsts_header');
}
add_filter('document_title_parts', 'my_custom_title');
function my_custom_title($title)
{
	if (isset ($_REQUEST['page'])) {
		if ($_REQUEST['page'] == "resident_unit") {
			$title['title'] = __("Residential Unit", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "member") {
			$title['title'] = __("Member", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "committee-member") {
			$title['title'] = __("Committee Member", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "accountant") {
			$title['title'] = __("Accountant", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "staff-members") {
			$title['title'] = __("Staff Member", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "gatekeeper") {
			$title['title'] = __("Gatekeeper", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "visitor-manage") {
			$title['title'] = __("Visitor Management", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "notice-event") {
			$title['title'] = __("Notification", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "complaint") {
			$title['title'] = __("Complaint", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "parking-manager") {
			$title['title'] = __("Parking Manager", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "services") {
			$title['title'] = __("Services", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "facility") {
			$title['title'] = __("Facility", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "accounts") {
			$title['title'] = __("Accounts", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "documents") {
			$title['title'] = __("Documents", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "assets-inventory-tracker") {
			$title['title'] = __("Assets / Inventory Tracker", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "message") {
			$title['title'] = __("Notification", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "report") {
			$title['title'] = __("Report", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "profile") {
			$title['title'] = __("Profile", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "faq") {
			$title['title'] = __("FAQ", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "society_rules") {
			$title['title'] = __("Society Rules", "apartment_mgt");
		} elseif ($_REQUEST['page'] == "gallery") {
			$title['title'] = __("Gallery", "apartment_mgt");
		}
	} else {
		if (is_singular('post')) {
			$title['title'] = get_option('amgt_system_name', 'apartment_mgt') . ' ' . $title['title'];
		}
	}
	return $title;
}

function gettext_filter($translation, $orig, $domain)
{
	switch ($orig) {
		case 'Username or Email Address':
			//$translation = "Email ID";
			$translation = esc_html__('Email ID', 'apartment_mgt');
			break;

	}
	return $translation;
}
add_filter('gettext', 'gettext_filter', 10, 3);


// CSP: Wildcard Directive
function add_csp_header() {
	header("Content-Security-Policy: default-src 'self'; frame-src 'self' https://www.youtube.com; style-src 'self' 'unsafe-inline' https://fonts.googleapis.com https://cdn.jsdelivr.net; font-src 'self' https://fonts.gstatic.com; script-src 'self' 'unsafe-inline' 'unsafe-eval';");
}
add_action('send_headers', 'add_csp_header');

//  Missing Anti-clickjacking Header
add_action('send_headers', function () {
    header("Content-Security-Policy: frame-ancestors 'self';"); // Replace 'self' with allowed domains if needed
});


// Strict-Transport-Security Multiple Header Entries (Non-compliant with Spec)
function set_hsts_header() {
    // Ensure only one HSTS header is sent
    header_remove('Strict-Transport-Security'); // Remove existing headers (if any)
    // Add the HSTS header
    header('Strict-Transport-Security: max-age=31536000; includeSubDomains; preload');
}
add_action('send_headers', 'set_hsts_header');

// Server Leaks Version Information via "Server" HTTP Response Header Field
function remove_server_header() {
    // Remove the Server header
    header_remove('Server');
}
add_action('send_headers', 'remove_server_header');

// Cookie No HttpOnly Flag
add_action('init', function () {
    if (session_status() === PHP_SESSION_NONE) {
        session_set_cookie_params([
            'httponly' => true,
            'secure' => is_ssl(),
            'samesite' => 'Strict', // Optional: Add SameSite attribute
        ]);
        session_start();
    }
});

// Server Leaks Information via "X-Powered-By" HTTP Response Header Field
function remove_version_info() {
    header_remove('Server');
	header_remove('X-Powered-By');
}
add_action('send_headers', 'remove_version_info');

// X-Content-Type-Options Header Missing
function add_nosniff_header() {
    header('X-Content-Type-Options: nosniff');
}
add_action('send_headers', 'add_nosniff_header');

// =========== USER LOGIN LOG=============
add_action('wp_login', 'Mj_amgt_member_login', 10, 2);
function Mj_amgt_member_login($user_login, $user)
{
	$role = $user->roles;
	$role_name = $role[0];
	Mj_amgt_append_user_log($user_login, $role_name);
}

// ============== DUE INVOICE REMINDER =============

register_activation_hook(AMS_PLUGIN_BASENAME, 'myplugin_schedule_cron');
function myplugin_schedule_cron() {
    if (!wp_next_scheduled('myplugin_daily_invoice_reminder')) {
        wp_schedule_event(time(), 'daily', 'myplugin_daily_invoice_reminder');
    }
}

register_deactivation_hook(AMS_PLUGIN_BASENAME, 'myplugin_clear_cron');

function myplugin_clear_cron() {
    wp_clear_scheduled_hook('myplugin_daily_invoice_reminder');
}

?>