<?php
class MJ_amgt_gatekeeper
{	
    //ADD GATE FUNCTION//
	public function MJ_amgt_add_gate($data)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_gates';
		$gatedata['created_date']=date('Y-m-d');
		$gatedata['created_by']=intval(get_current_user_id());
		
			if(isset($data['counter']))
			{
				for($i=0;$i<=$data['counter'];$i++)
				{
					$gatedata['for_entry']='';
					$gatedata['for_exit']='';
					$gatedata['gate_name']=($data['gate_name_'.$i]);
					if(isset($data['for_entry_'.$i]))
					$gatedata['for_entry']=($data['for_entry_'.$i]);
					if(isset($data['for_exit_'.$i]))
					$gatedata['for_exit']=($data['for_exit_'.$i]);
					
					if($data['action']=='edit')
					{
						$res_id=$this->MJ_amgt_check_gate_id($data['gate_id_'.$i]);
						if(isset($data['gate_id_'.$i]))
							$whereid['id']=sanitize_text_field($data['gate_id_'.$i]);	
						if($res_id){
							$result=$wpdb->update( $table_name, $gatedata,$whereid );
							if($i == 0)
							apartment_append_audit_log('' . esc_html__('Gate Updated', 'apartment_mgt') . '', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
						}else{
							$result=$wpdb->insert( $table_name, $gatedata );
							if($i == 0)
							apartment_append_audit_log('' . esc_html__('Gate Added', 'apartment_mgt') . '', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
						}
					}
					else
					{						
						$result=$wpdb->insert( $table_name, $gatedata );
						apartment_append_audit_log('' . esc_html__('Gate Added', 'apartment_mgt') . '', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
					}
					
				}
			}
			return $result;
	}
	// get visiter record entry
	public function MJ_amgt_get_visiter_entry_records($data,$data1)
	// public function MJ_amgt_get_visiter_entry_records($data)
	{
			$visitor_name=($data['visitor_name']);
			$mobile=($data['mobile']);
			$vehicle_number=($data['vehicle_number']);
			$contact_number=($data['contact_number']);
			$email=($data['email']);
			$entry_data=array();
			$i=0;
			if(!empty($data1))
			{
				foreach($data1 as $visitor)
				{
					$visitor_image[] = $visitor;
				}
			}else {
				$visitor_image[] = "";
			}
		
			foreach($visitor_name as $one_entry)
			{
				// $target_dir = AMS_PLUGIN_DIR . "/assets/visitor_checkin/";
				// $target_file = $target_dir . basename($data1["visitor_file"]["name"][$i]);
				
				// if (move_uploaded_file($data1["visitor_file"]["tmp_name"][$i], $target_file)) {
				// 	$image_name = $target_dir . $data1["visitor_file"]["name"][$i];
				// } else {
				// 	$image_name = "";
				// }
				// if(isset($data['amgt_user_avatar'])){
				// 	$visitor_image=$data['amgt_user_avatar'];
				// }else{
				// 	$visitor_image=$image_name;
				// }
				// $entry_data[]= array('visitor_name'=>$one_entry,'mobile'=>$mobile[$i],'vehicle_number'=>$vehicle_number[$i],'visitor_image'=>$visitor_image[$i]);
				$entry_data[]= array('visitor_name'=>$one_entry,'mobile'=>$mobile[$i],'contact_number'=>$contact_number[$i],'email'=>$email[$i],'vehicle_number'=>$vehicle_number[$i],'visitor_image'=>$visitor_image);
				$i++;
			}	
			return json_encode($entry_data);
	}
	//ADD VISITOR ENTRY FUNCTION
	public function MJ_amgt_add_visitor_entry($data,$files)
	{
		
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_checkin_entry';
		$entrydata['gate_id']=sanitize_text_field($data['gate']);
		$entrydata['checkin_date']=MJ_amgt_get_format_for_db($data['checkin_date']);
		$entrydata['checkin_time']=sanitize_text_field($data['checkintime']);
		$entrydata['description']=sanitize_text_field($data['description']);
		
		if(isset($data['checkin_type']))
		{
			$entrydata['checkin_type']=sanitize_text_field($data['checkin_type']);
			
			if($data['checkin_type']=='visitor_checkin')
			{
				// $entry_value=$this->MJ_amgt_get_visiter_entry_records($data);
				$entry_value=$this->MJ_amgt_get_visiter_entry_records($data,$files);
				$entrydata['status']=sanitize_text_field($data['status']);
				$entrydata['visitor_name']=$data['visitor_name'];
				$entrydata['mobile']=$data['mobile'];
				$entrydata['vehicle_number']=$data['vehicle_number'];
				$entrydata['reason_id']=sanitize_text_field($data['reason_id']);
				$entrydata['building_id']=sanitize_text_field($data['building_id']);
				$entrydata['unit_cat']=sanitize_text_field($data['unit_cat_id']);
				$entrydata['unit_name']=sanitize_text_field($data['unit_name']);
				$entrydata['visiters_value']=$entry_value;
				
			}
			
			if($data['checkin_type']=='staff_checkin')
			{
				$entrydata['member_id']=sanitize_text_field($data['member_id']);
			}
		}
		$entrydata['created_date']=date('Y-m-d');
		
		if($data['action']=='edit')
		{  
			$whereid['id']=sanitize_text_field($data['vcheckin_id']);
			$result=$wpdb->update( $table_name, $entrydata,$whereid );
			if($data['checkin_type']=='visitor_checkin')
			{
				apartment_append_audit_log('' . esc_html__('Visitor Request Updated', 'apartment_mgt') . ' ('.$data['unit_name'].')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			}else{
				apartment_append_audit_log('' . esc_html__('Staff Request Updated', 'apartment_mgt') . ' ('.MJ_amgt_get_display_name($data['member_id']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			}
		}
		else
		{
			$user_query = new WP_User_Query(
				array(
					'meta_query' => array(
						array(
							'key'     => 'unit_name',
							'value'   => $data['unit_name'],
							'compare' => 'LIKE',
						),
					),
				)
			);
			$allmembers = $user_query->get_results();
			$member_name=$allmembers[0]->display_name;

			$entrydata['created_by']=get_current_user_id();
			$result=$wpdb->insert( $table_name, $entrydata );
			if($data['checkin_type']=='visitor_checkin')
			{
				apartment_append_audit_log('' . esc_html__('Visitor Request Added', 'apartment_mgt') . ' ('.$data['unit_name'].')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			}else{
				apartment_append_audit_log('' . esc_html__('Staff Request Added', 'apartment_mgt') . ' ('.MJ_amgt_get_display_name($data['member_id']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			}
			if($data['checkin_type']=='visitor_checkin')
			{
				// if($result)
				// {
					
					$apartmentname=get_option('amgt_system_name');
					$reson=get_the_title($data['reason_id']);
					$user_query = new WP_User_Query(
						array(
							'meta_query' => array(
								array(
									'key'     => 'unit_name',
									'value'   => $data['unit_name'],
									'compare' => 'LIKE',
								),
							),
						)
					);
					$allmembers = $user_query->get_results();
					$member_name=$allmembers[0]->display_name;
					$user_info = get_userdata(1);
					$subject =get_option('wp_amgt_visitor_request_subject');
					$subject_search=array('{{member_name}}','{{apartment_name}}');
					$subject_replace=array($member_name,$apartmentname);
					$subject_replacement=str_replace($subject_search,$subject_replace,$subject);
					
					$all_visiter_entry=json_decode($entry_value);
					foreach($all_visiter_entry as $entry1)
					{
						if (!empty($entry1->visitor_image) && is_string($entry1->visitor_image)) {
							if (strpos($entry1->visitor_image[0]->name[0], AMS_PLUGIN_URL) !== false) {
								$new_url = $entry1->visitor_image[0]->name[0];

							}
						} else {
							$new_url = str_replace(AMS_PLUGIN_DIR, AMS_PLUGIN_URL, $entry1->visitor_image[0]->name[0]);
						}
						$visitor_image1[] = '<img src="' . $new_url . '" width="25%">';
					}
					$message_content=get_option('wp_amgt_visitor_request_content');
					$search=array('{{admin_name}}','{{member_name}}','{{apartment_name}}','{{visit_reson}}','{{visit_time}}','{{visit_date}}','{{apartment_name}}','{{visitor_image}}');
					$replace = array($user_info->display_name,$member_name,$apartmentname,$reson,$data['checkintime'],$data['checkin_date'],$apartmentname,$visitor_image1);
					$message_content_replacement = str_replace($search, $replace, $message_content);
					$blogusers = get_users( [ 'role__in' => [ 'administrator'] ] );
					
					foreach ( $blogusers as $user )
					{
						$to = $user->user_email; 
						MJ_amgt_SendEmailNotification($to,$subject_replacement,$message_content_replacement);
					}

					// ============= Mail For visitor request approve by member =======================

					$subject =get_option('wp_amgt_visitor_request_forMember_subject');
					$subject_search=array('{{apartment_name}}');
					$subject_replace=array($apartmentname);
					$subject_replacement=str_replace($subject_search,$subject_replace,$subject);
					$message_content=get_option('wp_amgt_visitor_request_content_forMember');
					$search=array('{{member_name}}','{{visitor_name}}','{{apartment_name}}','{{visit_reson}}','{{visit_time}}','{{visit_date}}','{{apartment_name}}');
					$replace = array($member_name,$data['visitor_name'][0],$apartmentname,$reson,$data['checkintime'],$data['checkin_date'],$apartmentname);
					$message_content_replacement = str_replace($search, $replace, $message_content);
					
					$to = $allmembers[0]->user_email; 
					MJ_amgt_SendEmailNotification($to,$subject_replacement,$message_content_replacement);


				// }
			}
		}
		return $result;
	}
	// GET ALL VISITOR CHECKIN ENTRIES
	public function Amgt_get_all_visitor_checkinentries()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_checkin_entry';
		$result = $wpdb->get_results($wpdb->prepare(
			"SELECT * FROM $table_name 
			WHERE checkin_type = %s 
			ORDER BY checkin_date DESC, 
					STR_TO_DATE(checkin_time, '%%h:%%i %%p') DESC",
			'visitor_checkin'
		));
		return $result;
	}
	// GET ALL CHECKIN ENTRY OWNDATA
	public function MJ_amgt_get_all_visitor_checkinentries_owndata($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_checkin_entry';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE checkin_type = %s AND created_by = %d", 'visitor_checkin', $user_id));
		return $result;
	}
	// GET ALL CHECKIN ENTRY OWN DATA
	public function MJ_amgt_get_all_visitor_checkinentries_own($building_id,$unit_cat_id,$unit_name)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_checkin_entry';
		$role=MJ_amgt_get_user_role(get_current_user_id()); 
		if($role =='member') 
		{ 
			$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE checkin_type = %s AND building_id = %d AND unit_cat = %d",'visitor_checkin', $building_id, $unit_cat_id));	
		}else{
			$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE checkin_type = %s AND building_id = %d AND unit_cat = %d AND unit_name = %s", 'visitor_checkin', $building_id, $unit_cat_id, $unit_name));			
		}
			return $result;
	}
	//GET ALL STAFF CHECKIN ENTRIS FUNCTION
	public function MJ_amgt_get_all_staff_checkinentries()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_checkin_entry';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE checkin_type = %s", 'staff_checkin'));
		return $result;
	}
	//GET ALL GATES FUNCTION
	public function Amgt_get_all_gates()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_gates';
		$result = $wpdb->get_results("SELECT * FROM $table_name");
		return $result;
	}
	public function Amgt_get_gate_by_id($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_gates';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $id));
		return $result;
	}
	// CHECK GATE ID
	public function MJ_amgt_check_gate_id($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_gates';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $id));
		if(!empty($result))
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	// GET SINGLE CHECKIN
	public function MJ_amgt_get_single_checkin($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_checkin_entry';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $id));
		if(!empty($result))
		{
			return $result;
		}
	}
	//DELETE  GATES FUNCTION
	public function MJ_amgt_delete_gate($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_gates';
		$gate_name = $wpdb->get_row($wpdb->prepare("SELECT gate_name FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d", $id));
		apartment_append_audit_log('' . esc_html__('Gate Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($gate_name->gate_name).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}
	// DELETE VISITOR CHECKIN ENTRY
	public function MJ_amgt_delete_visitor_checkin_entry($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_checkin_entry';
		$visitor_name = $wpdb->get_row($wpdb->prepare("SELECT unit_name FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d", $id));
		apartment_append_audit_log('' . esc_html__('Visitor Request Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($visitor_name->unit_name).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}

	public function MJ_amgt_delete_all_visitor_checkin_entry($id)
	{
		global $wpdb;

		$table_name = $wpdb->prefix . 'usermeta';
		$result=$wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE user_id=".$id));
		$retuenval=wp_delete_user( $id );
		return $retuenval;
	}
	//VISITOR CHEKIN OUT ENTERYS FUNCTION
	public function MJ_amgt_visitor_check_out_entry($data)
	{
		date_default_timezone_set('Asia/Kolkata');
		
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_checkin_entry';
		// $entrydata['checkout_time']=date( 'h:i A');
		$entrydata['checkout_time']=$data['checkout_time'];
		$entrydata['exit_gate_id']=$data['gate_name'];
		$whereid['id']=$data['checkin_id'];
		$result=$wpdb->update( $table_name, $entrydata,$whereid );
		return $result;
	}
	// GET MEMBER BY BADGEID
	public function MJ_amgt_get_memberby_basedid($badgeid)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'usermeta';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE meta_key = %s AND meta_value = %s", 'badge_id', $badgeid));

		if(!empty($result))
			return $result;
	}
	//GET ALL EXIT  GATES FUNCTION
	public function MJ_amgt_get_all_exit_gates()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_gates';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE for_exit = %s", 'yes'));
		return $result;
	}
	//GET ALL ENTRY GATES FUNCTION
	public function MJ_amgt_get_all_entry_gates()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_gates';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE for_entry = %s OR for_exit = %s", 'yes', 'yes'));
		return $result;
	}
	
//ADD VISITOR Ruqest FUNCTION//
	public function MJ_amgt_add_visitor_request($data)
	{
		global $wpdb;
		$amgt_visitor_request = $wpdb->prefix. 'amgt_visitor_request';
		$request_data['visitor_name']=$data['visitor_name'];
		$request_data['mobile']=$data['id'];
		$request_data['vehicle_number']=$data['vehicle_number'];
		$request_data['member_id']=$data['member'];
		$request_data['visit_date']=MJ_amgt_get_format_for_db($data['visit_date']);
		$request_data['description']=$data['description'];
		$request_data['created_date']=date('Y-m-d');
		$request_data['status']=$data['status'];
		$request_data['created_by']=get_current_user_id();
		
		if($data['action']=='edit')
		{
			$whereid['id']=$data['visitor_request_id'];
			$result=$wpdb->update( $amgt_visitor_request, $request_data,$whereid );
		}
		else
		{
			$result=$wpdb->insert( $amgt_visitor_request, $request_data );
			if($result)
			{
				$user_info = get_userdata(1);
				$to = $user_info->user_email; 
				$apartmentname=get_option('amgt_system_name');
				
				$member_info = get_userdata($data['member']);
                $member_name = $member_info->display_name;
				
				$subject =get_option('wp_amgt_visitor_request_subject');
				$subject_search=array('{{member_name}}','{{apartment_name}}');
		        $subject_replace=array($member_name,$apartmentname);
				$subject_replacement=str_replace($subject_search,$subject_replace,$subject);
				
				$message_content=get_option('wp_amgt_visitor_request_content');
				$search=array('{{admin_name}}','{{visitor_name}}','{{visit_date}}','{{apartment_name}}');
				$replace = array($user_info->display_name,$data['visitor_name'],$data['visit_date'],$apartmentname);
				$message_content_replacement = str_replace($search, $replace, $message_content);
				MJ_amgt_SendEmailNotification($to,$subject_replacement,$message_content_replacement);
			}
		}
		return $result;
	}
	
	//GET ALL Ruqest Function
	public function MJ_amgt_get_all_request()
	{
		global $wpdb;
		$amgt_visitor_request = $wpdb->prefix. 'amgt_visitor_request';
		$result = $wpdb->get_results("SELECT * FROM $amgt_visitor_request");
		return $result;
	}
	
	//GET ALL Ruqest Function
	public function MJ_amgt_get_all_request_curent_user_id()
	{
		global $wpdb;
		
		$get_current_user_id=get_current_user_id();
		$amgt_visitor_request = $wpdb->prefix. 'amgt_visitor_request';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $amgt_visitor_request WHERE member_id = %d", $get_current_user_id));
		return $result;
	}
	// GET SINGLE VISITOR REQUEST	
	public function MJ_amgt_get_single_visitor_request($id)
	{
		global $wpdb;
		$amgt_visitor_request = $wpdb->prefix. 'amgt_visitor_request';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $amgt_visitor_request WHERE id = %d", $id));
		if(!empty($result))
		{
			return $result;
		}
	}
	// DELETE VISITOR REQUEST
	public function MJ_amgt_delete_visitor_request($id)
	{
		global $wpdb;
		$amgt_visitor_request = $wpdb->prefix. 'amgt_visitor_request';
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $amgt_visitor_request WHERE id = %d", $id));
		return $result;
	}
	/*<---GET ALL TASK BY DUEDATE WISE FUNCTION--->*/
	public function MJ_amgt_get_visitor_request_filter_data($starting_date,$ending_date,$status)
	{
		global $wpdb;
		$amgt_visitor_request = $wpdb->prefix. 'amgt_visitor_request';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $amgt_visitor_request WHERE visit_date >= %s AND visit_date <= %s AND status = %d",$starting_date,$ending_date,$status));		
		return $result;		
	}
	// EXPORT SELECTED VISITOR
	public function MJ_amgt_export_selected_visitor($all)
	{		
		global $wpdb;
		$amgt_visitor_request = $wpdb->prefix. 'amgt_visitor_request';
		$result = $wpdb->get_results("select * FROM $amgt_visitor_request where id IN($all)");
		return $result;
	}
	// FILTER CHECKIN ENTRY
	public function MJ_amgt_get_all_visitor_checkinentries_filter($starting_date,$ending_date,$status)
	{
		global $wpdb;
		$amgt_checkin_entry = $wpdb->prefix. 'amgt_checkin_entry';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $amgt_checkin_entry WHERE checkin_type = %s AND checkin_date >= %s AND checkin_date <= %s AND status = %d", 'visitor_checkin', $starting_date, $ending_date, $status)); 
		return $result;	
	}
	//GET ALL STAFF CHECKIN AND VISIOR ENTRY ENTRIS FUNCTION
	public function MJ_amgt_get_all_entries()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_checkin_entry';
		$result = $wpdb->get_results("SELECT * FROM $table_name");
		return $result;
	}

	public function MJ_amgt_get_all_entries_by_member_id($member_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_checkin_entry';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE member_id = %d", $member_id));
		return $result;
	}

	//GET Only ALL ENTRY GATES FUNCTION
	public function MJ_amgt_get_only_all_entry_gates()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_gates';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE for_entry = %s", 'yes'));
		return $result;
	}
}
//END CLASS
?>