<?php
class MJ_amgt_Tax
{	
    //ADD TAX FUNCTON
	public function MJ_amgt_add_tax($data)
	{
		
		global $wpdb;
		$table_amgt_taxes = $wpdb->prefix. 'amgt_taxes';
		$taxdata['tax_title']=sanitize_text_field($data['tax_title']);
		$taxdata['tax']=sanitize_text_field($data['tax']);
		$taxdata['created_at']=date('Y-m-d');
		if($data['action']=='edit')
		{
			$whereid['id']=intval($data['tax_id']);
			$result=$wpdb->update( $table_amgt_taxes, $taxdata ,$whereid);
			apartment_append_audit_log('' . esc_html__('Tax Updated', 'apartment_mgt') . ' ('.sanitize_text_field($data['tax_title']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			$result=$wpdb->insert( $table_amgt_taxes, $taxdata );
			apartment_append_audit_log('' . esc_html__('Tax Added', 'apartment_mgt') . ' ('.sanitize_text_field($data['tax_title']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	}
	//GET ALL TAX FUNCTION
	public function Amgt_get_all_tax()
	{
		global $wpdb;
		$table_amgt_taxes = $wpdb->prefix. 'amgt_taxes';
		$result = $wpdb->get_results("SELECT * FROM $table_amgt_taxes");
		return $result;
	}
	// GET ALL TAX BY CHARGE ID
	public function MJ_amgt_get_all_tax_by_charge_id($id)
	{
		global $wpdb;
		$table_amgt_invoice_tax = $wpdb->prefix. 'amgt_invoice_tax';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_amgt_invoice_tax WHERE invoice_id = %d", intval($id)));
		return $result;	
	}
	//GET SINGLE TAX FUNCTION
	public function MJ_amgt_get_single_tax($id)
	{
		global $wpdb;
		$table_amgt_taxes = $wpdb->prefix. 'amgt_taxes';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_amgt_taxes WHERE id = %d", intval($id)));
		return $result;
	}
	//DELETE TAX FUNCTION
	public function MJ_amgt_delete_tax($id)
	{
		global $wpdb;
		$table_amgt_taxes = $wpdb->prefix. 'amgt_taxes';
		$tax_name = $wpdb->get_row($wpdb->prepare("SELECT tax_title FROM $table_amgt_taxes where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_amgt_taxes WHERE id = %d", intval($id)));
		apartment_append_audit_log('' . esc_html__('Tax Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($tax_name->tax_title).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}

	//GET INVOICE TAX FUNCTION
	public function MJ_amgt_GetInvoiceTax($invoiceid)
	{
		global $wpdb;
		$table_amgt_invoice_tax = $wpdb->prefix. 'amgt_invoice_tax';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_amgt_invoice_tax WHERE invoice_id = %d", intval($invoiceid)));
		return $result;
	}
	// GET INVOICE TAX BY MEMBER ID
	public function MJ_amgt_GetInvoiceTax_by_memberid($invoiceid,$member_id)
	{
		global $wpdb;
		$table_amgt_invoice_tax = $wpdb->prefix. 'amgt_invoice_tax';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_amgt_invoice_tax WHERE invoice_id = %d AND member_id = %d", intval($invoiceid), intval($member_id)));
		return $result;
	}
	//GET TEXT TITLE FUNCTION
	public function MJ_amgt_GetTaxtitle($id)
	{
		global $wpdb;
		$tax_title=esc_html__('Tax Title','apartment_mgt');
		$table_amgt_taxes = $wpdb->prefix. 'amgt_taxes';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_amgt_taxes WHERE id = %d", intval($id)));
		if(!empty($result))
		{
			$tax_title=$result->tax_title;
		}
		return $tax_title;
	}
}
?>