<?php
class MJ_amgt_Service
{	
    //ADD SERVICES FUNCTION
	public function MJ_amgt_add_service($data)
	{
		
		global $wpdb;
		$table_amgt_serivce = $wpdb->prefix. 'amgt_serivce';
		$servicedata['service_name']=sanitize_text_field($data['service_name']);
		$servicedata['service_provider']=sanitize_text_field($data['service_provider']);
		$servicedata['contact_name']=sanitize_text_field($data['contact_name']);
		$servicedata['contact_number']=sanitize_text_field($data['contact_number']);
		$servicedata['mobile_number']=sanitize_text_field($data['mobile_number']);
		$servicedata['email']=sanitize_email($data['email']);
		$servicedata['address']=sanitize_text_field($data['address']);
		$servicedata['created_date']=date('Y-m-d');
		$servicedata['status']=1;
		if($data['action']=='edit')
		{
			$whereid['service_id']=intval($data['service_id']);
			$result=$wpdb->update( $table_amgt_serivce, $servicedata ,$whereid);
			apartment_append_audit_log('' . esc_html__('Service Updated', 'apartment_mgt') . ' ('.sanitize_text_field($data['service_name']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			$servicedata['created_by']=get_current_user_id();
			$result=$wpdb->insert( $table_amgt_serivce, $servicedata );
			apartment_append_audit_log('' . esc_html__('Service Added', 'apartment_mgt') . ' ('.sanitize_text_field($data['service_name']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	}
	//GET ALL SERVICES FUNCTION
	public function MJ_amgt_get_all_service()
	{
		global $wpdb;
		$table_amgt_serivce = $wpdb->prefix. 'amgt_serivce';
		$result = $wpdb->get_results("SELECT * FROM $table_amgt_serivce");
		return $result;
	}
	// GET OWN SERVICES
	public function MJ_amgt_get_own_service($user_id)
	{
		global $wpdb;
		$table_amgt_serivce = $wpdb->prefix. 'amgt_serivce';
		$result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_amgt_serivce WHERE created_by = %d", intval($user_id )) );
		return $result;
	}
	
	//GET ALL dashboard SERVICES FUNCTION
	public function MJ_amgt_get_all_dashboard_service()
	{
		global $wpdb;
		$table_amgt_serivce = $wpdb->prefix. 'amgt_serivce';
		$result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_amgt_serivce ORDER BY created_date DESC LIMIT %d", 5 ) );
		return $result;
	}
	// GET OWN SERVICES DASHBOARD
	public function MJ_amgt_get_own_service_dashboard($user_id)
	{
		$user_id = intval($user_id);
		global $wpdb;
		$table_amgt_serivce = $wpdb->prefix. 'amgt_serivce';
		$result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_amgt_serivce WHERE created_by = %d ORDER BY created_date DESC LIMIT %d", $user_id, 5 ) );
		return $result;
	}
	//GET SINGLE SERVICES FUNCTION
	public function MJ_amgt_get_single_service($service_id)
	{
		global $wpdb;
		$table_amgt_serivce = $wpdb->prefix. 'amgt_serivce';
		$result = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table_amgt_serivce WHERE service_id = %d", intval($service_id )) );
		return $result;
	}
	//DELETE SERVICES FUNCTION
	public function MJ_amgt_delete_service($service_id)
	{
		global $wpdb;
		$table_amgt_serivce = $wpdb->prefix. 'amgt_serivce';
		$service_name = $wpdb->get_row($wpdb->prepare("SELECT service_name FROM $table_amgt_serivce where service_id= %d ", $service_id));
		$result = $wpdb->query( $wpdb->prepare( "DELETE FROM $table_amgt_serivce WHERE service_id = %d", intval($service_id )) );
		apartment_append_audit_log('' . esc_html__('Service Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($service_name->service_name).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}
}
//END CLASS
?>