<?php
class MJ_amgt_ResidentialUnit
{
	//GET ENTRY RECORD FUNCTION
	public function MJ_amgt_get_entry_records($data)
	{
		$all_units_entry = $data['unit_names'];
		$all_measurement_entry = $data['unit_size'];
		$all_unit_measerment_type = $data['unit_measerment_type'];

		$entry_data = array();
		foreach ($all_units_entry as $key => $one_entry) {
			$entry_data[] = array(
			'entry' => sanitize_text_field($one_entry),
			'measurement' => sanitize_text_field($all_measurement_entry[$key])
		);
		}
		return json_encode($entry_data);
	}
	//GET Edit ENTRY RECORD FUNCTION
	public function MJ_amgt_get_edit_entry_records($data)
	{
		$unit_id = intval($data['unit_id']); // Ensure it's an integer
		$unit_index = intval($data['unit_index']); // Ensure it's an integer
		$all_units_entry = $data['unit_names'];
		$all_measurement_entry = $data['unit_size'];
	
		$entry_data = array();
		foreach ($all_units_entry as $key => $one_entry) {
			$entry_data = array(
				'entry' => sanitize_text_field($one_entry), // Sanitize text input
				'measurement' => sanitize_text_field($all_measurement_entry[$key]) // Sanitize text input
			);
		}
		
		$entary = array();
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $unit_id),ARRAY_A);
	
		if (!$result || !isset($result['units'])) {
			return json_encode([]); // Return an empty array if no data is found
		}
		$units = $result['units'];
		$entary = json_decode($units, true);
		$edit_record = array();
		foreach ($entary as $key => $en) {
			if ($key == $unit_index) {
				$edit_record[] = array_replace($entary[$key], $entry_data);
			} else {
				$edit_record[] = $entary[$key];
			}
		}
		return json_encode($edit_record);
	}
	//ADD RESIDENTIAL UNIT FUNCTION
	public function MJ_amgt_add_residential_unit($data)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$amgt_building_cat = $wpdb->prefix . 'amgt_building_cat';
	
		$building_id = sanitize_text_field($data['building_id']);
		$unit_cat_id = sanitize_text_field($data['unit_cat_id']);
		$created_date = current_time('mysql');
		$created_by = get_current_user_id();
	
		if ($data['action'] === 'edit') {
			
			$edit_entry_value = $this->MJ_amgt_get_edit_entry_records($data);
			
			$unitdata = [
				'building_id' => $building_id,
				'unit_cat_id' => $unit_cat_id,
				'units' => $edit_entry_value,
				'created_date' => $created_date,
			];
	
			$where_unit_id = ['id' => intval($data['unit_id'])];
			$result = $wpdb->update($table_name, $unitdata, $where_unit_id, ['%d', '%d', '%s', '%s'], ['%d']);
		
			$building_cat = [
				'building_id' => $building_id,
				'building_cat_id' => $unit_cat_id,
			];
			$where_building_id = ['building_id' => $building_id];
			$result1 = $wpdb->update($amgt_building_cat, $building_cat, $where_building_id, ['%d', '%d'], ['%d']);
			apartment_append_audit_log('' . esc_html__('Residential Unit Updated', 'apartment_mgt') . ' (Units)', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		} else {
			$entry_value = $this->MJ_amgt_get_entry_records($data);
	
			$unitdata = [
				'building_id' => $building_id,
				'unit_cat_id' => $unit_cat_id,
				'units' => $entry_value,
				'created_date' => $created_date,
				'created_by' => intval($created_by),
			];
	

			$building_cat = [
				'building_id' => $building_id,
				'building_cat_id' => $unit_cat_id,
				'created_by' => intval($created_by),
			];
	
			// Insert new data securely
			$result1 = $wpdb->insert($amgt_building_cat, $building_cat, ['%d', '%d', '%d']);
			$result = $wpdb->insert($table_name, $unitdata, ['%d', '%d', '%s', '%s', '%d']);
			apartment_append_audit_log('' . esc_html__('Residential Unit Added', 'apartment_mgt') . ' (Units)', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	}
	public function MJ_amgt_get_all_residentials_own($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$building_id = intval(get_user_meta($user_id, 'building_id', true));
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE building_id = %d", $building_id));
		return $result;
	}

	//GET OWN RESIDENTIAL UNIT.
	public function MJ_amgt_get_all_residentials_own_member($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$building_id = intval(get_user_meta($user_id, 'building_id', true));
		$unit_name = sanitize_text_field(get_user_meta($user_id, 'unit_name', true));
		$role = MJ_amgt_get_user_role(get_current_user_id());
	
		$result = [];
		$is_json = is_json($unit_name);
	
		if ($is_json === 'TRUE') {
			$units_data = json_decode($unit_name);
			$units_data_array = [];

			// Extract unit names from JSON
			if (!empty($units_data)) {
				foreach ($units_data as $unit) {
					$units_data_array[] = sanitize_text_field($unit->unit_name);
				}
			}
			// Query for each unit
			if (!empty($units_data_array)) {
				foreach ($units_data_array as $unit) {
					$unit_json = wp_json_encode(['entry' => $unit]); // Secure JSON encoding
					$query = $wpdb->prepare(
						"SELECT * FROM $table_name WHERE JSON_CONTAINS(units, %s)",
						$unit_json
					);
					$result[] = $wpdb->get_row($query);
				}
			}
		} else {
			// If not JSON, handle as plain unit name
			$unit_json = wp_json_encode(['entry' => $unit_name]); // Secure JSON encoding
			$query = $wpdb->prepare(
				"SELECT * FROM $table_name WHERE JSON_CONTAINS(units, %s)",
				$unit_json
			);
			$result = $wpdb->get_results($query);
		}
		return $result;
	}

	//GET OWN RESIDENTIAL UNIT.
	public function MJ_amgt_get_all_residentials_own_for_dashboard($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$building_id = intval(get_user_meta($user_id, 'building_id', true));
		$query = $wpdb->prepare(
			"SELECT * FROM $table_name WHERE building_id = %d ORDER BY created_date DESC LIMIT 5",
			$building_id
		);
		$result = $wpdb->get_results($query);
	
		return $result;
	}
	
	//GET ALL RESIDENTIAL UNIT.
	public function MJ_amgt_get_all_residentials()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$query = $wpdb->prepare("SELECT * FROM $table_name WHERE 1 = %d", 1); 
		$result = $wpdb->get_results($query);
		return $result;
	}
	//GET SINGAL RESIDENTIAL FUNCTION
	public function MJ_amgt_get_single_unit($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
	
		// Use a prepared statement for secure querying
		$query = $wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", intval($id));
		$result = $wpdb->get_row($query);
	
		return $result;
	}
	
	//DELETE UNIT FUNCTION
	public function MJ_amgt_delete_unit($id, $index)
	{
		$id = intval($id);
		$index = intval($index);
	
		$entry = array();
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
	
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $id), ARRAY_A);
	
		if (!empty($result) && isset($result['units'])) {
			$units = $result['units'];
			$entry = json_decode($units, true);
			if (is_array($entry) && array_key_exists($index, $entry)) {
				unset($entry[$index]);
			}
	
			if (!empty($entry)) {
				$updated_units = json_encode(array_values($entry));
				$units_data = array('units' => $updated_units);
	
				$result = $wpdb->update(
					$table_name,
					$units_data,
					array('id' => $id),
					array('%s'),
					array('%d')
				);
			} else {
				$result = $wpdb->delete(
					$table_name,
					array('id' => $id),
					array('%d')
				);
			}
			apartment_append_audit_log('' . esc_html__('Residential Unit Deleted', 'apartment_mgt') . ' (Units)', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		return false;
	}
	
	public function MJ_amgt_delete_all_unit($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$id = intval($id);
		$result = $wpdb->delete($table_name, array('id' => $id), array('%d'));
		return $result;
	}


	//GET SINGLE UNIT CATEGORY
	public function MJ_amgt_get_single_cat_units($building_id, $unit_category)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$building_id = intval($building_id);
		$unit_category = intval($unit_category);
		$query = $wpdb->prepare(
			"SELECT units FROM $table_name WHERE building_id = %d AND unit_cat_id = %d",
			$building_id,
			$unit_category
		);
		$unit_catdata = $wpdb->get_results($query);
	
		$all_entry = array();
		if (!empty($unit_catdata)) {
			foreach ($unit_catdata as $unit) {
				$decoded_units = json_decode($unit->units, true);
				if ($decoded_units) {
					$all_entry[] = $decoded_units;
				}
			}
		}
		$array_var = array();
		if (!empty($all_entry)) {
			foreach ($all_entry as $val) {
				foreach ($val as $unit) {
					if (isset($unit['entry'])) {
						$array_var[] = array('value' => $unit['entry']);
					}
				}
			}
		}
		return json_encode($array_var);
	}
	// UPDATE UNIT
	public function MJ_amgt_update_unit($building_id, $unit_cat_id, $cat_name)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$building_id = intval($building_id);
		$unit_cat_id = intval($unit_cat_id);
		$cat_name = sanitize_text_field($cat_name);
	
		$unitdata = array('units' => $cat_name);
		$whereid = array(
			'building_id' => $building_id,
			'unit_cat_id' => $unit_cat_id
		);
		$result = $wpdb->update($table_name, $unitdata, $whereid, array('%s'), array('%d', '%d'));
		return $result;
	}
	//GET RESIDENTIAL UNIT REPORT FUNCTION
	public function MJ_amgt_unit_report()
	{
		$role = MJ_amgt_get_user_role(get_current_user_id());
		global $wpdb;
		$return_array = array();

		if ($role == 'member') {
			$member_id = wp_get_current_user();
			$building_id = get_user_meta($member_id->ID, 'building_id', true);
			if (!$building_id) {
				return $return_array; 
			}

			$table_name = $wpdb->prefix . 'amgt_residential_units';
			$all_building = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE building_id = %d", $building_id));
		} else {
			$all_building = $this->MJ_amgt_get_all_residentials();
		}

		$building = array();
		foreach ($all_building as $retrivedata) {
			$units = json_decode($retrivedata->units, true);
			if ($units) {
				$building[$retrivedata->building_id][] = count($units);
			}
		}

		if (!empty($building)) {
			foreach ($building as $key => $value) {
				$total_unit = array_sum($value);
				$return_array[] = array('building_id' => $key, 'no_of_unit' => $total_unit);
			}
		}
		return $return_array;
	}

	//GET RESIDENTIAL UNIT REPORT FUNCTION
	public function MJ_amgt_get_building_unit_count($building_id)
	{
		global $wpdb;
		$table_amgt_residential_units = $wpdb->prefix . 'amgt_residential_units';
		$building_id = intval($building_id);

		$results = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT units FROM $table_amgt_residential_units WHERE building_id = %d",
				$building_id
			)
		);
		$total_units = 0;
		if (!empty($results)) {
			foreach ($results as $retrieved_data) {
				$units = json_decode($retrieved_data->units, true);
				if (is_array($units)) {
					$total_units += count($units);
				}
			}
		}
		return array('building_id' => $building_id, 'no_of_unit' => $total_units);
	}

	//ADD MEMBER BY BULDING FUNCTION
	public function MJ_amgt_member_by_building()
	{
		global $wpdb;
		$table_amgt_residential_units = $wpdb->prefix . 'amgt_residential_units';
	
		// Use DISTINCT to retrieve unique building IDs directly
		$result = $wpdb->get_results("SELECT DISTINCT building_id FROM $table_amgt_residential_units", ARRAY_A);
	
		$return_array = array();
	
		// Iterate through each building ID
		if (!empty($result)) {
			foreach ($result as $retrivedata) {
				$building_id = intval($retrivedata['building_id']);
	
				// Retrieve members associated with this building ID
				$members = get_users(array(
					'meta_key'   => 'building_id',
					'meta_value' => $building_id,
					'role'       => 'member',
					'fields'     => 'ID', // Fetch only IDs to reduce memory usage
				));
	
				$return_array[] = array(
					'building_id'   => $building_id,
					'no_of_member' => count($members),
				);
			}
		}
	
		return $return_array;
	}

	public function MJ_amgt_member_by_building_id($member_buildingid)
	{
		global $wpdb;
		$table_amgt_residential_units = $wpdb->prefix . 'amgt_residential_units';
		$result = $wpdb->get_results("SELECT * FROM $table_amgt_residential_units group by building_id");
		$return_array = array();
		$member_buildingid = intval($member_buildingid);
		$member = get_users(array('meta_key' => 'building_id', 'meta_value' => $member_buildingid, 'role' => 'member'));
		$return_array[] = array('building_id' => $member_buildingid, 'no_of_member' => count($member));

		return $return_array;
	}
	public function MJ_amgt_member_by_building_own($building_id)
	{
		global $wpdb;
		$table_amgt_residential_units = $wpdb->prefix . 'amgt_residential_units';

		$return_array = array();
		$building_id = intval($building_id);
		$member = get_users(array('meta_key' => 'building_id', 'meta_value' => $building_id, 'role' => 'member'));
		$return_array[] = array('building_id' => $building_id, 'no_of_member' => count($member));

		return $return_array;
	}
	// GET ALL RESIDENTAL DASHBOARD
	public function MJ_amgt_get_all_residentials_dashboard()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name ORDER BY created_date DESC LIMIT %d", 5));
		return $result;
	}
	//GET ALL RESIDENTIAL UNIT CRETED BY.
	public function MJ_amgt_get_all_residentials_created_by($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$user_id = intval($user_id);

		$query = "SELECT * FROM $table_name WHERE created_by = %d";
		$result = $wpdb->get_results($wpdb->prepare($query, $user_id));
		return $result;
	}

	//GET ALL RESIDENTIAL UNIT CRETED BY for dashboard
	public function MJ_amgt_get_all_residentials_created_by_for_dashboard($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$user_id = intval($user_id);
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE created_by = %d ORDER BY created_date DESC LIMIT %d", $user_id, 5));
		return $result;
	}

	//GET ALL RESIDENTIAL UNIT BY MEMBER.
	public function MJ_amgt_get_unit_list_member($building_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_residential_units';
		$building_id = intval($building_id);
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE building_id = %d", $building_id));
		return $result;
	}

	//GET RESIDENTIAL UNIT OCCUPIED STATUS //
	public function MJ_amgt_get_all_residentials_status_history($member_name)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_unit_occupied_history';
		$member_name = sanitize_text_field($member_name);
		$result = $wpdb->get_row($wpdb->prepare("SELECT occupied_to_date FROM $table_name WHERE member_name = %s", $member_name));
		return $result;
	}


	public function MJ_amgt_total_residentials_units()
	{
		// Retrieve all residential units
		$residentialdata = $this->MJ_amgt_get_all_residentials();

		$unoccupied = 0;
		$occupied = 0;

		if (!empty($residentialdata)) {
			foreach ($residentialdata as $retrieved_data) {
				$units_data = json_decode($retrieved_data->units);

				if (!empty($units_data)) {
					foreach ($units_data as $unit) {
						$args = array(
							'meta_query' => array(
								'relation' => 'AND',
								array(
									'key' => 'building_id',
									'value' => intval($retrieved_data->building_id),
									'compare' => '=',
								),
								array(
									'key' => 'unit_cat_id',
									'value' => intval($retrieved_data->unit_cat_id), 
									'compare' => '=',
								),
								array(
									'key' => 'unit_name',
									'value' => sanitize_text_field($unit->entry),
									'compare' => 'LIKE',
								),
								array(
									'relation' => 'OR',
									array(
										'key' => 'occupied_by',
										'value' => 'Owner',
										'compare' => '=',
									),
									array(
										'key' => 'occupied_by',
										'value' => 'Tenant',
										'compare' => '=',
									),
								),
							),
						);

						$users = get_users($args);

						if (!empty($users)) {
							$occupied++;
						} else {
							$unoccupied++;
						}
					}
				}
			}
		}
		return array(
			'occupied_units' => $occupied,
			'unoccupied_units' => $unoccupied,
		);
	}
}
//END CLASS
?>