<?php
class MJ_amgt_Parking
{
	//ADD PARKING SLOAT FUNCTION
	public function MJ_amgt_add_sloat($data)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_sloats';
		$sloatdata['sloat_name'] = sanitize_text_field($data['sloat_name']);
		$sloatdata['sloat_type'] = sanitize_text_field($data['sloat_type']);
		$sloatdata['comment'] = sanitize_text_field($data['comment']);
		$sloatdata['created_date'] = date('Y-m-d');

		if ($data['action'] == 'edit') {
			$whereid['id'] = $data['sloat_id'];
			$result = $wpdb->update($table_name, $sloatdata, $whereid);
			apartment_append_audit_log('' . esc_html__('Slot Updated', 'apartment_mgt') . ' ('.sanitize_text_field($data['sloat_name']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		} else {
			$sloatdata['created_by'] = get_current_user_id();
			$result = $wpdb->insert($table_name, $sloatdata);
			apartment_append_audit_log('' . esc_html__('Slot Added', 'apartment_mgt') . ' ('.sanitize_text_field($data['sloat_name']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			return $result;
		}

	}
	//ADD ASIGN PARKING SLOAT FUNCTION
	public function MJ_amgt_assign_sloat($data)
	{

		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_parking';
		$assignsloatdata['sloat_id'] = intval($data['sloat_id']);
		$assignsloatdata['vehicle_number'] =sanitize_text_field($data['vehicle_number']);
		$assignsloatdata['vehicle_model'] = sanitize_text_field($data['vehicle_model']);
		$assignsloatdata['RFID'] = sanitize_text_field($data['RFID']);
		$assignsloatdata['vehicle_type'] = sanitize_text_field($data['vehicle_type']);
		$assignsloatdata['building_id'] = sanitize_text_field(intval($data['building_id']));
		$assignsloatdata['unit_cat_id'] = sanitize_text_field(intval($data['unit_cat_id']));
		$assignsloatdata['unit_name'] = sanitize_text_field($data['unit_name']);
		// $assignsloatdata['member_id']=$data['member_id'];
	
		if (!empty ($data['member_id'])) {
			$assignsloatdata['member_id'] = sanitize_text_field(intval($data['member_id']));
		} else {
			$assignsloatdata['member_id'] = sanitize_text_field(intval($data['staff_member_id']));
		}
		$assignsloatdata['from_date'] = date('Y-m-d', strtotime($data['from_date']));
		// $assignsloatdata['to_date'] = MJ_amgt_get_format_for_db($data['to_date']);
		$assignsloatdata['to_date'] = date('Y-m-d', strtotime($data['to_date']));
		$todate = date('Y-m-d', strtotime($assignsloatdata['to_date']));
		$currentdate = date('Y-m-d');
		if ($todate >= $currentdate) {
			$assignsloatdata['status'] = 'alloted';
		} else {
			$assignsloatdata['status'] = 'unallocated';
		}

		$assignsloatdata['description'] = sanitize_textarea_field($data['description']);
		$assignsloatdata['created_date'] = date('Y-m-d');

		if ($data['action'] == 'edit') {
			$whereid['id'] = sanitize_text_field(intval($data['sloat_assign_id']));
			$result = $wpdb->update($table_name, $assignsloatdata, $whereid);
			apartment_append_audit_log('' . esc_html__('Assign Slot Updated for', 'apartment_mgt') . ' ('.MJ_amgt_get_sloat_name($data['sloat_id'])->sloat_name.')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			
			return $result;
		} else {   //ASIGN PARKING SLOAT MAIL SEND 
			$assignsloatdata['created_by'] = get_current_user_id();
			$result = $wpdb->insert($table_name, $assignsloatdata);

			apartment_append_audit_log('' . esc_html__('Assign Slot Added for', 'apartment_mgt') . ' ('.MJ_amgt_get_sloat_name($data['sloat_id'])->sloat_name.')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			
			$retrieved_data = get_userdata(intval($assignsloatdata['member_id']));
			$to = sanitize_email($retrieved_data->user_email);
			$subject = get_option('wp_amgt_add_assign_sloat_subject');
			$apartmentname = get_option('amgt_system_name');
			$subject_search = array('{{apartment_name}}');
			$page_link = home_url() . '/?apartment-dashboard=user&page=parking-manager&tab=assigned-sloat-list';
			$subject_replace = array($apartmentname);
			$message_content = get_option('wp_amgt_add_assign_sloat_email_template');
			$slotdata = $this->MJ_amgt_get_single_sloat(intval($assignsloatdata['sloat_id']));
			$sloat_name = sanitize_text_field($slotdata->sloat_name);
			$search = array('{{member_name}}', '{{apartment_name}}', '{{slotname}}', '{{startdate}}', '{{enddate}}', '{{vehiclenumber}}', '{{vehiclemodel}}', '{{vehicletype}}', '{{RFID}}', '{{Sloat_Link}}');
			$replace = array(sanitize_text_field($retrieved_data->display_name), sanitize_text_field($apartmentname), sanitize_text_field($sloat_name), $assignsloatdata['from_date'], $assignsloatdata['to_date'], sanitize_text_field($assignsloatdata['vehicle_number']), sanitize_text_field($assignsloatdata['vehicle_model']), sanitize_text_field($assignsloatdata['vehicle_type']), $assignsloatdata['RFID'], $page_link);
			$subject = str_replace($subject_search, $subject_replace, $subject);
			$message_content = str_replace($search, $replace, $message_content);
			if(isset($_POST['amgt_mail_service_enable']))
			{
				MJ_amgt_SendEmailNotification($to, $subject, $message_content);
			}

			$assignsloat_startdate = $assignsloatdata['from_date'];
			$assignsloat_todate = $assignsloatdata['to_date'];

			//---------------- SEND  SMS ------------------//
			
			if(isset($_POST['amgt_sms_service_enable']))
			{
				$apartmentname=get_option('amgt_system_name');
				$message_content ="Dear $retrieved_data->display_name, Parking slot has been assigned to you in $apartmentname. Your parking slot is $sloat_name. You have assigned this slot from $assignsloat_startdate to $assignsloat_todate.";
				$send_sms = MJ_amgt_send_sms_notification(intval($assignsloatdata['member_id']),'Assign Parking slot',$message_content);
			}
			/// ================= SEND PUSH NOTIFICATION=======================
				
			$send_data['type']="assign_slot";
			$send_data['slotname']=$sloat_name;
			$send_data['startdate']=$assignsloat_startdate;
			$send_data['enddate']=$assignsloat_todate;
			$send_push_notification = MJ_amgt_send_push_notification(intval($assignsloatdata['member_id']),$send_data);
			return $result;
		}
	}
	//GET ALL SLAOT
	public function MJ_amgt_get_all_sloats()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_sloats';
		$result = $wpdb->get_results("SELECT * FROM $table_name");
		return $result;
	}
	public function MJ_amgt_get_all_sloats_ny_user($member_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_parking';
		$result = $wpdb->get_results($wpdb->prepare("SELECT status FROM $table_name WHERE member_id = %d", intval($member_id)));
		return $result;
	}

	// GET OWN SLOATS
	public function MJ_amgt_get_own_sloats($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_sloats';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name where created_by = %d", intval($user_id)));
		return $result;
	}
	// GET ASSIGNED SLOATS
	public function MJ_amgt_get_all_assigned_sloats()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_parking';
		$result = $wpdb->get_results("SELECT * FROM $table_name");
		return $result;
	}
	// GET OWN ASSIGNED SLOATS
	public function MJ_amgt_get_own_assigned_sloats($user_id)
	{
		global $wpdb;
		$user_id = intval($user_id);
		$table_name = $wpdb->prefix . 'amgt_parking';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name where member_id= $user_id OR created_by = %d", $user_id));
		return $result;
	}
	// GET SINGLE SLOAT
	public function MJ_amgt_get_single_sloat($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_sloats';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name where id = %d",  intval($id)));
		return $result;
	}
	// GET SINGLE ASSIGNED SLOAT
	public function MJ_amgt_get_single_assigned_sloat($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_parking';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name where id = %d",  intval($id)));
		return $result;
	}
	// DELETE SLOAT
	public function MJ_amgt_delete_sloat($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_sloats';
		$sloat_name = $wpdb->get_row($wpdb->prepare("SELECT sloat_name FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name where id = %d",  intval($id)));
		apartment_append_audit_log('' . esc_html__('Slot Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($sloat_name->sloat_name).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}
	//DELETE ASSIGN PARKINF SLOAT
	public function MJ_amgt_delete_assigned_sloat($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_parking';
		$sloat_name = $wpdb->get_row($wpdb->prepare("SELECT sloat_id FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name where id = %d",  intval($id)));
		apartment_append_audit_log('' . esc_html__('Assign Slot Deleted', 'apartment_mgt') . ' ('.MJ_amgt_get_sloat_name($sloat_name->sloat_id)->sloat_name.')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}
	// GET ALL ASSIGNED SLOAT BY DATE AND ID
	public function MJ_amgt_get_all_assigned_sloats_by_date_slot_id($id, $from_date, $to_date)
	{
		global $wpdb;
		$id = intval($id);
		$table_name = $wpdb->prefix . 'amgt_parking';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE sloat_id = %d AND (to_date <= %s AND from_date >= %s)",$id, $to_date, $from_date));
		return $result;

	}
}
//END CLASS
?>