<?php
class MJ_amgt_NoticeEvents
{	
   //ADD NOTICE FUNCTION
	public function MJ_amgt_add_notice($data,$file_name)
	{
	    $obj_apartment=new MJ_amgt_Apartment_management(get_current_user_id());
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_notice';
		$noticedata['notice_title']=sanitize_text_field($data['notice_title']);
		$noticedata['notice_type']=sanitize_text_field($data['notice_type']);
		$noticedata['notice_doc']=$file_name;
		$noticedata['description']=stripslashes(sanitize_textarea_field($data['description']));
		$noticedata['valid_date']=MJ_amgt_get_format_for_db($data['notice_valid']);
		$noticedata['start_date']=MJ_amgt_get_format_for_db($data['start_date']);
	
		if($obj_apartment->role=='administrator' || $obj_apartment->role=='staff_member')
		{
			$noticedata['status']=sanitize_text_field('Open');
		}	
		else
		{
			$enable_apartment_enable_notifications=get_option("notice_event_approved_by_admin");
			if($enable_apartment_enable_notifications =='yes')
			{
				$noticedata['status']='Open';
			}
			else
			{
				$noticedata['status']='Not Approved';
			}
		}
		$noticedata['created_date']=date('Y-m-d');
		
		if($data['action']=='edit')
		{
			$whereid['id']=intval($data['notice_id']);

	$user_ids = []; // Initialize an empty array to track inserted user IDs
			foreach ($data['notice_to'] as $notice_to) {
				$roless = sanitize_text_field($notice_to);

				if ($roless == 'member') {
					$userdata = get_users(array('role' => $roless));
					if (!empty($userdata)) {
						foreach ($userdata as $user) {
							if (!in_array($user->ID, $user_ids)) { // Prevent duplicates
								$user_ids[] = $user->ID;
								$noticedata['notice_to'] = $user->ID;
								$result=$wpdb->update( $table_name, $noticedata ,$whereid);
							}
						}
					}
				} else {
					$user_id = $notice_to;
					if (strpos($user_id, "grp_") === false) { // Only user selected but not group/building
						if (!in_array($user_id, $user_ids)) { // Prevent duplicates
							$user_ids[] = $user_id;
							$noticedata['notice_to'] = $user_id;
							$result=$wpdb->update( $table_name, $noticedata ,$whereid);
						}
					} else {
						$building_id = explode("_", $user_id);
						$building_id = intval($building_id[1]);

						$user_list = MJ_amgt_get_building_members($building_id);

						if (!empty($user_list)) {
							foreach ($user_list as $users) {
								if (!empty($users->ID) && !in_array($users->ID, $user_ids)) { // Prevent duplicates
									$user_ids[] = (int)$users->ID;
									$noticedata['notice_to'] = (int)$users->ID;
									$result=$wpdb->update( $table_name, $noticedata ,$whereid);
								}
							}
						}
					}
				}
			}

			apartment_append_audit_log('' . esc_html__('Notice Updated', 'apartment_mgt') . ' ('.sanitize_text_field($data['notice_title']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			$noticedata['created_by']=get_current_user_id();
			
			$user_ids = []; // Initialize an empty array to track inserted user IDs
			foreach ($data['notice_to'] as $notice_to) {
				$roless = sanitize_text_field($notice_to);

				if ($roless == 'member') {
					$userdata = get_users(array('role' => $roless));
					if (!empty($userdata)) {
						foreach ($userdata as $user) {
							if (!in_array($user->ID, $user_ids)) { // Prevent duplicates
								$user_ids[] = $user->ID;
								$noticedata['notice_to'] = $user->ID;
								$result = $wpdb->insert($table_name, $noticedata);
							}
						}
					}
				} else {
					$user_id = $notice_to;
					if (strpos($user_id, "grp_") === false) { // Only user selected but not group/building
						if (!in_array($user_id, $user_ids)) { // Prevent duplicates
							$user_ids[] = $user_id;
							$noticedata['notice_to'] = $user_id;
							$result = $wpdb->insert($table_name, $noticedata);
						}
					} else {
						$building_id = explode("_", $user_id);
						$building_id = intval($building_id[1]);

						$user_list = MJ_amgt_get_building_members($building_id);

						if (!empty($user_list)) {
							foreach ($user_list as $users) {
								if (!empty($users->ID) && !in_array($users->ID, $user_ids)) { // Prevent duplicates
									$user_ids[] = (int)$users->ID;
									$noticedata['notice_to'] = (int)$users->ID;
									$result = $wpdb->insert($table_name, $noticedata);
								}
							}
						}
					}
				}
			}

			apartment_append_audit_log('' . esc_html__('Notice Added', 'apartment_mgt') . ' ('.sanitize_text_field($data['notice_title']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			
			$get_members = array('role' => 'member');
			$membersdata = get_users($get_members);
			$membersdata = array_filter($membersdata, function ($user) use ($user_ids) {
				return in_array($user->ID, $user_ids);
			});
			
			if(!empty($membersdata))
			{
				foreach ($membersdata as $retrive_data)
				{
					$is_json = is_json($retrive_data->unit_name,$return_data = false);
					
					if($is_json == "TRUE")
					{
						$json_unit = json_decode($retrive_data->unit_name);
						$user_id = array();
						foreach($json_unit as $data){
							if($data->type == "active"){
								$user_id[]=$retrive_data->ID;
							}
						}
					}
					if($is_json != "TRUE")
					{
						if($retrive_data->unit_status == "active")
						{
							$user_id[]=$retrive_data->ID;
						}
					}
				}
			}
			// $amgt_sms_service_enable=0;
			if(isset($_POST['amgt_sms_service_enable']))
			$amgt_sms_service_enable = $_POST['amgt_sms_service_enable'];
			if($amgt_sms_service_enable)
			{
				$user_number=array();
				foreach($user_id as $user)
				{
					if(!empty(get_user_meta($user, 'phonecode',true))){ $phone_code=get_user_meta($user, 'phonecode',true); }else{ $phone_code='+'.MJ_amgt_get_countery_phonecode(get_option( 'amgt_contry' )); }
								
					$user_number[] = $phone_code.get_user_meta($user, 'mobile',true);
				
				}
				//---------------- SEND  SMS ------------------//
				include_once(ABSPATH.'wp-admin/includes/plugin.php');
				if(is_plugin_active('sms-pack/sms-pack.php'))
				{
					$apartmentname=get_option('amgt_system_name');
					$message_content = MJ_amgt_strip_tags_and_stripslashes($_POST['sms_template']);
					$current_sms_service 	= get_option( 'smgt_sms_service');
					$args = array();
					$args['mobile']=$user_number;
					$args['message_from']="NOTICE";
					$args['message']=$message_content;					
					if($current_sms_service=='telerivet' || $current_sms_service ="MSG91" || $current_sms_service=='bulksmsgateway.in' || $current_sms_service=='textlocal.in' || $current_sms_service=='bulksmsnigeria' || $current_sms_service=='africastalking' || $current_sms_service == 'clickatell')
					{				
						$send = send_sms($args);							
					}
				}
			}

		
			if(!empty($membersdata))
			{
				
				foreach($membersdata as $retrieved_data)
				{
					
					$to = sanitize_email($retrieved_data->user_email); 
					$subject =get_option('wp_amgt_add_notice_subject');
					$apartmentname=get_option('amgt_system_name');
					$page_link=home_url().'/?apartment-dashboard=user&page=notice-event&tab=notice_list';
					$subject_search=array('{{apartment_name}}','{{member_name}}');
					$subject_replace=array($apartmentname,$retrieved_data->display_name);
					$subject=str_replace($subject_search,$subject_replace,$subject);
					$message_content=get_option('wp_amgt_add_notice_email_template');
					$search=array('{{member_name}}','{{apartment_name}}','{{notice_title}}','{{notice_type}}','{{notice_valid_date}}','{{notice_content}}','{{Notice_Link}}');
					$replace = array($retrieved_data->display_name,$apartmentname,$noticedata['notice_title'],$noticedata['notice_type'],$noticedata['valid_date'],$noticedata['description'],$page_link);
					$message_content = str_replace($search, $replace, $message_content);

					if(isset($_POST['amgt_mail_service_enable']))
					{
						MJ_amgt_SendEmailNotification($to,$subject,$message_content);
					}
					//---------------- SEND  SMS ------------------//
					if(isset($_POST['amgt_sms_service_enable']))
					{
						$apartmentname=get_option('amgt_system_name');
						$message_content ="Dear $retrieved_data->display_name, You have been new notice from $apartmentname.";
						$send_sms = MJ_amgt_send_sms_notification($retrieved_data->data->ID,'New Notice',$message_content);
					}
					// ================= SEND PUSH NOTIFICATION==========================
					
					$send_data['type']="notice";
					$send_push_notification = MJ_amgt_send_push_notification($retrieved_data->ID,$send_data);
				}
			}
			return $result;
		}
	}
	
	//ADD EVENT FUNCTION
	public function MJ_amgt_add_event($data,$file_name)
	{
		$obj_apartment=new MJ_amgt_Apartment_management(get_current_user_id());
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_events';
		$eventdata['event_title']=sanitize_text_field($data['notice_title']);
		$eventdata['description']=stripslashes(sanitize_text_field($data['description']));
		$eventdata['start_date']=MJ_amgt_get_format_for_db($data['start_date']);
		$eventdata['start_time']=$data['start_time'];
		$eventdata['end_date']=MJ_amgt_get_format_for_db($data['end_date']);
		$eventdata['end_time']=$data['end_time'];
		$eventdata['event_doc']=$file_name;
	

		if($obj_apartment->role=='administrator' || $obj_apartment->role=='staff_member')
		{
			$eventdata['publish_status']='yes';
		}	
		else
		{
			$enable_apartment_enable_notifications=get_option("notice_event_approved_by_admin");
			
			if(isset($data['publish']))
			{	
				$eventdata['publish_status']=sanitize_text_field($data['publish']);
			}
			else
			{
				if($enable_apartment_enable_notifications=='yes')
				{
					$eventdata['publish_status']=sanitize_text_field('yes');
				}
				else
				{
					$eventdata['publish_status']=sanitize_text_field('no');
				}
			}
		}
		$eventdata['created_date']=date('Y-m-d');
		$eventdata['created_by']=get_current_user_id();
		if($data['action']=='edit')
		{
			$whereid['id']=intval($data['event_id']);

			$user_ids = []; // Initialize an array to track inserted user IDs
			foreach ($data['event_to'] as $event_to) 
			{
				$roless = sanitize_text_field($event_to);

				if ($roless == 'member') {
				$userdata = get_users(array('role' => $roless));
				if (!empty($userdata)) {
					foreach ($userdata as $user) {
						if (!in_array($user->ID, $user_ids)) { // Prevent duplicates
							$user_ids[] = $user->ID;
							$eventdata['event_to'] = $user->ID;
							$result=$wpdb->update( $table_name, $eventdata ,$whereid);
						}
					}
				}
				} else {
					$user_id = $event_to;
					if (strpos($user_id, "grp_") === false) { // Only user selected but not group/building
						if (!in_array($user_id, $user_ids)) { // Prevent duplicates
							$user_ids[] = $user_id;
							$eventdata['event_to'] = $user_id;
							$result=$wpdb->update( $table_name, $eventdata ,$whereid);
						}
					} else {
						$building_id = explode("_", $user_id);
						$building_id = intval($building_id[1]);

						$user_list = MJ_amgt_get_building_members($building_id);

						if (!empty($user_list)) {
							foreach ($user_list as $users) {
								if (!empty($users->ID) && !in_array($users->ID, $user_ids)) { // Prevent duplicates
									$user_ids[] = (int)$users->ID;
									$eventdata['event_to'] = (int)$users->ID;
									$result=$wpdb->update( $table_name, $eventdata ,$whereid);
								}
							}
						}
					}
				}
			}
			apartment_append_audit_log('' . esc_html__('Event Updated', 'apartment_mgt') . ' ('.sanitize_text_field($data['notice_title']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			$user_ids = []; // Initialize an array to track inserted user IDs

			foreach ($data['event_to'] as $event_to) 
			{
				$roless = sanitize_text_field($event_to);

				if ($roless == 'member') {
				$userdata = get_users(array('role' => $roless));
				if (!empty($userdata)) {
					foreach ($userdata as $user) {
						if (!in_array($user->ID, $user_ids)) { // Prevent duplicates
							$user_ids[] = $user->ID;
							$eventdata['event_to'] = $user->ID;
							$result = $wpdb->insert($table_name, $eventdata);
						}
					}
				}
				} else {
					$user_id = $event_to;
					if (strpos($user_id, "grp_") === false) { // Only user selected but not group/building
						if (!in_array($user_id, $user_ids)) { // Prevent duplicates
							$user_ids[] = $user_id;
							$eventdata['event_to'] = $user_id;
							$result = $wpdb->insert($table_name, $eventdata);
						}
					} else {
						$building_id = explode("_", $user_id);
						$building_id = intval($building_id[1]);

						$user_list = MJ_amgt_get_building_members($building_id);

						if (!empty($user_list)) {
							foreach ($user_list as $users) {
								if (!empty($users->ID) && !in_array($users->ID, $user_ids)) { // Prevent duplicates
									$user_ids[] = (int)$users->ID;
									$eventdata['event_to'] = (int)$users->ID;
									$result = $wpdb->insert($table_name, $eventdata);
								}
							}
						}
					}
				}
			}

			apartment_append_audit_log('' . esc_html__('Event Added', 'apartment_mgt') . ' ('.sanitize_text_field($data['notice_title']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));

			//--------Event NOTIFICATION EMAIL CODE-------
			$get_members = array('role' => 'member');
			$membersdata=get_users($get_members);
			$membersdata = array_filter($membersdata, function ($user) use ($user_ids) {
				return in_array($user->ID, $user_ids);
			});
			
			// if(!empty($membersdata))
			// {
			// 	$user_id = array();
			// 	foreach($membersdata as $retrieved_data1)
			// 	{
			// 		$user_id[]=$retrieved_data1->ID;
			// 	}
			// }

			if(!empty($membersdata))
			{
				foreach ($membersdata as $retrive_data)
				{
					$is_json = is_json($retrive_data->unit_name,$return_data = false);
					
					if($is_json == "TRUE")
					{
						$json_unit = json_decode($retrive_data->unit_name);
						$user_id = array();
						foreach($json_unit as $data){
							if($data->type == "active"){
								$user_id[]=$retrive_data->ID;
							}
						}
					}
					if($is_json != "TRUE")
					{
						if($retrive_data->unit_status == "active")
						{
							$user_id[]=$retrive_data->ID;
						}
					}
				}
			}
			$amgt_sms_service_enable=0;
			if(isset($_POST['amgt_sms_service_enable']))
			$amgt_sms_service_enable = $_POST['amgt_sms_service_enable'];
			if($amgt_sms_service_enable)
			{
				$user_number=array();
				foreach($user_id as $user)
				{
					if(!empty(get_user_meta($user, 'phonecode',true))){ $phone_code=get_user_meta($user, 'phonecode',true); }else{ $phone_code='+'.MJ_amgt_get_countery_phonecode(get_option( 'amgt_contry' )); }		
					$user_number[] = $phone_code.get_user_meta($user, 'mobile',true);
				}
				//---------------- SEND  SMS ------------------//
				include_once(ABSPATH.'wp-admin/includes/plugin.php');
				if(is_plugin_active('sms-pack/sms-pack.php'))
				{
					$apartmentname=get_option('amgt_system_name');
					$message_content = MJ_amgt_strip_tags_and_stripslashes($_POST['sms_template']);
					$current_sms_service 	= get_option( 'smgt_sms_service');
					$args = array();
					$args['mobile']=$user_number;
					$args['message_from']="Event";
					$args['message']=$message_content;					
					if($current_sms_service=='telerivet' || $current_sms_service ="MSG91" || $current_sms_service=='bulksmsgateway.in' || $current_sms_service=='textlocal.in' || $current_sms_service=='bulksmsnigeria' || $current_sms_service=='africastalking' || $current_sms_service == 'clickatell')
					{				
						$send = send_sms($args);							
					}
				}
			}	
			
			if(!empty($membersdata))
			{
				foreach($membersdata as $retrieved_data)
				{
					$to = sanitize_email($retrieved_data->user_email); 
					$subject =get_option('wp_amgt_add_event_subject');
					$apartmentname=get_option('amgt_system_name');
					$page_link=home_url().'/?apartment-dashboard=user&page=notice-event&tab=event_list';
					$subject_search=array('{{apartment_name}}');
		            $subject_replace=array($apartmentname);
					$subject=str_replace($subject_search,$subject_replace,$subject);
					$message_content=get_option('wp_amgt_add_event_email_template');
					$search=array('{{member_name}}','{{apartment_name}}','{{event_title}}','{{event_start_date}}','{{event_end_date}}','{{event_start_time}}','{{event_end_time}}','{{event_description}}','{{Event_Link}}');
					$replace = array($retrieved_data->display_name,$apartmentname,$eventdata['event_title'],$eventdata['start_date'],$eventdata['end_date'],$eventdata['start_time'],$eventdata['end_time'],$eventdata['description'],$page_link);
					$message_content = str_replace($search, $replace, $message_content);
					
					if(isset($_POST['amgt_mail_service_enable']))
					{
						MJ_amgt_SendEmailNotification($to,$subject,$message_content);
					}

					//---------------- SEND  SMS ------------------//
					if(isset($_POST['amgt_sms_service_enable']))
					{
						$apartmentname=get_option('amgt_system_name');
						$message_content ="Dear $retrieved_data->display_name, You have been new event from $apartmentname.";
						$send_sms = MJ_amgt_send_sms_notification($retrieved_data->data->ID,'New Event',$message_content);
					}
					// ================= SEND PUSH NOTIFICATION==========================
							
					$apartmentname=get_option('amgt_system_name');
					$send_data['type']="event";
					$send_push_notification = MJ_amgt_send_push_notification($retrieved_data->ID,$send_data);
					
				}
			}
			return $result;
		}
	}
	// GET ALL EVENTS
		// GET ALL EVENTS
	public function MJ_amgt_get_all_events()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_events';
		$obj_apartment = new MJ_amgt_Apartment_management(get_current_user_id());

		if ($obj_apartment->role == 'administrator') {
			// Admin gets all events
			$result = $wpdb->get_results("SELECT * FROM $table_name");
		} elseif ($obj_apartment->role == 'member') {
			$member_id = get_current_user_id();
			// Get events created by the member
			$data = $wpdb->get_results(
				$wpdb->prepare("SELECT * FROM $table_name WHERE created_by = %d", intval($member_id))
			);
			// Get published events
			$data1 = $wpdb->get_results("SELECT * FROM $table_name WHERE publish_status = 'yes'");
			// Merge and remove duplicates based on event ID
			$merged = array_merge($data, $data1);
			$result = $this->remove_duplicate_events($merged);
		} else {
			// Other roles get only published events
			$result = $wpdb->get_results(
				$wpdb->prepare("SELECT * FROM $table_name WHERE publish_status = %s", 'yes')
			);
		}

		return $result;
	}

	// Helper function to remove duplicate events
	private function remove_duplicate_events($events)
	{
		$unique_events = [];
		$seen_ids = [];

		foreach ($events as $event) {
			if (!in_array($event->id, $seen_ids)) {
				$unique_events[] = $event;
				$seen_ids[] = $event->id;
			}
		}

		return $unique_events;
	}
	// GET OWN EVENTS
	public function MJ_amgt_get_own_events($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_events';
		$obj_apartment=new MJ_amgt_Apartment_management(get_current_user_id());
		if($obj_apartment->role=='administrator'){
		   $result = $wpdb->get_results("SELECT * FROM $table_name");
		}
		elseif($obj_apartment->role=='member')
		{
			$member_id = get_current_user_id();
			$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE created_by = %d",intval($user_id)));			
		}
		else
		{
			$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE publish_status = %s AND created_by = %d",'yes',intval($user_id)));			
		}
		return $result;
	}
	// GET ALL NOTICE
	public function MJ_amgt_get_all_notice()
		{
			global $wpdb;
			$table_name = $wpdb->prefix . 'amgt_notice';
			$obj_apartment = new MJ_amgt_Apartment_management(get_current_user_id());

			if ($obj_apartment->role == 'administrator' || $obj_apartment->role == 'staff_member') {
				// Admin or staff members get all notices
				$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name ORDER BY id DESC"));
			} elseif ($obj_apartment->role == 'member') {
				$member_id = get_current_user_id();
				// Get notices created by the member
				$data = $wpdb->get_results(
					$wpdb->prepare("SELECT * FROM $table_name WHERE created_by = %d ORDER BY id DESC", intval($member_id))
				);
				// Get notices with 'open' status
				$data1 = $wpdb->get_results(
					$wpdb->prepare("SELECT * FROM $table_name WHERE status = %s ORDER BY id DESC", 'open')
				);
				// Merge and remove duplicates
				$result = array_merge($data, $data1);
				$result = array_unique($result, SORT_REGULAR); // Remove duplicates based on the entire object
			} else {
				// For other roles, only get notices with 'open' status
				$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE status = %s ORDER BY id DESC", 'open'));
			}
			return $result;
		}
	// GET OWN NOTICES
	public function MJ_amgt_get_own_notice($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_notice';
		$obj_apartment=new MJ_amgt_Apartment_management(get_current_user_id());
		if($obj_apartment->role=='administrator'){
			$result = $wpdb->get_results("SELECT * FROM $table_name");
		}
		elseif($obj_apartment->role=='member')
		{
			$member_id = get_current_user_id();
			$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE created_by = %d ORDER BY id DESC",intval($member_id)));			
		}
		else
		{
			$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE status = %s AND created_by = %d",'open',intval($user_id) ));
		}
		return $result;
	}
	// GET SINGLE NOTICE
	public function MJ_amgt_get_single_notice($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_notice';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", intval($id)));
		return $result;
	}
	// GET SINGLE EVENT
	public function MJ_amgt_get_single_event($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_events';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", intval($id)));
		return $result;
	}
	// DELETE NOTICE
	public function MJ_amgt_delete_notice($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_notice';
		$notice_name = $wpdb->get_row($wpdb->prepare("SELECT notice_title FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d", intval($id)));
		apartment_append_audit_log('' . esc_html__('Notice Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($notice_name->notice_title).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}

	// DELETE EVENTS
	public function MJ_amgt_delete_event($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_events';
		$event_name = $wpdb->get_row($wpdb->prepare("SELECT event_title FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d", intval($id)));
		apartment_append_audit_log('' . esc_html__('Event Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($event_name->event_title).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}

	// GET NOTICE FOR DASHBOARD
	public function MJ_amgt_get_notice_list_ondashboard()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_notice';
		$currentdate=date('Y-m-d');
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE status = %s ORDER BY created_date DESC LIMIT 4", 'open'));
		return $result;
	}
	public function MJ_amgt_get_notice_list_oncalander()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_notice';
		$currentdate=date('Y-m-d');
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE status = %s ORDER BY created_date DESC", 'open'));
		return $result;
	}
	//Approved NOTICE FUNCTION
	public function MJ_amgt_approve_notice($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_notice';
		$whereid['id']=intval($id);
		$noticedata['status']='Open';
		$result=$wpdb->update( $table_name, $noticedata ,$whereid);
		if($result)
		{
			$noticeData=$this->MJ_amgt_get_single_notice(intval($id));
			//---------NOTICE NOTIFICATION EMAIL CODE-------
			$get_members = array('role' => 'member');
			$membersdata=get_users($get_members);
			if(!empty($membersdata))
			{
				foreach($membersdata as $retrieved_data)
				{
					$to = sanitize_email($retrieved_data->user_email); 
					$subject =get_option('wp_amgt_add_notice_subject');
					$page_link=home_url().'/?apartment-dashboard=user&page=notice-event&tab=notice_list';
					$apartmentname=get_option('amgt_system_name');
					$message_content=get_option('wp_amgt_add_notice_email_template');
					$subject_search=array('{{member_name}}','{{apartment_name}}');
		            $subject_replace=array($retrieved_data->display_name,$apartmentname);
					$search=array('{{member_name}}','{{apartment_name}}','{{notice_title}}','{{notice_type}}','{{notice_valid_date}}','{{notice_content}}','{{Notice_Link}}');
					$subject=str_replace($subject_search,$subject_replace,$subject);
					$replace = array($retrieved_data->display_name,$apartmentname,$noticeData->notice_title,$noticeData->notice_type,$noticeData->valid_date,$noticeData->description,$page_link);
					$message_content = str_replace($search, $replace, $message_content);
					MJ_amgt_SendEmailNotification($to,$subject,$message_content);

					//---------------- SEND  SMS ------------------//
				
					$apartmentname=get_option('amgt_system_name');
					$message_content ="Dear $retrieved_data->display_name, You have been new notice from $apartmentname.";
					$send_sms = MJ_amgt_send_sms_notification($retrieved_data->data->ID,'New Notice',$message_content);
					
					// ================= SEND PUSH NOTIFICATION==========================
							
					$apartmentname=get_option('amgt_system_name');
					$send_data['type']="notice";
					$send_push_notification = MJ_amgt_send_push_notification($retrieved_data->ID,$send_data);
				}
			}
		}	
		return $result;
	}
	//Approved EVENT FUNCTUION
	public function MJ_amgt_approve_event($id)
	{
		global $wpdb; 
		$table_name = $wpdb->prefix. 'amgt_events';
		$whereid['id']=intval($id); 
		$eventdata['publish_status']='yes';
		$result=$wpdb->update( $table_name, $eventdata ,$whereid);
		return $result;
	}
	// GET OWN NOTICE DASHBOARD
	public function MJ_amgt_get_own_notice_dashboard($user_id)
	{
		$user_id = intval($user_id);
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_notice';
		$currentdate=date('Y-m-d');
		$result = $wpdb->get_results("SELECT * FROM $table_name where status='open' and created_by='$user_id' order by 'created_date' DESC limit 4");
		return $result;
	}
	// GET ALL NOTICE DASHBOARD
	public function MJ_amgt_get_all_notice_dashboard()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_notice';
		$currentdate=date('Y-m-d');
		$result = $wpdb->get_results("SELECT * FROM $table_name where status='open' AND valid_date >= '$currentdate' order by 'created_date' DESC limit 2");
		return $result;
	}
}
?>