<?php 
class MJ_amgt_message
{	
	 //ADD MESSAGE FUNCTION
	 public function MJ_amgt_add_message($data)
	 {
		 $result="";
		 global $wpdb;
		 $table_message=$wpdb->prefix."amgt_message";
		 $created_date = date("Y-m-d H:i:s");
		 $subject = sanitize_text_field($data['subject']);
		 $message_body = sanitize_text_field($data['message_body']);
		 $sendmail=0;
		 if(isset($_POST['amgt_send_message_mail']))
		 {
			 $sendmail=$_POST['amgt_send_message_mail'];
		 }
	 
		 $processed_user_ids = array();
	 
		 foreach($data['receiver'] as $receiver)
		 {
			 $roless=sanitize_text_field($receiver);
			 if($roless == 'member' || $roless=='staff_member' || $roless == 'accountant' || $roless == 'gatekeeper' || $roless=='committee_member' || $roless == 'employee')
			 { 
				 if($roless=='committee_member')
				 {
					 $args = array('meta_key'=>'committee_member','meta_value'=>'yes');
					 $userdata = get_users($args);
				 }
				 elseif($roless == "employee")
				 {
					 $userdata=get_users();	
				 }
				 else
				 {			
					 $userdata=get_users(array('role'=>$roless));	
				 }
				 if(!empty($userdata))
				 {       
					 $mail_id = array();            
					 foreach($userdata as $user)
					 {
						 if (!in_array($user->ID, $processed_user_ids)) {
							 $mail_id[] = $user->ID;
							 $processed_user_ids[] = $user->ID;
						 }
					 }
					 $post_id = wp_insert_post(array(
						 'post_status' => 'publish',
						 'post_type' => 'amgt_message',
						 'post_title' => $subject,
						 'post_content' => $message_body
					 ));
	 
					 foreach($mail_id as $user_id)
					 {
						 $this->MJ_amgt_send_individual_message($user_id, $subject, $message_body, $post_id, $created_date, $sendmail);
					 }
	 
					 add_post_meta($post_id, 'message_for', $roless);
					 $result = 1;
				 }
			 }
			 else
			 {
				 if(strpos($receiver,"rp_") === false)
				 {
					 $user_id = intval($receiver);
					 if (!in_array($user_id, $processed_user_ids)) {
						 $processed_user_ids[] = $user_id;
						 $post_id = wp_insert_post(array(
							 'post_status' => 'publish',
							 'post_type' => 'amgt_message',
							 'post_title' => $subject,
							 'post_content' => $message_body
						 ));
						 $this->MJ_amgt_send_individual_message($user_id, $subject, $message_body, $post_id, $created_date, $sendmail);
						 add_post_meta($post_id, 'message_for', 'user');
						 add_post_meta($post_id, 'message_for_userid', $user_id);
					 }
				 }
				 else
				 {
					 $building_id = explode("_", $receiver);
					 $building_id = intval($building_id[1]);
					 $user_list = MJ_amgt_get_building_members($building_id);
					 if(!empty($user_list))
					 {
						 foreach($user_list as $users)
						 {
							 $user_id = (int)$users->ID;
							 if (!in_array($user_id, $processed_user_ids)) {
								 $processed_user_ids[] = $user_id;
								 $post_id = wp_insert_post(array(
									 'post_status' => 'publish',
									 'post_type' => 'amgt_message',
									 'post_title' => $subject,
									 'post_content' => $message_body
								 ));
								 $this->MJ_amgt_send_individual_message($user_id, $subject, $message_body, $post_id, $created_date, $sendmail);
								 add_post_meta($post_id, 'message_for', 'user');
								 add_post_meta($post_id, 'message_for_userid', $user_id);
							 }
						 }
					 }
				 }
			 }
		 }
		 return $result;
	 }
	 
	 private function MJ_amgt_send_individual_message($user_id, $subject, $message_body, $post_id, $created_date, $sendmail)
	 {
		 global $wpdb;
		 $table_message=$wpdb->prefix."amgt_message";
		 if($sendmail==1)
		 {
			 $userdata=get_userdata($user_id);
			 wp_mail($userdata->user_email, $subject, $message_body);
		 }
		 $message_data=array(
			 'sender'=>get_current_user_id(),
			 'receiver'=>$user_id,
			 'msg_subject'=>$subject,
			 'message_body'=>$message_body,
			 'post_id'=>$post_id,
			 'msg_date'=>$created_date,
			 'msg_status' =>0
		 );
		 $wpdb->insert($table_message, $message_data);
	 
		 $reciever_data=get_userdata($user_id);
		 $reciever_name=$reciever_data->display_name;
		 $to=$reciever_data->user_email;
		 $sender_id=get_current_user_id();
		 $senderdata=get_userdata($sender_id);
		 $sendername_name=$senderdata->user_login;
		 $apartmentname=get_option('amgt_system_name');
		 $page_link=is_super_admin() ? admin_url().'admin.php?page=amgt-message' : home_url().'/?apartment-dashboard=user&page=message';
	 
		 $subject1 =get_option('wp_amgt_Message_Received_subject');
		 $subject_search=array('{{Sender Name}}','{{Apartment Name}}');
		 $subject_replace=array($sendername_name,$apartmentname);
		 $mail_subject=str_replace($subject_search,$subject_replace,$subject1);
	 
		 $message_template=get_option('wp_amgt_Message_Received_Template');
		 $search=array('{{Receiver Name}}','{{Sender Name}}','{{Message Content}}','{{Apartment Name}}','{{Message_Link}}');
		 $replace = array($reciever_name,$sendername_name,$message_body,$apartmentname,$page_link);
		 $message_content = str_replace($search, $replace, $message_template);
	 
		 if(isset($_POST['amgt_mail_service_enable']))
		 {
			 MJ_amgt_SendEmailNotification($to,$mail_subject,$message_content);
		 }
	 
		 if(isset($_POST['amgt_sms_service_enable']))
		 {
			 $message_sms ="Dear $reciever_name, You have received new message from $sendername_name. $message_body";
			 MJ_amgt_send_sms_notification($user_id,'New Message',$message_sms);
		 }
	 
		 $send_data = array(
			 'type' => 'new_message',
			 'sender' => $sendername_name,
			 'message_body' => $message_body
		 );
		 MJ_amgt_send_push_notification($user_id, $send_data);
	 }
	 
	// DELETE MESSAGE
	public function MJ_amgt_delete_message($mid)
	{
		$mid = intval($mid);
		global $wpdb;
		$table_hmgt_message = $wpdb->prefix. 'amgt_message';
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_hmgt_message WHERE post_id = %d", $mid));
		return $result;
	}
	//COUNT SEND MESSGAE FUNCTION
	public function MJ_amgt_count_send_item($user_id)
	{
		global $wpdb;
		$posts = $wpdb->prefix."posts";
		$total = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $posts WHERE post_type = 'amgt_message' AND post_author = %d", $user_id));
		return $total;
	}
	//COUNT INBOX MESSGAE FUNCTION
	public function MJ_amgt_count_inbox_item($user_id)
	{
		global $wpdb;
		$tbl_name_message = $wpdb->prefix .'amgt_message';
		$inbox = $wpdb->get_results($wpdb->prepare("SELECT * FROM $tbl_name_message WHERE receiver = %d AND msg_status = 0", $user_id));
		return $inbox;
	}
	// GET INBOX MESSAGE
	public function MJ_amgt_get_inbox_message($user_id,$p=0,$lpm1=10)
	{
		global $wpdb;
		$tbl_name_message = $wpdb->prefix .'amgt_message';
		$tbl_name_message_replies = $wpdb->prefix .'amgt_message_replies';
		$inbox = $wpdb->get_results($wpdb->prepare("SELECT DISTINCT b.message_id, a.* FROM $tbl_name_message a LEFT JOIN $tbl_name_message_replies b ON a.post_id = b.message_id WHERE (a.receiver = %d OR b.receiver_id = %d) GROUP BY a.post_id ORDER BY msg_date DESC LIMIT %d, %d", $user_id, $user_id, $p, $lpm1));
		return $inbox;
	}
	//MESSAGE PAGINATION FUNCTUION
	public function MJ_amgt_pagination($totalposts,$p,$prev,$next,$page)
	{
		$pagination = "";
		if($totalposts > 1)
		{
			$pagination .= '<div class="btn-group">';
		
			if ($p > 1)
				$pagination.= "<a href=\"?$page&pg=$prev\" class=\"btn btn-default\"><i class=\"fa fa-angle-left\"></i></a> ";
			else
				$pagination.= "<a class=\"btn btn-default disabled\"><i class=\"fa fa-angle-left\"></i></a> ";
		
			if ($p < $totalposts)
				$pagination.= " <a href=\"?$page&pg=$next\" class=\"btn btn-default next-page\"><i class=\"fa fa-angle-right\"></i></a>";
			else
				$pagination.= " <a class=\"btn btn-default disabled\"><i class=\"fa fa-angle-right\"></i></a>";
			$pagination.= "</div>\n";
		}
		
		return $pagination;
	}
	//SEND MAIL FUNCTION
	public function MJ_amgt_get_send_message($user_id,$max=10,$offset=0)
	{	
		$args['post_type'] = 'amgt_message';
		$args['posts_per_page'] =$max;
		$args['offset'] = $offset;
		$args['post_status'] = 'public';
		$args['author'] = $user_id;			
		$q = new WP_Query();
		$sent_message = $q->query( $args );
		return $sent_message;
	}
	// GET MESSAGE BY ID
	public function MJ_amgt_get_message_by_id($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "amgt_message";
		return $retrieve_subject = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM $table_name WHERE message_id = %d", intval($id) ) );
	}
	//SEND REPLY MESSAGE 
	public function MJ_amgt_send_replay_message($data)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "amgt_message_replies";
		if(!empty($data['receiver_id']))
		{
			foreach($data['receiver_id'] as $receiver_id)
			{
				$messagedata['message_id'] = sanitize_text_field($data['message_id']);
				$messagedata['sender_id'] = sanitize_text_field($data['user_id']);
				$messagedata['receiver_id'] = sanitize_text_field($receiver_id);
				$messagedata['message_comment'] = sanitize_text_field($data['replay_message_body']);
				$messagedata['msg_status'] =0;
				$messagedata['created_date'] = date("Y-m-d h:i:s");
				$result=$wpdb->insert( $table_name, $messagedata );
			}
		}
		if($result)	
		return $result;
	}
	//GET ALL REPLY FUNCTION
	public function MJ_amgt_get_all_replies($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "amgt_message_replies";
		$result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE message_id = %d GROUP BY message_id, sender_id, message_comment ORDER BY id ASC", intval($id) ) );
		return $result;
	}
	public function MJ_amgt_get_all_replies_frontend($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "amgt_message_replies";
		$result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE message_id = %d", $id ) );
		return $result;
	}

	//DELETE REPLY
	public function MJ_amgt_delete_reply($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . "amgt_message_replies";
		$reply_id['id']=intval($id);
		return $result=$wpdb->delete( $table_name, $reply_id);
	}
	//COUNT REPLY ITEM FUNCTION
}
?>