<?php
class MJ_amgt_Member
{
	//ADD MEMBER FUNCTION
	public function MJ_amgt_add_member($data)
	{
		// var_dump("hell");
		// var_dump($data);
		// die;
		global $wpdb;
		$table_amgt_unit_occupied_history = $wpdb->prefix . 'amgt_unit_occupied_history';
		$table_amgt_tenant_unit_occupied_history = $wpdb->prefix . 'amgt_tenant_unit_occupied_history';
		if (isset($data['building_id']))
			$usermetadata['building_id'] = sanitize_text_field($data['building_id']);
		if (isset($data['unit_cat_id']))
			$usermetadata['unit_cat_id'] = sanitize_text_field($data['unit_cat_id']);
		
		if (get_option('allow_member_to_multiple_units') == "no") {
			if (isset($data['unit_name']))
				$usermetadata['unit_name'] = sanitize_text_field($data['unit_name']);
				$usermetadata['unit_status'] = sanitize_text_field("active");
		} else {
			if (!empty($data['unit_name'])) {
				foreach ($data['unit_name'] as $unitname) {
					$unit_name[] = array("unit_name" => $unitname, "type" => "active");
				}
			}
			if (isset($data['unit_name']))
				$usermetadata['unit_name'] = json_encode($unit_name, JSON_UNESCAPED_UNICODE);
		}

		if (isset($data['unnit_measurement']))
			$usermetadata['unnit_measurement'] = MJ_amgt_strip_tags_and_stripslashes($data['unnit_measurement']);
		if (isset($data['unnit_chanrges']))
			$usermetadata['unnit_chanrges'] = MJ_amgt_strip_tags_and_stripslashes($data['unnit_chanrges']);
		if (isset($data['member_type']))
			$usermetadata['member_type'] = MJ_amgt_strip_tags_and_stripslashes($data['member_type']);
		if (isset($data['occupied_by']))
			$usermetadata['occupied_by'] = MJ_amgt_strip_tags_and_stripslashes($data['occupied_by']);
		if (isset($data['occupied_date']))
			$usermetadata['occupied_date'] = MJ_amgt_get_format_for_db($data['occupied_date']);
		if (isset($data['occupied_end_date']))
			$usermetadata['occupied_end_date'] = MJ_amgt_get_format_for_db($data['occupied_end_date']);
		if (isset($data['middle_name']))
			$usermetadata['middle_name'] = MJ_amgt_strip_tags_and_stripslashes($data['middle_name']);
		if (isset($data['gender']))
			$usermetadata['gender'] = sanitize_text_field($data['gender']);
		if (isset($data['birth_date']))
			$usermetadata['birth_date'] = MJ_amgt_get_format_for_db($data['birth_date']);
		if (isset($data['mobile']))
			$usermetadata['mobile'] = MJ_amgt_strip_tags_and_stripslashes($data['mobile']);
		if (isset($data['gst_no']))
			$usermetadata['gst_no'] = MJ_amgt_strip_tags_and_stripslashes($data['gst_no']);
		if (isset($data['phone']))
			$usermetadata['phone'] = MJ_amgt_strip_tags_and_stripslashes($data['phone']);
		if (isset($data['address']))
			$usermetadata['address'] = MJ_amgt_strip_tags_and_stripslashes($data['address']);
		if (isset($data['address']))
			$usermetadata['city_name'] = MJ_amgt_strip_tags_and_stripslashes($data['city_name']);
		if (isset($data['state_name']))
			$usermetadata['state_name'] = MJ_amgt_strip_tags_and_stripslashes($data['state_name']);
		if (isset($data['country_name']))
			$usermetadata['country_name'] = MJ_amgt_strip_tags_and_stripslashes($data['country_name']);
		if (isset($data['zipcode']))
			$usermetadata['zipcode'] = sanitize_text_field($data['zipcode']);
		if (isset($data['owner_payment_detail']))
			$usermetadata['owner_payment_detail'] = sanitize_text_field($data['owner_payment_detail']);
		if (isset($data['amgt_user_avatar']))
			$usermetadata['amgt_user_avatar'] = $data['amgt_user_avatar'];
		$usermetadata['created_by'] = sanitize_text_field(get_current_user_id());

		if (isset($data['email']))
			$userdata['user_email'] = sanitize_text_field($data['email']);
		$userdata['user_login'] = sanitize_text_field($data['email']);
		if (isset($data['first_name']))
			$userdata['display_name'] = sanitize_text_field($data['first_name'] . " " . $data['last_name']);

		if ($data['password'] != "")
			$userdata['user_pass'] = $data['password'];

		if (isset($data['committee_member'])) {
			$usermetadata['committee_member'] = 'yes';
			if (isset($data['designation_id']))
				$usermetadata['designation_id'] = sanitize_text_field($data['designation_id']);
		} else {
			$usermetadata['committee_member'] = 'no';
		}
		if ($data['role'] == 'staff_member' || $data['role'] == 'accountant') {
			if (isset($data['birth_date']))
				$usermetadata['birth_date'] = MJ_amgt_get_format_for_db($data['birth_date']);
			if (isset($data['staff_category']))
				$usermetadata['staff_category'] = MJ_amgt_strip_tags_and_stripslashes($data['staff_category']);
			if (isset($data['badge_id']))
				$usermetadata['badge_id'] = sanitize_text_field($data['badge_id']);
			if (isset($data['qualification']))
				$usermetadata['qualification'] = MJ_amgt_strip_tags_and_stripslashes($data['qualification']);
			if (isset($data['skills']))
				$usermetadata['skills'] = MJ_amgt_strip_tags_and_stripslashes($data['skills']);
		}
		if ($data['role'] == 'gatekeeper') {

			if (isset($data['birth_date']))
				$usermetadata['birth_date'] = MJ_amgt_get_format_for_db($data['birth_date']);
			if (isset($data['address']))
				$usermetadata['address'] = MJ_amgt_strip_tags_and_stripslashes($data['address']);
			if (isset($data['gate']))
				$usermetadata['aasigned_gate'] = MJ_amgt_strip_tags_and_stripslashes($data['gate']);
		}
		if ($data['action'] == 'edit') {
			$userdata['ID'] = $data['user_id'];
			$user_id = $data['user_id'];
			wp_update_user($userdata);
			$user_data = get_userdata($user_id);
			$membername = $user_data->display_name;

			if (!empty($data['occupied_by'])) 
			{
				$historydata['building_id'] = intval($data['building_id']);
				$historydata['unit_cat_id'] = intval($data['unit_cat_id']);
				$historydata['member_name'] = sanitize_text_field($user_data->display_name);
				$membername = sanitize_text_field($data['member_name']);
				
				$table_amgt_unit_occupied_history = $wpdb->prefix . 'amgt_unit_occupied_history';
				$table_amgt_tenant_unit_occupied_history = $wpdb->prefix . 'amgt_tenant_unit_occupied_history';
			
				$result_history_id = $wpdb->get_row(
					$wpdb->prepare(
						"SELECT id FROM $table_amgt_unit_occupied_history WHERE member_name = %s",
						$membername
					)
				);
				$whereid['id'] = isset($result_history_id->id) ? intval($result_history_id->id) : 0;
			
				$entry_data = [
					[
						'email' => sanitize_email($data['email']),
						'mobile' => sanitize_text_field($data['mobile']),
						'address' => sanitize_textarea_field($data['address']),
					],
				];
				$historydata['member_contact_details'] = wp_json_encode($entry_data);
			
				$historydata['occupied_from_date'] = MJ_amgt_get_format_for_db(sanitize_text_field($data['occupied_date']));
			
				if (get_option('allow_member_to_multiple_units') === "no") {
					$historydata['unit_name'] = MJ_amgt_strip_tags_and_stripslashes($data['unit_name']);
					$historyUnit = sanitize_text_field($data['unit_name']);
			
					if ($data['member_type'] === 'Owner') {
						$result_history_id = $wpdb->get_row(
							$wpdb->prepare(
								"SELECT id FROM $table_amgt_unit_occupied_history WHERE member_name = %s AND unit_name = %s",
								$membername,
								$historyUnit
							)
						);
			
						if (!empty($result_history_id->id)) {
							$result = $wpdb->update($table_amgt_unit_occupied_history, $historydata, ['id' => $whereid['id']]);
						} else {
							$result = $wpdb->insert($table_amgt_unit_occupied_history, $historydata);
						}
					} else {
						$historydata['member_id'] = intval($user_id);
						$result_history_id = $wpdb->get_row(
							$wpdb->prepare(
								"SELECT id FROM $table_amgt_tenant_unit_occupied_history WHERE member_name = %s AND unit_name = %s",
								$membername,
								$historyUnit
							)
						);
			
						if (!empty($result_history_id->id)) {
							$result = $wpdb->update($table_amgt_tenant_unit_occupied_history, $historydata, ['id' => $whereid['id']]);
						} else {
							$result = $wpdb->insert($table_amgt_tenant_unit_occupied_history, $historydata);
						}
					}
				} else {
					foreach ($data['unit_name'] as $unit_name) {
						$historydata['unit_name'] = MJ_amgt_strip_tags_and_stripslashes($unit_name);
						$sanitized_unit_name = sanitize_text_field($unit_name);
			
						if ($data['member_type'] === 'Owner') {
							$result_history_id = $wpdb->get_row(
								$wpdb->prepare(
									"SELECT id FROM $table_amgt_unit_occupied_history WHERE member_name = %s AND unit_name = %s",
									$membername,
									$sanitized_unit_name
								)
							);
							if (!empty($result_history_id->id)) {
								$result = $wpdb->update($table_amgt_unit_occupied_history, $historydata, ['id' => $whereid['id']]);
							} else {
								$result = $wpdb->insert($table_amgt_unit_occupied_history, $historydata);
							}
						} else {
							$historydata['member_id'] = intval($user_id);
							$result_history_id = $wpdb->get_row(
								$wpdb->prepare(
									"SELECT id FROM $table_amgt_tenant_unit_occupied_history WHERE member_name = %s AND unit_name = %s",
									$membername,
									$sanitized_unit_name
								)
							);
			
							if (!empty($result_history_id->id)) {
								$result = $wpdb->update($table_amgt_tenant_unit_occupied_history, $historydata, ['id' => $whereid['id']]);
							} else {
								$result = $wpdb->insert($table_amgt_tenant_unit_occupied_history, $historydata);
							}
						}
					}
				}
			}
			if ($data['role'] == 'member') {
				$committee_member_status = get_user_meta($user_id, 'committee_member', true);
				if ($committee_member_status == 'yes' && $usermetadata['committee_member'] == 'no') {
					//-- committee member REMOVE  mail template-- //
					$user_info = get_userdata($data['user_id']);
					$to = $user_info->user_email;
					$apartmentname = get_option('amgt_system_name');
					$subject = get_option('wp_amgt_Member_removed_committee_subject');
					$message_content = get_option('wp_amgt_Member_removed_committee_email_template');
					$subject_search = array('{{apartment_name}}');
					$subject_replace = array($apartmentname);
					$search = array('{{member_name}}', '{{apartment_name}}');
					$replace = array(
						esc_html($user_info->display_name),
						esc_html($apartmentname),
						esc_url($loginlink),
					);

					$subject = str_replace($subject_search, $subject_replace, $subject);
					$message_content = str_replace($search, $replace, $message_content);
					MJ_amgt_SendEmailNotification($to, $subject, $message_content);

					//---------------- SEND  SMS ------------------//
				
					$apartmentname=get_option('amgt_system_name');
					$message_content ="Dear $user_info->display_name, You have been removes from Committee in $apartmentname.";
					$send_sms = MJ_amgt_send_sms_notification($user_id,'Remove from Committee Member',$message_content);

					// ================= SEND PUSH NOTIFICATION==========================
			
					$send_data['type']="commettiee_member_remove";
					$send_data['loginlink']=$loginlink;
					$send_push_notification = MJ_amgt_send_push_notification($user_id,$send_data);

				} elseif ($committee_member_status == 'no' && $usermetadata['committee_member'] == 'yes') {
					//adds committee member mail template
					$user_info = get_userdata($user_id);
					$to = $user_info->user_email;
					$subject = get_option('wp_amgt_Member_Become_committee_subject');
					$loginlink = home_url() . '/apartment-management/';
					$apartmentname = get_option('amgt_system_name');
					$subject_search = array('{{apartment_name}}');
					$subject_replace = array($apartmentname);
					$message_content = get_option('wp_amgt_Member_Become_committee_email_template');
					$search = array('{{member_name}}', '{{apartment_name}}', '{{loginlink}}');
					$replace = array(
						esc_html($user_info->display_name),
						esc_html($apartmentname),
						esc_url($loginlink),
					);
					$subject = str_replace($subject_search, $subject_replace, $subject);
					$message_content = str_replace($search, $replace, $message_content);
					MJ_amgt_SendEmailNotification($to, $subject, $message_content);
					//end adds committee member mail template

					//---------------- SEND  SMS ------------------//
				
					$apartmentname=get_option('amgt_system_name');
					$message_content ="Dear $user_info->display_name, Congratulations!! You have been appointed as committee member of Committee, $apartmentname.";
					$send_sms = MJ_amgt_send_sms_notification($user_id,'Appointed as Committee Member',$message_content);


					// ================= SEND PUSH NOTIFICATION==========================
			
					$send_data['type']="commettiee_member";
					$send_data['loginlink']=$loginlink;
					$send_push_notification = MJ_amgt_send_push_notification($user_id,$send_data);
				}
			}

			$returnans = update_user_meta($user_id, 'first_name', sanitize_text_field($data['first_name']));
			$returnans = update_user_meta($user_id, 'last_name', sanitize_text_field($data['last_name']));

			if (!empty($usermetadata) && is_array($usermetadata)) {
				foreach ($usermetadata as $key => $val) {
					$sanitized_key = sanitize_key($key);
					$sanitized_val = is_array($val) ? array_map('sanitize_text_field', $val) : sanitize_text_field($val);
					$returnans = update_user_meta($user_id, $sanitized_key, $sanitized_val);
				}
			}
			return $user_id;
		} else {
			$user_id = wp_insert_user($userdata);
			$user_data = get_userdata(intval($user_id));
			$family_member_ids = array();
			if (!empty($data['family_type'][0])) {
				$family_member_ids = [];
			
				foreach ($data['family_type'] as $key => $value) {
					// Generate unique family email using member's email
					$member_email_parts = explode('@', sanitize_email($data['email']));
					$family_first_name = sanitize_text_field($data['family_first_name'][$key]);
					$family_email = $member_email_parts[0] . '+' . $family_first_name . '@' . $member_email_parts[1];
			
					$familyUserdata = [
						'user_email'  => $family_email,
						'user_login'  => $family_email,
						'user_pass'   => !empty($data['password']) ? sanitize_text_field($data['mobile']) : wp_generate_password(),
						'display_name'=> $family_first_name . ' ' . sanitize_text_field($data['family_last_name'][$key]),
					];
			
					// Prepare user metadata
					$familyusermetadata = [
						'first_name'  => $family_first_name,
						'last_name'   => sanitize_text_field($data['family_last_name'][$key]),
						'birth_date'  => sanitize_text_field($data['family_birth_date'][$key]),
						'gender'      => sanitize_text_field($data['family_gender_' . $key]),
						'mobile'      => sanitize_text_field($data['family_mobile'][$key]),
						'building_id' => sanitize_text_field($usermetadata['building_id']),
						'unit_cat_id' => sanitize_text_field($usermetadata['unit_cat_id']),
						'unit_name'   => sanitize_text_field($usermetadata['unit_name']),
						'member_type' => MJ_amgt_strip_tags_and_stripslashes($value),
					];
			
					// Insert family user
					if (!empty($familyUserdata)) {
						$familyUser_id = wp_insert_user($familyUserdata);
			
						if (!is_wp_error($familyUser_id)) {
							$familyusermetadata['member_id'] = sanitize_text_field(intval($user_id));
							$family_member_ids[] = intval($familyUser_id);
			
							// Update user metadata for family member
							foreach ($familyusermetadata as $meta_key => $meta_val) {
								update_user_meta(intval($familyUser_id), $meta_key, $meta_val);
							}
			
							// Assign role to family user
							$family_user = new WP_User(intval($familyUser_id));
							$family_user->set_role(sanitize_text_field($data['role']));
						}
					}
				}
			
				// Save family member IDs to the primary user
				if (!empty($family_member_ids)) {
					update_user_meta(intval($user_id), 'family_member_id', $family_member_ids);
				}
			}
			if (!empty($data['occupied_by'])) {

				
				$historydata['building_id'] = sanitize_text_field($data['building_id']);
				$historydata['unit_cat_id'] = sanitize_text_field($data['unit_cat_id']);
				$historydata['member_name'] = sanitize_text_field($user_data->display_name);
				$entry_data = array();

				$entry_data[] = array('email' => $data['email'], 'mobile' => $data['mobile'], 'address' => $data['address']);
				$member_contact_details = wp_json_encode($entry_data);
				$historydata['member_contact_details'] = $member_contact_details;
				$historydata['occupied_from_date'] = MJ_amgt_get_format_for_db($data['occupied_date']);
				$historydata['occupied_to_date'] = MJ_amgt_get_format_for_db($data['occupied_end_date']);
			
					
				if (get_option('allow_member_to_multiple_units') == "no") {
					$historydata['unit_name'] = MJ_amgt_strip_tags_and_stripslashes($data['unit_name']);

					if (sanitize_text_field($data['member_type']) == 'Owner') {
						// Sanitize and validate history data before insertion
						$historydata_sanitized = array_map('sanitize_text_field', $historydata);
						$result = $wpdb->insert($table_amgt_unit_occupied_history, $historydata_sanitized);
					
						// Prepare arguments for tenant lookup
						$args = array(
							'meta_query' => array(
								'relation' => 'AND',
								array(
									'key'     => 'building_id',
									'value'   => sanitize_text_field($data['building_id']),
									'compare' => '='
								),
								array(
									'key'     => 'unit_cat_id',
									'value'   => sanitize_text_field($data['unit_cat_id']),
									'compare' => '='
								),
								array(
									'key'     => 'unit_name',
									'value'   => sanitize_text_field($historydata['unit_name']),
									'compare' => 'LIKE'
								),
								array(
									'key'     => 'member_type',
									'value'   => 'tenant',
									'compare' => '='
								)
							)
						);
						$old_tenant = get_users($args);
						if (!empty($old_tenant)) {
							$old_tenant_owner = sanitize_text_field($old_tenant[0]->owner_id);
							if (!empty($old_tenant_owner)) {
								$owner_data = json_decode($old_tenant_owner);
								$updated_owner_data = array();
					
								if (is_array($owner_data)) {
									foreach ($owner_data as $owner) {
										if (isset($owner->status) && sanitize_text_field($owner->status) === 'active') {
											$owner->status = 'vacate'; 
										}
										$updated_owner_data[] = $owner;
									}
								}
								$new_owner_data = array(
									"owner_id" => sanitize_text_field(intval($user_id)),
									"status"   => "active"
								);
								$updated_owner_data[] = (object) $new_owner_data;
								$updated_owner_data_json = wp_json_encode($updated_owner_data);
								$update_tenants_owner = update_user_meta($old_tenant[0]->ID, 'owner_id', $updated_owner_data_json);
							}
						}
					}
					else{
						$historydata['member_id'] = intval($user_id);
						$result = $wpdb->insert($table_amgt_tenant_unit_occupied_history, $historydata);

						$add_owner_id = intval($data['owner_id']);;
						$owner_data[] = array("owner_id" => "$add_owner_id", "status" => "active");
						$usermetadata['owner_id'] = wp_json_encode($owner_data);
					}
				} else {
					foreach ($data['unit_name'] as $unit_name) {
						$historydata['unit_name'] = sanitize_text_field($unit_name);
						if($data['member_type'] == 'Owner')
						{
							$result = $wpdb->insert($table_amgt_unit_occupied_history, $historydata);

							$args = array(
								'meta_query' => array(
									'relation' => 'AND',
									array(
										'key' => 'building_id',
										'value' => sanitize_text_field($data['building_id']),
										'compare' => '='
									),
									array(
										'key' => 'unit_cat_id',
										'value' => sanitize_text_field($data['unit_cat_id']),
										'compare' => '='
									),
									array(
										'key' => 'unit_name',
										'value' => sanitize_text_field($historydata['unit_name']),
										'compare' => 'LIKE'
									),
									array(
										'key' => 'member_type',
										'value' => 'tenant',
										'compare' => '='
									)
								)
							);
							
							$old_tenant = get_users($args);
							$old_tenant_owner = $old_tenant[0]->owner_id;
							if (!empty($old_tenant_owner)) {
								$owner_data = json_decode($old_tenant_owner);
								
								// Initialize an array to hold the updated owner data
								$updated_owner_data = array();
								
								// Update the status of the existing owners
								foreach ($owner_data as $owner) {
									if (isset($owner->status) && $owner->status === 'active') {
										$owner->status = 'vacate';
									}
									$updated_owner_data[] = $owner;
								}
								
								// Add the new owner with the 'active' status
								$user_id = intval($user_id);
								$new_owner_data = array("owner_id" => "$user_id", "status" => "active");
								$updated_owner_data[] = (object) $new_owner_data;
							
								$updated_owner_data_json = wp_json_encode($updated_owner_data);
								$update_tenants_owner =  update_user_meta($old_tenant[0]->ID, 'owner_id', $updated_owner_data_json);
							
							}
						}
						else{
							$historydata['member_id'] = intval($user_id);
							
							$result = $wpdb->insert($table_amgt_tenant_unit_occupied_history, $historydata);

							$add_owner_id = sanitize_text_field($data['owner_id']);
							$owner_data[] = array("owner_id" => "$add_owner_id", "status" => "active");
							$usermetadata['owner_id'] = wp_json_encode($owner_data);
						}
					}
				}
			}
			$user = new WP_User($user_id);
			$user->set_role($data['role']);
			foreach ($usermetadata as $key => $val) {
				
				$returnans = add_user_meta($user_id, $key, $val, true);
			}
			if (isset($data['first_name']))
				$returnans = update_user_meta($user_id, 'first_name', $data['first_name']);
			if (isset($data['last_name']))
				$returnans = update_user_meta($user_id, 'last_name', $data['last_name']);
			//adds committee member mail template
			if ($usermetadata['committee_member'] == 'yes') {

				$user_info = get_userdata($user_id);
				$to = $user_info->user_email;
				$subject = get_option('wp_amgt_Member_Become_committee_subject');
				$loginlink = home_url() . '/apartment-management/';
				$apartmentname = get_option('amgt_system_name');
				$subject_search = array('{{apartment_name}}');
				$subject_replace = array($apartmentname);
				$message_content = get_option('wp_amgt_Member_Become_committee_email_template');
				$search = array('{{member_name}}', '{{apartment_name}}', '{{loginlink}}');
				$replace = array(
						esc_html($user_info->display_name),
						esc_html($apartmentname),
						esc_url($loginlink),
					);
				$subject = str_replace($subject_search, $subject_replace, $subject);
				$message_content = str_replace($search, $replace, $message_content);
				MJ_amgt_SendEmailNotification($to, $subject, $message_content);

				//---------------- SEND  SMS ------------------//
				
				$apartmentname=get_option('amgt_system_name');
				$message_content ="Dear $user_info->display_name, Congratulations!! You have been appointed as committee member of Committee, $apartmentname.";
				$send_sms = MJ_amgt_send_sms_notification(intval($user_id),'Appointed as Committee Member',$message_content);

				// ================= SEND PUSH NOTIFICATION==========================
			
				$send_data['type']="commettiee_member";
				$send_data['loginlink']=$loginlink;
				$send_push_notification = MJ_amgt_send_push_notification(intval($user_id),$send_data);

			}
			//ADD USER TIME SEND MAIL 
			$user_info = get_userdata(intval($user_id));
			$to = sanitize_email($user_info->user_email);
			$subject = get_option('wp_amgt_add_user_subject');
			$apartmentname = get_option('amgt_system_name');
			$message_content = get_option('wp_amgt_add_user_email_template');
			$loginlink = home_url() . '/apartment-management/';
			$arrayvar = explode("_", $data['role']);
			$role = "";
			foreach ($arrayvar as $name) {
				$role .= $name . " ";
			}
			$rolename = ucwords($role);

			$subject_search = array('{{rolename}}', '{{apartment_name}}');
			$subject_replace = array($rolename, $apartmentname);
			$search = array('{{member_name}}', '{{apartment_name}}', '{{rolename}}', '{{loginlink}}', '{{email}}', '{{password}}');
			$replace = array(
				esc_html($user_info->display_name),
				esc_html($apartmentname),
				esc_html($rolename),
				esc_url($loginlink),
				esc_html(sanitize_email($data['email'])),
				esc_html($data['password']) // Note: Consider never emailing passwords if possible!
			);


			$subject = str_replace($subject_search, $subject_replace, $subject);
			$message_content = str_replace($search, $replace, $message_content);
			MJ_amgt_SendEmailNotification($to, $subject, $message_content);

			// ==================Family Member details Mail ===================

			if (!empty($data['family_type'][0])) {

				$get_owner_family_ids = get_user_meta(intval($user_id),'family_member_id',true);

				if(!empty($get_owner_family_ids) && is_array($get_owner_family_ids))
				{
					foreach($get_owner_family_ids as $family_member_id)
					{
						$family_info = get_userdata(intval($family_member_id));
						$display_name[] = sanitize_email($family_info->user_email);
					}
				}
				$subject = esc_html__('Family Member Details', 'apartment_mgt');
				$array_implode = implode(', ', $display_name);
				$password= sanitize_text_field($data['mobile']);
				$display_name = sanitize_text_field($user_info->display_name);
				$display_name_safe = esc_html($user_info->display_name);
				$array_implode_safe = esc_html($array_implode);
				$password_safe = esc_html($password);

				$message_content = "Dear $display_name_safe, Your family member details:
				Email : $array_implode_safe
				Password : $password_safe";

				MJ_amgt_SendEmailNotification($to, $subject, $message_content);
			}

			return $user_id;
		}
	}
	//DELETE USERDATA
	public function MJ_amgt_delete_usedata($record_id) {
		global $wpdb;
	
		// Ensure the record_id is an integer
		$record_id = intval($record_id);
	
		// Retrieve user data safely
		$user_data = get_userdata($record_id);
		if (!$user_data) {
			return false; // User not found
		}
	
		// Sanitize the member name (for any potential malicious input)
		$member_name = sanitize_text_field($user_data->display_name);
	
		// Tables
		$table_name = $wpdb->prefix . 'usermeta';
		$table_amgt_unit_occupied_history = $wpdb->prefix . 'amgt_unit_occupied_history';
	
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE user_id = %d", $record_id));
	
		$returnval = wp_delete_user($record_id);
		if (!$returnval) {
			return false;
		}
		$history_result = $wpdb->get_row($wpdb->prepare("SELECT id FROM $table_amgt_unit_occupied_history WHERE member_name = %s", $member_name));
	
		if ($history_result && isset($history_result->id)) {
			$whereid = array('id' => $history_result->id);
			$historydata = array(
				'occupied_to_date' => date('Y-m-d')
			);
			$result_update_history = $wpdb->update($table_amgt_unit_occupied_history, $historydata, $whereid);
	
			if ($result_update_history === false) {
				return false;
			}
		}
		return $returnval;
	}
	
	public function delete_user_and_update_family_member_id($user_id)
	{
		global $wpdb;
		// Get the owner's user ID from the family member's usermeta
		$owner_id = get_user_meta(intval($user_id), 'member_id', true);
		if ($owner_id) {
			// Get the current family_member_id value of the owner
			$family_member_ids = get_user_meta(intval($owner_id), 'family_member_id', true);
			// Remove the deleted member ID from the family_member_id array
			$index = array_search(intval($user_id), $family_member_ids);
			if ($index !== false) {
				unset($family_member_ids[$index]);
				$updated_family_member_ids = $family_member_ids;
				// Update the owner's family_member_id field
				update_user_meta(intval($owner_id), 'family_member_id', $updated_family_member_ids);
			}
		}
		// Delete usermeta and user data
		$wpdb->query($wpdb->prepare("DELETE FROM {$wpdb->usermeta} WHERE user_id = %d", intval($user_id)));
		$wpdb->query($wpdb->prepare("DELETE FROM {$wpdb->users} WHERE ID = %d", intval($user_id)));

		return true;
	}



	public function MJ_amgt_delete_all_user($record_id)
	{
		global $wpdb;

		$table_name = $wpdb->prefix . 'usermeta';
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE user_id= %d", intval($record_id)));
		$retuenval = wp_delete_user(intval($record_id));
		return $retuenval;
	}

	//UPLOAD USER DOCUMENT FUNCTION
	public function MJ_amgt_upload_documents($id_proof_1, $id_proof_2, $document_title, $upload_docs_array, $user_id)
	{
		$usermetadata['id_proof_1'] = $id_proof_1;
		$usermetadata['id_proof_2'] = $id_proof_2;

		foreach ($usermetadata as $key => $val) {
			$returnans = add_user_meta(intval($user_id), $key, $val, true);
		}
		if (!empty($upload_docs_array)) {
			$returnans1 = array();
			foreach ($document_title as $key => $value) {
				$title = sanitize_text_field($value);
    $filename = sanitize_file_name($upload_docs_array[$key]);
				 $returnans1[] = array("title" => $title, "value" => $filename);
			}
			$doc_data = json_encode($returnans1);
			$doc_result = add_user_meta(intval($user_id), "document", $doc_data, true);
		}
	}

	//UPLOAD USER DOCUMENT FUNCTION

	public function MJ_amgt_update_upload_documents($id_proof_1, $id_proof_2, $document_title, $upload_docs_array, $user_id)
	{
		$user_id = intval($user_id);
		$usermetadata['id_proof_1'] = sanitize_text_field($id_proof_1);
    	$usermetadata['id_proof_2'] = sanitize_text_field($id_proof_2);
		
		foreach ($usermetadata as $key => $val) {
			$returnans = update_user_meta($user_id, $key, $val);
		}

		if (!empty($upload_docs_array)) {
			$returnans1 = array();
			foreach ($document_title as $key => $value) {
				 $title = sanitize_text_field($value);
    $filename = sanitize_file_name($upload_docs_array[$key]);
				$returnans1[] = array("title" => $title, "value" => $filename);
			}
			$doc_data = json_encode($returnans1);
			$doc_result = update_user_meta($user_id, "document", $doc_data);
		}
	}

	public function MJ_amgt_add_family_member($data, $member_id)
	{
		$member_id = intval($member_id);
		$usermetadata = get_userdata($member_id);

		$family_member_ids = array();
		if (!empty($data['family_type'])) {
			// Fetch existing family_member_ids
			$existing_family_member_ids = get_user_meta($member_id, 'family_member_id', true);
			if (!is_array($existing_family_member_ids)) {
				$existing_family_member_ids = array();
			}

			foreach ($data['family_type'] as $key => $value) {
				$member_email = explode('@', sanitize_email($usermetadata->data->user_email));
				$family_email = $member_email[0] . '+' . $data['family_first_name'][$key] . '@' . $member_email[1];

				$familyUserdata = array();
				$familyusermetadata = array();

				$familyUserdata['user_email'] = sanitize_email($family_email);
				$familyUserdata['user_login'] = sanitize_text_field($family_email);
				$familyUserdata['display_name'] = sanitize_text_field($data['family_first_name'][$key] . " " . $data['family_last_name'][$key]);
				$familyUserdata['user_pass'] = sanitize_text_field($usermetadata->mobile);

				$familyusermetadata['first_name'] = sanitize_text_field($data['family_first_name'][$key]);
				$familyusermetadata['last_name'] = sanitize_text_field($data['family_last_name'][$key]);
				$familyusermetadata['birth_date'] = sanitize_text_field($data['family_birth_date'][$key]);
				$familyusermetadata['gender'] = sanitize_text_field($data['family_gender_' . $key]);
				$familyusermetadata['mobile'] = sanitize_text_field($data['family_mobile'][$key]);


				$familyusermetadata['building_id'] = sanitize_text_field($usermetadata->building_id);
				$familyusermetadata['unit_cat_id'] = sanitize_text_field($usermetadata->unit_cat_id);
				$familyusermetadata['unit_name'] = sanitize_text_field($usermetadata->unit_name);

				$familyusermetadata['member_type'] = sanitize_text_field(MJ_amgt_strip_tags_and_stripslashes($data['family_type'][$key]));

				if (!empty($familyUserdata)) {
					$familyUser_id = wp_insert_user($familyUserdata);

					if (is_wp_error($familyUser_id)) {
						error_log('Error inserting user: ' . $familyUser_id->get_error_message());
						// Handle the error, e.g., display a message or return early
						continue; // Skip to the next iteration of the loop
					} else {
						$familyusermetadata['member_id'] = sanitize_text_field($member_id);

						foreach ($familyusermetadata as $meta_key => $meta_value) {
							update_user_meta($familyUser_id, $meta_key, $meta_value);
						}
						$family_user = new WP_User(intval($familyUser_id));
						$family_user->set_role($data['role']);
						// Add the new family member ID to the list
						$existing_family_member_ids[] = intval($familyUser_id);
					}
				}
			}
			// Remove duplicates from the family_member_ids array
			$existing_family_member_ids = array_unique($existing_family_member_ids);

			// Update the owner's family_member_id field
			update_user_meta($member_id, 'family_member_id', $existing_family_member_ids);

			// ==================Family Member details Mail ===================

			$get_owner_family_ids = get_user_meta($member_id,'family_member_id',true);

			$to = sanitize_email($usermetadata->user_email);
			if(!empty($get_owner_family_ids))
			{
				foreach($get_owner_family_ids as $family_member_id)
				{
					$family_info = get_userdata($family_member_id);
					$display_name[] = sanitize_email($family_info->user_email);
				}
			}
			$subject = esc_html__('Family Member Details', 'apartment_mgt');
			$array_implode = implode(', ', $display_name);
			$password= $usermetadata->mobile;
			$message_content = "Dear $user_info->display_name ,
				Your family member details:
				Email : $array_implode
				Password : $password";
			MJ_amgt_SendEmailNotification($to, $subject, $message_content);
		}
		return $familyUser_id;

	}
	public function MJ_amgt_delete_family_usedata($record_id)
	{
		global $wpdb;
		$record_id = intval($record_id);
		$get_owner_id = get_user_meta($record_id,'member_id',true);
		$get_owner_id = intval($get_owner_id);
		$get_owner_family_ids =  get_user_meta($get_owner_id,'family_member_id',true);

		$key = array_search($record_id, $get_owner_family_ids);
		
		if ($key !== false) {
			unset($get_owner_family_ids[$key]);
		}
		$update_OwnerFamilyMemberId = update_user_meta($get_owner_id, 'family_member_id', $get_owner_family_ids);
		$get_owner_family_ids =  get_user_meta($get_owner_id,'family_member_id',true);
	
		$user_data = get_userdata($record_id);
		$member_name = sanitize_text_field($user_data->display_name);
		$table_name = $wpdb->prefix . 'usermeta';
		$table_amgt_unit_occupied_history = $wpdb->prefix . 'amgt_unit_occupied_history';
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE user_id= %d", $record_id));
		$retuenval = wp_delete_user($record_id);
		// $history_result = $wpdb->get_row("SELECT id FROM $table_amgt_unit_occupied_history where member_name='$member_name'");

		// $whereid['id'] = $history_result->id;
		// $historydata['occupied_to_date'] = date('Y-m-d');
		// $result_update_history = $wpdb->update($table_amgt_unit_occupied_history, $historydata, $whereid);
		return $retuenval;
	}
	public function MJ_amgt_delete_tenant_userdata($record_id)
	{
		global $wpdb;
		$record_id = intval($record_id);
		$user_data = get_userdata($record_id);
		$member_name = sanitize_text_field($user_data->display_name);
		$table_name = $wpdb->prefix . 'usermeta';
		$table_amgt_tenant_unit_occupied_history = $wpdb->prefix . 'amgt_tenant_tenant_unit_occupied_history';
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE user_id= %d", $record_id));
		$retuenval = wp_delete_user($record_id);
		$history_result = $wpdb->get_row($wpdb->prepare("SELECT id FROM $table_amgt_tenant_unit_occupied_history WHERE member_name = %s", $member_name));

		$whereid['id'] = $history_result->id;
		$historydata['occupied_to_date'] = date('Y-m-d');
		$result_update_history = $wpdb->update($table_amgt_tenant_unit_occupied_history, $historydata, $whereid);

		return $retuenval;
	}

}
?>