<?php
class MJ_amgt_Facility
{	
    //ADD FACILITY DOCUMENT FUNCTION
	public function MJ_amgt_add_facility($data)
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility';
		$facilitydata['facility_name']=sanitize_text_field($data['facility_name']);
		$facilitydata['facility_charge']=sanitize_text_field($data['facility_charge']);
		$facilitydata['charge_per']=sanitize_text_field($data['charge_per']);
		$facilitydata['allow_booking_multiple_base'] = 0;
		if(isset($data['allow_booking_multiple_base']))
		$facilitydata['allow_booking_multiple_base']=sanitize_text_field($data['allow_booking_multiple_base']);		
		$facilitydata['created_date']=date('Y-m-d');
		
		if($data['action']=='edit')	
		{
			$whereid['facility_id']=intval($data['facility_id']);
			$result=$wpdb->update( $table_amgt_facility, $facilitydata ,$whereid);
			apartment_append_audit_log('' . esc_html__('Facility Updated', 'apartment_mgt') . ' ('.sanitize_text_field($data['facility_name']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			$facilitydata['created_by']=get_current_user_id();
			$result=$wpdb->insert( $table_amgt_facility, $facilitydata );
			apartment_append_audit_log('' . esc_html__('Facility Added', 'apartment_mgt') . ' ('.sanitize_text_field($data['facility_name']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	}
	//ADD BOOK FACILITY FUNCTION
	public function MJ_amgt_book_facility($data)
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility_booking';
		$bookdata['facility_id']=sanitize_text_field($data['facility_id']);
		$bookdata['activity_id']=sanitize_text_field($data['activity_id']);
		$bookdata['status']=sanitize_text_field($data['status']);
		$bookdata['period_type']=MJ_amgt_strip_tags_and_stripslashes($data['period_type']);
		if(isset($data['start_date']))
		{
			$bookdata['start_date']=MJ_amgt_get_format_for_db($data['start_date']);
		}
		if(isset($data['end_date']))
		{
			$bookdata['end_date'] = MJ_amgt_get_format_for_db($data['end_date']);
		}
		if(isset($data['start_time']))
		{
			$bookdata['start_time'] = $data['start_time'];
		}
		if(isset($data['end_time']))
		{
			$bookdata['end_time'] = $data['end_time'];
		}
		$bookdata['booking_cost'] = sanitize_text_field($data['facility_charge']);
		$bookdata['book_on_behalf_of'] = sanitize_text_field($data['on_behalf_of']);
		$bookdata['created_date']=date('Y-m-d');
		
		if($data['action']=='edit')
		{
			$whereid['id']=intval($data['facility_booking_id']);
			$result=$wpdb->update( $table_amgt_facility, $bookdata ,$whereid);
			apartment_append_audit_log('' . esc_html__('Booking Facility Updated', 'apartment_mgt') . ' ('.MJ_amgt_get_facility_name($data['facility_id']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			$bookdata['created_by']=sanitize_text_field(get_current_user_id());
			$result=$wpdb->insert( $table_amgt_facility, $bookdata );

			apartment_append_audit_log('' . esc_html__('Booking Facility Added', 'apartment_mgt') . ' ('.MJ_amgt_get_facility_name($data['facility_id']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));

			$retrieved_data=get_userdata($bookdata['book_on_behalf_of']);
			$to = $retrieved_data->user_email; 
			
			$subject =get_option('wp_amgt_book_facility_subject');
			$apartmentname=get_option('amgt_system_name');
			$message_content=get_option('wp_amgt_book_facility_email_template');
			$facility=$this->MJ_amgt_get_single_facility($bookdata['facility_id']);
			$facility_name=$facility->facility_name;
			$facility_charge=$facility->facility_charge;
			
			$currentuser=get_userdata(get_current_user_id());
			$booked_user_name=$currentuser->display_name;
			
			$activitpost=get_post($bookdata['activity_id']);
			$activity_name=$activitpost->post_title;
			$start_date="";
			$end_date="";
			$start_time="";
			$end_time="";
			$booking_cost=0;
			if(isset($bookdata['start_date']))
			{
				$start_date=$bookdata['start_date'];
			}
			if(isset($bookdata['end_date']))
			{
				$end_date = $bookdata['end_date'];
			}
			
			if(isset($bookdata['start_time']))
			{
				$start_time = $bookdata['start_time'];
			}
			if(isset($bookdata['end_time']))
			{
				$end_time = $bookdata['end_time'];
			}
			if(isset($bookdata['booking_cost']))
			{
				$booking_cost = $bookdata['booking_cost'];	
			}
			if($result)
			{
				//---------------- SEND  SMS ------------------//
				if(isset($_POST['amgt_sms_service_enable']))
				{
					$apartmentname=get_option('amgt_system_name');
					$message_content ="$facility_name has been successfully booked for you from $apartmentname.";
					$send_sms = MJ_amgt_send_sms_notification($retrieved_data->ID,'Booked Facilty',$message_content);
				}
				// ================= SEND PUSH NOTIFICATION==========================
				
				$send_data['type']="booked_facility";
				$send_data['facility_name']=$facility_name;
				$send_push_notification = MJ_amgt_send_push_notification($retrieved_data->ID,$send_data);
			
				if($data['user_type'] == 'admin')
				{
					$page_link=home_url().'/??apartment-dashboard=user&page=facility&tab=facility-booking-list';
					$subject_search=array('{{booked_user_name}}','{{activity_name}}','{{from_date}}','{{from_time}}');
					$subject_replace=array($booked_user_name,$activity_name,$start_date,$start_time);
					$subject=str_replace($subject_search,$subject_replace,$subject);
					
					$search=array('{{member_name}}','{{apartment_name}}','{{facility_name}}','{{booked_user_name}}','{{activity_name}}','{{from_date}}','{{to_date}}','{{from_time}}','{{to_time}}','{{facility_charge}}','{{facility_link}}');
					if(empty($end_date))
					{
						$new_end_date=$start_date;
					}
					else
					{
						$new_end_date=$end_date;
					}
					
					$replace = array($retrieved_data->display_name,$apartmentname,$facility_name,$booked_user_name,$activity_name,$start_date,$new_end_date,$start_time,$end_time,$booking_cost,$page_link);
					$message_content = str_replace($search, $replace, $message_content);
					if(isset($_POST['amgt_mail_service_enable']))
					{
						MJ_amgt_SendEmailNotification($to,$subject,$message_content);
					}
				}
				else
				{
					$user_info = get_userdata(1);
                    $user_name = sanitize_text_field($user_info->display_name);
					$to1=sanitize_email($user_info->user_email);
					$admin_subject =get_option('wp_amgt_book_facility_subject_admin');
					$admin_message_content=get_option('wp_amgt_book_facility_email_template_admin');
					$page_link=home_url().'/??apartment-dashboard=user&page=facility&tab=facility-booking-list';
					$subject_search=array('{{member_name}}','{{apartment_name}}');
					$subject_replace=array($retrieved_data->display_name,$apartmentname);
					$subject=str_replace($subject_search,$subject_replace,$admin_subject);
					
					$search=array('{{admin_name}}','{{facility_name}}','{{member_name}}','{{apartment_name}}','{{activity_name}}','{{facility_charge}}','{{from_date}}','{{to_date}}','{{from_time}}','{{to_time}}','{{facility_link}}');
					if(empty($end_date))
					{
						$new_end_date=$start_date;
					}
					else
					{
						$new_end_date=$end_date;
					}
					$replace = array($user_name,$facility_name,$retrieved_data->display_name,$apartmentname,$activity_name,$booking_cost,$start_date,$new_end_date,$start_time,$end_time,$page_link);
					$message_content = str_replace($search, $replace, $admin_message_content);
					if(isset($_POST['amgt_mail_service_enable']))
					{
						MJ_amgt_SendEmailNotification($to1,$subject,$message_content);
					}	
				}
			}
			return $result;
		}
	}
	//GET ALL FACILITY FUNCTION
	public function MJ_amgt_get_all_facility()
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility';
		$result = $wpdb->get_results("SELECT * FROM $table_amgt_facility");
		return $result;
	}
	//GET ALL BOOKED FACILITY FUNCTION
	public function MJ_amgt_get_all_booked_facility()
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility_booking';
	
		$result = $wpdb->get_results("SELECT * FROM $table_amgt_facility");
		return $result;
	
	}
	// GET OWN BOOK FACILITY
	public function MJ_amgt_get_own_booked_facility($user_id)
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility_booking';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_amgt_facility WHERE created_by = %d OR book_on_behalf_of = %d",intval($user_id), intval($user_id)));		
		return $result;
	}
	// GET SINGLE FACILITY
	public function MJ_amgt_get_single_facility($facility_id)
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_amgt_facility WHERE facility_id = %d",intval($facility_id)));
		return $result;
	}
	//GET SINGLE BOOKED FACILITY
	public function MJ_amgt_get_single_boooked_facility($id)
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility_booking';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_amgt_facility WHERE id = %d",intval($id)));		
		return $result;
	}
	// DELETE FACILITY
	public function MJ_amgt_delete_facility($facility_id)
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility';
		$facility_name = $wpdb->get_row($wpdb->prepare("SELECT facility_name FROM $table_amgt_facility where facility_id= %d ", $facility_id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_amgt_facility WHERE facility_id = %d",intval($facility_id)));		
		apartment_append_audit_log('' . esc_html__('Facility Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($facility_name->facility_name).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}
	//DELETE BOOKED FACILITY FUNCTION
	public function MJ_amgt_delete_booked_facility($id)
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility_booking';
		$facility_name = $wpdb->get_row($wpdb->prepare("SELECT facility_id FROM $table_amgt_facility where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_amgt_facility WHERE id = %d",intval($id)));
		apartment_append_audit_log('' . esc_html__('Booked Facility Deleted', 'apartment_mgt') . ' ('.MJ_amgt_get_facility_name($facility_name->facility_id).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}
	//--------- GET ALL BOOKED FACILITY BY MEMBER ID -----------//
	public function MJ_amgt_get_all_booked_facility_bt_memberid($id)
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility_booking';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_amgt_facility WHERE book_on_behalf_of = %d",intval($id)));
		return $result;
	}

	//GET ALL FACILITY FUNCTION FOR DASHBOARD
	public function MJ_amgt_get_all_facility_for_dashboard()
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_amgt_facility ORDER BY facility_id DESC LIMIT %d", 5));
		return $result;
	}
	//GET ALL FACILITY FUNCTION FOR DASHBOARD
	public function MJ_amgt_get_all_booked_facility_for_dashboard()
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility_booking';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_amgt_facility ORDER BY facility_id DESC LIMIT %d", 5));
		return $result;
	}
	// GET OWN BOOK FACILITY FOR DASHBOARD
	public function MJ_amgt_get_own_booked_facility_for_dashboard($user_id)
	{
		$user_id = intval($user_id);
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility_booking';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_amgt_facility WHERE created_by = %d OR book_on_behalf_of = %d ORDER BY facility_id DESC LIMIT %d", $user_id, $user_id, 5));
		return $result;
	}
	//GET title BOOKED FACILITY FUNCTION
	public function MJ_amgt_get_title_booked_facility($id)
	{
		global $wpdb;
		$table_amgt_facility = $wpdb->prefix. 'amgt_facility';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_amgt_facility WHERE facility_id = %d", intval($id)));
		return $result;
	}
}
?>