<?php
class MJ_amgt_Document
{	
   //ADD DOCUMENT FUNCTION
	public function MJ_amgt_add_document($data,$upload_docs_array)
	{ 
      	global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_document';
	    $document_title=$data['doc_title'];
	    $document_description=$data['description'];
		
		if($data['action']=='edit')
		{ 
			$documentdata['doc_title']=sanitize_text_field($data['doc_title']);
			$documentdata['building_id']=sanitize_text_field($data['building_id']);
			$documentdata['unit_cat_id']=sanitize_text_field($data['unit_cat_id']);
			$documentdata['unit_name']=MJ_amgt_strip_tags_and_stripslashes($data['unit_name']);
			$documentdata['member_id']=sanitize_text_field($data['member_id']);
			$documentdata['document_content'] = sanitize_text_field($upload_docs_array);

			$documentdata['description']=sanitize_textarea_field($data['description']);
			$documentdata['created_date']=date('Y-m-d');
			$documentdata['created_by']=sanitize_text_field(get_current_user_id());
			$documentdata['category_id']=sanitize_text_field($data['category_id']);
			$whereid['id']=intval($data['document_id']);
			$result=$wpdb->update( $table_name, $documentdata ,$whereid);
			apartment_append_audit_log('' . esc_html__('Document Updated', 'apartment_mgt') . ' ('.sanitize_text_field($data['doc_title']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			if(!empty($document_title))
			{	
				foreach($document_title as $key => $value)
				{
					$user_avatar=$upload_docs_array[$key];
					$document_description=$document_description[$key];

					if($data['member_id']=="all_member")
					{
						$building_id=$data['building_id'];
						$membersdata = get_users(
							array(
								'role' => 'member',						
								'meta_query' => array(
								'relation' => 'AND',
								array(
									'key' => 'building_id',
									'value' =>intval($building_id),
									'compare' => '='
								),
								array(
									'key'	  =>'unit_cat_id',
									'value'	=>	intval($data['unit_cat_id']),
									'compare' => '=',
								),
							)
						));
						foreach($membersdata as $retrive_data)
						{
							$unit_cat_id =get_user_meta( intval($retrive_data->ID),'unit_cat_id',true ); 
							$unit_name =get_user_meta( intval($retrive_data->ID),'unit_name',true ); 

							$documentdata['doc_title']=sanitize_text_field($value);
							$documentdata['building_id']= intval($data['building_id']);
							$documentdata['unit_cat_id']=sanitize_text_field(intval($unit_cat_id));
							$documentdata['unit_name']=MJ_amgt_strip_tags_and_stripslashes($unit_name);
							$documentdata['member_id']=sanitize_text_field(intval($retrive_data->ID));
							$documentdata['document_content']=sanitize_text_field($user_avatar);
							$documentdata['description']=sanitize_textarea_field($document_description);
							$documentdata['created_date']=date('Y-m-d');
							$documentdata['created_by']=sanitize_text_field(get_current_user_id());
							$documentdata['category_id']=sanitize_text_field(intval($data['category_id']));
							$result=$wpdb->insert( $table_name, $documentdata );
						}
					}
					else
					{
						$documentdata['doc_title']=sanitize_text_field($value);
						$documentdata['building_id']=sanitize_text_field(intval($data['building_id']));
						$documentdata['unit_cat_id']=sanitize_text_field(intval($data['unit_cat_id']));
						$documentdata['unit_name']=MJ_amgt_strip_tags_and_stripslashes($data['unit_name']);
						$documentdata['member_id']=sanitize_text_field(intval($data['member_id']));
						$documentdata['document_content']=$user_avatar;
						$documentdata['description']=sanitize_text_field($document_description);
						$documentdata['created_date']=date('Y-m-d');
						$documentdata['created_by']=sanitize_text_field(get_current_user_id());
						$documentdata['category_id']=sanitize_text_field(intval($data['category_id']));
						$result=$wpdb->insert( $table_name, $documentdata );
					}
				}
			}
			apartment_append_audit_log('' . esc_html__('Document Added', 'apartment_mgt') . ' ('.sanitize_text_field($value).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	}
	//GET ALL DOCUMENT FUNCTION
	public function MJ_amgt_get_all_documents()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_document';
		$result = $wpdb->get_results("SELECT * FROM $table_name");
		return $result;
	}
	//GET ALL DOCUMENT FUNCTION
	public function MJ_amgt_get_own_documents($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_document';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE member_id = %d OR created_by = %d",intval($user_id),intval($user_id)));
		return $result;
	}
	//GET ALL UNIT DOCUMENT 
	public function MJ_amgt_get_units_all_documents($unitname)
	{
		$unitname = sanitize_text_field($unitname);

		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_document';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE unit_name = %s ORDER BY created_date DESC",$unitname));
		return $result;
	}
	// GET ALL DOCUMENT BY UNIT
	public function MJ_amgt_get_units_all_documents_new($unitname,$building_id)
	{
		$unitname = sanitize_text_field($unitname);

		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_document';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE unit_name = %s AND building_id = %d ORDER BY created_date DESC",$unitname,$building_id));
		return $result;
	}
	// GET ALL DOCUMENT BY UNIT FOR JSON 
	public function MJ_amgt_get_units_all_documents_new_json($unitname)
	{
		$result = array();
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_document';
		if (!empty($unitname)) {
			$unitnames = json_decode($unitname);
			
			if (is_array($unitnames)) {
				foreach ($unitnames as $value) {
					// Ensure unit_name is properly escaped using prepared statements
					$query = $wpdb->prepare(
						"SELECT * FROM $table_name WHERE unit_name = %s ORDER BY created_date DESC",
						$value->unit_name
					);
					$result[] = $wpdb->get_row($query);
				}
			}
		}
		return $result;
	}
	
	//GET SINGLE DOCUMENT FUNCTION
	public function MJ_amgt_get_single_document($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_document';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d",$id));
		return $result;
	}
	// DELETE DOCUMENTS
	public function MJ_amgt_delete_document($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_document';
		$document_name = $wpdb->get_row($wpdb->prepare("SELECT doc_title FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d",$id));
		apartment_append_audit_log('' . esc_html__('Document Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($document_name->doc_title).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}
	//GET MEMBER DOCUMENT
	public function MJ_amgt_get_member_document($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_document';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE member_id = %d",$id));
		return $result;
	}
	//----------------- GET ALL DOCUMENT BY MEMBER ID --------------//
	public function MJ_amgt_get_all_documents_by_member_id($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_document';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE member_id = %d",$user_id));
		return $result;
	}
}
?>