<?php
class MJ_amgt_Complaint
{	
	//ADD COMPLAIN FUNCTION
	public function MJ_amgt_add_complaint($data,$file_name)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		if($data['complaint_nature'] == 'Maintenance Request')
		{
			$complaintdata['complain_date']=MJ_amgt_get_format_for_db($data['date']);
			$complaintdata['time'] = sanitize_text_field($data['time']);

		}
		else
		{
			$complaintdata['complain_date']=MJ_amgt_get_format_for_db($data['complain_date']);
			$complaintdata['time']='';
		}
		$complaintdata['complaint_cat']=sanitize_text_field($data['category']);
		$complaintdata['complaint_nature']=sanitize_text_field($data['complaint_nature']);
		$complaintdata['complaint_member_id']=sanitize_text_field($data['member_id']);
		$complaintdata['complaint_type']=MJ_amgt_strip_tags_and_stripslashes($data['type']);
		$complaintdata['complaint_description'] = sanitize_textarea_field($data['description']);

		$complaintdata['complain_title']=sanitize_text_field($data['complain_title']);
		$complaintdata['created_date']=date('Y-m-d');
		if(!empty($file_name))
		{
			$complaintdata['complain_doc']=sanitize_file_name($file_name);
		}
		else
		{
			$complaintdata['complain_doc']=null;
		}
		
		if($data['action']=='edit')
		{
			$complaintdata['complaint_status']=sanitize_text_field($data['status']);
			$complaintdata['resolution']=sanitize_text_field($data['resolution']);
			$whereid['id']=intval($data['complaint_id']);
			$result=$wpdb->update( $table_name, $complaintdata ,$whereid);
			apartment_append_audit_log('' . esc_html__('Complain Updated', 'apartment_mgt') . ' ('.sanitize_text_field($data['complain_title']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			$complaintdata['complaint_status']='open';
			$complaintdata['resolution']='';
			//--------NOTICE NOTIFICATION EMAIL CODE-------
			if($complaintdata['complaint_type']=='individual')
			{	
				$retrieved_data=get_userdata(intval($data['member_id']));
				$to = sanitize_email($retrieved_data->user_email); 
				$member_name=sanitize_text_field($retrieved_data->display_name);

				//---------------- SEND  SMS ------------------//
				if(isset($_POST['amgt_sms_service_enable']))
					$amgt_sms_service_enable = $_POST['amgt_sms_service_enable'];
				if($amgt_sms_service_enable)
				{
					$apartmentname=get_option('amgt_system_name');
					$message_content ="Dear $member_name, New Complaint added in $apartmentname.";
					$send_sms = MJ_amgt_send_sms_notification($data['member_id'],'New Complaint',$message_content);
				}
				// ================= SEND PUSH NOTIFICATION=======================
				
				$send_data['type']="complaint";
				$send_push_notification = MJ_amgt_send_push_notification(intval($data['member_id']),$send_data);
				
				
		        //SEND NOTICE NOTIFICATION MEMBER //
				$retrieved_data=get_userdata(intval($data['member_id']));
				$to = sanitize_email($retrieved_data->user_email); 
				$member_name=sanitize_text_field($retrieved_data->display_name);
				$subject =get_option('wp_amgt_add_complaint_subject');
				$apartmentname=get_option('amgt_system_name');
				$page_link=home_url().'/?apartment-dashboard=user&page=complaint&tab=complaintlist';
				$message_content=get_option('wp_amgt_add_complaint_email_template');
				$catdata=get_post($complaintdata['complaint_cat']);
				if(!empty($complaintdata['complaint_cat']))
				{
					$category = esc_html($catdata->post_title);

				}
				else
				{
					$category="-";
				}
				$apartmentnumber=get_user_meta(intval($retrieved_data->ID),'unit_name',true);
				$apartmentnumber=MJ_amgt_get_member_assing_unit_name($apartmentnumber);
				
				$fromdata=get_userdata(get_current_user_id());
				$complaintfrom=sanitize_text_field($fromdata->display_name);
				$useremail=sanitize_email($fromdata->user_email);
				$subject_search=array('{{member_name}}','{{apartment_name}}');
		        $subject_replace=array($member_name,$apartmentname);
				$subject=str_replace($subject_search,$subject_replace,$subject);
				$search=array('{{member_name}}','{{apartment_name}}','{{nature}}','{{noticetype}}','{{noticecategory}}','{{complaintstatus}}','{{description}}','{{apartmentnumber}}','{{complainfrom}}','{{Complain_Link}}');
				$replace = array_map('esc_html', [ $member_name,$apartmentname,$complaintdata['complaint_nature'],$complaintdata['complaint_type'],$category,$complaintdata['complaint_status'],$complaintdata['complaint_description'],$apartmentnumber,$complaintfrom,$page_link]);
				$message_content = str_replace($search, $replace, $message_content);
				
				if(isset($_POST['amgt_mail_service_enable']))
				{
					MJ_amgt_SendEmailNotification($to,$subject,$message_content);
				}
				
				//send mail notification for admin//
				$admin_subject =get_option('wp_amgt_Admin_Complain');
				$page_link=admin_url().'admin.php?page=amgt-complaint&tab=complaintlist';
				$admin_subject_search=array('{{member_name}}','{{apartment_name}}');
		        $admin_subject_replace=array($member_name,$apartmentname);
				$admin_subject=str_replace($admin_subject_search,$admin_subject_replace,$admin_subject);
				$admin_message_content=get_option('wp_amgt_admin_complain_email_template');
			    $blogusers = get_users( [ 'role__in' => [ 'administrator'] ] );
				foreach ( $blogusers as $user ) 
				{
					$email =sanitize_email($user->user_email) ;
					$display_name=sanitize_text_field($user->display_name);
					
					$admin_search=array('{{admin_name}}','{{apartment_name}}','{{nature}}','{{noticetype}}','{{noticecategory}}','{{complaintstatus}}','{{description}}','{{apartmentnumber}}','{{complainfrom}}','{{complainto}}','{{Admin_Complain_Link}}');
					$admin_replace = array($display_name,$apartmentname,$complaintdata['complaint_nature'],$complaintdata['complaint_type'],$category,$complaintdata['complaint_status'],$complaintdata['complaint_description'],$apartmentnumber,$complaintfrom,'All Member of Society.',$page_link);
					$admin_message_content = str_replace($admin_search, $admin_replace, $admin_message_content);
					if(isset($_POST['amgt_mail_service_enable']))
					{
						MJ_amgt_SendEmailNotification($email,$admin_subject,$admin_message_content);
				
					}
				}
				
			}
			else
			{
				
				$apartmentname=get_option('amgt_system_name');
				$apartmentnumber=get_user_meta(get_current_user_id(),'unit_name',true);
				$apartmentnumber=MJ_amgt_get_member_assing_unit_name($apartmentnumber);
				$catdata=get_post($complaintdata['complaint_cat']);
				if(!empty($complaintdata['complaint_cat']))
				{
					$category=sanitize_text_field($catdata->post_title);
				}
				else
				{
					$category="-";
				}
				
				//send mail notification for admin//
				$admin_subject =get_option('wp_amgt_Admin_Complain');
				$page_link=admin_url().'admin.php?page=amgt-complaint&tab=complaintlist';
				$admin_subject_search=array('{{member_name}}','{{apartment_name}}');
		        $admin_subject_replace=array($complainfrom,$apartmentname);
				$admin_subject=str_replace($admin_subject_search,$admin_subject_replace,$admin_subject);
				$admin_message_content=get_option('wp_amgt_admin_complain_email_template');
			    $blogusers = get_users( [ 'role__in' => [ 'administrator'] ] );
				
				foreach ( $blogusers as $user ) 
				{
					
					$email =sanitize_email($user->user_email) ;
					$display_name=sanitize_text_field($user->display_name);
					$fromdata=get_userdata(get_current_user_id());
					$complaintfrom=sanitize_text_field($fromdata->display_name);
					$admin_search=array('{{admin_name}}','{{apartment_name}}','{{nature}}','{{noticetype}}','{{noticecategory}}','{{complaintstatus}}','{{description}}','{{apartmentnumber}}','{{complainfrom}}','{{complainto}}','{{Admin_Complain_Link}}');
					$admin_replace = array($display_name,$apartmentname,$complaintdata['complaint_nature'],$complaintdata['complaint_type'],$category,$complaintdata['complaint_status'],$complaintdata['complaint_description'],$apartmentnumber,$complaintfrom,'All Member of Society.',$page_link);
					$admin_message_content = str_replace($admin_search, $admin_replace, $admin_message_content);
					
					if(isset($_POST['amgt_mail_service_enable']))
					{
						MJ_amgt_SendEmailNotification($email,$admin_subject,$admin_message_content);
					}
					//---------------- SEND  SMS ------------------//
				
					if(isset($_POST['amgt_sms_service_enable']))
					{
						$apartmentname=get_option('amgt_system_name');
						$message_content ="Dear $display_name, New Complaint added in $apartmentname.";
						$send_sms = MJ_amgt_send_sms_notification(intval($user->data->ID),'New Complaint',$message_content);
					}
					/// ================= SEND PUSH NOTIFICATION=======================
				
					$send_data['type']="complaint";
					$send_push_notification = MJ_amgt_send_push_notification(intval($user->data->ID),$send_data);
				}
				
			}
			$complaintdata['created_by']=get_current_user_id();

			$result=$wpdb->insert($table_name,$complaintdata);
			apartment_append_audit_log('' . esc_html__('Complain Added', 'apartment_mgt') . ' ('.sanitize_text_field($data['complain_title']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	}
	//GET ALL COMPLAIN
	public function MJ_amgt_get_all_complaints()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_results("SELECT * FROM $table_name");
		return $result;
	}

	// GET ALL DASHBOARD COMPLAINTS
	public function MJ_amgt_get_all_dashboard_complaints()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name ORDER BY created_date DESC LIMIT %d", 5));
		return $result;
	}
	
	//GET OWN CRETATED COMPLAIN FUNCTION
	public function MJ_amgt_get_own_created_complaints($userid)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE created_by = %d", $userid));
		return $result;
	}
	//GET Member OWN CRETATED COMPLAIN FUNCTION
	public function MJ_amgt_get_member_own_created_complaints($userid)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE complaint_member_id = %d",$userid));
		return $result;
	}
	//GET SINGLE COMPLIANTS
	public function MJ_amgt_get_single_complaint($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d",$id));
		return $result;
	}
	// DELATE COMPLAIMTS
	public function MJ_amgt_delete_comlaint($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$complain_name = $wpdb->get_row($wpdb->prepare("SELECT complain_title FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d",$id));
		apartment_append_audit_log('' . esc_html__('Complain Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($complain_name->complain_title).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}
	//GET ALL COMPLAIN COUNT BY STATUS
	
	public function MJ_amgt_complaint_countby_status($status)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_var($wpdb->prepare("SELECT count(*) FROM $table_name WHERE complaint_status = %s",$status));
		return $result;
	}
	public function MJ_amgt_complaint_countby_status_and_user_id($status,$user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_var($wpdb->prepare("SELECT count(*) FROM $table_name WHERE complaint_status = %s AND complaint_member_id = %d",$status, $user_id));
		return $result;
	}
	//GET OWN CRETATED COMPLAIN FUNCTION
	public function MJ_amgt_get_own_created_complaints_dashboard($userid)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE created_by = %d ORDER BY id DESC LIMIT %d", $userid, 5));
		return $result;
	}
	//GET ALL COMPLAIN
	public function MJ_amgt_get_all_complaints_dashboard()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name ORDER BY id DESC LIMIT %d", 3));
		return $result;
	}

	//------------------- GET COMPLAINT BY MEMBER ID -----------------//

	public function MJ_amgt_get_all_complaints_by_memberid($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE complaint_member_id = %d",$id));
		return $result;
	}

	//------------ GET TOTAL COMPLAINT --------------//
	public function MJ_amgt_complaint_count_by_nature($status,$status_1)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_var($wpdb->prepare("SELECT count(*) FROM $table_name WHERE complaint_nature = %s AND complaint_status = %s",$status, $status_1));
		return $result;
	}
	
	public function MJ_amgt_complaint_countby_nature_and_user_id($status,$status_1,$user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_var($wpdb->prepare("SELECT count(*) FROM $table_name WHERE complaint_nature = %s AND complaint_status = %s AND complaint_member_id = %d",$status, $status_1, $user_id));
		return $result;
	}
	
	public function MJ_amgt_complaint_countby_nature_and_created_by($status,$status_1,$user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$result = $wpdb->get_var($wpdb->prepare("SELECT count(*) FROM $table_name WHERE complaint_nature = %s AND complaint_status = %s AND created_by = %d",$status, $status_1, $user_id));
		return $result;
	}
	public function MJ_amgt_complaint_status_update($data)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_complaints';
		$complaintdata['complaint_status']=sanitize_text_field($data['status']);
		$complaintdata['resolution']=sanitize_text_field($data['resolution']);
		$whereid['id']=intval($data['complaint_id']);
		$result=$wpdb->update( $table_name, $complaintdata ,$whereid);
		return $result;
	}
}
?>