<?php
//ASSEETSINVENTORY CLASS
class MJ_amgt_AssetsInventory
{	
    //ADD ASSET FUNCTION
	public function MJ_amgt_add_assets($data)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_assets';
		$assetsdata['assets_no']=sanitize_text_field($data['assets_no']);
		$assetsdata['assets_name']=sanitize_text_field($data['assets_name']);
		$assetsdata['vender_name']=sanitize_text_field($data['vender_name']);
		$assetsdata['assets_cat_id']=sanitize_text_field($data['assets_cat_id']);
		$assetsdata['location']=sanitize_text_field($data['location']);
		$assetsdata['purchage_date']=MJ_amgt_get_format_for_db($data['purchage_date']);
		$assetsdata['assets_cost']=sanitize_text_field($data['asset_cost']);
		$assetsdata['created_date']=date('Y-m-d');
		$assetsdata['created_by']=sanitize_text_field(get_current_user_id());
		if($data['action']=='edit')
		{
			$whereid['id']=intval($data['assets_id']);
			$result=$wpdb->update( $table_name, $assetsdata ,$whereid);
			apartment_append_audit_log('' . esc_html__('Assets Updated', 'apartment_mgt') . ' ('.sanitize_text_field($data['assets_name']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			
			$result=$wpdb->insert( $table_name, $assetsdata );
			apartment_append_audit_log('' . esc_html__('Assets Added', 'apartment_mgt') . ' ('.sanitize_text_field($data['assets_name']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	
	}
	 //ADD INVENTORY FUNCTION
	public function MJ_amgt_add_inventory($data)
	{
		
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_inventory';
		$inventorydata['inventory_name']=sanitize_text_field($data['inventory_name']);
		$inventorydata['inventory_unit_cat']=sanitize_text_field($data['inventory_unit_cat']);
		$inventorydata['quentity']=sanitize_text_field($data['quentity']);
		$inventorydata['created_date']=date('Y-m-d');
		$inventorydata['created_by']=sanitize_text_field(get_current_user_id());
		
		if($data['action']=='edit')
		{
			$whereid['id']=intval($data['inventory_id']);
			$result=$wpdb->update( $table_name, $inventorydata ,$whereid);
			apartment_append_audit_log('' . esc_html__('Inventory Updated', 'apartment_mgt') . ' ('.sanitize_text_field($data['inventory_name']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
		else
		{
			$result=$wpdb->insert( $table_name, $inventorydata );
			apartment_append_audit_log('' . esc_html__('Inventory Added', 'apartment_mgt') . ' ('.sanitize_text_field($data['inventory_name']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	
	}
	 //GET ALL ASSETS FUNCTION
	public function MJ_amgt_get_all_assets()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_assets';
		$result = $wpdb->get_results("SELECT * FROM $table_name");
		return $result;
	}
	 //GET ALL ASSETS FUNCTION
	public function MJ_amgt_get_all_assets_created_by($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_assets';
		$results = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE created_by = %d",intval($user_id)));		
		return $results;
	}
	 //GET SINGE  ASSET FUNCTION
	public function MJ_amgt_get_single_assets($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_assets';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d",intval($id)));		
		return $result;
	}
	 //GET SINGLE INVENTORY FUNCTION
	public function MJ_amgt_get_single_inventory($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_inventory';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d",intval($id)));		
		return $result;
	}
	 //DELETE ASSET FUNCTION
	public function MJ_amgt_delete_assets($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_assets';
		$assets_name = $wpdb->get_row($wpdb->prepare("SELECT assets_name FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d",intval($id)));		
		apartment_append_audit_log('' . esc_html__('Assets Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($assets_name->assets_name).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}
	// GET ALL INVENTORY
	public function MJ_amgt_get_all_inventory()
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_inventory';
	
		$result = $wpdb->get_results("SELECT * FROM $table_name");
		return $result;
	
	}
	// GET OWN INVENTRY
	public function MJ_amgt_get_own_inventory($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_inventory';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE created_by = %d",intval($user_id)));		
		return $result;
	}
	//DELETE INVENTRY
	public function MJ_amgt_delete_inventory($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix. 'amgt_inventory';
		$inventory_name = $wpdb->get_row($wpdb->prepare("SELECT inventory_name FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d",intval($id)));		
		apartment_append_audit_log('' . esc_html__('Inventory Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($inventory_name->inventory_name).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}
}
?>