<?php
class MJ_amgt_Accounts
{
	//OWN PAYMENT FUNCTION
	public function MJ_amgt_add_own_payment($data)
	{
		// var_dump($data);
		// die;
		global $wpdb;
		$table_invoice = $wpdb->prefix . 'amgt_created_invoice_list';
		$table_amgt_invoice_payment_history = $wpdb->prefix . 'amgt_invoice_payment_history';

		$invoiceid = $data['invoice_id'];
		$member_id = $data['member_id'];
		$history_data['invoice_id'] = sanitize_text_field($data['invoice_id']);
		$history_data['member_id'] = sanitize_text_field($data['member_id']);
		$history_data['date'] = date("Y-m-d");
		$history_data['amount'] = MJ_amgt_strip_tags_and_stripslashes($data['amount']);
		$history_data['payment_method'] = sanitize_text_field($data['payment_method']);
		if($data['created_by'])
		{
			$history_data['payment_by'] = sanitize_text_field($data['created_by']);
		}else{
			$history_data['payment_by'] = sanitize_text_field(get_current_user_id());
		}
		
		if (isset ($data['payment_method'])) {
			$history_data['description'] = sanitize_text_field($data['description']);
		}
		$invoicedata = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_invoice WHERE id = %d", intval($invoiceid)));
		$paid_amount = $invoicedata->paid_amount;

		$invoice_length = strlen($invoicedata->invoice_no);
		if ($invoice_length == '5') {
			$total_amount = $invoicedata->total_amount;
		} else {
			$total_amount = $invoicedata->invoice_amount;
		}
		$uddate_data['paid_amount'] = $paid_amount + $data['amount'];
		$uddate_data['due_amount'] = $total_amount - $uddate_data['paid_amount'];
		$uddate_data['total_amount'] = $total_amount;
		$uddate_data['payment_status'] = $total_amount;

		// if (round($uddate_data['paid_amount']) < round($uddate_data['total_amount'])) {
		// 	$uddate_data['payment_status'] = "Partially Paid";
		// } elseif (round($uddate_data['paid_amount']) >= round($uddate_data['total_amount'])) {
		// 	$uddate_data['payment_status'] = "Fully Paid";
		// } else {
		// 	$uddate_data['payment_status'] = "Unpaid";
		// }
		if ($uddate_data['paid_amount'] < $uddate_data['total_amount']) {
			$uddate_data['payment_status'] = "Partially Paid";
		} elseif ($uddate_data['paid_amount'] >= $uddate_data['total_amount']) {
			$uddate_data['payment_status'] = "Fully Paid";
		} else {
			$uddate_data['payment_status'] = "Unpaid";
		}

		$id['id'] = $invoiceid;

		$update_invoice = $wpdb->update($table_invoice, $uddate_data, $id);
	
		$result = $wpdb->insert($table_amgt_invoice_payment_history, $history_data);
		
		//----SEND NOTIFICATION MAIL--------
		// $user_invoiceid = $data['invoice_id'];
		$invoice_no = $this->MJ_amgt_get_invoiceno_by_invoice_id($data['invoice_id']);
		// $retrieved_data = get_userdata($data['member_id']);
		// $to = $retrieved_data->user_email;
		// $subject = get_option('wp_amgt_paid_invoice_subject');
		// $apartmentname = get_option('amgt_system_name');

		// $page_link = home_url() . '/?apartment-dashboard=user&page=notice-event&tab=event_list';
		// $subject_search = array('{{apartment_name}}', '{{invoiceno}}');
		// $subject_replace = array($apartmentname, $invoice_no);
		// $subject = str_replace($subject_search, $subject_replace, $subject);
		$message_content = get_option('wp_amgt_paid_invoice_email_template');
		// $search = array('{{member_name}}', '{{apartment_name}}', '{{invoiceno}}');
		// $replace = array($retrieved_data->display_name, $apartmentname, $invoice_no);
		// $message_content = str_replace($search, $replace, $message_content);
		// MJ_amgt_send_invoice_generate_mail($to, $subject, $message_content, $user_invoiceid);

		//---------------- SEND  SMS ------------------//
				
		// $apartmentname=get_option('amgt_system_name');
		// $message_content ="Dear $retrieved_data->display_name, You have Paid Your Invoice $invoice_no in $apartmentname.";
		// $send_sms = MJ_amgt_send_sms_notification($data['member_id'],'Paid Invoice',$message_content);

		// ================= SEND PUSH NOTIFICATION==	========================
			
		// $send_data['type']="paid_invoice";
		// $send_data['invoice_no']=$invoice_no;
		// $send_push_notification = MJ_amgt_send_push_notification($data['member_id'],$send_data);

		return $result;
	}
	//GET INVOICE NO BY INVOICE ID
	public function MJ_amgt_get_invoiceno_by_invoice_id($invoice_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_row($wpdb->prepare("SELECT invoice_no FROM $table_name WHERE id = %d", intval($invoice_id)));
		return $result->invoice_no;
	}
	//GET INVOICE NO BY INVOICE ID
	public function MJ_amgt_get_invoice_unit($invoice_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_row($wpdb->prepare("SELECT  FROM unit_name WHERE id = %d", intval($invoice_id)));
		return $result->invoice_no;
	}
	//GET SINGLE INVOICE PAYMENT HISTORY BY ID
	public function MJ_amgt_get_single_invoice_payment_history_by_id($invoice_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_invoice_payment_history';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE invoice_id = %d ORDER BY id DESC", intval($invoice_id)));
		return $result;
	}
	public function MJ_amgt_get_single_invoice_payment_history_by_id_view_invoice($invoice_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_invoice_payment_history';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE invoice_id = %d ORDER BY id DESC", intval($invoice_id)));
		return $result;
	}
	//GET ALL INVOICE
	public function MJ_amgt_get_all_invoice()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE status != %s", 'Deactivate'));
		return $result;
	}
	//GET OWN INVOICE
	public function MJ_amgt_get_own_invoice($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE status != %s AND created_by = %d", 'Deactivate', $user_id));
		return $result;
	}
	//GET MEMBER ALL INVOICE
	public function MJ_amgt_get_member_all_invoice()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$current_user_id = get_current_user_id();
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE member_id = %d OR created_by = %d", $current_user_id, $current_user_id));
		return $result;
	}
	//CHECK INVOICE GENERATED OR NOT
	public function MJ_amgt_check_invoice_generated($building_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE building_id = %d", $building_id));
		return $result;
	}
	//CHECK INVOICE REGENERATED 
	public function MJ_amgt_check_invoice_regenerated($building_id, $from_date)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE building_id = %d AND to_date < %s AND generated_status = 0", intval($building_id), $from_date));
		return $result;
	}
	//CHECK ALLREADY GENERATED MEMBER INVOICE
	public function MJ_amgt_check_allready_generate_member_invoice($invoiceid, $memberid)
	{
		global $wpdb;
		$table_amgt_created_invoice_list = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_amgt_created_invoice_list WHERE invoice_id = %d AND member_id = %d", intval($invoiceid), intval($memberid)));
		return $result;
	}
	//GET BUILDING INVOICE ID
	public function MJ_amgt_get_building_invoice_id($building_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_row($wpdb->prepare("SELECT id FROM $table_name WHERE building_id = %d AND generated_status = %d", intval($building_id), 0));
		return $result->id;
	}
	//GET ALL CERATED INVOCIE
	public function MJ_amgt_get_all_crated_invoice()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE status = %s", 'Activate'));
		return $result;
	}
	//GET ALL UNPAID CERATED INVOCIE
	public function MJ_amgt_get_all_unpaid_crated_invoice()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE status = %s AND (payment_status = %s OR payment_status = %s)", 'Activate', 'Unpaid','Partially Paid'));
		return $result;
	}
	//GET ALL UNPAID CERATED INVOCIE MEMBER ID
	public function MJ_amgt_get_all_unpaid_crated_invoice_memberid($member_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE member_id = %d AND status = %s AND (payment_status = %s OR payment_status = %s)", intval($member_id), 'Activate', 'Unpaid', 'Partially Paid'));		
		return $result;
	}
	//GET SINGLE CREATED INVOCIE
	public function MJ_amgt_get_single_crated_invoice($invoiceid, $memberid)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE charges_id = %d AND member_id = %d", intval($invoiceid), intval($memberid)));
		return $result;
	}
	//GET SINGLE INVOCIE BY ID
	public function MJ_amgt_get_single_invoice_by_id($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", intval($id)));		
		return $result;
	}
	//GET SINGLE OLD INVOCIE BY ID
	public function MJ_amgt_get_single_old_invoice_by_id($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", intval($id)));		
		return $result;
	}
	//GET SINGLE INVOCIE BY ID	
	public function MJ_amgt_get_single_invoice($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", intval($id)));
		return $result;
	}
	//DELETE INVOCIE
	public function MJ_amgt_delete_invoice($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$invoice = $wpdb->get_row($wpdb->prepare("SELECT invoice_no FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d", intval($id)));
		apartment_append_audit_log('' . esc_html__('Slot Deleted', 'apartment_mgt') . ' ('.sanitize_text_field($invoice->invoice_no).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		if ($result) {
			return $result;
		}
	}
	//ADD EXPENSE FUNCTION
	public function MJ_amgt_add_expense($data)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_income_expense';
		if (isset ($data['expense_type']))
			$expensedata['type_id'] = sanitize_text_field($data['expense_type']);
		if (isset ($data['vender_name']))
			$expensedata['vender_name'] = sanitize_text_field($data['vender_name']);
		if (!empty ($data['bill_date'])) {
			$expensedata['bill_date'] = MJ_amgt_get_format_for_db($data['bill_date']);
		}
		if (isset ($data['amount']))
			$expensedata['amount'] = sanitize_text_field($data['amount']);
		if (isset ($data['payment_date']))
			$expensedata['payment_date'] = MJ_amgt_get_format_for_db($data['payment_date']);
		if (isset ($data['description']))
			$expensedata['description'] = sanitize_text_field($data['description']);
		$expensedata['created_date'] = date('Y-m-d');
		$expensedata['created_by'] = sanitize_text_field(get_current_user_id());
		$expensedata['type'] = 'expense';
		if ($data['action'] == 'edit') {
			$whereid['id'] = $data['expense_id'];
			$result = $wpdb->update($table_name, $expensedata, $whereid);
			apartment_append_audit_log('' . esc_html__('Expense Updated', 'apartment_mgt') . ' ('.get_the_title($data['expense_type']).')', $result, get_current_user_id(), 'edit', sanitize_text_field($_REQUEST['page']));
			return $result;
		} else {
			$result = $wpdb->insert($table_name, $expensedata);
			apartment_append_audit_log('' . esc_html__('Expense Added', 'apartment_mgt') . ' ('.get_the_title($data['expense_type']).')', $result, get_current_user_id(), 'insert', sanitize_text_field($_REQUEST['page']));
			return $result;
		}
	}
	//GET ALL EXPENSE
	public function MJ_amgt_get_all_expense()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_income_expense';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE type = %s", 'expense'));
		return $result;
	}
	//GET OWN EXPENSE
	public function MJ_amgt_get_own_expense($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_income_expense';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE type = %s AND created_by = %d", 'expense', $user_id));
		return $result;
	}
	//GET SINGLE EXPENSE
	public function MJ_amgt_get_single_expense($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_income_expense';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", intval($id)));
		return $result;
	}
	//DELETE EXPENSE
	public function MJ_amgt_delete_expense($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_income_expense';
		$expense = $wpdb->get_row($wpdb->prepare("SELECT type_id FROM $table_name where id= %d ", $id));
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d", $id));
		apartment_append_audit_log('' . esc_html__('Expense Deleted', 'apartment_mgt') . ' ('.get_the_title($expense->type_id).')', $result, get_current_user_id(), 'delete', sanitize_text_field($_REQUEST['page']));
		return $result;
	}
	//SAVE INVOCIE PAYMENT
	public function MJ_amgt_save_invoice_payment($data)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_income_expense';
		if (isset ($data['invoice_id']))
			$paymentdata['invoice_id'] = sanitize_text_field($data['invoice_id']);
		if (isset ($data['member_id']))
			$paymentdata['member_id'] = sanitize_text_field($data['member_id']);
		if (isset ($data['amount']))
			$paymentdata['amount'] = sanitize_text_field($data['amount']);
		if (isset ($data['payment_date']))
			$paymentdata['payment_date'] = MJ_amgt_get_format_for_db($data['payment_date']);
		if (isset ($data['description']))
			$paymentdata['description'] = sanitize_text_field($data['description']);
		$paymentdata['created_date'] = date('Y-m-d');
		$paymentdata['created_by'] = sanitize_text_field(get_current_user_id());
		$paymentdata['type'] = 'income';

		$check_unit_invoice = $this->MJ_amgt_get_single_invoice($data['invoice_id']);

		$payment_res = $this->MJ_amgt_check_invoice_payment($data['member_id'], $data['invoice_id']);
		$old_payment = $this->MJ_amgt_get_prv_payments($data['member_id'], $data['invoice_id']);
		$paid_amount = 0;
		$invoice_amount = 0;
		if (!empty ($old_payment)) {
			$paid_amount = $old_payment->paid_amount;
			$invoice_amount = $old_payment->invoice_amount;
		}
		$amount = 0;
		if (isset ($data["amount"]))
			$amount = (int) $data["amount"];
		if (isset ($data["inv_amount"]))
			$amount = (int) $data["inv_amount"];
		$new_amt = $amount + (int) $paid_amount;

		$payment_status = ($new_amt == $invoice_amount || $new_amt >= $invoice_amount) ? "Paid" : "Partially Paid";

		if (!empty ($payment_res)) {

			$check_unit_invoice = $this->MJ_amgt_get_single_invoice($data['invoice_id']);

			if ($check_unit_invoice->unit_name != '') {
				$invoice_whereid['id'] = $payment_res->id;
				$result = $wpdb->update($table_name, $paymentdata, $invoice_whereid);

				$table_invoice = $wpdb->prefix . 'amgt_created_invoice_list';
				$invoicedata['payment_status'] = sanitize_text_field($payment_status);
				$invoicedata['paid_amount'] = sanitize_text_field($new_amt);
				$whereid['invoice_id'] = sanitize_text_field($data['invoice_id']);
				$whereid['member_id'] = sanitize_text_field($data['member_id']);
				$transaction_id = "";
				$payment_method = "";
				if (isset ($data['transaction_id']))
					$transaction_id = sanitize_text_field($data['transaction_id']);
				if (isset ($data['payment_method']))
					$payment_method = sanitize_text_field($data['payment_method']);
				if ($transaction_id != "" && $payment_method != "") {
					$sql = $wpdb->prepare("UPDATE `$table_invoice` SET payment_status = %s, paid_amount = %f, transaction_id = %s, payment_method = %s WHERE invoice_id = %d AND member_id = %d",$payment_status, $new_amt, $transaction_id, $payment_method, $data['invoice_id'], $data['member_id']);
					$result = $wpdb->query($sql);
				} else {
					$sql = $wpdb->prepare("UPDATE `$table_invoice` SET payment_status = %s, paid_amount = %f WHERE invoice_id = %d AND member_id = %d", $payment_status, $new_amt, $data['invoice_id'], $data['member_id']);
					$result = $wpdb->query($sql);
				}
			} else {
				$invoice_whereid['id'] = intval($payment_res->id);
				$result = $wpdb->update($table_name, $paymentdata, $invoice_whereid);
				if ($result) {
					$table_invoice = $wpdb->prefix . 'amgt_created_invoice_list';
					$invoicedata['payment_status'] = sanitize_text_field($payment_status);
					$invoicedata['paid_amount'] = sanitize_text_field($new_amt);
					$whereid['invoice_id'] = sanitize_text_field($data['invoice_id']);
					$whereid['member_id'] = sanitize_text_field($data['member_id']);
					$transaction_id = "";
					$payment_method = "";
					if (isset ($data['transaction_id']))
						$transaction_id = sanitize_text_field($data['transaction_id']);
					if (isset ($data['payment_method']))
						$payment_method = sanitize_text_field($data['payment_method']);

					if ($transaction_id != "" && $payment_method != "") {
						$sql = $wpdb->prepare(
							"UPDATE `$table_invoice` 
							 SET payment_status = %s, paid_amount = %f, transaction_id = %s, payment_method = %s 
							 WHERE invoice_id = %d AND member_id = %d",
							$payment_status, $new_amt, $transaction_id, $payment_method, $data['invoice_id'], $data['member_id']
						);
						$result = $wpdb->query($sql);
						//---------Notification send mail code---------------------
						$retrieved_data = get_userdata($data['member_id']);
						$to = sanitize_email($retrieved_data->user_email);
						$invoiceno = $payment_res->invoice_no;
						$subject = get_option('wp_amgt_paid_invoice_subject');
						$apartmentname = get_option('amgt_system_name');
						$subject_search = array('{{invoiceno}}');
						$subject_replace = array($invoiceno);
						$subject = str_replace($subject_search, $subject_replace, $subject);
						$message_content = get_option('wp_amgt_paid_invoice_email_template');
						$search = array('{{member_name}}', '{{apartment_name}}', '{{invoiceno}}');
						$replace = array($retrieved_data->display_name, $apartmentname, $invoiceno);
						$message_content = str_replace($search, $replace, $message_content);
						$resultInvoice = getHTMLInvoice($payment_res->id, 'invoice');
						$message_content .= $resultInvoice;
						MJ_amgt_SendEmailNotificationWithHTML($to, $subject, $message_content);

						//---------------- SEND  SMS ------------------//
				
						$apartmentname=get_option('amgt_system_name');
						$message_content ="Dear $retrieved_data->display_name, You have Paid Your Invoice $invoiceno in $apartmentname.";
						$send_sms = MJ_amgt_send_sms_notification($retrieved_data->ID,'Paid Invoice',$message_content);

						// ================= SEND PUSH NOTIFICATION==========================
			
						$send_data['type']="paid_invoice";
						$send_data['invoice_no']=sanitize_text_field($invoiceno);
						$send_push_notification = MJ_amgt_send_push_notification($retrieved_data->ID,$send_data);
					} else {
						$sql = $wpdb->prepare(
							"UPDATE `$table_invoice` SET payment_status = %s, paid_amount = %f WHERE invoice_id = %d AND member_id = %d",
							$payment_status, $new_amt, $data['invoice_id'], $data['member_id']
						);
						$result = $wpdb->query($sql);
						//---------Notification send mail code---------------------
						$retrieved_data = get_userdata($data['member_id']);
						$to = sanitize_email($retrieved_data->user_email);
						$subject = get_option('wp_amgt_paid_invoice_subject');
						$apartmentname = get_option('amgt_system_name');
						$message_content = get_option('wp_amgt_paid_invoice_email_template');
						$invoiceno = $payment_res->invoice_no;
						$subject_search = array('{{invoiceno}}');
						$subject_replace = array($invoiceno);
						$search = array('{{member_name}}', '{{apartment_name}}', '{{invoiceno}}');
						$replace = array($retrieved_data->display_name, $apartmentname, $invoiceno);
						$subject = str_replace($subject_search, $subject_replace, $subject);
						$message_content = str_replace($search, $replace, $message_content);
						$resultInvoice = getHTMLInvoice($payment_res->id, 'invoice');
						$message_content .= $resultInvoice;
						$headers = 'From: ' . get_option('amgt_system_name') . "\r\n";
						$headers = 'MIME-Version: 1.0\r\nContent-type: text/html; charset=iso-8859-1' . "\r\n";
						$messagecontent = MJ_amgt_get_mail_content_with_template_design('<pre>'.$message_content.'</pre>');
						MJ_amgt_SendEmailNotification($to, $subject, $messagecontent, $headers);

						//---------------- SEND  SMS ------------------//
				
						$apartmentname=get_option('amgt_system_name');
						$message_content ="Dear $retrieved_data->display_name, You have Paid Your Invoice $invoiceno in $apartmentname.";
						$send_sms = MJ_amgt_send_sms_notification($retrieved_data->ID,'Paid Invoice',$message_content);

						// ================= SEND PUSH NOTIFICATION==========================
			
						$send_data['type']="paid_invoice";
						$send_data['invoice_no']=$invoiceno;
						$send_push_notification = MJ_amgt_send_push_notification($retrieved_data->ID,$send_data);
					}
				}
			}
		} else {
			$invoice_data = $this->MJ_amgt_get_user_invoice($data['member_id'], $data['invoice_id']);
			if ($check_unit_invoice->unit_name != '') {
				$result = $wpdb->insert($table_name, $paymentdata);
				if ($result) {
					$table_invoice = $wpdb->prefix . 'amgt_created_invoice_list';
					$invoicedata['payment_status'] = sanitize_text_field($payment_status);
					$invoicedata['paid_amount'] = sanitize_text_field($new_amt);
					$whereid['invoice_id'] = sanitize_text_field($data['invoice_id']);
					$whereid['member_id'] = sanitize_text_field($data['member_id']);
					$sql = $wpdb->prepare(
						"UPDATE `$table_invoice` SET payment_status = %s, paid_amount = %f WHERE invoice_id = %d AND member_id = %d",
						$payment_status, $new_amt, $data['invoice_id'], $data['member_id']
					);
					$result = $wpdb->query($sql);
					//---------Notification send mail code---------------------
					$retrieved_data = get_userdata($data['member_id']);
					$to = sanitize_email($retrieved_data->user_email);
					$subject = get_option('wp_amgt_paid_invoice_subject');
					$apartmentname = get_option('amgt_system_name');
					$message_content = get_option('wp_amgt_paid_invoice_email_template');
					$invoiceno = $invoice_data->invoice_no;
					$subject_search = array('{{invoiceno}}');
					$subject_replace = array($invoiceno);
					$subject = str_replace($subject_search, $subject_replace, $subject);
					$search = array('{{member_name}}', '{{apartment_name}}', '{{invoiceno}}');
					$replace = array($retrieved_data->display_name, $apartmentname, $invoiceno);
					$message_content = str_replace($search, $replace, $message_content);
					$resultInvoice = getHTMLInvoice($invoice_data->id, 'invoice');
					$message_content .= $resultInvoice;
					MJ_amgt_SendEmailNotificationWithHTML($to, $subject, $message_content);

					//---------------- SEND  SMS ------------------//
				
					$apartmentname=get_option('amgt_system_name');
					$message_content ="Dear $retrieved_data->display_name, You have Paid Your Invoice $invoiceno in $apartmentname.";
					$send_sms = MJ_amgt_send_sms_notification($retrieved_data->ID,'Paid Invoice',$message_content);

					// ================= SEND PUSH NOTIFICATION==========================
			
					$send_data['type']="paid_invoice";
					$send_data['invoice_no']=$invoiceno;
					$send_push_notification = MJ_amgt_send_push_notification($retrieved_data->ID,$send_data);

				}
			} else {

				$result = $wpdb->insert($table_name, $paymentdata);
				if ($result) {
					$table_invoice = $wpdb->prefix . 'amgt_created_invoice_list';
					$invoicedata['payment_status'] = sanitize_text_field($payment_status);
					$invoicedata['paid_amount'] = sanitize_text_field($new_amt);
					$whereid['invoice_id'] = sanitize_text_field($data['invoice_id']);
					$whereid['member_id'] = sanitize_text_field($data['member_id']);
					$result = $wpdb->update($table_invoice, $invoicedata, $whereid);

					$sql = $wpdb->prepare(
						"UPDATE `$table_invoice` SET payment_status = %s, paid_amount = %f WHERE invoice_id = %d AND member_id = %d",
						$payment_status, $new_amt, $data['invoice_id'], $data['member_id']
					);
					$result = $wpdb->query($sql);
					//---------Notification send mail code---------------------
					$retrieved_data = get_userdata($data['member_id']);
					$to = sanitize_email($retrieved_data->user_email);
					$subject = get_option('wp_amgt_paid_invoice_subject');
					$apartmentname = get_option('amgt_system_name');
					$message_content = get_option('wp_amgt_paid_invoice_email_template');
					$invoiceno = $invoice_data->invoice_no;
					$subject_search = array('{{invoiceno}}');
					$subject_search = array('{{invoiceno}}');
					$subject_replace = array($invoiceno);
					$subject = str_replace($subject_search, $subject_replace, $subject);
					$search = array('{{member_name}}', '{{apartment_name}}', '{{invoiceno}}');
					$replace = array($retrieved_data->display_name, $apartmentname, $invoiceno);
					$message_content = str_replace($search, $replace, $message_content);
					$resultInvoice = getHTMLInvoice($invoice_data->id, 'invoice');
					$message_content .= $resultInvoice;
					MJ_amgt_SendEmailNotificationWithHTML($to, $subject, $message_content);

					//---------------- SEND  SMS ------------------//
				
					$apartmentname=get_option('amgt_system_name');
					$message_content ="Dear $retrieved_data->display_name, You have Paid Your Invoice $invoiceno in $apartmentname.";
					$send_sms = MJ_amgt_send_sms_notification($retrieved_data->ID,'Paid Invoice',$message_content);

					// ================= SEND PUSH NOTIFICATION==========================
			
					$send_data['type']="paid_invoice";
					$send_data['invoice_no']=$invoiceno;
					$send_push_notification = MJ_amgt_send_push_notification($retrieved_data->ID,$send_data);
				}
			}
		}
		return $result;
	}
	//GET PREVIOUS PAYMENT
	public function MJ_amgt_get_prv_payments($member_id, $invoice_id)
	{
		global $wpdb;
		$tbl = $wpdb->prefix . "amgt_created_invoice_list";
		$data = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$tbl} WHERE member_id = %d AND invoice_id = %d", $member_id, $invoice_id));		
		return $data;
	}
	//GET ALL INCOME
	public function MJ_amgt_get_all_income()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_income_expense';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE type = %s", 'income'));		
		return $result;
	}
	//GET SINGLE INCOME
	public function MJ_amgt_get_single_income($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_income_expense';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", intval($id)));
		return $result;
	}
	public function MJ_amgt_delete_payment($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE id = %d", intval($id)));		
		return $result;
	}
	//SAVE CHARGES PAYMENT	
	public function MJ_amgt_save_charges_payment($data)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_charges_payments';
		$entry_value = $this->MJ_amgt_get_entry_records($data);

		if (isset ($data['building_id']))
			$chargesdata['building_id'] = sanitize_text_field($data['building_id']);
		if (isset ($data['unit_cat_id']))
			$chargesdata['unit_cat_id'] = sanitize_text_field($data['unit_cat_id']);
		if (isset ($data['unit_name']))
			$chargesdata['unit_name'] = sanitize_text_field($data['unit_name']);
		if (isset ($data['member_id']))
			$chargesdata['member_id'] = sanitize_text_field($data['member_id']);
		if (isset ($data['charges_id']))
			$chargesdata['charges_type_id'] = sanitize_text_field($data['charges_id']);
		if (isset ($data['discount_amount']))
			$chargesdata['discount_amount'] = sanitize_text_field($data['discount_amount']);
		$chargesdata['charges_payment'] = sanitize_text_field($entry_value);
		if (isset ($data['description']))
			$chargesdata['description'] = sanitize_text_field($data['description']);
		$chargesdata['created_date'] = date('Y-m-d');
		$chargesdata['created_by'] = sanitize_text_field(get_current_user_id());

		if ($data['action'] == 'edit') {
			$whereid['id'] = intval($data['pay_charges_id']);
			$result = $wpdb->update($table_name, $chargesdata, $whereid);
			return $result;
		} else {
			// $result = $wpdb->insert($table_name, $chargesdata);
			// $user_invoiceid = $wpdb->insert_id;
			$user_invoiceid = 6;
			//---------Notification send mail code---------------------
			$retrieved_data = get_userdata($data['member_id']);
			$to = sanitize_email($retrieved_data->user_email);
			$subject = get_option('wp_amgt_add_charges_subject');
			$apartmentname = get_option('amgt_system_name');
			$page_link = home_url() . '/?apartment-dashboard=user&page=message';
			$message_content = get_option('wp_amgt_add_charges_email_template');
			$invoiceno = $invoice_data->invoice_no;
			$search = array('{{member_name}}', '{{apartment_name}}');
			$replace = array($retrieved_data->display_name, $apartmentname);
			$message_content = str_replace($search, $replace, $message_content);
			$resultInvoice = getHTMLInvoice($user_invoiceid, 'charges');
			$message_content .= $resultInvoice;
		
			MJ_amgt_SendEmailNotificationWithHTML($to, $subject, $message_content);

			//---------------- SEND  SMS ------------------//
				
			$apartmentname=get_option('amgt_system_name');
			$message_content ="Your have a new Charges Invoice raised by Admin from $apartmentname.";
			$send_sms = MJ_amgt_send_sms_notification($retrieved_data->ID,'Invoice Charge',$message_content);
			
			// ================= SEND PUSH NOTIFICATION==========================
			
			$send_data['type']="invoice_charge";
			$send_push_notification = MJ_amgt_send_push_notification($retrieved_data->ID,$send_data);
			return $result;
		}
	}
	//SAVE CHARGES PAYMENT ALL MEMBER
	public function MJ_amgt_save_charges_payment_all_member($data)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_charges_payments';
		$amgt_amgt_generat_invoice = $wpdb->prefix . 'amgt_generat_invoice';
		if ($data['charge_cal'] == 'fix_charge') {
			$entry_value = $this->MJ_amgt_get_entry_records($data);
		} elseif ($data['charge_cal'] == 'measurement_charge') {
			$entry_value = $this->MJ_amgt_get_entry_records_by_measurement($data);
		}
		if (isset ($data['select_serveice']))
			$charges_recuring_data['invoice_options'] = sanitize_text_field($data['select_serveice']);
		if (isset ($data['building_id']))
			$charges_recuring_data['building_id'] = sanitize_text_field($data['building_id']);
		if (isset ($data['unit_cat_id']))
			$charges_recuring_data['unit_cat_id'] = sanitize_text_field($data['unit_cat_id']);
		if (isset ($data['unit_name']))
			$charges_recuring_data['unit_name'] = sanitize_text_field($data['unit_name']);
		if (isset ($data['member_id']))
			$charges_recuring_data['member_id'] = sanitize_text_field($data['member_id']);
		if (isset ($data['charges_id']))
			$charges_recuring_data['charges_type_id'] = sanitize_text_field($data['charges_id']);
		if (isset ($data['charge_cal']))
			$charges_recuring_data['charges_calculate_by'] = sanitize_text_field($data['charge_cal']);
		if (isset ($data['amgt_charge_period']))
			$charges_recuring_data['amgt_charge_period'] = sanitize_text_field($data['amgt_charge_period']);
		if (isset ($data['discount_amount']))
			$charges_recuring_data['discount_amount'] = sanitize_text_field($data['discount_amount']);
		$charges_recuring_data['charges_payment'] = sanitize_text_field($entry_value);
		if (isset ($data['description']))
			$charges_recuring_data['description'] = sanitize_text_field($data['description']);
		if (isset ($data['amount']))
			$charges_recuring_data['amount'] = sanitize_text_field($data['amount']);
		if (isset ($data['tax_amount']))
			$charges_recuring_data['tax_amount'] = sanitize_text_field($data['tax_amount']);
		if (isset ($data['total_amount']))
			$charges_recuring_data['total_amount'] = sanitize_text_field($data['total_amount']);
		if (isset ($data['end_date_one_charge']))
			$charges_recuring_data['end_date_one_charge'] = sanitize_text_field($data['end_date_one_charge']);
		if (isset ($data['one_time_recurring_option']))
			$charges_recuring_data['one_time_recurring_option'] = sanitize_text_field($data['one_time_recurring_option']);
		$charges_recuring_data['delete_status'] = '0';

		if ($data['action'] == 'edit') {
			$whereid['id'] = $data['pay_charges_id'];
			if (isset ($data['start_date_one_charge'])) {
				$charges_recuring_data['start_date_one_charge'] = sanitize_text_field($data['start_date_one_charge']);
			}
			$result = $wpdb->update($amgt_amgt_generat_invoice, $charges_recuring_data, $whereid);

			$last_id = $data['pay_charges_id'];

			global $wpdb;
			$table_amgt_invoice_tax = $wpdb->prefix . 'amgt_invoice_tax';
			$result_delete_tax = $wpdb->query("DELETE FROM $table_amgt_invoice_tax where invoice_id= " . $last_id);

			if ($data['charge_cal'] == 'fix_charge') {
				if (!empty ($data['tax_entry'])) {
					foreach ($data['tax_entry'] as $key => $tax) {
						$table_invoice_tax = $wpdb->prefix . 'amgt_invoice_tax';
						$invoicetax['invoice_id'] = sanitize_text_field($last_id);
						$invoicetax['tax_id'] = sanitize_text_field($data['tax_title'][$key]);
						$invoicetax['tax'] = sanitize_text_field($tax);
						$invoicetax['created_at'] = date('Y-m-d');
						$invoicetax['created_by'] = get_current_user_id();

						$result = $wpdb->insert($table_invoice_tax, $invoicetax);
					}
				}
			} elseif ($data['charge_cal'] == 'measurement_charge') {
				if (!empty ($data['tax_entry'])) {
					foreach ($data['tax_entry'] as $key => $tax) {
						$table_invoice_tax = $wpdb->prefix . 'amgt_invoice_tax';
						$invoicetax['invoice_id'] = sanitize_text_field($last_id);
						$invoicetax['tax_id'] = sanitize_text_field($data['tax_title'][$key]);
						$invoicetax['tax'] = sanitize_text_field($tax);
						$invoicetax['created_at'] = date('Y-m-d');
						$invoicetax['created_by'] = get_current_user_id();
						$result = $wpdb->insert($table_invoice_tax, $invoicetax);
					}
				}
			}
			return $last_id;
		} else {
			$charges_recuring_data['created_by'] = get_current_user_id();
			if (isset ($data['start_date_one_charge'])) {
				$charges_recuring_data['start_date_one_charge'] = sanitize_text_field($data['start_date_one_charge']);
			}

			$charges_recuring_data['created_date'] = date('Y-m-d');

			$result = $wpdb->insert($amgt_amgt_generat_invoice, $charges_recuring_data);

			$last_id = $wpdb->insert_id;
			if ($data['charge_cal'] == 'fix_charge') {
				if (!empty ($data['tax_entry'])) {
					foreach ($data['tax_entry'] as $key => $tax) {
						$table_invoice_tax = $wpdb->prefix . 'amgt_invoice_tax';
						$invoicetax['invoice_id'] = sanitize_text_field($last_id);
						$invoicetax['tax_id'] = sanitize_text_field($data['tax_title'][$key]);
						$invoicetax['tax'] = sanitize_text_field($tax);
						$invoicetax['created_at'] = date('Y-m-d');
						$invoicetax['created_by'] = get_current_user_id();
						$result = $wpdb->insert($table_invoice_tax, $invoicetax);
					}
				}
			} elseif ($data['charge_cal'] == 'measurement_charge') {
				if (!empty ($data['tax_entry'])) {
					foreach ($data['tax_entry'] as $key => $tax) {
						$table_invoice_tax = $wpdb->prefix . 'amgt_invoice_tax';
						$invoicetax['invoice_id'] = sanitize_text_field($last_id);
						$invoicetax['tax_id'] = sanitize_text_field($data['tax_title'][$key]);
						$invoicetax['tax'] = sanitize_text_field($tax);
						$invoicetax['created_at'] = date('Y-m-d');
						$invoicetax['created_by'] = get_current_user_id();
						$result = $wpdb->insert($table_invoice_tax, $invoicetax);

					}
				}
			}

			return $last_id;
		}
	}
	//GET ENTRY RECORD
	public function MJ_amgt_get_entry_records($data)
	{
		$all_income_entry = $data['income_entry'];
		$all_income_amount = $data['income_amount'];

		$entry_data = array();
		$i = 0;
		foreach ($all_income_entry as $one_entry) {
			$entry_data[] = array(
				'entry' => $one_entry,
				'amount' => $all_income_amount[$i]
			);
			$i++;
		}
		return json_encode($entry_data);
	}
	//GET ENTRY RECORD BY MEASUREMENT
	public function MJ_amgt_get_entry_records_by_measurement($data)
	{
		$all_income_amount = $data['income_amount'];

		$entry_data = array();
		$i = 0;
		foreach ($all_income_amount as $one_entry) {
			$entry_data[] = array('amount' => $one_entry);
			$i++;
		}
		return json_encode($entry_data);
	}
	//GET ALL PAID CHARGES
	public function MJ_amgt_get_all_paid_charges()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_charges_payments';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name"));
		return $result;
	}
	//GET ALL CHARGES
	public function MJ_amgt_get_all_charges()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE delete_status = %s", '0'));		
		return $result;
	}

	public function MJ_amgt_get_all_charges_charges_menu()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name ORDER BY %s DESC", 'id'));		
		return $result;
	}
	public function MJ_amgt_get_own_charges($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE delete_status = %d AND created_by = %d", 0, intval($user_id)));		
		return $result;
	}
	//GET ALL RECURING CHARGES
	public function MJ_amgt_get_all_recuring_charges()
	{
		global $wpdb;
		$amgt_recuring_charges_payments = $wpdb->prefix . 'amgt_recuring_charges_payments';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $amgt_recuring_charges_payments"));
		return $result;
	}
	//GET SINGLE RECURING CHARGES LIST
	public function MJ_amgt_get_single_recuring_charges_list($id)
	{
		global $wpdb;
		$amgt_recuring_charges_payments = $wpdb->prefix . 'amgt_recuring_charges_payments';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $amgt_recuring_charges_payments WHERE id = %d",intval($id)));
		return $result;
	}
	//GET SINGLE CHARGES LIST
	public function MJ_amgt_get_single_charges_list($id)
	{
		global $wpdb;
		$amgt_amgt_generat_invoice = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $amgt_amgt_generat_invoice WHERE id = %d",intval($id)));		
		return $result;
	}
	//DELETE RECURING CHARGES
	public function MJ_amgt_delete_recuring_charges($id)
	{
		global $wpdb;
		$amgt_recuring_charges_payments = $wpdb->prefix . 'amgt_recuring_charges_payments';
		$result = $wpdb->query($wpdb->prepare("DELETE FROM $amgt_recuring_charges_payments WHERE id = %d",intval($id)));		
		return $result;
	}
	//GET CHARGES TOTAL
	public function MJ_amgt_get_charges_total($data)
	{
		$all_income_entry = $data['income_entry'];
		$all_income_amount = $data['income_amount'];

		$entry_data = array();
		$i = 0;
		foreach ($all_income_entry as $one_entry) {
			$entry_data[] = array(
				'entry' => $one_entry,
				'amount' => $all_income_amount[$i]
			);
			$i++;
		}
		return json_encode($entry_data);
	}
	//GET SINGLE PAID CHARGES LIST
	public function MJ_amgt_get_single_paid_charges_list($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_charges_payments';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d",intval($id)));
		return $result;
	}
	//DELETE PAID CHARGES
	public function MJ_amgt_delete_paid_charges($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$data['delete_status'] = '1';
		$whereid['id'] = intval($id);
		$result = $wpdb->update($table_name, $data, $whereid);

		return $result;
	}
	//GET USER INVOCIE
	function MJ_amgt_get_user_invoice($member, $invoiceid)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$table_name = sanitize_text_field($table_name);
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE invoice_id = %d AND member_id = %d",$invoiceid,$member));
		return $result;
	}
	//GET CHARGES ONE TIME
	function MJ_amgt_get_chargis_one_time($chargis_option, $recuring_date_new1)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM $table_name 
				WHERE amgt_charge_period = %d 
				AND invoice_end_date <= %s 
				AND end_date_one_charge >= %s 
				AND delete_status = %d 
				AND one_time_recurring_option = %d",
				$chargis_option,
				$recuring_date_new1,
				$recuring_date_new1,
				0,
				1
			));		
		return $result;
	}
	//GET CHARGES MONTHALY
	function MJ_amgt_get_chargis_monthaly($chargis_option, $recuring_date_new1)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $table_name WHERE amgt_charge_period = %d AND invoice_end_date <= %s AND delete_status = %d",$chargis_option,$recuring_date_new1,0));		
		return $result;
	}
	//GET CHARGES QUARTLY
	function MJ_amgt_get_chargis_quarterly($chargis_option, $recuring_date_new1)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $table_name WHERE amgt_charge_period = %d AND invoice_end_date <= %s AND delete_status = %d",$chargis_option,$recuring_date_new1,0));		
		return $result;
	}
	function MJ_amgt_get_chargis_yearly($chargis_option, $recuring_date_new1)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $table_name WHERE amgt_charge_period = %d AND invoice_end_date <= %s AND delete_status = %d",$chargis_option,$recuring_date_new1,0));		
		return $result;
	}
	//Check ALLREADY Member Generated Invocie //
	function MJ_amgt_member_invoice_allready_generated($member_id, $start_date, $end_date)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_row(
			$wpdb->prepare("SELECT * FROM $table_name WHERE member_id = %d AND start_date = %s AND end_date = %s",$member_id,$start_date, $end_date));
		if (!empty ($result)) {
			$generated_status = '1';
		} else {
			$generated_status = '0';
		}
		return $generated_status;
	}
	//CHECK INVOCIE PAYMENT
	function MJ_amgt_check_invoice_payment($member, $invoiceid)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_income_expense';
		$result = $wpdb->get_row(
			$wpdb->prepare("SELECT * FROM $table_name WHERE invoice_id = %d AND member_id = %d", $invoiceid, $member));		
		return $result;
	}
	//GET RECURING MAINTENANCE CHARGES
	function MJ_amgt_get_recuring_maintenance_charge($to_date, $building_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		return $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $table_name WHERE to_date = %s AND building_id = %d", $to_date, $building_id));		
	}
	//CHECK INVOCIE GENERATED
	function MJ_amgt_check_invoice_gebnerated($building_id, $year, $from_date, $to_date)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		return $result = $wpdb->get_row(
			$wpdb->prepare(
				"SELECT * FROM $table_name WHERE building_id = %d AND year = %s AND from_date = %s AND to_date = %s", $building_id, $year, $from_date, $to_date));		
	}
	//CHECK MEMBER INVOCIE
	function MJ_amgt_CheckMemberInvoice($member_id, $invoice_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		return $result = $wpdb->get_row(
			$wpdb->prepare("SELECT * FROM $table_name WHERE invoice_id = %d AND member_id = %d", $invoice_id,$member_id));		
	}
	//CHECK MEMBER INVOCIE PAYMENT STATUS	
	function MJ_amgt_CheckMemberInvoice_payment_status($member_id, $start_date)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		return $result = $wpdb->get_row(
			$wpdb->prepare("SELECT * FROM $table_name WHERE created_date = %s AND member_id = %d", $start_date, $member_id));		
	}
	//INVOCIE PAYMENT BY MEMBER
	function MJ_amgt_invoice_payment_by_member($invoice_id, $member_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_invoice_payment_history';
		$result = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $table_name WHERE invoice_id = %d AND member_id = %d", $invoice_id, $member_id));		
		return $result;
	}
	//GET ALL INVOICE DASHBOARD
	public function MJ_amgt_get_all_invoice_dashboard()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $table_name WHERE status != %s ORDER BY created_date DESC LIMIT %d", 'Deactivate', 5));		
		return $result;
	}
	public function MJ_amgt_get_all_invoice_dashboard_for_payment_status()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_results(
			$wpdb->prepare("SELECT payment_status FROM $table_name WHERE status != %s", 'Deactivate'));		
		return $result;
	}
	//------------- GET MEMBER CREATED INVOICE LIST -------------//
	public function MJ_amgt_get_all_member_invoice_dashboard($id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $table_name WHERE member_id = %d AND status != %s", $id, 'Deactivate'));		
		return $result;
	}
	//GET ALL INVOICE OF MEMBER FORDASHBOARD
	public function MJ_amgt_get_member_all_invoice_dashboard()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$current_user_id = get_current_user_id();
		$result = $wpdb->get_results(
			$wpdb->prepare("SELECT * FROM $table_name WHERE member_id = %d ORDER BY created_date DESC LIMIT %d", $current_user_id, 5));		
		return $result;
	}
	//GET OWN INVOICE OF MEMBER FORDASHBOARD
	public function MJ_amgt_get_own_invoice_dashboard($user_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE status != 'Deactivate' AND created_by = %d ORDER BY created_date DESC LIMIT %d", $user_id, 5));		
		return $result;
	}
	//GET ALL INVOICE DASHBOARD
	public function MJ_amgt_get_all_invoice_for_chart()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_created_invoice_list';
		$result = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT SUM(total_amount), DATE_FORMAT(start_date, '%%M %%Y') AS MONTH FROM $table_name WHERE status != 'Deactivate' GROUP BY DATE_FORMAT(start_date, '%%M %%Y')"
			));		
		return $result;
	}
	public function MJ_amgt_get_unitname_by_chargeid($charges_id)
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'amgt_generat_invoice';
		$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $charges_id));		
		return $result;
	}
	public function MJ_amgt_get_invoice_totals()
	{
		global $wpdb;
		$totals = array(
			'unpaid' => 0,
			'paid' => 0,
			'partially_paid' => 0,
		);
		// Query to get total amount of unpaid invoices
		$unpaid_query = $wpdb->prepare("SELECT SUM(due_amount) AS total_unpaid_amount FROM {$wpdb->prefix}amgt_created_invoice_list WHERE payment_status = %s", 'Unpaid');
		$totals['unpaid'] = $wpdb->get_var($unpaid_query);

		// Query to get total amount of paid invoices
		$paid_query = $wpdb->prepare("SELECT SUM(total_amount) AS total_paid_amount FROM {$wpdb->prefix}amgt_created_invoice_list WHERE payment_status = %s", 'Fully Paid');
		$totals['paid'] = $wpdb->get_var($paid_query);

		// Query to get total amount of partially paid invoices
		$partially_paid_query = $wpdb->prepare("SELECT SUM(paid_amount) AS total_partially_paid_amount FROM {$wpdb->prefix}amgt_created_invoice_list WHERE payment_status = %s", 'Partially Paid');
		$totals['partially_paid'] = $wpdb->get_var($partially_paid_query);
		return $totals;
	}
	public function MJ_amgt_get_invoice_totals_user($member_id)
	{
		global $wpdb;

		$totals = array(
			'unpaid' => 0,
			'paid' => 0,
			'partially_paid' => 0,
		);

		// Query to get total amount of unpaid invoices for the user
		$unpaid_query = $wpdb->prepare(
			"SELECT SUM(due_amount) AS total_unpaid_amount 
			FROM {$wpdb->prefix}amgt_created_invoice_list 
			WHERE payment_status = 'Unpaid' 
			AND member_id = %d",
			$member_id
		);
		$totals['unpaid'] = $wpdb->get_var($unpaid_query);

		// Query to get total amount of paid invoices for the user
		$paid_query = $wpdb->prepare(
			"SELECT SUM(total_amount) AS total_paid_amount 
			FROM {$wpdb->prefix}amgt_created_invoice_list 
			WHERE payment_status = 'FullyPaid' 
			AND member_id = %d",
			$member_id
		);
		$totals['paid'] = $wpdb->get_var($paid_query);

		// Query to get total amount of partially paid invoices for the user
		$partially_paid_query = $wpdb->prepare(
			"SELECT SUM(paid_amount) AS total_partially_paid_amount 
			FROM {$wpdb->prefix}amgt_created_invoice_list 
			WHERE payment_status = 'Partially Paid' 
			AND member_id = %d",
			$member_id
		);
		$totals['partially_paid'] = $wpdb->get_var($partially_paid_query);

		return $totals;
	}

}
?>