<?php
/*
Plugin Name: Apartment Management System
Plugin URI: https://mojoomla.com/
Description: Apartment Management System for wordpress plugin is ideal way to manage complete housing society or neighborhood maintenance tasks. It has different user roles like Admin, Resident members, Staff Member, Gatekeeper and Accountant Users.
Version: 49.4.0 (17-05-25)
Author: Mojoomla
Author URI: https://codecanyon.net/user/mojoomla
Text Domain: apartment_mgt
Domain Path: /languages/
License: GPLv2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Copyright 2023  Mojoomla  (email : sales@mojoomla.com)
*/
define( 'AMS_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'AMS_PLUGIN_DIR', untrailingslashit( dirname( __FILE__ ) ) );
define( 'AMS_PLUGIN_URL', untrailingslashit( plugins_url( '', __FILE__ ) ) );
define( 'AMS_CONTENT_URL',  content_url( ));
require_once AMS_PLUGIN_DIR . '/settings.php';

// Add custom links to the plugin details page for better user engagement
function ams_custom_plugin_links($links) {
    $addons_link = admin_url() . 'admin.php?page=amgt-system_addon';
    $plugin_links = [
        '<a href="https://mojoomlasoftware.github.io/wp-apartment-documentation/" target="_blank">Documentation</a>',
        '<a href="https://youtu.be/AblpNzAuIo4?si=hMkoTqoVhmt5pqfm" target="_blank">Video Guide</a>',
        '<a href="https://mojoomla.com/contact/" target="_blank">Community Support</a>',
        '<a href="'.$addons_link.'" target="_blank">Addons</a>',
    ];

    return array_merge($links, $plugin_links);
}
add_filter('plugin_action_links_' . AMS_PLUGIN_BASENAME, 'ams_custom_plugin_links');

// Add custom metadata links to the plugin row for better visibility
function ams_custom_plugin_row_meta($links, $file) {
    $addons_link = admin_url() . 'admin.php?page=amgt-system_addon';
    if ($file == AMS_PLUGIN_BASENAME) {
        $custom_links = [
            '<a href="https://mojoomlasoftware.github.io/wp-apartment-documentation/" target="_blank">Documentation</a>',
            '<a href="https://youtu.be/AblpNzAuIo4?si=hMkoTqoVhmt5pqfm" target="_blank">Video Guide</a>',
            '<a href="https://mojoomla.com/contact/" target="_blank">Community Support</a>',
            '<a href="'.$addons_link.'" target="_blank">Addons</a>',
        ];
        $links = array_merge($links, $custom_links);
    }
    return $links;
}
add_filter('plugin_row_meta', 'ams_custom_plugin_row_meta', 10, 2);
?>