<?php 
add_filter( 'login_redirect', 'MJ_amgt_login_redirect',10, 3 );
// user login redirect to dashboard
function MJ_amgt_login_redirect($redirect_to, $request, $user )
{
	if (isset($user->roles) && is_array($user->roles)) 
	{
		$roles = ['Staff-Member','accountant','member','gatekeeper'];
		foreach($roles as $role)
		{
			if (in_array($role, $user->roles))
			{ 
				$redirect_to =  home_url('?apartment-dashboard=user');
				break;
			}
		}
		$roles1 = ['administrator','management'];
		foreach($roles1 as $role1)
		{
			if (in_array($role1, $user->roles))
			{ 
				$redirect_to =  admin_url () . 'admin.php?page=amgt-apartment_system';	
				break;
			}
		}
	}
	return $redirect_to;
}
//-- Fronted menu titles in Multi language formate
function MJ_amgt_change_menutitle($key)
{
	$unit_type=get_option( 'amgt_apartment_type' );
	$menu_titlearray=array(
	'resident_unit'=>esc_html__(''.$unit_type.' Unit ', 'apartment_mgt'),
	'member'=>esc_html__('Member','apartment_mgt'),
	'committee-member'=>esc_html__('Committee Member','apartment_mgt'),
	'accountant'=>esc_html__('Accountant','apartment_mgt'),
	'staff-members'=>esc_html__('Staff Member','apartment_mgt'),
	'gatekeeper'=>esc_html__('Gatekeeper','apartment_mgt'),
	'visitor-manage'=>esc_html__('Visitor Management','apartment_mgt'),
	'notice-event'=>esc_html__('Notice And Event','apartment_mgt'),
	'complaint'=>esc_html__('Complaint','apartment_mgt'),
	'parking-manager'=>esc_html__('Parking Manager','apartment_mgt'),
	'services'=>esc_html__('Services','apartment_mgt'),
	'facility'=>esc_html__('Facility','apartment_mgt'),
	'accounts'=>esc_html__('Accounts','apartment_mgt'),
	'message'=>esc_html__('Message','apartment_mgt'),
	'documents'=>esc_html__('Documents','apartment_mgt'),
	'assets-inventory-tracker'=>esc_html__('Assets / Inventory Tracker','apartment_mgt'),
	'report'=>esc_html__('Report','apartment_mgt'),
	'profile'=>esc_html__('Profile','apartment_mgt'),
	'faq'=>esc_html__('FAQ','apartment_mgt'),
	'society_rules'=>esc_html__('Society Rules','apartment_mgt'),
	'gallery'=>esc_html__('Gallery','apartment_mgt'),
	);
	return $menu_titlearray[$key];
}
//-- Get Static User Type
function MJ_amgt_get_user_roles($user_id)
{
	$user = new WP_User( intval($user_id) );
	if ( !empty( $user->roles ) && is_array( $user->roles ) ) 
	{
	    foreach ( $user->roles as $role )
		{
	      if($role == 'member')
		  {
		    
			$user_type=esc_html__('Member','apartment_mgt');

		  }
	      else if($role == 'accountant')
		  {
		   
			$user_type=esc_html__('Accountant','apartment_mgt');

		  }
	      else if($role == 'staff_member')
		  {
		   
			$user_type=esc_html__('Staff Member','apartment_mgt');

		  }
		  else if($role == 'gatekeeper')
		  {
		    
			$user_type=esc_html__('Gatekeeper','apartment_mgt');
			
		  }
		 
		}
		
		return $user_type;
	}
}
//-- End Get Static User Type

//-- User Roles In Multi language Formate 
function MJ_amgt_get_role_name($role)
{
	if($role=='all'){
		$role_title=esc_html__('All','apartment_mgt');
	}
	
	// if($role=='management'){
	// 	$role_title=esc_html__('management','apartment_mgt');
	// }

	if($role=='staff_member'){
		$role_title=esc_html__('Staff Member','apartment_mgt');
	}
		
	if($role=='committee_member'){
		$role_title=esc_html__('Committee Member','apartment_mgt');
	}
		
	if($role=='member')	{
		$role_title=esc_html__('Member','apartment_mgt');
	}
		
	if($role=='gatekeeper')	{
		$role_title=esc_html__('Gatekeeper','apartment_mgt');	
	}
		
	if($role=='accountant')
	{
		$role_title=esc_html__('Accountant','apartment_mgt');
	}
	if($role=='employee')
	{
		$role_title=esc_html__('All User','apartment_mgt');

	}
	return $role_title;
}
//-- Get Member Type Labels In Multi language 
function MJ_amgt_get_member_status_label($status)
{
	$status_title = "";
	if($status=='Owner')
		$status_title=esc_html__('Owner','apartment_mgt');
	if($status=='tenant')
		$status_title=esc_html__('Tenant','apartment_mgt');
	if($status=='owner_family')
		$status_title=esc_html__('Owner Family','apartment_mgt');
	if($status=='tenant_family')	
		$status_title=esc_html__('Tenant Family','apartment_mgt');
	if($status=='care_taker')	
		$status_title=esc_html__('Care Taker','apartment_mgt');
	return $status_title;
}
//-- Get Time Frequency Labels In Multi language  
function MJ_amgt_get_frequency_label($frequency)
{
	if($frequency=='monthly')
		$frequency_title=esc_html__('Monthly','apartment_mgt');
	if($frequency=='quarterly')
		$frequency_title=esc_html__('Quarterly','apartment_mgt');
	if($frequency=='half_yearly')
		$frequency_title=esc_html__('Half Yearly','apartment_mgt');
	if($frequency=='yearly')	
		$frequency_title=esc_html__('Yearly','apartment_mgt');
	return $frequency_title;
}
//-- Get Sloat Name
function MJ_amgt_get_sloat_name($id)
{
	global $wpdb;
	$table_name = $wpdb->prefix. 'amgt_sloats';
	$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", intval($id)));
	if(!empty($result))
		return $result;
}
//-- Get FACILITY Name
function MJ_amgt_get_facility_name($id)
{
	global $wpdb;
	$table_name = $wpdb->prefix. 'amgt_facility';
	$result = $wpdb->get_row($wpdb->prepare("SELECT * from $table_name WHERE facility_id = %d", intval($id)));
	return $result->facility_name;
}
//-- Get Apartment Gate Name
function MJ_amgt_get_gate_name($id)
{
	global $wpdb;
	$table_name = $wpdb->prefix. 'amgt_gates';
	$result = $wpdb->get_row($wpdb->prepare("SELECT *from $table_name where id = %d", intval($id)));
	if(!empty($result))
		return $result->gate_name;
}

//-- Get Invoice Title
function MJ_amgt_get_invoice_title($id)
{
	global $wpdb;
	$table_name = $wpdb->prefix. 'amgt_generat_invoice';
	$result = $wpdb->get_row($wpdb->prepare("SELECT *from $table_name where id = %d", intval($id)));
	if(!empty($result))
		return $result->title;
}

//-- Get User Display Name
function MJ_amgt_get_display_name($id)
{
	if(intval($id))
	{
		$user=get_userdata(intval($id));
		if(!empty(sanitize_text_field($user->display_name)))
		{
			return sanitize_text_field($user->display_name);
		}
		else
		{
			return "-";
		}
	}
}
//-- Get User Email By ID
function MJ_amgt_get_emailid_byuser_id($id)
{
	if (!$user = get_userdata(intval($id)))
		return false;
	return $user->data->user_email;
}
//-- Count Committee Members
function MJ_amgt_count_committee_members()
{
	$get_members = array('role' => 'member','meta_key' => 'committee_member','meta_value'=> 'yes');
	$users=get_users($get_members);
	if(!empty($users))
	{
		$user=count($users);
		return $user;
	}
	else
	{
		return 0;
	}
}
//-- Count Building Units
function MJ_amgt_count_units()
{
	$buildings=MJ_amgt_get_all_category('building_category');
	return count($buildings);
}
//-- Count In box Items
function MJ_amgt_count_inbox_item($id)
{
	global $wpdb;
	$tbl_name = $wpdb->prefix .'amgt_message';
	$inbox =$wpdb->get_results($wpdb->prepare("SELECT COUNT(*) FROM $tbl_name WHERE receiver = %d", intval($id)));
	return $inbox;
}
//-- Change Message Read Status
function MJ_amgt_change_read_status($id)
{
	global $wpdb;
	$table_name = $wpdb->prefix . "amgt_message";
	$data['msg_status']=1;
	$whereid['message_id']=intval($id);
	return $retrieve_subject = $wpdb->update($table_name,$data,$whereid);
}
function MJ_amgt_change_read_status_reply($id)
{
	global $wpdb;
	$amgt_message_replies = $wpdb->prefix . 'amgt_message_replies';
		
	$data['msg_status']=1;
	$whereid['message_id']=intval($id);
	$whereid['receiver_id']=get_current_user_id();
	$retrieve_message_reply_status = $wpdb->update($amgt_message_replies,$data,$whereid);
	
	return $retrieve_message_reply_status;
}
//-- Change Date Formate 
function MJ_amgt_change_dateformat($date)
{
	return mysql2date(get_option('date_format'),$date);
}
//-- Get Dynamic Categories
function MJ_amgt_get_all_category($model){

	$args= array('post_type'=> $model,'posts_per_page'=>-1,'orderby'=>'post_title','order'=>'Asc');

	$cat_result = get_posts( $args );

	return $cat_result;

}
//-- Get Dynamic Categories
function MJ_amgt_get_all_category_by_id($model,$post_id)
{
	$args= array('post_type'=> $model,'ID'=>intval($post_id),'order'=>'Asc');
	$cat_result = get_posts( $args );
	return $cat_result;
}
//-- Get Dynamic Categories by building id
function MJ_amgt_get_all_category_by_building_id($building_id)
{

	global $wpdb;
	$amgt_residential_units = $wpdb->prefix. 'amgt_residential_units';
	$unit_catdata = $wpdb->get_results($wpdb->prepare("SELECT DISTINCT(unit_cat_id) FROM $amgt_residential_units WHERE building_id = %d", intval($building_id)));	
	return $unit_catdata;
}
//-- Add Dynamic Category
function MJ_amgt_add_categorytype($data)
{
	
	global $wpdb;
	$result = wp_insert_post( array(

			'post_status' => 'publish',

			'post_type' => $data['category_type'],

			'post_title' => $data['category_name']) );

	 $id = $wpdb->insert_id;

	return $id;

}
//-- Get country phone Code
function MJ_amgt_get_countery_phonecode($country_name)
{
	// $url=content_url( ).'/plugins/apartment-management/lib/countrylist/countrylist.xml';
	// $xml =simplexml_load_string(MJ_amgt_get_remote_file($url));
	$path = ABSPATH."wp-content/plugins/apartment-management/lib/countrylist/countrylist.xml";
	$xml=simplexml_load_file($path) or die("Error: Cannot create object");
	foreach($xml as $country)
	{
		if($country_name == $country->name)
			return $country->phoneCode;

	}
}
//-- Load All Users in Message Module
function MJ_amgt_get_all_user_in_message()
{
	$role = MJ_amgt_get_user_role(get_current_user_id());
	$member_data = wp_get_current_user();
	if($role != "member")
	{
		$member=get_users(array('role'=>'member'));
		$accountant = get_users(array('role'=>'accountant'));
	}
	$staff_member = get_users(array('role'=>'staff_member'));
	if($role != "member")
	{
		$committee_member = get_users(array('role'=>'committee_member'));
		$gatekeeper = get_users(array('role'=>'gatekeeper'));
	}
	
	if($role != "administrator")
	{
		$admin = get_users(array('role'=>'administrator'));
	}
	
	$all_user = array(esc_html__('member','apartment_mgt')=>$member,
					esc_html__('accountant','apartment_mgt')=>$accountant,
					esc_html__('staffmember','apartment_mgt')=>$staff_member,	
					esc_html__('committee member','apartment_mgt')=>$committee_member,
					esc_html__('gatekeeper','apartment_mgt')=>$gatekeeper,
					esc_html__('administrator','apartment_mgt')=>$admin,);	
	$return_array = array();
	
	foreach($all_user as $key => $value)
	{ 
		if(!empty($value))
		{
		 
		 echo '<optgroup label='.esc_html__("$key","apartment_mgt").' style = "text-transform: capitalize;">';
			foreach($value as $user)
			{
				
				echo '<option value="'.$user->ID.'">'.$user->display_name.'</option>';
			}
		}
	}	

	$activity_category=MJ_amgt_get_all_category('building_category');
	
	if(!empty($activity_category))
	{
		echo '<optgroup label='.esc_html__("Building/Group","apartment_mgt"). ' style = "text-transform: capitalize;">';
		foreach ($activity_category as $retrive_data)
		{
			if($role == "member")
			{
				if($member_data->building_id == $retrive_data->ID)
				{
					echo '<option value="grp_'.$retrive_data->ID.'">'.$retrive_data->post_title.'</option>';
				}
			}
			else{
				echo '<option value="grp_'.$retrive_data->ID.'">'.$retrive_data->post_title.'</option>';
			}
		}
	} 
}
//-- Create Login Page For Front-end Users
function MJ_amgt_login_link()
{
	$args = array( 'redirect' => site_url() );
	if(isset($_GET['login']) && $_GET['login'] == 'failed')
	{?>
		<div id="login-error" class="login_css">
		  <p><?php esc_html_e('Login failed: You have entered an incorrect Username or password, please try again.','apartment_mgt');?></p>
		</div>
<?php
	}
	 $args = array(
			'echo' => true,
			'redirect' => site_url( $_SERVER['REQUEST_URI'] ),
			'form_id' => 'loginform',
			'label_username' => esc_html__('Username' , 'apartment_mgt'),
			'label_password' => esc_html__('Password', 'apartment_mgt' ),
			'label_remember' => esc_html__('Remember Me' , 'apartment_mgt'),
			'label_log_in' => esc_html__('Log In' , 'apartment_mgt'),
			'id_username' => 'user_login',
			'id_password' => 'user_pass',
			'id_remember' => 'rememberme',
			'id_submit' => 'wp-submit',
			'remember' => true,
			'value_username' => NULL,
	        'value_remember' => false ); 
	 $args = array('redirect' => site_url('/?amgt-dashboard=user') );
	 
	 if ( is_user_logged_in() )
	 {
	 	?>
		<a href="<?php echo home_url('/')."?amgt-dashboard=user"; ?>"><i class="fa fa-sign-out m-r-xs"></i>
		  <?php esc_html_e('Dashboard','apartment_mgt');?>
		</a>
		<br />
		<a href="<?php echo wp_logout_url(); ?>"><i class="fa fa-sign-out m-r-xs"><?php esc_html_e('Logout','apartment_mgt');?>
		</a> 
		<?php 
	 }
	 else 
	 {
		wp_login_form( $args );
	 }
}
//-- Get User Role by User ID
function MJ_amgt_get_user_role($user_id)
{
	$user = new WP_User( intval($user_id) );
	if ( !empty( $user->roles ) && is_array( $user->roles ) ) 
	{
		foreach ( $user->roles as $role )
		return $role;
	}
}
//-- Check Facility Available OR Not
function MJ_amgt_check_facility_availability($facility_id)
{
	global $wpdb;
	$curr_date=date('Y-m-d');
	$table_name = $wpdb->prefix. 'amgt_facility_booking';
	$result=$wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE end_date >= %s AND facility_id = %d",$curr_date,intval($facility_id)));	
	return $result;
}
//-- Get Period Title For Generate Invoice 
function MJ_amgt_get_period_title($frequency,$period)
{
	$period_title='';
	if($frequency=='monthly')
	{
		
		$period_title=date('F',strtotime("first day of -$period month"));
	
	}
	if($frequency=='quarterly')
	{ 
		if($period=='quirter1')
			$period_title=esc_html__('Quarter I','apartment_mgt');
		if($period=='quirter2')
			$period_title=esc_html__('Quarter II','apartment_mgt');
		if($period=='quirter3')
			$period_title=esc_html__('Quarter III','apartment_mgt');
		if($period=='quirter4')
			$period_title=esc_html__('Quarter IV','apartment_mgt');
		
	}
	if($frequency=='half_yearly')
	{ 	
			if($period=='half1')
			$period_title=esc_html__('I Half','apartment_mgt');
			if($period=='half2')
			$period_title=esc_html__('II Half','apartment_mgt');

	}
	if($frequency=='yearly')
	{  
		$period_title=esc_html__('Yearly','apartment_mgt');
	}
	return $period_title;
}
//-- Get Member List of Building By Passing Building ID 
function MJ_amgt_get_building_members($id)
{
	
	$user_query = new WP_User_Query(
		array(
			'meta_key'	  =>	'building_id',
			'meta_value'	=>	intval($id)
		)
	);
	$users = $user_query->get_results();
	if(!empty($users))
		return $users;
}
//-- Get Member List of Unit By Passing Unit Name 
function MJ_amgt_get_unit_members($unitname)
{
	$user_query = new WP_User_Query(
		array(
			'meta_key'	  =>	'unit_name',
			'meta_value'	=>	sanitize_text_field($unitname)
		)
	);
	$users = $user_query->get_results();
	if(!empty($users))
		return $users;
}
//-- Get Member List of Unit By Passing Unit Name  AND Building_id
function MJ_amgt_get_building_unit_cat_members($building_id,$unit_cat)
{
	
	$user_query = new WP_User_Query(
		array(
			'meta_key'	  =>	'building_id',
			'meta_value'	=>	sanitize_text_field($building_id),
		),
		array(
			'meta_key'	  =>	'unit_cat_id',
			'meta_value'	=>	sanitize_text_field($unit_cat),
		)
	);
	$users = $user_query->get_results();
	if(!empty($users))
		return $users;
}
//-- Register Custome Post Type For Apartment Rules
function MJ_amgt_register_rules_post_type() {
		
			$labels = array(
				'name'               => _x( 'Society Rules', 'Post Type General Name', 'apartment_mgt' ),
				'singular_name'      => _x( 'Society Rules', 'Post Type Singular Name', 'apartment_mgt' ),
				'menu_name'          => esc_html__('Society Rules', 'apartment_mgt' ),
				'parent_item_colon'  => esc_html__('Parent Item:', 'apartment_mgt' ),
				'all_items'          => esc_html__('Society Rules', 'apartment_mgt' ),
				'view_item'          => esc_html__('View Rules', 'apartment_mgt' ),
				'add_new_item'       => esc_html__('Add New Rules', 'apartment_mgt' ),
				'add_new'            => esc_html__('Add New', 'apartment_mgt' ),
				'edit_item'          => esc_html__('Edit Rules', 'apartment_mgt' ),
				'update_item'        => esc_html__('Update Rules', 'apartment_mgt' ),
				'search_items'       => esc_html__('Search Rules', 'apartment_mgt' ),
				'not_found'          => esc_html__('No rules found', 'apartment_mgt' ),
				'not_found_in_trash' => esc_html__('No rules found in Trash', 'apartment_mgt' ),
			);
		
		$args = array(
				'labels'             => $labels,
				'public'             => true,
                'show_ui'            => true,
				'map_meta_cap'       => true,
				//'show_in_menu'       => 'amgt-apartment_system',
				'show_in_admin_bar'  => true,
				'show_in_nav_menus'  => true,
				'menu_icon'          => 'dashicons-hammer',
			     'supports'           => array( 'title', 'editor', 'thumbnail', 'revisions', 'comments', 'author' ),
				'hierarchical'       => true,
				'rewrite'            => array( 'slug' => 'rules', 'hierarchical' => true, 'with_front' => false )
				//"register_meta_box_cb" => array(__CLASS__,"meta_boxes")
			);
			register_post_type( 'amgt_society_rules', $args );
				
		
	}
//-- Register Custome Post Type For FAQ
function MJ_amgt_register_faq_post_type() {
		
			$labels = array(
				'name'               => _x( 'FAQ', 'Post Type General Name', 'apartment_mgt' ),
				'singular_name'      => _x( 'FAQ', 'Post Type Singular Name', 'apartment_mgt' ),
				'menu_name'          => esc_html__('FAQ', 'apartment_mgt' ),
				
				'parent_item_colon'  => esc_html__('Parent Item:', 'apartment_mgt' ),
				'all_items'          => esc_html__('All FAQ', 'apartment_mgt' ),
				'view_item'          => esc_html__('View FAQ', 'apartment_mgt' ),
				'add_new_item'       => esc_html__('Add New FAQ', 'apartment_mgt' ),	
				'add_new'            => esc_html__('Add New', 'apartment_mgt' ),
				'edit_item'          => esc_html__('Edit FAQ', 'apartment_mgt' ),
				'update_item'        => esc_html__('Update FAQ', 'apartment_mgt' ),
				'search_items'       => esc_html__('Search FAQ', 'apartment_mgt' ),
				'not_found'          => esc_html__('No FAQ found', 'apartment_mgt' ),
				'not_found_in_trash' => esc_html__('No FAQ found in Trash', 'apartment_mgt' ),
			);
		
		$args = array(
				'labels'             => $labels,
				'public'             => true,
                'show_ui'            => true,
				'map_meta_cap'       => true,
				//'show_in_menu'       => 'amgt-apartment_system',
				'show_in_admin_bar'  => true,
				'show_in_nav_menus'  => true,
				'menu_icon'          => 'dashicons-format-status',
			     'supports'           => array( 'title', 'editor', 'thumbnail', 'revisions', 'comments', 'author' ),
				'hierarchical'       => true,
				'rewrite'            => array( 'slug' => 'faq', 'hierarchical' => true, 'with_front' => false )
				//"register_meta_box_cb" => array(__CLASS__,"meta_boxes")
			);
			register_post_type( 'amgt_FAQ', $args );
				
		
	}
//-- Register Custome Post Type For Photo Gallery
function MJ_amgt_register_photogallary_post_type() {
		
			$labels = array(
				'name'               => _x( 'Photo Gallery', 'Post Type General Name', 'apartment_mgt' ),
				'singular_name'      => _x( 'Photo Gallery', 'Post Type Singular Name', 'apartment_mgt' ),
				'menu_name'          => esc_html__('Photo Gallery', 'apartment_mgt' ),
				'parent_item_colon'  => esc_html__('Parent Item:', 'apartment_mgt' ),
				'all_items'          => esc_html__('Photo Gallery', 'apartment_mgt' ),
				'view_item'          => esc_html__('View Photo Gallery', 'apartment_mgt' ),
				'add_new_item'       => esc_html__('Add New Photo Gallery', 'apartment_mgt' ),
				'add_new'            => esc_html__('Add New', 'apartment_mgt' ),
				'edit_item'          => esc_html__('Edit Photo Gallery', 'apartment_mgt' ),
				'update_item'        => esc_html__('Update Photo Gallery', 'apartment_mgt' ),
				'search_items'       => esc_html__('Search Photo Gallery', 'apartment_mgt' ),
				'not_found'          => esc_html__('No Photo Gallery found', 'apartment_mgt' ),
				'not_found_in_trash' => esc_html__('No Photo Gallery found in Trash', 'apartment_mgt' ),
			);
		
		$args = array(
				'labels'             => $labels,
				'public'             => true,
                'show_ui'            => true,
				'map_meta_cap'       => true,
				
				//'show_in_menu'       => 'amgt-apartment_system',
				'show_in_admin_bar'  => true,
				'show_in_nav_menus'  => true,
				'menu_icon'          => 'dashicons-format-gallery',
			     'supports'           => array( 'title', 'editor', 'thumbnail', 'revisions', 'comments', 'author' ),
				'hierarchical'       => true,
				'rewrite'            => array( 'slug' => 'photo-Gallery', 'hierarchical' => true, 'with_front' => false )
				//"register_meta_box_cb" => array(__CLASS__,"meta_boxes")
			);
			register_post_type( 'amgt_photo_gallery', $args );
				
		
	}
//-- Get Columns of Photo Gallery Post Type
function MJ_amgt_Gallery_columns_head($defaults)
 {
    $defaults['Gallery_shortcode'] = 'Shortcode';
    return $defaults;
 }
// SHOW THE FEATURED IMAGE
function MJ_amgt_gallery_columns_content($column_name, $post_ID) {
    if ($column_name == 'Gallery_shortcode') {
        echo '[photoGalleryCode id='.$post_ID.']';
    }
}

add_filter('manage_amgt_photo_gallery_posts_columns', 'MJ_amgt_Gallery_columns_head');
add_action('manage_amgt_photo_gallery_posts_custom_column', 'MJ_amgt_gallery_columns_content', 10, 2);	

/*--------Add post metabox-------------------*/
add_action("add_meta_boxes_amgt_photo_gallery","add_meta_gallery",2);	
add_action('save_post_amgt_photo_gallery', 'MJ_amgt_save_posts',2);
function add_meta_gallery()
{
	add_meta_box('amgt_meta_gallery','Gallery','MJ_amgt_meta_callback_gallery','amgt_photo_gallery','normal','default');			
}
// ADD METABOX FOR GALLERY CUSTOM POST TYPE 
function MJ_amgt_meta_callback_gallery()
{ 
 global $post;
	$gallery_data = get_post_meta( $post->ID, 'amgtfld_gallery', true );
 
	// Use nonce for verification
	wp_nonce_field( plugin_basename( __FILE__ ), 'noncename_so_14445904' );
	?> 
<div id="dynamic_form"> <!--  Dynamic form div  -->
    <div id="field_wrap_1">
    <?php 
    if ( isset( $gallery_data['image_url'] ) && !empty($gallery_data['image_url'][0]) ) 
    { 		
       	 
			foreach($gallery_data['image_url'] as $img)
			{
				if($img != "")
				{ ?>				 
					<div class="field_row">
			 
					  <div class="field_left">
						<div class="form_field">
						  <label><?php _e("Image URL","apartment_mgt");?></label>
						  <input type="text"
								 class="meta_image_url"
								 name="amgtfld_gallery[image_url][]"
								 value="<?php echo $img;//esc_html_e( $gallery_data['image_url'][$i] ); ?>"/>
						</div>
					  </div>
			 
					  <div class="field_right image_wrap">
						<img src="<?php echo $img;//esc_html_e( $gallery_data['image_url'][$i] ); ?>" height="65" width="65" />
					  </div>
			 
					  <div class="field_right">
						<input class="button" type="button" value="<?php _e("Select Image","apartment_mgt");?>" onclick="add_image(this)" /><br />
						<input class="button" type="button" value="<?php _e("Remove","apartment_mgt");?>" onclick="remove_field(this)" />
					  </div>
			 
					  <div class="clear"></div> 
	</div>
			<?php
				} 
			}
    } 
    ?>
</div><!--  Enc Dynamic form div  -->
    <div class="display_none" id="master-row-1">
		<div class="field_row">
			<div class="field_left">
				<div class="form_field">
					<label><?php _e("Image URL","apartment_mgt");?></label>
					<input class="meta_image_url" value="" type="text" name="amgtfld_gallery[image_url][]" />
				</div>
			</div>
			<div class="field_right image_wrap">
			</div> 
			<div class="field_right"> 
				<input type="button" class="button" value="<?php _e("Select Image","apartment_mgt");?>" onclick="add_image(this)" />
				<br />
				<input class="button" type="button" value="<?php _e("Remove","apartment_mgt");?>" onclick="remove_field(this)" /> 
			</div>
			<div class="clear"></div>
		</div>
    </div>
    <div id="add_field_row">
      <input class="button" type="button" value="<?php _e("Add Image","apartment_mgt"); ?>" onclick="add_field_row(1)" />
    </div>
  <?php
  echo "<input type='hidden' name='amgtfld_amgt_meta_nonce' value='".wp_create_nonce(basename(__FILE__))."'>";
}	
// SAVE GALLERY CUSTOM POST TYPE 
function MJ_amgt_save_posts($post_id)
{
	
	if(@!wp_verify_nonce($_POST['amgtfld_amgt_meta_nonce'], basename(__FILE__)))
	{
		return;
	}	
  	else if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
	else if ( ! current_user_can( 'edit_page', $post_id ) ) {
		return false;
	}
	else{
	
		foreach($_POST as $form_field => $value)
		{
			$fld = "";
			$fld = substr($form_field,0,8);
			if($fld == "amgtfld_")
			{				
				update_post_meta($post_id,$form_field,$value);
			}			
		}

	}
	
}
// LOAD APARTMENT DOCUMENTS  
function MJ_amgt_amgt_load_documets($file,$type,$nm) 
{
	$check_document=MJ_amgt_wp_check_filetype_and_ext($file['tmp_name'],$file['name']);
	if($check_document)
	{
		$parts = pathinfo($_FILES[$type]['name']);
		$inventoryimagename = time()."-".$nm."-"."in".".".$parts['extension'];
		$document_dir = WP_CONTENT_DIR ;
		$document_dir .= '/uploads/apartment_assets/';
		$document_path = $document_dir;
		if (!file_exists($document_path))
		{
			mkdir($document_path, 0777, true);
		}	
		if (is_uploaded_file($_FILES[$type]['tmp_name'])) 
		{
			if (move_uploaded_file($_FILES[$type]['tmp_name'], $document_path.$inventoryimagename))
			{
			$imagepath= $inventoryimagename;	
			}
		}
		return $imagepath;
	}
	else
	{
		die(__("File type is not allowed.", "gym_mgt"));
	}
}
// LOAD DOCUMENTS  FUNCTION
// function MJ_amgt_load_documets($file,$type,$nm)
// {	
// 	$parts = pathinfo($type['name'][0]);
// 	$inventoryimagename = time()."-".rand().".".$parts['extension'];
// 	$document_dir = WP_CONTENT_DIR;
// 	$document_dir .= '/uploads/apartment_assets/';
// 	$document_path = $document_dir;
// 	if (!file_exists($document_path)) {
// 		mkdir($document_path, 0777, true);	
// 	}
// 	$imagepath="";	
// 	if (move_uploaded_file($type['tmp_name'][0], $document_path.$inventoryimagename)) 
// 	{
// 		$imagepath= $inventoryimagename; 
// 	}
// 	return $imagepath;
// }

function MJ_amgt_load_documets($file, $type, $nm)
{   

    $parts = pathinfo($file['name']);
    $imagepath = "";
    $check_document = MJ_amgt_wp_check_filetype_and_ext($file['tmp_name'], $file['name']);
    if ($check_document)
    {
        if (isset($parts['extension']))
        {
            $inventoryimagename = time()."-".rand().".".$parts['extension'];

            $document_dir = WP_CONTENT_DIR;
            $document_dir .= '/uploads/apartment_assets/';
            $document_path = $document_dir;

            if (!file_exists($document_path)) {
                mkdir($document_path, 0777, true);  
            }

            if (is_uploaded_file($file['tmp_name']))  // Fix: access tmp_name correctly
            {
                if (move_uploaded_file($file['tmp_name'], $document_path.$inventoryimagename)) 
                {
                    $imagepath = $inventoryimagename; 
                }
            }
        }
        return $imagepath;
    }
    else
    {
        die(__("File type is not allowed.", "gym_mgt"));
    }
}
function MJ_amgt_load_documets_edit($file, $type, $nm)
{   

    $parts = pathinfo($file['name'][0]);
    $imagepath = "";
    $check_document = MJ_amgt_wp_check_filetype_and_ext($file['tmp_name'][0], $file['name'][0]);
    if ($check_document)
    {
        if (isset($parts['extension']))
        {
            $inventoryimagename = time()."-".rand().".".$parts['extension'];

            $document_dir = WP_CONTENT_DIR;
            $document_dir .= '/uploads/apartment_assets/';
            $document_path = $document_dir;

            if (!file_exists($document_path)) {
                mkdir($document_path, 0777, true);  
            }

            if (is_uploaded_file($file['tmp_name'][0]))  // Fix: access tmp_name correctly
            {
                if (move_uploaded_file($file['tmp_name'][0], $document_path.$inventoryimagename)) 
                {
                    $imagepath = $inventoryimagename; 
                }
            }
        }
        return $imagepath;
    }
    else
    {
        die(__("File type is not allowed.", "gym_mgt"));
    }
}



// DEFINED PRINT FUNCTION ON INIT EVENT
function MJ_amgt_print_init()
{
	if(isset($_REQUEST['print']) && $_REQUEST['print'] == 'print' && $_REQUEST['page'] == 'invoice')
	{ ?>
			<script>window.onload = function(){ setTimeout(function() { window.print()}, 500); };</script>
			<?php 
			MJ_amgt_invoice_print(Mj_amgt_decrypt_id($_REQUEST['invoice_id']),$_REQUEST['invoice_type']);
			exit;
	}
	elseif(isset($_REQUEST['print']) && $_REQUEST['print'] == 'print' && $_REQUEST['page'] == 'amgt-visiter-manage') { ?>

		<script>window.onload = function(){ setTimeout(function() { window.print()}, 1000); };</script>
		<?php
		MJ_amgt_visiter_checkin_details_print(Mj_amgt_decrypt_id($_REQUEST['visitor_checkin_id']));
		exit;
	}
	
	elseif(isset($_REQUEST['print']) && $_REQUEST['print'] == 'print' && $_REQUEST['page'] == 'visitor-manage')
	{ ?>
			<script>window.onload = function(){ setTimeout(function() { window.print()}, 500); };</script>
			<?php 
			MJ_amgt_visiter_checkin_details_print(Mj_amgt_decrypt_id($_REQUEST['visitor_checkin_id']));
			exit;
	}
	elseif(isset($_REQUEST['print']) && $_REQUEST['print'] == 'print' && $_REQUEST['page'] == 'payment_receipt')
	{ ?>
			<script>window.onload = function(){ setTimeout(function() { window.print()}, 500); };</script>
			<?php 
			MJ_amgt_invoice_payment_receipt_print(Mj_amgt_decrypt_id($_REQUEST['invoice_id']),Mj_amgt_decrypt_id($_REQUEST['member_id']));
			exit;
	}	
	
}
add_action('init','MJ_amgt_print_init');
//GENERATE  INVOICE FOR PDF FUNCTION CALL FOR INIT
function MJ_amgt_pdf_init()
{
	if (is_user_logged_in ()) 
	{
		if(isset($_REQUEST['invoicepdf']) && $_REQUEST['invoicepdf'] == 'invoicepdf')
		{	
			ob_start();
			error_reporting(0);		
			MJ_amgt_invoice_pdf(intval(Mj_amgt_decrypt_id($_REQUEST['invoice_id'])),$_REQUEST['invoice_type']);
			$out_put = ob_get_contents();
			ob_clean();
			header('Content-type: application/pdf');
			header('Content-Disposition: inline; filename="invoice.pdf"');
			header('Content-Transfer-Encoding: binary');
			header('Accept-Ranges: bytes');	
			require_once AMS_PLUGIN_DIR . '/lib/mpdf/vendor/autoload.php';	
			$mpdf = new Mpdf\Mpdf;
			$mpdf->SetTitle('Invoice Payment');
			$mpdf->autoScriptToLang = true;
			$mpdf->autoLangToFont = true;
			
			if (is_rtl())
			{
				$mpdf->autoScriptToLang = true;
				$mpdf->autoLangToFont = true;
				$mpdf->SetDirectionality('rtl');
			}   
			
			$mpdf->WriteHTML($out_put);
			$mpdf->Output();
			unset( $out_put );
			unset( $mpdf );
			ob_end_flush();
			exit;
		}	
	}
}
add_action('init','MJ_amgt_pdf_init');

/* Setup form submit*/
function MJ_amgt_submit_setupform($data)
{
	$domain_name= $data['domain_name'];
	$licence_key = $data['licence_key'];
	$email = $data['enter_email'];		
	$result = amgt_check_productkey($domain_name,$licence_key,$email);	
	if($result == '1')
	{
		$message = esc_attr__('Please provide correct Envato purchase key.','apartment_mgt');
		$_SESSION['amgt_verify'] = '1';
	}
	elseif($result == '2')
	{
		$message = esc_attr__('This purchase key is already registered with the different domain.please contact us at sales@mojoomla.com','apartment_mgt');
		$_SESSION['amgt_verify'] = '2';
	}
	elseif($result == '3')
	{
		$message = esc_attr__('There seems to be some problem please try after sometime or contact us on sales@mojoomla.com','apartment_mgt');
		$_SESSION['amgt_verify'] = '3';
	}
	else
	{
		update_option('domain_name',$domain_name,true);
		update_option('licence_key',$licence_key,true);
		update_option('amgt_setup_email',$email,true);
		$message = esc_attr__('License key successfully registered.','apartment_mgt');
		$_SESSION['amgt_verify'] = '0';
			
	}		
	$result_array = array('message'=>$message,'amgt_verify'=>$_SESSION['amgt_verify']);
	return $result_array;
}
// CHECK PRODUCT KEY FOR REGISTER LICENCE PRODUCT
function amgt_check_productkey($domain_name,$licence_key,$email)
{
	$api_server = 'license.dasinfomedia.com';
	$fp = @fsockopen($api_server,80, $errno, $errstr, 2);
	$location_url = admin_url().'admin.php?page=customcrm';
	if (!$fp)
	{
        $server_rerror = 'Down';
	}
    else
	{
        $server_rerror = "up";
	}
	if($server_rerror == "up")
	{
		$curl = curl_init();
		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://license.dasinfomedia.com/admin/api/license/register',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		  CURLOPT_POSTFIELDS => array('pkey' =>$licence_key ,'email' => $email,'domain' => $domain_name),
		));
		$response = curl_exec($curl);
		
		curl_close($curl);
		return amgt_return_license_response($response);
	}
	else
	{
		return '3';
	}
}
function amgt_return_license_response($response)
{
	$response_data=json_decode($response,true);
	$error=$response_data['error'];
	$message=$response_data['message'];
	if($error === false && $message === 'License already registered')
	{
		return '2';
	}
	elseif($error === false && $message === 'Invalid license')
	{
		return '1';
	}
	elseif($error === false && $message === 'Failed to register license')
	{
		return '3';
	}
	elseif($error === true && $message === 'License registered successfully')
	{
		return '0';
	}
	elseif($error === false && $message === 'License already registered with the same domain')
	{
		return '0';
	}
}
// CHECK PAGE IS APARTMENT PAGE OR NOT
function amgt_is_amgtpage()
{
	$current_page = isset($_REQUEST['page'])?$_REQUEST['page']:'';
	$pos = strrpos($current_page, "amgt-");	
	if($pos !== false)			
	{
		return true;
	}
	return false;
}

// CHECK LOCAL SERVER OR NOT
function amgt_chekserver($server_name)
{
	if($server_name == 'localhost')
	{
		return true;
	}		
}
// CHECK LIVE SERVER(license.dasinfomedia.com) IS DOWN OR NOT
function amgt_check_ourserver()
{
	//$api_server = 'http://license.dasinfomedia.com';
	$api_server = 'license.dasinfomedia.com';
	//$api_server = '192.168.1.22';
	$fp = @fsockopen($api_server,80, $errno, $errstr, 2);
	$location_url = admin_url().'admin.php?page=amgt-amgt_setup';
	if (!$fp)
        return false; /*server down*/
    else
        return true; /*Server up*/
}

// CHECK PAGE IS APARTMENT OR NOT
function amgt_check_verify_or_not($result)
{	
	$server_name = $_SERVER['SERVER_NAME'];
	$current_page = isset($_REQUEST['page'])?$_REQUEST['page']:'';
	$pos = strrpos($current_page, "amgt-");	
	if($pos !== false)			
	{
		if($server_name == 'localhost')
		{
			return true;
		}
		else
		{
			if($result === '0' OR $result === '4')
			{
				return true;
			}
		}
		return false;
	}	
}
// GET MEASUREMENT TYPE TITLE IN MULTILANGUAGE FORMATE
function MJ_amgt_GetMeasurementTypeText($measurement)
{
	$measuremetn_array=array('square_feet'=>esc_html__('Square Feet','apartment_mgt'),
							'square_meter'=>esc_html__('Square Meter','apartment_mgt'),
							'square_yards'=>esc_html__('Square Yards','apartment_mgt'));
		return $measuremetn_array[$measurement];					
}
// SEND EMAIL FOR NOTIFICATIONS WITH HTML CONTENT 
function MJ_amgt_SendEmailNotificationWithHTML($to, $subject, $message_content)
{
	$apartment=get_option('amgt_system_name');
	$headers="";
	$headers .= 'From: '.$apartment.' <noreplay@gmail.com>' . "\r\n";
	$headers .= "MIME-Version: 1.0\r\n";
	//$headers .= "Content-Type: text/html; charset=iso-8859-1\r\n";
	$headers .= array('Content-Type: text/html; charset=UTF-8');
	$enable_notofication=get_option('apartment_enable_notifications');
	if($enable_notofication=='yes')
	{
		$messagecontent = MJ_amgt_get_mail_content_with_template_design('<pre>'.$message_content.'</pre>');
		wp_mail($to, $subject, $messagecontent,$headers); 
	}
}
// SEND EMAIL FOR NOTIFICATIONS WITH TEXT CONTENT  
function MJ_amgt_SendEmailNotification($to, $subject, $message_content)
{
	$apartment=get_option('amgt_system_name');
	$headers="";
	$headers .= 'From: '.$apartment.' <noreplay@gmail.com>' . "\r\n";
	$headers .= "MIME-Version: 1.0\r\n";
	$headers .= "Content-Type: text/html; charset=iso-8859-1\r\n";
	$headers .= 'Content-Type: text/html; charset=UTF-8';
	$enable_notofication=get_option('apartment_enable_notifications');
	if($enable_notofication=='yes')
	{
		$messagecontent = MJ_amgt_get_mail_content_with_template_design('<pre>'.$message_content.'</pre>');
        wp_mail($to, $subject, $messagecontent,$headers);  
	}
}
//GET CURENCY FOR COUNTARY FUNCTION
function MJ_amgt_get_currency_symbol( $currency = '' )
{	
	switch ( $currency ) {
	case 'Q' :
	$currency_symbol = 'Q';
	break;
	case 'AED' :
	$currency_symbol = 'د.إ';
	break;
	case 'AUD' :
	$currency_symbol = '&#36;';
	break;
	case 'CAD' :
	$currency_symbol = 'C&#36;';
	break;
	case 'CLP' :
	case 'COP' :
	case 'HKD' :
	$currency_symbol = '&#36';
	break;
	case 'MXN' :
	$currency_symbol = '&#36';
	break;
	case 'NZD' :
	$currency_symbol = '&#36';
	break;
	case 'SGD' :
	case 'USD' :
	$currency_symbol = '&#36;';
	break;
	case 'BDT':
	$currency_symbol = '&#2547;&nbsp;';
	break;
	case 'BGN' :
	$currency_symbol = '&#1083;&#1074;.';
	break;
	case 'BRL' :
	$currency_symbol = '&#82;&#36;';
	break;
	case 'CHF' :
	$currency_symbol = '&#67;&#72;&#70;';
	break;
	case 'ZAR' :
	$currency_symbol = 'ZAR';
	break;
	case 'CNY' :
	case 'JPY' :
	case 'RMB' :
	$currency_symbol = '&yen;';
	break;
	case 'CZK' :
	$currency_symbol = '&#75;&#269;';
	break;
	case 'DKK' :
	$currency_symbol = 'kr.';
	break;
	case 'DOP' :
	$currency_symbol = 'RD&#36;';
	break;
	case 'EGP' :
	$currency_symbol = 'EGP';
	break;
	case 'EUR' :
	$currency_symbol = '&euro;';
	break;
	case 'GBP' :
	$currency_symbol = '&pound;';
	break;
	case 'HRK' :
	$currency_symbol = 'Kn';
	break;
	case 'HUF' :
	$currency_symbol = '&#70;&#116;';
	break;
	case 'IDR' :
	$currency_symbol = 'Rp';
	break;
	case 'ILS' :
	$currency_symbol = '&#8362;';
	break;
	case 'INR' :
	$currency_symbol = 'Rs.';
	break;
	case 'ISK' :
	$currency_symbol = 'Kr.';
	break;
	case 'KIP' :
	$currency_symbol = '&#8365;';
	break;
	case 'KRW' :
	$currency_symbol = '&#8361;';
	break;
	case 'MYR' :
	$currency_symbol = '&#82;&#77;';
	break;
	case 'NGN' :
	$currency_symbol = '&#8358;';
	break;
	case 'NOK' :
	$currency_symbol = '&#107;&#114;';
	break;
	case 'NPR' :
	$currency_symbol = 'Rs.';
	break;
	case 'PHP' :
	$currency_symbol = '&#8369;';
	break;
	case 'PLN' :
	$currency_symbol = '&#122;&#322;';
	break;
	case 'PYG' :
	$currency_symbol = '&#8370;';
	break;
	case 'RON' :
	$currency_symbol = 'lei';
	break;
	case 'RUB' :
	$currency_symbol = '&#1088;&#1091;&#1073;.';
	break;
	case 'SEK' :
	$currency_symbol = '&#107;&#114;';
	break;
	case 'THB' :
	$currency_symbol = '&#3647;';
	break;
	case 'TRY' :
	$currency_symbol = '&#8378;';
	break;
	case 'TWD' :
	$currency_symbol = '&#78;&#84;&#36;';
	break;
	case 'UAH' :
	$currency_symbol = '&#8372;';
	break;
	case 'VND' :
	$currency_symbol = '&#8363;';
	break;
	case 'ZAR' :
	$currency_symbol = '&#82;';
	break;
	default :
	$currency_symbol = $currency;
	break;
	}
	return $currency_symbol;

  }
  //IMAGE VALIDATION FUNCTION
  function MJ_amgt_check_valid_extension($filename)
  {
	$flag = 2; 
	if($filename != '')
	{
		$flag = 0;
		$ext = pathinfo($filename, PATHINFO_EXTENSION);
		$valid_extension = ['gif','png','jpg','jpeg',""];
		if(in_array($ext,$valid_extension) )
		{
		$flag = 1;
		}
	}
	return $flag;
  }
  function MJ_cmgt_calander_laungage()
  {
	  $lancode=get_locale();
	  $code=substr($lancode,0,2);		
	   return $code;
  }
function MJ_amgt_convert_time($time) 
{
	$timestamp = strtotime( $time ); // Converting time to Unix timestamp
	$offset = get_option( 'gmt_offset' ) * 60 * 60; // Time offset in seconds
	$local_timestamp = $timestamp + $offset;
	$local_time = date_i18n('Y-m-d H:i:s', $local_timestamp);
	return $local_time;
}
  //GET DATA FORMATE FUNCTION
    function MJ_amgt_date_formate()
    {
	  $dateFormat=get_option( 'amgt_date_formate' );
	 return $dateFormat;
    }
	//GET PHP DATA FORMATE FUNCTION
	function MJ_amgt_dateformat_PHP_to_jQueryUI($php_format)
    {
			$SYMBOLS_MATCHING = array(
			// Day
			'd' => 'dd',
			'D' => 'D',
			'j' => 'd',
			'l' => 'DD',
			'N' => '',
			'S' => '',
			'w' => '',
			'z' => 'o',
			// Week
			'W' => '',
			// Month
			'F' => 'MM',
			'm' => 'mm',
			'M' => 'M',
			'n' => 'm',
			't' => '',
			// Year
			'L' => '',
			'o' => '',
			'Y' => 'yyyy',
			'y' => 'y',
			// Time
			'a' => '',
			'A' => '',
			'B' => '',
			'g' => '',
			'G' => '',
			'h' => '',
			'H' => '',
			'i' => '',
			's' => '',
			'u' => ''
			);
			$jqueryui_format = "";
			$escaping = false;
			for($i = 0; $i < strlen($php_format); $i++)
			{
				$char = $php_format[$i];
				if($char === '\\') // PHP date format escaping character
				{
					$i++;
					if($escaping) $jqueryui_format .= $php_format[$i];
					else $jqueryui_format .= '\'' . $php_format[$i];
					$escaping = true;
				}
				else
				{
					if($escaping) { $jqueryui_format .= "'"; $escaping = false; }
					if(isset($SYMBOLS_MATCHING[$char]))
					$jqueryui_format .= $SYMBOLS_MATCHING[$char];
					else
					$jqueryui_format .= $char;
				}
			}
        return $jqueryui_format;
    }
 //GET DATA FORMATE FOR DATABASE FUNCTION
// function MJ_amgt_get_format_for_db($date)
//  {
// 	 if(!empty($date))
// 	 {
		
		
// 		 $date = trim($date);
// 		 $new_date = DateTime::createFromFormat(MJ_amgt_date_formate(), $date); // Correct the format
// 		 if ($new_date) {
// 			 $new_date = $new_date->format('Y-m-d');
// 		 } else {
// 			 $new_date = null; // Handle parsing failure
// 		 }
// 	 }
// 	 else
// 	 {
// 		 $new_date = null;
// 	 }
// 	 return $new_date;
//  }
function MJ_amgt_get_format_for_db($date) 
 {
	 if (!empty($date)) 
	 {
		 $date = trim($date);
		 $new_date = DateTime::createFromFormat("Y-m-d", $date);
 
		 // Check if the date was successfully parsed
		 if ($new_date !== false) {
			 $new_date = $new_date->format('Y-m-d');
		 } else {
			 // Handle the case where the date format is invalid
			 $new_date = null;
		 }
	 } 
	 else 
	 {
		 $new_date = null;
	 }
	 return $new_date;
 }
 
//GET DATA FORMATE  FOR VIEW TIME FUNCTION
function MJ_amgt_get_format_for_display($date)
{
	 $date = trim($date);
	 $new_date = DateTime::createFromFormat(MJ_amgt_date_formate(), $date);
	 $new_date=$new_date->format(MJ_amgt_date_formate());
	 return $new_date;
}

//GET DATA FOR ALL MEMBER FUNCTION
function MJ_amgt_get_all_member_data()
{
   /*$get_members = array(
						'role' => 'member',
						'meta_query'=>
						 array(
							array(
								'relation' => 'OR',
							array(
								'key'	  =>'occupied_by',
								'value'	=>	'Owner',
								'compare' => '=',
							),
							array(
								'key'	  =>'occupied_by',
								'value'	=>	'Tenant',
								'compare' => '=',
							)
						  )
					   )
					);*/
	$get_members = array('role' => 'member');
	 $membersdata=get_users($get_members);
	 return $membersdata;
}

//GET MEMBER DATA FOR BULDING WISE FUNCTION
function MJ_amgt_get_all_member_data_by_building_id($building_id)
{
/*	$membersdata = get_users(
					array(
						'role' => 'member',						
						'meta_query' => array(
						'relation' => 'AND',
						array(
							'key' => 'building_id',
							'value' =>$building_id,
							'compare' => '='
							),
						array(
							'relation' => 'OR',
						array(
							'key'	  =>'occupied_by',
							'value'	=>	'Owner',
							'compare' => '=',
						),
						array(
							'key'	  =>'occupied_by',
							'value'	=>	'Tenant',
							'compare' => '=',
						)
					  )
					)
				));*/
		$membersdata = get_users(
					array(
						'role' => 'member',						
						'meta_query' => array(
						'relation' => 'AND',
						array(
							'key' => 'building_id',
							'value' =>sanitize_text_field($building_id),
							'compare' => '='
							)
					)
				));
	 return $membersdata;
}

//GET MEMBER DATA FOR UNIT WISE FUNCTION
function MJ_amgt_get_all_member_data_by_building_unit_id($building_id,$unit_id)
{
	$args = array(
		'role' => 'member',
        'meta_query'=>
         array(
		//	'relation' => 'AND',
			'relation' => 'OR',
            array(
                'relation' => 'AND',
			array(
				'key'	  =>'building_id',
				'value'	=>	sanitize_text_field($building_id),
				'compare' => '=',
			),
			array(
				'key'	  =>'unit_cat_id',
				'value'	=>	sanitize_text_field($unit_id),
				'compare' => '=',
			)
          ),
		  array(
				'relation' => 'OR',
			array(
				'key'	  =>'occupied_by',
				'value'	=>	'Owner',
				'compare' => '=',
			),
			array(
				'key'	  =>'occupied_by',
				'value'	=>	'Tenant',
				'compare' => '=',
			)
		  )
       )
    );

    $membersdata = get_users($args);
	return $membersdata;
}

function MJ_amgt_get_single_member_unit_size($member_id)
{

	global $wpdb;
	$table_amgt_residential_units = $wpdb->prefix. 'amgt_residential_units';
	$userdata=get_userdata($member_id);
	
	$building_id=sanitize_text_field($userdata->building_id);
	$unit_cat_id=sanitize_text_field($userdata->unit_cat_id);
	$unit_name=sanitize_text_field($userdata->unit_name);
	$result_unit = $wpdb->get_results($wpdb->prepare("SELECT units FROM $table_amgt_residential_units WHERE building_id = %d AND unit_cat_id = %d",$building_id,$unit_cat_id));
	
	$units_data=array();
	foreach ($result_unit as $unit1)
	{
		$units_data[]=json_decode($unit1->units);
	}
	
	$memberunitdata="";
	if(!empty($units_data))
	{	
		foreach ($units_data as $unit)
		{
			$is_json = is_json($unit_name,$return_data = false);
			if($is_json == "TRUE")
			{
				$json_unit = json_decode($unit_name);
				foreach($json_unit as $data){
					if($unit['0']->entry==$data->unit_name)
					{
						$memberunitdata=$unit['0']->measurement;
					}
				}
			}
			elseif($unit['0']->entry==$unit_name)
			{
				$memberunitdata=$unit['0']->measurement;
			}
		}
	}
	
	return $memberunitdata;
}
//GET MEASURMENT CHARGIS FOR MEMBERWISE FUNCTION
function MJ_amgt_get_single_member_measurment_charge($invoice_id)
{
	global $wpdb;
	$table_amgt_generat_invoice= $wpdb->prefix. 'amgt_generat_invoice';
	$charge="";
	$result_charge = $wpdb->get_row($wpdb->prepare("SELECT charges_payment FROM $table_amgt_generat_invoice WHERE id = %d",intval($invoice_id)));
	
	if(!empty($result_charge->charges_payment))
	{
		$charge=array();
		$charge=json_decode($result_charge->charges_payment);
		
		if(!empty($charge))
		{	
			foreach ($charge as $data)
			{			
				$charge=$data->amount;			
			}
		}
	}	
	return $charge;
}

//GETINVOICE CHARGIS FUNCTION
function MJ_amgt_get_invoice_charges_calculate_by($invoiceid)
{
	global $wpdb;
	$table_amgt_generat_invoice = $wpdb->prefix. 'amgt_generat_invoice';
	$result = $wpdb->get_row($wpdb->prepare("SELECT charges_calculate_by FROM $table_amgt_generat_invoice WHERE id = %d", intval($invoiceid)));
	return $result;
}

//GET CHARGIS Period BY ID FUNCTION
function MJ_amgt_get_charge_period_by_id($invoiceid)
{
	global $wpdb;
	$table_amgt_generat_invoice = $wpdb->prefix. 'amgt_generat_invoice';
	$result = $wpdb->get_row($wpdb->prepare("SELECT amgt_charge_period FROM $table_amgt_generat_invoice WHERE id = %d", intval($invoiceid)));
	return $result->amgt_charge_period;
}

//GET MEMBER UNIT NAME  WISE FUNCTION
function MJ_amgt_get_member_id_by_unit_name($unitname)
{
	$args = array(
		'role' => 'member',
        'meta_query'=>
         array(                   
			array(
				'key'	  =>'unit_name',
				'value'	=>	sanitize_text_field($unitname),
				'compare' => '=',
			)			
          )       
    );

    $membersdata = get_users($args);
	if(!empty($membersdata))
	{	
		foreach ($membersdata as $data)
		{			
			$member_id=intval($data->ID);			
		}
	}	
	
	return $member_id;
}
//GET REMOTE FILE FUNCTION
function MJ_amgt_get_remote_file($url, $timeout = 30)
{
	$ch = curl_init();
	curl_setopt ($ch, CURLOPT_URL, $url);
	curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
	$file_contents = curl_exec($ch);
	curl_close($ch);
	return ($file_contents) ? $file_contents : FALSE;
}

//-------DATA TABLE MULTILANGUAGE-----------
function MJ_amgt_datatable_multi_language()
{
$datatable_attr=array("sEmptyTable"=> __("No data available in table","apartment_mgt"),
"sInfo"=>__("Showing _START_ to _END_ of _TOTAL_ entries","apartment_mgt"),
"sInfoEmpty"=>__("Showing 0 to 0 of 0 entries","apartment_mgt"),
"sInfoFiltered"=>__("(filtered from _MAX_ total entries)","apartment_mgt"),
"sInfoPostFix"=> "",
"sInfoThousands"=>",",
"sLengthMenu"=>__(" _MENU_ ","apartment_mgt123"),
"sLoadingRecords"=>__("Loading...","apartment_mgt"),
"sProcessing"=>__("Processing...","apartment_mgt"),
"sSearch"=>__("","apartment_mgt"),
"sZeroRecords"=>__("No matching records found","apartment_mgt"),
"oPaginate"=>array(
"sFirst"=>__("First","apartment_mgt"),
"sLast"=>__("Last","apartment_mgt"),
"sNext"=>__("Next","apartment_mgt"),
"sPrevious"=>__("Previous","apartment_mgt")
),
"oAria"=>array(
"sSortAscending"=>__(": activate to sort column ascending","apartment_mgt"),
"sSortDescending"=>__(": activate to sort column descending","apartment_mgt")
)
);

return $data=json_encode( $datatable_attr);
}
//strip tags and slashes
function MJ_amgt_strip_tags_and_stripslashes($post_string)
{
	$string = str_replace('&nbsp;', ' ', $post_string);
	$string = html_entity_decode($string, ENT_QUOTES | ENT_COMPAT , 'UTF-8');
	$string = html_entity_decode($string, ENT_HTML5, 'UTF-8');
	$string = html_entity_decode($string);
	$string = htmlspecialchars_decode($string);
	$string = strip_tags($string);
//$replace_string=preg_replace('/[^\x00-\x80]|[^0-9a-zA-Z\ \_\,\`\.\'\^\-\&\@\()\{}\|\|\=\%\*\#\!\~\$\+\n]/s', '', $string);
return $string;
}

function MJ_amgt_browser_javascript_check()
{
	$plugins_url = plugins_url( 'apartment-management/ShowErrorPage.php' );
?>
	<noscript><meta http-equiv="refresh" content="0;URL=<?php echo $plugins_url;?>"></noscript> 
<?php
}
//user role wise access right array
function MJ_amgt_get_userrole_wise_access_right_array()
{
	$role = MJ_amgt_get_user_role(get_current_user_id());
	if($role=='member')
	{
		$menu = get_option( 'amgt_access_right_member');
	}
	elseif($role=='staff_member')
	{
		$menu = get_option( 'amgt_access_right_staff_member');
	}
	elseif($role=='accountant')
	{
		$menu = get_option( 'amgt_access_right_accountant');
	}
	elseif($role=='gatekeeper')
	{
		$menu = get_option( 'amgt_access_right_gatekeeper');
	}
	
	foreach ( $menu as $key1=>$value1 ) 
	{									
		foreach ( $value1 as $key=>$value ) 
		{				
			if ($_REQUEST ['page'] == $value['page_link'])
			{				
				return $value;
			}
		}
	}
}
//access right page not access message
function MJ_amgt_access_right_page_not_access_message()
{
	?>
	<script type="text/javascript">
		$(document).ready(function() 
		{
			"use strict";
			alert('<?php esc_html_e('You do not have permission to perform this operation.','apartment_mgt');?>');
			window.location.href='?dashboard=user';
		});
	</script>
<?php
}
//user role wise access right array In Filter Data
function MJ_amgt_get_userrole_wise_filter_access_right_array($page_name)
{
	$role = MJ_amgt_get_user_role(get_current_user_id());
	if($role=='member')
	{
		$menu = get_option( 'amgt_access_right_member');
	}
	elseif($role=='staff_member')
	{
		$menu = get_option( 'amgt_access_right_staff_member');
	}
	elseif($role=='accountant')
	{
		$menu = get_option( 'amgt_access_right_accountant');
	}
	elseif($role=='gatekeeper')
	{
		$menu = get_option( 'amgt_access_right_gatekeeper');
	}
	// elseif($role=='management')
	// {
	// 	$menu = get_option( 'amgt_access_right_management');
	// }

	foreach ( $menu as $key1=>$value1 ) 
	{									
		
		foreach ( $value1 as $key=>$value ) 
		{				
			if ($page_name == $value['page_link'])
			{				
				return $value;
			}
		}
	}	
} 
//dashboard page access right
function MJ_amgt_page_access_rolewise_accessright_dashboard($page)
{
	$role = MJ_amgt_get_user_role(get_current_user_id());
	if($role=='member')
	{
		$menu = get_option( 'amgt_access_right_member');
	}
	elseif($role=='staff_member')
	{
		$menu = get_option( 'amgt_access_right_staff_member');
	}
	elseif($role=='accountant')
	{
		$menu = get_option( 'amgt_access_right_accountant');
	}
	elseif($role=='gatekeeper')
	{
		$menu = get_option( 'amgt_access_right_gatekeeper');
	}
	
	
	foreach ( $menu as $key1=>$value1 ) 
	{									
		foreach ( $value1 as $key=>$value ) 
		{	
			if ($page == $value['page_link'])
			{				
				if($value['view']=='0')
				{			
					$flage=0;
				}
				else
				{
					$flage=1;
				}
			}
		}
	}	
	return $flage;
}
//-------- GET DISPLAY NAME  FUNCTION -----//
function MJ_amgt_apartment_get_display_name($id)
{
	$result=get_userdata(intval($id));
	if(!empty($result->display_name))
	{
		return sanitize_text_field($result->display_name);
	}
	else
	{
		return "N/A";
	}
	
}
function MJ_amgt_count_reply_item($id)
{
	global $wpdb;
	$tbl_amgt_message = $wpdb->prefix .'amgt_message';
	$amgt_message_replies = $wpdb->prefix .'amgt_message_replies';	
	
	$user_id=get_current_user_id();
	$inbox_sent_box =$wpdb->get_results( $wpdb->prepare("SELECT * FROM $tbl_amgt_message WHERE receiver = %d AND sender != %d AND post_id = %d AND msg_status = 0",$user_id,$user_id,$id));
	$reply_msg =$wpdb->get_results($wpdb->prepare("SELECT * FROM $amgt_message_replies WHERE receiver_id = %d AND message_id = %d AND (msg_status = 0 OR msg_status IS NULL)",$user_id,$id));
	$count_total_message=count($inbox_sent_box) + count($reply_msg); 
	return $count_total_message; 
}
function MJ_amgt_count_unread_message($user_id)
{
	global $wpdb;
	$tbl_name = $wpdb->prefix .'amgt_message';
	$smgt_message_replies = $wpdb->prefix . 'amgt_message_replies';
	
	$inbox = $wpdb->get_results($wpdb->prepare("SELECT * FROM $tbl_name WHERE receiver = %d AND sender != %d AND msg_status = 0", $user_id, $user_id));

	$reply_msg = $wpdb->get_results($wpdb->prepare("SELECT * FROM $smgt_message_replies WHERE receiver_id = %d AND (msg_status = 0 OR msg_status IS NULL)", $user_id));

	$count_total_message=count($inbox) + count($reply_msg);
	return $count_total_message;
}
function MJ_amgt_get_receiver_name_array($message_id,$sender_id,$created_date,$message_comment)
{
	$message_id=(int)$message_id;
	$sender_id=(int)$sender_id;
	global $wpdb;
	$new_name_array=array();
	$receiver_name=array();
	$tbl_name = $wpdb->prefix .'amgt_message_replies';
	$reply_msg = $wpdb->get_results($wpdb->prepare("SELECT receiver_id FROM $tbl_name WHERE message_id = %d AND sender_id = %d AND message_comment = %s OR created_date = %s", $message_id, $sender_id, $message_comment, $created_date));
	if (!empty($reply_msg)) {
		foreach ($reply_msg as $receiver_id) {
			$receiver_name[]=MJ_amgt_get_display_name(intval($receiver_id->receiver_id));
		}
	}
	$new_name_array=implode(", ",$receiver_name);
	return $new_name_array;
}
function MJ_amgt_count_unread_message_admin($user_id)
{
	global $wpdb;
	$tbl_name_message = $wpdb->prefix .'amgt_message';
	$amgt_message_replies = $wpdb->prefix . 'amgt_message_replies';

	$inbox = $wpdb->get_results($wpdb->prepare("SELECT * FROM $tbl_name_message WHERE receiver = %d AND sender != %d AND msg_status = 0", $user_id, $user_id));
	$reply_msg = $wpdb->get_results($wpdb->prepare("SELECT * FROM $amgt_message_replies WHERE receiver_id = %d AND (msg_status = 0 OR msg_status IS NULL)", $user_id));

	$count_total_message=count($inbox) + count($reply_msg);
	return $count_total_message;
}

function MJ_amgt_facility_booking_add_date_type_data($start_date,$end_date,$facility_id)
{
	global $wpdb;
	$table_amgt_facility = $wpdb->prefix. 'amgt_facility_booking';
	$facility_booking_data = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_amgt_facility WHERE start_date <= %s AND end_date >= %s AND facility_id = %d AND period_type = %s", $start_date, $end_date, intval($facility_id), 'date_type'));
	return $facility_booking_data;
}

function MJ_amgt_facility_booking_edit_data_id($start_date,$end_date,$facility_id)
{
	global $wpdb;
	$table_amgt_facility = $wpdb->prefix. 'amgt_facility_booking';
	$facility_booking_data = $wpdb->get_results($wpdb->prepare("SELECT id FROM $table_amgt_facility WHERE start_date <= %s AND end_date >= %s AND facility_id = %d AND period_type = %s", $start_date, $end_date, intval($facility_id), 'date_type'));
	return $facility_booking_data['0']->id;
}

function MJ_amgt_facility_booking_edit_time_id($start_date,$start_time,$end_time,$facility_id)
{
	global $wpdb;
	$table_amgt_facility = $wpdb->prefix. 'amgt_facility_booking';
	$facility_booking_data = $wpdb->get_results($wpdb->prepare("SELECT id FROM $table_amgt_facility WHERE start_date = %s AND start_time <= %s AND end_time >= %s AND facility_id = %d AND period_type = %s", $start_date, $start_time, $end_time, intval($facility_id), 'hour_type'));
	return $facility_booking_data['0']->id;
}

function MJ_amgt_get_roles($user_id)
{
	$roles = array();
	$user = new WP_User( intval($user_id) );
	if ( !empty( $user->roles ) && is_array( $user->roles ) )
	{	
		return $user->roles;
	}	
}
function Mj_amgt_invoicepayment_detail($id)
{
	global $wpdb;
	$table_amgt_invoice_payment = $wpdb->prefix. 'amgt_created_invoice_list';
	$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_amgt_invoice_payment WHERE member_id = %d ORDER BY charges_id DESC LIMIT 4", intval($id)));
	return $result;
}

add_action( 'wp_ajax_MJ_amgt_check_email_exit_or_not','MJ_amgt_check_email_exit_or_not');
add_action( 'wp_ajax_nopriv_MJ_amgt_check_email_exit_or_not','MJ_amgt_check_email_exit_or_not');
function MJ_amgt_check_email_exit_or_not()
{
	$email= $_POST['email_id'];
	if ( email_exists( $email ) ) 
	{
		$response = 1;
	} else 
	{
		$response = 0;
	}
	echo $response;
	die;
}

//--- Datatable Heder Display show class ----//
function MJ_amgt_datatable_heder()
{
	$datatbl_heder_value = get_option( 'apartment_heder_enable' ); 
	if($datatbl_heder_value == "no")
	{
		$apartment_datatbl_heder= "apartment_heder_none";
	}
	else
	{		
		$apartment_datatbl_heder= "apartment_heder_block";
	}
	return $apartment_datatbl_heder;
	
}

function MJ_amgt_get_parking_record($id)
{
	global $wpdb;
	$tbl_name = $wpdb->prefix .'amgt_parking';
	$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM $tbl_name WHERE sloat_id = %d", intval($id)));
	return $result;
}
//-----Get all Date Type to star_date and end_date  - Start ------//
function mj_amgt_all_date_type_value($date_type)
{
	$array_res = array();
	$start_date = "";
	$end_date = "";
	if($date_type=="today")
	{
		$start_date = date('Y-m-d');
		$end_date= date('Y-m-d');
	}
	elseif($date_type=="this_week")
	{
		//check the current day
		if(date('D')!='Mon')
		{    
			//take the last monday
			$start_date = date('Y-m-d',strtotime('last sunday'));    
		}else{
			$start_date = date('Y-m-d');   
		}
		//always next saturday
		if(date('D')!='Sat')
		{
			$end_date = date('Y-m-d',strtotime('next saturday'));
		}else{
			$end_date = date('Y-m-d');
		}
	}
	elseif($date_type=="last_week")
	{
		$previous_week = strtotime("-1 week +1 day");
		$start_week = strtotime("last sunday midnight",$previous_week);
		$end_week = strtotime("next saturday",$start_week);

		$start_date = date("Y-m-d",$start_week);
		$end_date = date("Y-m-d",$end_week);
	}
	elseif($date_type=="this_month")
	{
		$start_date = date('Y-m-d',strtotime('first day of this month'));
		$end_date = date('Y-m-d',strtotime('last day of this month'));
	}
	elseif($date_type=="last_month")
	{
		$start_date = date('Y-m-d',strtotime("first day of previous month"));
		$end_date =  date('Y-m-d',strtotime("last day of previous month"));
	}
	elseif($date_type=="last_3_month")
	{
		$month_date =  date('Y-m-d', strtotime('-2 month'));
		$start_date = date("Y-m-01", strtotime($month_date));
		$end_date = date('Y-m-d',strtotime('last day of this month'));
		
	}
	elseif($date_type=="last_6_month")
	{
		$month_date =  date('Y-m-d', strtotime('-5 month'));
		$start_date = date("Y-m-01", strtotime($month_date));
		$end_date = date('Y-m-d',strtotime('last day of this month'));
	}
	elseif($date_type=="last_12_month")
	{
		$month_date =  date('Y-m-d', strtotime('-11 month'));
		$start_date = date("Y-m-01", strtotime($month_date));
		$end_date = date('Y-m-d',strtotime('last day of this month'));
	}
	elseif($date_type=="this_year")
	{
		$start_date = date("Y-01-01", strtotime("0 year"));
		$end_date = date("Y-12-t", strtotime($start_date));

	}
	elseif($date_type=="last_year")
	{
		$start_date = date("Y-01-01", strtotime("-1 year"));
		$end_date = date("Y-12-t", strtotime($start_date));
	}
	elseif($date_type=="period")
	{
		//$result= mj_smgt_admission_repot_load_date();

	}
	$array_res[] = $start_date;
	$array_res[] = $end_date;
	return json_encode($array_res);
}
function MJ_get_all_income()
{
    global $wpdb;
    $table_income = $wpdb->prefix . 'amgt_invoice_payment_history';

    $user_roles = MJ_amgt_get_user_role(get_current_user_id());
    $member_id = get_current_user_id();

    if ($user_roles == 'member') {
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income WHERE member_id = %d", $member_id));
    } else {
        $result = $wpdb->get_results("SELECT * FROM $table_income");
    }
    return $result;
}

function MJ_get_all_expense()
{
    global $wpdb;
    $table_expense = $wpdb->prefix . 'amgt_income_expense';

    $user_roles = MJ_amgt_get_user_role(get_current_user_id());
    $member_id = get_current_user_id();

    if ($user_roles == 'member') {
        $result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_expense WHERE member_id = %d", intval($member_id)));
    } else {
        $result = $wpdb->get_results("SELECT * FROM $table_expense");
    }
    return $result;
}

function MJ_get_total_income($start_date,$end_date)
{
 	global $wpdb;
	$table_income=$wpdb->prefix.'amgt_invoice_payment_history';

	$user_roles=MJ_amgt_get_user_role(get_current_user_id());
	$member_id = get_current_user_id();
	if($user_roles == 'member')
	{
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income WHERE member_id = %d AND date BETWEEN %s AND %s",$member_id,$start_date,$end_date));
	}else{
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income WHERE date BETWEEN %s AND %s", $start_date, $end_date));
	}
	return $result;
}
function MJ_get_total_expense($start_date,$end_date)
{
 	global $wpdb;
	$table_income=$wpdb->prefix.'amgt_income_expense';
	$user_roles=MJ_amgt_get_user_role(get_current_user_id());
	$member_id = get_current_user_id();
	if($user_roles == 'member')
	{
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_income WHERE created_by = %d AND created_date BETWEEN %s AND %s", $member_id, $start_date, $end_date));
	}else{
		$result = $wpdb->get_results("SELECT * FROM $table_income where created_date BETWEEN '$start_date' AND '$end_date' ");
	}
	return $result;
}


add_action( 'wp_ajax_mj_amgt_admission_repot_load_date', 'mj_amgt_admission_repot_load_date');
add_action( 'wp_ajax_nopriv_mj_amgt_admission_repot_load_date',  'mj_amgt_admission_repot_load_date');

function mj_amgt_admission_repot_load_date()
{
	 $date_type = $_REQUEST['date_type'];
	 //var_dump($date_type);
	 ?>
	
	<script type="text/javascript">
		jQuery(document).ready(function($)
		{
			"use strict";	
			$("#report_sdate").datepicker({
				dateFormat: "yy-mm-dd",
				changeYear: true,
				changeMonth: true,
				maxDate:0,
				onSelect: function (selected) {
					var dt = new Date(selected);
					dt.setDate(dt.getDate() + 0);
					$("#report_edate").datepicker("option", "minDate", dt);
				}
			});

			$("#report_edate").datepicker({
			dateFormat: "yy-mm-dd",
			changeYear: true,
			changeMonth: true,
			maxDate:0,
				onSelect: function (selected) {
					var dt = new Date(selected);
					dt.setDate(dt.getDate() - 0);
					$("#report_sdate").datepicker("option", "maxDate", dt);
				}
			});
		} );
	</script>
	<?php
	if($date_type=='period')
	{ 
		?>
		<div class="row">
		<div class="col-md-6 mb-2">
			<div class="form-group input">
				<div class="col-md-12 form-control">
					<input type="text" id="report_sdate" class="form-control" name="start_date" value="<?php if(isset($_REQUEST['start_date'])) echo $_REQUEST['start_date'];else echo date('Y-m-d');?>" readonly>
					<label for="userinput1" class="active"><?php esc_html_e('Start Date','apartment_mgt');?></label>
				</div>
			</div>
		</div>
		<div class="col-md-6 mb-2">
			<div class="form-group input">
				<div class="col-md-12 form-control">
					<input type="text" id="report_edate" class="form-control" name="end_date" value="<?php if(isset($_REQUEST['edate'])) echo $_REQUEST['end_date'];else echo date('Y-m-d');?>" readonly>
					<label for="userinput1" class="active"><?php esc_html_e('End Date','apartment_mgt');?></label>
				</div>
			</div>
		</div> 
		</div>
		<?php 
	} 
	die();
	
}

add_filter( 'cron_schedules', 'MJ_amgt_minute_for_add_penalty' );
function MJ_amgt_minute_for_add_penalty( $schedules ) 
{
    $schedules['every_minute'] = array(
            'interval'  => 60,
            'display'   => esc_html__('Every minute', 'textdomain' )
    );
    return $schedules;
} 
if ( ! wp_next_scheduled( 'MJ_amgt_minute_for_add_penalty' ) )
{
    wp_schedule_event( time(), 'every_minute', 'MJ_amgt_minute_for_add_penalty' );
}  
add_action( 'MJ_amgt_minute_for_add_penalty', 'MJ_add_invoice_penalty_charge' );

function MJ_add_invoice_penalty_charge()
{
	$today_date = date("Y-m-d");

 	global $wpdb;
	$table_invoice=$wpdb->prefix.'amgt_created_invoice_list';
	$table_penalty_charge=$wpdb->prefix.'amgt_invoice_penalty_charges';
	$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_invoice WHERE payment_status IN (%s, %s)", 'Unpaid', 'Partially Paid'));

	if(get_option('invoice_penalty_enable') == "yes"){
		foreach($result as $data)
		{
			if($data->end_date < $today_date){
				$invoice_data[] = $data;
				$invoice_id = intval($data->id);
				$penalty_data['invoice_id']=intval($invoice_id);
				$penalty_data['member_id']=intval($data->member_id);
				$penalty_data['penalty_charge']=PenaltyCalc($data->due_amount,get_option('invoice_penalty_charge')) - $data->due_amount;
				$penalty_data['end_date']=date('Y-m-d', strtotime($data->end_date. ' + '.get_option('invoice_penalty_days').'days'));
				$penalty_data['created_date']=date("Y-m-d");
				$add_penalty=$wpdb->insert( $table_penalty_charge,$penalty_data);

				$update_id['id']=intval($data->id);
				$update_data['total_amount']=$data->paid_amount + PenaltyCalc($data->due_amount,get_option('invoice_penalty_charge'));
				$update_data['due_amount']=PenaltyCalc($data->due_amount,get_option('invoice_penalty_charge'));
				$update_data['end_date']=date('Y-m-d', strtotime($data->end_date. ' + '.get_option('invoice_penalty_days').'days'));
				$update_invoice=$wpdb->update( $table_invoice,$update_data,$update_id);
			}
		}
	}
	return $result;
}
function PenaltyCalc($amount,$penalty){
	$p_amount = ($penalty / 100) * $amount;
	return $TotalFees = $p_amount+$amount;
}
// access right function manage
function MJ_amgt_add_check_access_for_view($page_name)
{
	$user_roles=MJ_amgt_get_user_role(get_current_user_id());
	if(is_array($user_roles) && in_array('management', $user_roles))
	{
		$menu = get_option('amgt_access_right_management');
		if(!empty($menu))
		{
			foreach ( $menu as $key1=>$value1 )
			{	
				foreach ( $value1 as $key=>$value ) 
				{	
					if ($page_name == $value['page_link'])
					{	
						return $value;
					}
				}
			}
		}
	}
	else
	{
		return 'administrator';
	}
}
function MJ_amgt_add_check_access_for_view_add($page_name,$action)
{
	$user_roles=MJ_amgt_get_user_role(get_current_user_id());
	if(is_array($user_roles) && in_array('management', $user_roles))
	{
		$menu = get_option('amgt_access_right_management');
		if(!empty($menu))
		{
			foreach ( $menu as $key1=>$value1 )
			{	
				foreach ( $value1 as $key=>$value ) 
				{	
					if ($page_name == $value['page_link'])
					{	
						return $value[$action];
					}
				}
			}
		}
	}
	else
	{
		return 1;
	}
}
//access right page not access message admin side //
function mj_amgt_access_right_page_not_access_message_admin_side()
{
	?>
	<script type="text/javascript">
		$(document).ready(function() 
		{	
			alert('<?php esc_attr_e('You do not have permission to perform this operation.','apartment_mgt');?>');
			window.location.href='?page=amgt-apartment_system';
		});
	</script>
<?php
}

function payment_first_entry_create_invoice_history_show($invoice_id)
{
    global $wpdb;
    $table_income = $wpdb->prefix . 'amgt_invoice_payment_history';
    $entry_count_query = "SELECT COUNT(DISTINCT member_id) AS entry_count FROM $table_income WHERE invoice_id = %d";
    $entry_count = $wpdb->get_var($wpdb->prepare($entry_count_query, $invoice_id));

    return $entry_count;
}

// ===================GET MEMBER UNIT NAME=====================

function MJ_amgt_get_member_assing_unit_name($unit_data)
{
	$unit_name_json = stripslashes(($unit_data));
																
	$is_json = is_json($unit_name_json);
	// var_dump($is_json);
	if($is_json == "TRUE")
	{
		$array_unit = json_decode($unit_name_json);
		if(is_array($array_unit))
		{
			if(!empty($array_unit))
			{
				foreach($array_unit as $data)
				{
					$units[]=$data->unit_name;
					// $unit_name[] = $units.', ';
				}
				$unit_name = implode(", ",$units);
			}else{
				$unit_name = "N/A";
			}
		}else{
			$unit_name = $unit_data;
		}
	}else{
		$unit_name = $unit_data;
	}
	return esc_html($unit_name, 'apartment_mgt');
}

// ==========SETUP WIZARD UPDATE OPTION==============
function MJ_amgt_update_setup_wizard_options($key)
{
	$get_wizard_status = get_option('amgt_setup_wizard_status');
	$get_wizard_step = get_option('amgt_setup_wizard_step');
	if($get_wizard_status == 'no')
	{
		$setup_wizard = get_option('amgt_setup_wizard_step');
		$setup_wizard[$key] = "yes";
		$update_setup_wizard = update_option('amgt_setup_wizard_step',$setup_wizard);
		$get_wizard_step = get_option('amgt_setup_wizard_step');
		if(!in_array('no',$get_wizard_step))
		{
			$amgt_setup_wizard_status = 'yes';
			$update_setup_wizard_status = update_option('amgt_setup_wizard_status',$amgt_setup_wizard_status);
		}
	}
}

//------------Dashboard card access---------------//
function MJ_amgt_frontend_dashboard_card_access()
{
	$user_id = get_current_user_id();
	$role=MJ_amgt_get_roles(intval($user_id));

	if($role[0]=='member')
	{ 
		$card_access = get_option( 'amgt_dashboard_card_for_member');
	}
	elseif($role[0]=='staff_member')
	{
		$card_access = get_option( 'amgt_dashboard_card_for_staffmember');
	}
	elseif($role[0]=='acountant')
	{
		$card_access = get_option( 'amgt_dashboard_card_for_accountant');
	}
	elseif($role[0]=='gatekeeper')
	{
		$card_access = get_option( 'amgt_dashboard_card_for_gatekeeper');
	}
	// elseif($role[0]=='committee')
	// {
	// 	$card_access = get_option( 'smgt_dashboard_card_for_support_staff');
	// }
	return $card_access;
}
function MJ_amgt_pdf_for_mobile($invoice_id,$invoice_type,$pdf_name)
{
	
	ob_start();
	error_reporting(0);		
	MJ_amgt_generate_invoice_pdf($invoice_id,$invoice_type);
	$out_put = ob_get_contents();
	ob_clean();
	header('Content-type: application/pdf');
	header('Content-Disposition: inline; filename="invoice.pdf"');
	header('Content-Transfer-Encoding: binary');
	header('Accept-Ranges: bytes');	
	require_once AMS_PLUGIN_DIR . '/lib/mpdf/vendor/autoload.php';	
	$mpdf = new Mpdf\Mpdf;
	$mpdf->SetTitle('Invoice Payment');
	$mpdf->autoScriptToLang = true;
	$mpdf->autoLangToFont = true;
	
	if (is_rtl())
	{
		$mpdf->autoScriptToLang = true;
		$mpdf->autoLangToFont = true;
		$mpdf->SetDirectionality('rtl');
	}   
	$mpdf->WriteHTML($out_put);

	$invoice_dir = WP_CONTENT_DIR.'/uploads/invoice_pdf/';
	$invoice_path = $invoice_dir;
	mkdir($invoice_path, 0777, true);
	
	$mpdf->Output( WP_CONTENT_DIR . '/uploads/invoice_pdf/'.$pdf_name.'.pdf','F');

	// $mpdf->Output();
	unset( $out_put );
	unset( $mpdf );
	ob_end_flush();
	return $mpdf;	
}


add_action('init','MJ_amgt_invoice_payment_receipt_pdf_for_mobile');
function MJ_amgt_invoice_payment_receipt_pdf_for_mobile()
{
		if(isset($_REQUEST['invoice_id']) && isset($_REQUEST['member_id']) && isset($_REQUEST['pdf_name']) )
		{
			ob_start();
			error_reporting(0);		
			MJ_amgt_generate_invoice_payment_receipt_pdf(intval($_REQUEST['invoice_id']),intval($_REQUEST['member_id']));
			$out_put = ob_get_contents();
			ob_clean();
			header('Content-type: application/pdf');
			header('Content-Disposition: inline; filename="invoice.pdf"');
			header('Content-Transfer-Encoding: binary');
			header('Accept-Ranges: bytes');	
			require_once AMS_PLUGIN_DIR . '/lib/mpdf/vendor/autoload.php';	
			$mpdf = new Mpdf\Mpdf;
			$mpdf->SetTitle('Invoice Payment Receipt');
			$mpdf->autoScriptToLang = true;
			$mpdf->autoLangToFont = true;
			
			if (is_rtl())
			{
				$mpdf->autoScriptToLang = true;
				$mpdf->autoLangToFont = true;
				$mpdf->SetDirectionality('rtl');
			}   
			$mpdf->WriteHTML($out_put);
			
			$invoice_dir = WP_CONTENT_DIR.'/uploads/payment_receipt/';
			$invoice_path = $invoice_dir;
			mkdir($invoice_path, 0777, true);
		
			$mpdf->Output( WP_CONTENT_DIR . '/uploads/payment_receipt/'.$_REQUEST['invoice_id'].'.pdf','F');
			wp_redirect ( content_url() .'/uploads/payment_receipt/'.$_REQUEST['invoice_id'].'.pdf');
			ob_end_flush();
			wp_redirect ( content_url() .'/uploads/payment_receipt/'.$_REQUEST['invoice_id'].'.pdf');
		}
}

//GEENERATE  INVOICE FOR VISITOR REQUEST PDF FUNCTION CALL FOR INIT

add_action('init','MJ_amgt_visitor_checkin_pdf_for_mobile');
function MJ_amgt_visitor_checkin_pdf_for_mobile()
{
	// if (is_user_logged_in ()) 
	// {
		if(isset($_REQUEST['visitor_checkin_id']) && isset($_REQUEST['pdf_name']) )
		{
			ob_start();
			error_reporting(0);		
			MJ_amgt_generate_visitor_request_pdf($_REQUEST['visitor_checkin_id']);
			$out_put = ob_get_contents();
			ob_clean();
			header('Content-type: application/pdf');
			header('Content-Disposition: inline; filename="invoice.pdf"');
			header('Content-Transfer-Encoding: binary');
			header('Accept-Ranges: bytes');	
			require_once AMS_PLUGIN_DIR . '/lib/mpdf/vendor/autoload.php';	
			$mpdf = new Mpdf\Mpdf;
			$mpdf->SetTitle('Visitor Checkin');
			$mpdf->autoScriptToLang = true;
			$mpdf->autoLangToFont = true;
			
			if (is_rtl())
			{
				$mpdf->autoScriptToLang = true;
				$mpdf->autoLangToFont = true;
				$mpdf->SetDirectionality('rtl');
			}   
			$mpdf->WriteHTML($out_put);

			$invoice_dir = WP_CONTENT_DIR.'/uploads/visitor_checkin/';
			$invoice_path = $invoice_dir;
			mkdir($invoice_path, 0777, true);
			
			$mpdf->Output( WP_CONTENT_DIR . '/uploads/visitor_checkin/'.$_REQUEST['visitor_checkin_id'].'.pdf','F');
			wp_redirect ( content_url() .'/uploads/visitor_checkin/'.$_REQUEST['visitor_checkin_id'].'.pdf');
			ob_end_flush();
			wp_redirect ( content_url() .'/uploads/visitor_checkin/'.$_REQUEST['visitor_checkin_id'].'.pdf');
		}
}

function MJ_amgt_get_payment_paid_data_by_date_method($method)
{
    global $wpdb;
    $table_smgt_fees_history = $wpdb->prefix . 'amgt_invoice_payment_history';
    
    $result = $wpdb->get_results(
        $wpdb->prepare(
            "SELECT * FROM $table_smgt_fees_history WHERE payment_method = %s",
            $method
        )
    );

    return $result;
}

//SEND SMS NOTIFICTION FUNCTION FOR Clicktell SMS//
function amgt_clickatell_send_mail_function($mobiles,$message)
{
  $clickatell=get_option('amgt_clickatell_sms_service');
  $api_key = $clickatell['api_key'];

  $curl = curl_init();
  curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://platform.clickatell.com/v1/message',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{"messages": [ { "channel": "sms", "to": "'.$mobiles.'", "content": "'.$message.'" }]}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json',
    'Accept: application/json',
    'Authorization: '.$api_key.''
  ),	
	));
	$response = curl_exec($curl);
	curl_close($curl);

}

//SEND SMS NOTIFICTION FUNCTION FOR MSG91 SMS//
function amgt_msg91_send_mail_function($mobiles,$message,$countary_code)
{	
	$msg91= get_option('amgt_msg91_sms_service');
	$senderId = $msg91['msg91_senderID'];
	$message = $message;
	$route = $msg91['sms_route'];
	$authkey =$msg91['sms_auth_key'];
	//Prepare you post parameters
	$postData = array(
		'mobiles' => sanitize_text_field($mobiles),
		'message' => sanitize_text_field($message),
		'sender' => sanitize_text_field($senderId),
		'route' => sanitize_text_field($route)
	);

	$url="http://api.msg91.com/api/v2/sendsms";


	$curl = curl_init();
	curl_setopt_array($curl, array(
		CURLOPT_URL => "$url",
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_CUSTOMREQUEST => "POST",
		CURLOPT_POSTFIELDS => $postData,
		CURLOPT_HTTPHEADER => array(
			"authkey: $authkey",
			"content-type: multipart/form-data"
		),
	));

	$response = curl_exec($curl);

	$err = curl_error($curl);

	curl_close($curl);

	if ($err) {
		echo "cURL Error #:" . $err;
	} else {
		echo $response;
	}
	
}

function MJ_amgt_send_sms_notification($user_id,$type,$message_content)
{

	$userdata=get_userdata(intval($user_id));
	$mobile_number=array();
	$mobile_number[] = "+".MJ_amgt_get_countery_phonecode(get_option( 'amgt_contry' )).$userdata->mobile;
	$to_mobile_number= sanitize_text_field($userdata->mobile);
	$country_code="+".MJ_amgt_get_countery_phonecode(get_option( 'amgt_contry' ));
	$current_sms_service 	= 	get_option( 'amgt_sms_service');
	
	include_once(ABSPATH.'wp-admin/includes/plugin.php');
	if(is_plugin_active('sms-pack/sms-pack.php'))
	{ 
		$args = array();
		$args['mobile']=sanitize_text_field($mobile_number);
		$args['message_from']=sanitize_text_field($type);
		$args['message']=$message_content;					
		if($current_sms_service=='telerivet' || $current_sms_service ="MSG91" || $current_sms_service=='bulksmsgateway.in' || $current_sms_service=='textlocal.in' || $current_sms_service=='bulksmsnigeria' || $current_sms_service=='africastalking' || $current_sms_service == 'clickatell' || $current_sms_service=='twillo')
		{				
			$send = send_sms($args);							
		}
	}
	else
	{
		if($current_sms_service == 'clickatell')
		{
			$to_mobile_number= "+".MJ_amgt_get_countery_phonecode(get_option( 'amgt_contry' )).$userdata->mobile;
			amgt_clickatell_send_mail_function($to_mobile_number,$message_content);				
		}
		if($current_sms_service == 'msg91')
		{
			amgt_msg91_send_mail_function($to_mobile_number,$message_content,$country_code);
		}	
	}
	return true;
}

// add_action( "init", "MJ_amgt_send_push_notification");
function MJ_amgt_send_push_notification($member_id,$data)
{
	$send_push_notifications=get_option("send_push_notifications");
	
	if($send_push_notifications == "yes")
	{
		//--------- Firebas token -----------------//
		// $firebase_token="AAAAqRfYgqs:APA91bELXPnQjQPBch0v98_2npzPjlAhidELpGnzpZLH0VJ83ttJytjFmgdmRLoOASBxisGHgyOkyNvQaZopEHLMtH4dGEPCpMcRxAS1DiaaXfJAR-ZyffbHMfOOSrg7p21FgX08pLYR";
		$firebase_token = get_option("amgt_notification_fcm_key");
	
		$dev_token = get_user_meta( intval($member_id), 'device_token', true );	
		$user_data = get_userdata(intval($member_id));
		$member_name=sanitize_text_field($user_data->display_name);
		$apartmentname=get_option('amgt_system_name');
	
		if(!empty($firebase_token))
		{
			if($data['type'] == "paid_invoice")
			{
				$invoice_no=sanitize_text_field($data['invoice_no']);
				
				$title ="Paid Invoice";
				$body = "Dear $member_name, You have Paid Your Invoice $invoice_no in $apartmentname.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			}
			elseif($data['type'] == "commettiee_member")
			{
				$loginlink=$data['loginlink'];
				
				$title ="Appointed as Committee Member";
				$body = "Dear $member_name, Congratulations!! You have been appointed as committee member of Committee, $apartmentname.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			
			}
			elseif($data['type'] == "commettiee_member_remove")
			{
				$loginlink=$data['loginlink'];
				
				$title ="Remove from Committee Member";
				$body = "Dear $member_name, You have been removes from Committee in $apartmentname.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			}
			elseif($data['type'] == "notice")
			{
				$title ="New Notice";
				$body = "Dear $member_name, You have been new notice from $apartmentname.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			}
			elseif($data['type'] == "event")
			{
				$title ="New Event";
				$body = "Dear $member_name, You have been new event from $apartmentname.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			}
			elseif($data['type'] == "complaint")
			{
				$title ="New Complaint";
				$body = "Dear $member_name, New Complaint added in $apartmentname.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			}
			elseif($data['type'] == "assign_slot")
			{
				$title ="Assign Parking slot";
				$slotname=$data['slotname'];
				$startdate=$data['startdate'];
				$enddate=$data['enddate'];
				$body = "Dear $member_name, Parking slot has been assigned to you in $apartmentname. Your parking slot is $slotname. You have assigned this slot from $startdate  to $enddate.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			}
			elseif($data['type'] == "booked_facility")
			{
				$title ="Booked Facilty";
				$facility_name=$data['facility_name'];
				$body = "Dear $member_name, $facility_name has been successfully booked for you from $apartmentname.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			}
			elseif($data['type'] == "new_invoice")
			{
				$title ="New Invoice";
				$invoice_no=$data['invoice_no'];
				$body = "Dear $member_name, You have a new invoice. You can check the invoice $invoice_no.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			}
			elseif($data['type'] == "new_message")
			{
				$title ="New Message";
				$sender=$data['sender'];
				$message_body=$data['message_body'];
				$body = "Dear $member_name, You have received new message from $sender. $message_body.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			}
			elseif($data['type'] == "invoice_charge")
			{
				$title ="Invoice Charge";
				$body = "Dear $member_name,  Your have a new Charges Invoice raised by Admin.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			}
			elseif($data['type'] == "visitor_request_approved")
			{
				$title ="Visitor Request Approved";
				$body = "Dear $member_name,  Your visitor request has been approved by admin.";
				
				$msg = array('to'=>$dev_token,'notification'=>array('title'=>$title,'body'=>$body));

				$json = json_encode($msg);
			}

			$curl = curl_init();

			curl_setopt_array($curl, array(
				CURLOPT_URL => "https://fcm.googleapis.com/fcm/send",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 300,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "POST",
				CURLOPT_POSTFIELDS => $json,
				CURLOPT_HTTPHEADER => array(
					'Content-Type: application/json',
					'authorization: key='.$firebase_token
				),
			));
			$response = curl_exec($curl);
			$err = curl_error($curl);
			curl_close($curl);
			return $response;
		}
	}
}
function MJ_amgt_get_request_type()
{
	return $_REQUEST['web_type'];
}
// =======CHECK FILE UPLOAD VALIDATION============
function MJ_amgt_wp_check_filetype_and_ext($tmp_name,$name)
{
	$file_info = wp_check_filetype_and_ext($tmp_name, $name);
	// Step 2: Define custom allowed MIME types and extensions
    $allowed_mime_types = [
        'jpg'   => 'image/jpeg',
        'jpeg'  => 'image/jpeg',
        'png'   => 'image/png',
        'gif'   => 'image/gif',
        'bmp'   => 'image/bmp',
        'webp'  => 'image/webp',
        'svg'   => 'image/svg+xml',
        'pdf'   => 'application/pdf',
        'doc'   => 'application/msword',
        'docx'  => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        'ppt'   => 'application/vnd.ms-powerpoint',
        'pptx'  => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
        'xls'   => 'application/vnd.ms-excel',
        'xlsx'  => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'csv'   => 'text/csv',
        //'txt'   => 'text/plain'
    ];
    if (!$file_info['ext'] || !$file_info['type']) 
	{
        return false;
    }
	// Check if the extension and MIME type match our custom list
	$extension = $file_info['ext'];
	$mime_type = $file_info['type'];

	if (array_key_exists($extension, $allowed_mime_types) && $allowed_mime_types[$extension] === $mime_type) {
		return true; // Valid file type
	}
	return false; // Invalid file type
}

function MJ_amgt_wp_check_filetype_and_ext_image($tmp_name,$name)
{
	$file_info = wp_check_filetype_and_ext($tmp_name, $name);
	// Step 2: Define custom allowed MIME types and extensions
    $allowed_mime_types = [
        'jpg'   => 'image/jpeg',
        'jpeg'  => 'image/jpeg',
        'png'   => 'image/png',
        'gif'   => 'image/gif',
        'bmp'   => 'image/bmp',
        'webp'  => 'image/webp',
        'svg'   => 'image/svg+xml'
    ];
    if (!$file_info['ext'] || !$file_info['type']) 
	{
        return false;
    }
	// Check if the extension and MIME type match our custom list
	$extension = $file_info['ext'];
	$mime_type = $file_info['type'];

	if (array_key_exists($extension, $allowed_mime_types) && $allowed_mime_types[$extension] === $mime_type) {
		return true; // Valid file type
	}
	return false; // Invalid file type
}
// ============NEW MAIL TEMPLATE DESIGN=======================
function MJ_amgt_get_mail_content_with_template_design($message)
{
	$logo = get_option('amgt_system_logo');
	$system_color = get_option('amgt_system_color_code');
	$email_template = '
	<html>
		<body>
			<div bgcolor="#ffffff" style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;height:100%;width:100%!important;background-color:#ffffff">
				<div style="background-color: aliceblue !important;font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;margin:0 auto;max-width:525px">
					<table style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;float: left;width: 100%;">
					<tbody>
						<tr style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;background:' . $system_color . ';">
							<td style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;text-align:center ; padding-top: 12px;">
								<p style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif">
									<img alt="WP-AMS" src="' . $logo . '" style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;max-width: 50%;" class="CToWUd">
								</p>
							</td>
						</tr>
					</tbody>
					</table>
					<table style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;float:left;width:100%;background-color:aliceblue;">
						<tbody>
							<tr style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif">
								<td style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;color:#333333;padding-top:15px !important;padding: 0px 20px;">
									<p>
										<pre style="white-space: pre-wrap;word-wrap: break-word; overflow-wrap: break-word; max-width: 100%;">' . $message . '</pre>
									</p>
								</td>
							</tr>
							<tr style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;background:' . $system_color . ';">
								<td style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;color:#ffffff;">
									<p style="font-family: \'Proxima Nova\',\'proxima-nova\',Helvetica,Arial sans-serif;font-size:12px;text-align:center;margin-top:10px">
									' . esc_html__("Copyright ©", "gym_mgt") . date('Y') . ' <a href="https://mojoomla.com/" target="_blank" style="text-decoration: underline !important; color: white;">' . esc_html__("Mojoomla", "gym_mgt") .'</a>. '. esc_html__("All rights reserved.", "gym_mgt") . '
									</p>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</body>
	</html>';
	return $email_template;
}
function Mj_amgt_time_format()
{
	$date_format_array = array(
	'H:i:s'=>'24 Hours Format',
	'h:i A'=>'12 Hours Format'); 
	return $date_format_array;
}
// ==============GET TIME FORMAT======================
function Mj_amgt_get_time_format($time)
{		
	$formats = Mj_amgt_time_format();
    $selected_format = get_option('gmgt_time_format');
    // Check if the selected format is in the available formats
    if (array_key_exists($selected_format, $formats)) {
        $time24HourFormat = date($selected_format, strtotime($time));
        return $time24HourFormat;
    } else {
        // Handle the case where the format is not found, maybe return a default format
        return date('H:i:s', strtotime($time));
    }
}
// ===========ADD USER LOG ============
function Mj_amgt_append_user_log($user_login,$role)
{
	global $wpdb;
	$table_amgt_user_log=$wpdb->prefix. 'amgt_user_log';
	$ip_address = getHostByName(getHostName());
	$data['user_login']="$user_login";
	$data['role']="$role";
	$data['ip_address']=$ip_address;
	$data['created_at']=date("Y-m-d");
	$data['deleted_status']=0;
	$timezone_format = _x( 'H:i:s', 'timezone date format' );
    $attendance_time = date_i18n( $timezone_format );
	$data['date_time']=date("Y-m-d").' '.$attendance_time;
	$result=$wpdb->insert( $table_amgt_user_log,$data);
	return $result;
}
function apartment_append_audit_log($audit_action,$user_id,$created_by,$action,$module)
{
	global $wpdb;
	$table_amgt_audit_log=$wpdb->prefix. 'amgt_audit_log';
	$ip_address = getHostByName(getHostName());
	$data['audit_action']=$audit_action;
	$data['user_id']=$user_id;
	$data['action']=$action;
	$data['ip_address']=$ip_address;
	$data['created_by']=$created_by;
	$data['module']=$module;
	$data['created_at']=date("Y-m-d");
	$data['deleted_status']=0;
	$timezone_format = _x( 'H:i:s', 'timezone date format' );
    $attendance_time = date_i18n( $timezone_format );
	$data['date_time']=date("Y-m-d").' '.$attendance_time;
	$result=$wpdb->insert( $table_amgt_audit_log,$data);
	return $result;
}
// =========== DELETE Audit Log==============
function Mj_amgt_delete_audit_log($id)
{
	global $wpdb;
	$id = intval($id);
	$table_amgt_audit_log = $wpdb->prefix. 'amgt_audit_log';
	$result = $wpdb->query($wpdb->prepare("DELETE FROM $table_amgt_audit_log WHERE id = %d", $id)
	);
	return $result;
}
// ============= Encryption Function =====================
function Mj_amgt_encrypt_id($id) {
    $key = 'apartment_amgt'; // Change this to a secure key
    $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
    $encrypted = openssl_encrypt($id, 'aes-256-cbc', $key, 0, $iv);
	$encoded = base64_encode($iv . $encrypted);
    return strtr($encoded, '+/=', '-_,'); // Replace + with -, / with _, and = with ,
}

// =============== Decryption Function ========================
function Mj_amgt_decrypt_id($encrypted_id) 
{
    $key = 'apartment_amgt';
    $decoded_id = strtr($encrypted_id, '-_,', '+/='); // Convert back to original base64 characters
    $data = base64_decode($decoded_id);
    $iv_length = openssl_cipher_iv_length('aes-256-cbc');
    $iv = substr($data, 0, $iv_length);
    $encrypted = substr($data, $iv_length);
    return openssl_decrypt($encrypted, 'aes-256-cbc', $key, 0, $iv);
}
// =============== DATATABLE LIST ENCRYPTED ID =================
function Mj_amgt_retrived_data_id($id)
{
	$user_id = Mj_amgt_encrypt_id($id); // Get logged-in user ID
	$secure_id = urlencode($user_id);
	return $secure_id;
}
// =============== VERIFY ACTION =================
function mj_amgt_create_and_verify_nonce($action)
{
	if(isset($action) & $action == 'view')
	{
		$create_nonce = wp_create_nonce('view_action');
	}elseif(isset($action) & $action == 'edit')
	{
   		$create_nonce = wp_create_nonce('edit_action');
	}elseif(isset($action) & $action == 'delete')
	{
		$create_nonce = wp_create_nonce('delete_action');
	}
	elseif(isset($action) & $action == 'approve')
	{
		$create_nonce = wp_create_nonce('approve_action');
	}
    return $create_nonce;
}
//-------- CHECK APP LICENSE KEY -----//
function Mj_amgt_check_appLicensekey($domain_name, $licence_key, $email)
{
	$curl = curl_init();
	
	curl_setopt_array($curl, array(
	  CURLOPT_URL => 'https://mojoomla.com/wp-json/lmfwc/v2/licenses/'.$licence_key,
	  CURLOPT_RETURNTRANSFER => true,
	  CURLOPT_ENCODING => '',
	  CURLOPT_MAXREDIRS => 10,
	  CURLOPT_TIMEOUT => 0,
	  CURLOPT_FOLLOWLOCATION => true,
	  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	  CURLOPT_CUSTOMREQUEST => 'GET',
	  CURLOPT_HTTPHEADER => array(
		'Authorization: Basic Y2tfMmY4OWU3OWQ2NDg2OTQ3NmM5MzRkMGY2ZjFmNTFkOTM2NGMyNDFjMTpjc18wZTAyOTQ0NGE5MTgwYmY3NGQ0OGI1YzQzODVlOGMwMjhjZmRhZGZl'
	  ),
	));
	
	$response = curl_exec($curl);
	curl_close($curl);

	if(!empty($response))
	{
		$data = json_decode($response, true);
		$success = isset($data['success']) ? $data['success'] : false;

		if($success == TRUE)
		{
			$curl = curl_init();
			curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://mojoomla.com/wp-json/lmfwc/v2/licenses/activate/'.$licence_key,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'Authorization: Basic Y2tfMmY4OWU3OWQ2NDg2OTQ3NmM5MzRkMGY2ZjFmNTFkOTM2NGMyNDFjMTpjc18wZTAyOTQ0NGE5MTgwYmY3NGQ0OGI1YzQzODVlOGMwMjhjZmRhZGZl'
			),
			));
			$response = curl_exec($curl);

			curl_close($curl);
			$data = json_decode($response, true);
			// Check if 'error' key exists, return 2 if present
			if (isset($data['data']['errors'])) {
				return '2';
			}else{
				return '4';
			}
		} else {
			return '1';
		}
	}else {
		return '3';
	}
}
// SETUP FORM FOR APP START
function Mj_amgt_submit_setupform_for_app($data)
{
	$domain_name= $data['app_url'];
	$licence_key = $data['app_license_key'];
	$email = $data['app_email'];
	$result = Mj_amgt_check_appLicensekey($domain_name,$licence_key,$email);

	if($result == '1')
	{
		$message = esc_html__('Please Provide Correct License Key.', 'apartment_mgt');
		$_SESSION['mobile_verify'] = '1';
	}
	elseif($result == '2')
	{
		$message = esc_html__('This license key is already registered with the different domain.please contact us at sales@mojoomla.com', 'apartment_mgt');
		$_SESSION['mobile_verify'] = '2';
	}
	elseif($result == '3')
	{
		$message = esc_html__('There seems to be some problem please try after sometime or contact us on sales@mojoomla.com', 'apartment_mgt');
		$_SESSION['mobile_verify'] = '3';
	}
	else
	{
		update_option('app_url',$domain_name,true);
		update_option('app_license_key',$licence_key,true);
		update_option('app_email',$email,true);
		$message = esc_html__('License Verification Key Registerd Successfully.', 'apartment_mgt');
		$_SESSION['mobile_verify'] = '0';
	}		
	$result_array = array('message'=>$message,'mobile_verify'=>$_SESSION['mobile_verify']);
	return $result_array;
}
function MJ_amgt_get_all_user_in_notice_event($selected_notice_to = array()) {
    $role = MJ_amgt_get_user_role(get_current_user_id());
    $member_data = wp_get_current_user();
    
    // Get only members
    $members = get_users(array('role' => 'member'));

    echo '<optgroup label="' . esc_html__("Members", "apartment_mgt") . '" style="text-transform: capitalize;">';
    foreach ($members as $user) {
        $selected = in_array($user->ID, (array) $selected_notice_to) ? 'selected' : '';
        echo '<option value="' . $user->ID . '" ' . $selected . '>' . esc_html($user->display_name) . '</option>';
    }
    echo '</optgroup>';

    // Get all building/group categories
    $activity_category = MJ_amgt_get_all_category('building_category');
    
    if (!empty($activity_category)) {
        echo '<optgroup label="' . esc_html__("Building/Group", "apartment_mgt") . '" style="text-transform: capitalize;">';
        foreach ($activity_category as $retrive_data) {
            $value = "grp_" . $retrive_data->ID;
            $selected = in_array($value, (array) $selected_notice_to) ? 'selected' : '';

            if ($role == "member") {
                if ($member_data->building_id == $retrive_data->ID) {
                    echo '<option value="' . $value . '" ' . $selected . '>' . esc_html($retrive_data->post_title) . '</option>';
                }
            } else {
                echo '<option value="' . $value . '" ' . $selected . '>' . esc_html($retrive_data->post_title) . '</option>';
            }
        }
        echo '</optgroup>';
    }
}

add_action('myplugin_daily_invoice_reminder', 'send_due_invoice_reminders_by_option');

function send_due_invoice_reminders_by_option() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'amgt_created_invoice_list'; // Replace with your actual invoice table name

    // Get the "days before" value from settings
    $days_before = (int)get_option('payment_reminder_day_before', 1); // Default to 1 if not set

    // Calculate target due date (e.g., if payment_reminder_day_before = 2, find invoices due in 2 days)
    $target_date = date('Y-m-d', strtotime("+{$days_before} days"));

    // Get invoices due on the target date
    $invoices = $wpdb->get_results(
        $wpdb->prepare("SELECT * FROM $table_name WHERE end_date = %s AND payment_status != %s", $target_date, 'Unpaid')
    );

    foreach ($invoices as $invoice) {
        $user_info = get_userdata($invoice->member_id);
        if (!$user_info) continue;
		
        $user_name = sanitize_text_field($user_info->display_name);
        $building_name = get_the_title($user_info->building_id);
        $invoice_no = get_option('invoice_prefix') . $invoice->invoice_no;
        $due_amount = MJ_amgt_get_currency_symbol(get_option('apartment_currency_code')) . ' ' . $invoice->due_amount;
        $to = sanitize_email($user_info->user_email);

        $admin_subject = get_option('wp_amgt_due_invoice_reminder_subject');
        $admin_message_content = get_option('wp_amgt_due_invoice_reminder_template');

        $subject = str_replace(['{{Invoice Number}}'], [$invoice_no], $admin_subject);
        $message_content = str_replace(
            ['{{Member Name}}', '{{Building Name}}', '{{Invoice Number}}', '{{Due Amount}}'],
            [$user_name, $building_name, $invoice_no, $due_amount],
            $admin_message_content
        );

        MJ_amgt_SendEmailNotification($to, $subject, $message_content);
    }
}

?>