<?php
if (!defined('ABSPATH')) {
    exit;
}
$active_tab = sanitize_text_field(isset($_GET['tab']) ? $_GET['tab'] : 'memberlist');
$obj_member = new MJ_amgt_Member;
$obj_units = new MJ_amgt_ResidentialUnit;
?>
<script type="text/javascript">
	$(document).ready(function () {
		"use strict";
		jQuery('#select_all').on('click', function (e) {
			if ($(this).is(':checked', true)) {
				$(".sub_chk").prop('checked', true);
			}
			else {
				$(".sub_chk").prop('checked', false);
				$(".select_all").prop('checked', false);
			}
		});
		$("body").on("change", ".sub_chk", function () {
			if (false == $(this).prop("checked")) {
				$("#select_all").prop('checked', false);
			}
			if ($('.sub_chk:checked').length == $('.sub_chk').length) {
				$("#select_all").prop('checked', true);
			}
		});
	});
</script>
<!-- POP UP CODE -->
<div class="popup-bg z_index_100000">
	<div class="overlay-content">
		<div class="modal-content">
			<div class="category_list"> </div>
		</div>
	</div>
</div>
<!-- END POP-UP CODE -->
<!-- user redirect url enter -->
<?php
$user_access = MJ_amgt_add_check_access_for_view('member');
if ($user_access == 'administrator') {
	$user_access_add = 1;
	$user_access_edit = 1;
	$user_access_delete = 1;
	$user_access_view = 1;
} else {
	$user_access_view = $user_access['view'];
	$user_access_add = $user_access['add'];
	$user_access_edit = $user_access['edit'];
	$user_access_delete = $user_access['delete'];

	if (isset($_REQUEST['page'])) {
		if ($user_access_view == '0') {
			mj_amgt_access_right_page_not_access_message_admin_side();
			die;
		}
		if (!empty($_REQUEST['action'])) {
			if ('member' == $user_access['page_link'] && $_REQUEST['action'] == 'edit') {
				if ($user_access_edit == '0') {
					mj_amgt_access_right_page_not_access_message_admin_side();
					die;
				}
			}
			if ('member' == $user_access['page_link'] && $_REQUEST['action'] == 'add') {
				if ($user_access_add == '0') {
					mj_amgt_access_right_page_not_access_message_admin_side();
					die;
				}
			}
			if ('member' == $user_access['page_link'] && $_REQUEST['action'] == 'delete') {
				if ($user_access_delete == '0') {
					mj_amgt_access_right_page_not_access_message_admin_side();
					die;
				}
			}
		}
	}
}
?>
<!-- user redirect url enter code end -->

<?php
//------------- export Member in csv ---------------//
if (isset($_POST['export_csv'])) {
	foreach ($_POST['selected_id'] as $m_id) {
		$member_list[] = get_userdata(intval($m_id));
	}

	if (!empty($member_list)) {
		$header = array();
		$header[] = 'username';
		$header[] = 'email';
		$header[] = 'password';
		$header[] = 'building_name';
		$header[] = 'unit_category';
		$header[] = 'unit_name';
		$header[] = 'first_name';
		$header[] = 'middle_name';
		$header[] = 'last_name';
		$header[] = 'gender';
		$header[] = 'birth_date';
		$header[] = 'member_type';
		$header[] = 'occupied_date';
		$header[] = 'display_name';
		$header[] = 'address';
		$header[] = 'city_name';
		$header[] = 'state_name';
		$header[] = 'country_name';
		$header[] = 'zipcode';
		$header[] = 'mobile';



		$document_dir = WP_CONTENT_DIR;
		$document_dir .= '/uploads/export/';
		$document_path = $document_dir;
		if (!file_exists($document_path)) {
			mkdir($document_path, 0777, true);
		}

		$filename = $document_path . 'export_member.csv';
		$fh = fopen($filename, 'w') or die("can't open file");
		fputcsv($fh, $header);
		foreach ($member_list as $retrive_data) {
			$row = array();
			$user_info = get_userdata(intval($retrive_data->ID));

			$building_id = get_post($user_info->building_id);
			$unit_id = get_post($user_info->unit_cat_id);

			$row[] = $user_info->user_login;
			$row[] = sanitize_email($user_info->user_email);
			$row[] = $user_info->user_pass;
			$row[] = sanitize_text_field($building_id->post_title);
			$row[] = sanitize_text_field($unit_id->post_title);
			$row[] = MJ_amgt_get_member_assing_unit_name(get_user_meta(sanitize_text_field($retrive_data->ID), 'unit_name', true));
			$row[] = get_user_meta(sanitize_text_field($retrive_data->ID), 'first_name', true);
			$row[] = get_user_meta(sanitize_text_field($retrive_data->ID), 'middle_name', true);
			$row[] = get_user_meta(sanitize_text_field($retrive_data->ID), 'last_name', true);
			$row[] = get_user_meta(sanitize_text_field($retrive_data->ID), 'gender', true);
			$row[] = get_user_meta(sanitize_text_field($retrive_data->ID), 'birth_date', true);
			$row[] = sanitize_text_field($user_info->member_type);
			$row[] = $user_info->occupied_date;
			$row[] = sanitize_text_field($user_info->display_name);
			// $row[] =  get_user_meta(sanitize_text_field($retrive_data->ID), 'display_name',true);							
			$row[] = get_user_meta(sanitize_text_field($retrive_data->ID), 'address', true);
			$row[] = get_user_meta(sanitize_text_field($retrive_data->ID), 'city_name', true);
			$row[] = get_user_meta(sanitize_text_field($retrive_data->ID), 'state_name', true);
			$row[] = get_user_meta(sanitize_text_field($retrive_data->ID), 'country_name', true);
			$row[] = sanitize_text_field($user_info->zipcode);
			$row[] = sanitize_text_field($user_info->mobile);

			fputcsv($fh, $row);

		}
		fclose($fh);

		//download csv file.
		ob_clean();
		$file = $document_path . 'export_member.csv';//file location

		$mime = 'text/plain';
		header('Content-Type:application/force-download');
		header('Pragma: public');       // required
		header('Expires: 0');           // no cache
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s', filemtime($file)) . ' GMT');
		header('Cache-Control: private', false);
		header('Content-Type: ' . $mime);
		header('Content-Disposition: attachment; filename="' . basename($file) . '"');
		header('Content-Transfer-Encoding: binary');
		header('Connection: close');
		readfile($file);
		exit;
	} else {
		?>
		<div id="message" class="updated below-h2 notice is-dismissible">
			<p>
				<?php esc_html_e('Records not found.', 'apartment_mgt'); ?>
			</p>
		</div>

		<?php
	}
}
?>
<!-- PAGE INNER DIV -->

<?php
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'delete') {
	if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'delete_action')) {
		$result = $obj_member->MJ_amgt_delete_usedata(intval(Mj_amgt_decrypt_id($_REQUEST['member_id'])));
		if ($result) {
			wp_redirect(admin_url() . 'admin.php?page=amgt-member&tab=memberlist&message=3');
		}
	} else {
		wp_die('Security check failed!');
	}
}
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'delete_family_member') {
	if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'delete_action')) {
		$result = $obj_member->MJ_amgt_delete_family_usedata(intval(Mj_amgt_decrypt_id($_REQUEST['member_id'])));
		if ($result) {
			wp_redirect(admin_url() . 'admin.php?page=amgt-member&tab=view_member&tab1=family_member&action=view&member_id='.intval($_REQUEST['owner_id']).'&message_family=3');
		}
	} else {
		wp_die('Security check failed!');
	}
}
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'delete_tenant') {
	if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'delete_action')) {
		$result = $obj_member->MJ_amgt_delete_tenant_userdata(intval(Mj_amgt_decrypt_id($_REQUEST['member_id'])));
		if ($result) {
			wp_redirect(admin_url() . 'admin.php?page=amgt-member&tab=view_member&tab1=tenant&action=view&member_id='.$_REQUEST['owner_id'].'&_wpnonce='.mj_amgt_create_and_verify_nonce('view').'&message_family=5');
		}
	} else {
		wp_die('Security check failed!');
	}
}

if (isset($_REQUEST['delete_selected2'])) {
		if (!isset($_POST['bulk_delete_nonce']) || !wp_verify_nonce($_POST['bulk_delete_nonce'], 'bulk_delete_calls_action')) {
        wp_die('Security check failed.'); // or handle the error gracefully
    }
	if (!empty($_REQUEST['selected_id'])) {
		foreach ($_REQUEST['selected_id'] as $id) {
			global $wpdb;
			$table_amgt_unit_occupied_history = $wpdb->prefix . 'amgt_unit_occupied_history';
			$user_data = get_userdata(intval($id));
			$member_name = $user_data->display_name;
			$result = $obj_member->MJ_amgt_delete_all_user(intval($id));
			if ($result) {
			    $member_name = sanitize_text_field($member_name);
				$history_result = $wpdb->get_row($wpdb->prepare("SELECT id FROM $table_amgt_unit_occupied_history WHERE member_name = %s", $member_name));
				$whereid['id'] = intval($history_result->id);
				$historydata['occupied_to_date'] = date('Y-m-d');
				$result_update_history = $wpdb->update($table_amgt_unit_occupied_history, $historydata, $whereid);
			}
		}
		if ($result) {
			wp_redirect(admin_url() . 'admin.php?page=amgt-member&tab=memberlist&message=3');
		}
	} else {
		echo '<script language="javascript">';
		echo 'alert("' . esc_html__('Please select at least one record.', 'apartment_mgt') . '")';
		echo '</script>';
	}
}
if (isset($_REQUEST['message_family']))//MESSAGES
{
	$message_family = $_REQUEST['message_family'];
	if ($message_family == 1) { ?>
		<div id="message" class="updated below-h2 notice is-dismissible">
			<p>
				<?php
				esc_html_e('Member inserted successfully', 'apartment_mgt');
				?>
			</p>
		</div>
		<?php

	} 
	elseif ($message_family == 3) {
		?>
		<div id="message" class="updated below-h2 notice is-dismissible">
			<p>
				<?php esc_html_e('Family Member Deleted Successfully', 'apartment_mgt'); ?>
		</div>
		</p>
		<?php
	}
	elseif ($message_family == 5) {
		?>
		<div id="message" class="updated below-h2 notice is-dismissible">
			<p>
				<?php esc_html_e('Tenant Deleted Successfully', 'apartment_mgt'); ?>
		</div>
		</p>
		<?php
	}
}
if (isset($_REQUEST['message']))//MESSAGES
{
	$message = $_REQUEST['message'];
	if ($message == 1) { ?>
		<div id="message" class="updated below-h2 notice is-dismissible">
			<p>
				<?php
				esc_html_e('Member inserted successfully', 'apartment_mgt');
				?>
			</p>
		</div>
		<?php

	} elseif ($message == 2) {
		?>
		<div id="message" class="updated below-h2 notice is-dismissible">
			<p>
				<?php _e("Member updated successfully.", 'apartment_mgt'); ?>
			</p>
		</div>
		<?php
	} elseif ($message == 3) {
		?>
		<div id="message" class="updated below-h2 notice is-dismissible">
			<p>
				<?php _e("Member Deleted Successfully.", 'apartment_mgt'); ?>
			</p>
		</div>
		<?php
	} elseif ($message == 4) {
		?>
		<div id="message" class="updated below-h2 notice is-dismissible">
			<p>
				<?php esc_html_e('Member Active Successfully', 'apartment_mgt'); ?>
		</div>
		</p>
		<?php
	}
}

//MEMBERLIST TAB
if ($active_tab == 'memberlist') {
	?>
	<script type="text/javascript">
		$(document).ready(function () {
			"use strict";

			<?php
			if (is_rtl()) {
				?>
				$('#member_list_dropdown').validationEngine({ promptPosition: "bottomLeft", maxErrorsPerField: 1 });
				<?php
			} else {
				?>
				$('#member_list_dropdown').validationEngine({ promptPosition: "bottomLeft", maxErrorsPerField: 1 });
				<?php
			}
			?>
			jQuery('#member_list').DataTable(
				{
					// "responsive": true,
					"order": [[2, "desc"]],
					dom: 'lifrtp',
					"aoColumns": [
						{ "bSortable": false },
						{ "bSortable": false },
						{ "bSortable": true },
						{ "bSortable": true },
						{ "bSortable": true },
						{ "bSortable": true },
						{ "bSortable": true },
						{ "bSortable": false }],
					language: <?php echo MJ_amgt_datatable_multi_language(); ?>,
					responsive: {
						details: {
							display: $.fn.dataTable.Responsive.display.modal({
								header: function (row) {
									var data = row.data();
									return 'Details for ' + data[2];
								}
							}),
							renderer: $.fn.dataTable.Responsive.renderer.tableAll()
						}
					}
				});
			$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'apartment_mgt') ?>");
			$("#delete_selected_member").on('click', function () {

				if ($('.select-checkbox:checked').length == 0) {
					alert(language_translate.select_atleast_one_record);
					return false;
				}
				else {
					var alert_msg = confirm("<?php esc_html_e('Are you sure you want to delete this record?', 'apartment_mgt') ?>");
					if (alert_msg == false) {
						return false;
					}
					else {
						return true;
					}
				}
			});
			$('.select_all').on('click', function (e) {
				if ($(this).is(':checked', true)) {
					$(".sub_chk").prop('checked', true);
					$(".select_all").prop('checked', true);
				}
				else {
					$(".sub_chk").prop('checked', false);
					$(".select_all").prop('checked', false);
				}
			});
			$('.sub_chk').on('change', function () {
				if (false == $(this).prop("checked")) {
					$(".select_all").prop('checked', false);
				}
				if ($('.sub_chk:checked').length == $('.sub_chk').length) {
					$(".select_all").prop('checked', true);
				}
			});
		});
	</script>
	<?php
	if (isset($_REQUEST['page']) && $_REQUEST['page'] == 'amgt-member')
	{
		if(get_option('apartment_enable_video_popup_show') == 'yes')
		{
			?>
			<a href="#" class="view_video_popup youtube-icon" link="<?php echo "https://www.youtube.com/embed/wA-B6_6rIIY?si=yDfyD7lfiarSVUb8";?>" title="Online rent collection made easy with WP - AMS">
				<img src="<?php echo AMS_PLUGIN_URL."/assets/images/video_addon/youtube-icon.png" ?>" alt="YouTube">
			</a>
			<?php
		}
		
	}
	?>
	<div class="panel-body clearfix padding_left_0">
		<form method="post" id="member_list_dropdown">
			<?php wp_nonce_field('bulk_delete_calls_action', 'bulk_delete_nonce'); ?>
			<div class="form-body user_form">
				<div class="row">
					<!-- <div class="col-md-6 mb-6 input"></div> -->
					<div class="col-md-3 mb-3 input">
						<label class="ml-1 custom-top-label top" for="class_id">
							<?php esc_attr_e('Member Type', 'apartment_mgt'); ?><span class="require-field">*</span>
						</label>
						<select class="line_height_30px form-control date_type validate[required]" name="member_type"
							autocomplete="off">
							<option value="all" <?php if (isset($_POST['member_type']) && $_POST['member_type'] == "all")
								echo 'selected="selected"'; ?>>
								<?php esc_attr_e('All', 'apartment_mgt'); ?>
							</option>
							<option value="owner" <?php if (isset($_POST['member_type']) && $_POST['member_type'] == "owner")
								echo 'selected="selected"'; ?>>
								<?php esc_attr_e('Owner', 'apartment_mgt'); ?>
							</option>
							<option value="tenant" <?php if (isset($_POST['member_type']) && $_POST['member_type'] == "tenant")
								echo 'selected="selected"'; ?>>
								<?php esc_attr_e('Tenant', 'apartment_mgt'); ?>
							</option>
							<option value="family_member" <?php if (isset($_POST['member_type']) && $_POST['member_type'] == "family_member")
								echo 'selected="selected"'; ?>>
								<?php esc_attr_e('Family Member', 'apartment_mgt'); ?>
							</option>
						</select>
					</div>
					<div id="date_type_div" class="date_type_div_none row col-md-6 mb-2"></div>
					<div class="col-md-1 mb-2">
						<input type="submit" name="member_list_selected" Value="<?php esc_attr_e('Go', 'apartment_mgt'); ?>"
							class="btn btn-info save_btn" />
					</div>
				</div>
			</div>
		</form>
	</div>
	<?php
	$get_members = array('role' => 'member', 'order' => 'DESC');
	$members_list = get_users($get_members);

	$membersdata = array();

	if (isset($_REQUEST['member_list_selected'])) {
		foreach ($members_list as $retrieved_data) {
			if ($_REQUEST['member_type'] == 'family_member') {
				if ($retrieved_data->member_type == 'owner_family' || $retrieved_data->member_type == 'tenant_family' || $retrieved_data->member_type == 'care_taker') {
					$membersdata[] = $retrieved_data;
				}
			} elseif ($_REQUEST['member_type'] == 'tenant') {
				if ($retrieved_data->member_type == 'tenant') {
					$membersdata[] = $retrieved_data;
				}
			} elseif ($_REQUEST['member_type'] == 'owner') {
				if ($retrieved_data->member_type == 'Owner') {
					$membersdata[] = $retrieved_data;
				}
			}else{
				$membersdata[] = $retrieved_data;
			}
		}
	} else {
		$membersdata = $members_list;
	}


	if (!empty($membersdata)) {
		?>
		<form name="member_form" action="" method="post"><!--MEMBER FORM-->
			<div class="panel-body padding_0"><!--PANEL BODY-->
				<div class="table-responsive"><!---TABLE-RESPONSIVE--->
			<table id="member_list" class="display" cellspacing="0" width="100%">
				<thead class="<?php echo MJ_amgt_datatable_heder(); ?>">
					<tr>
						<th class="padding_0"><input type="checkbox" class="select_all" id="select_all"></th>
						<th>
							<?php esc_html_e('Photo', 'apartment_mgt'); ?>
						</th>
						<th>
							<?php esc_html_e('Name & Email ID', 'apartment_mgt'); ?>
						</th>
						<th>
							<?php esc_html_e('Member Type', 'apartment_mgt'); ?>
						</th>
						<th>
							<?php esc_html_e('Building Name', 'apartment_mgt'); ?>
						</th>
						<th>
							<?php esc_html_e('Unit Name', 'apartment_mgt'); ?>
						</th>
						<th>
							<?php esc_html_e('Mobile No.', 'apartment_mgt'); ?>
						</th>
						<th class="text_align_end">
							<?php esc_html_e('Action', 'apartment_mgt'); ?>
						</th>
					</tr>
				</thead>
				<tfoot>
					<tr>
						<th class="padding_0"><input type="checkbox" class="select_all" id="select_all"></th>
						<th>
							<?php esc_html_e('Photo', 'apartment_mgt'); ?>
						</th>
						<th>
							<?php esc_html_e('Name & Email ID', 'apartment_mgt'); ?>
						</th>
						<th>
							<?php esc_html_e('Member Type', 'apartment_mgt'); ?>
						</th>
						<th>
							<?php esc_html_e('Building Name', 'apartment_mgt'); ?>
						</th>
						<th>
							<?php esc_html_e('Unit Name', 'apartment_mgt'); ?>
						</th>
						<th>
							<?php esc_html_e('Mobile No.', 'apartment_mgt'); ?>
						</th>
						<th class="text_align_end">
							<?php esc_html_e('Action', 'apartment_mgt'); ?>
						</th>
					</tr>

				</tfoot>
				<tbody>
					<?php
					if (!empty($membersdata)) {
						foreach ($membersdata as $retrieved_data) {
							$building_name = get_the_title(intval($retrieved_data->building_id));
							$role = MJ_amgt_get_user_role(intval($retrieved_data->ID));
							if ($role == 'member') {
								$page = 'member';
							}

							?>
					<tr>
						<td class="checkbox_width_10px">
							<input type="checkbox" name="selected_id[]" class="smgt_sub_chk sub_chk select-checkbox"
								value="<?php echo esc_attr(intval($retrieved_data->ID)); ?>">
						</td>
						<?php
						$data_member_id = Mj_amgt_retrived_data_id($retrieved_data->ID);
						$view_action = mj_amgt_create_and_verify_nonce('view');
						?>
						<td class="user_image width_50px profile_image_prescription padding_left_0">
							<a class="color_black"
								href="?page=amgt-member&tab=view_member&action=view&member_id=<?php echo esc_attr(intval($data_member_id)); ?>&_wpnonce=<?php echo $view_action; ?>">
								<?php
								$uid = intval($retrieved_data->ID);
								$userimage = get_user_meta($uid, 'amgt_user_avatar', true);
								if (empty($userimage)) {
									echo '<img src=' . esc_url(get_option('amgt_member_new_thumb')) . ' height="50px" width="50px" class="img-circle" />';
								} else {
									echo '<img src=' . esc_url($userimage) . ' height="50px" width="50px" class="img-circle"/>';
								}
								?>
							</a>
						</td>
						<td class="name">
							<a class="color_black title_name"
								href="?page=amgt-member&tab=view_member&action=view&member_id=<?php echo esc_attr($data_member_id); ?>&_wpnonce=<?php echo $view_action; ?>">
								<?php echo esc_html($retrieved_data->display_name); ?>
							</a><br>
							<label class="list_page_email">
								<?php
									$email = $retrieved_data->user_email;
									echo chunk_split($email, 20, "<br>");
								?>
							</label>
						</td>
						<td class="bnumber">
							<?php
							if (!empty($retrieved_data->member_type)) {
								echo esc_html(MJ_amgt_get_member_status_label($retrieved_data->member_type));
							} else {
								echo "N/A";
							}
							?>
						</td>
						<td class="activitydate">
							<?php echo esc_html($building_name); ?>
						</td>
						<td class="activitydate">
							<?php

							if (!empty($retrieved_data->unit_name)) {
								echo MJ_amgt_get_member_assing_unit_name($retrieved_data->unit_name);
							} else {
								echo "N/A";
							}

							?>
						</td>

						<td class="">+
							<?php echo MJ_amgt_get_countery_phonecode(get_option('amgt_contry')); ?>
							<?php echo esc_html($retrieved_data->mobile); ?>
						</td>
						<td class="action">
							<div class="amgt-user-dropdown">
								<ul class="" style="margin-bottom: 0px !important;">
									<li class="">
										<a class="" href="#" data-bs-toggle="dropdown" aria-expanded="false">
											<img
												src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/More.png" ?>">
										</a>
										<ul class="dropdown-menu heder-dropdown-menu action_dropdawn"
											aria-labelledby="dropdownMenuLink">
											<?php
											if (get_user_meta($retrieved_data->ID, 'amgt_hash', true)) {
												?>
											<li class="float_left_width_100">
												<a href="?page=amgt-member&action=active_member&member_id=<?php echo esc_attr($retrieved_data->ID) ?>"
													class="float_left_width_100"><i class="fa fa-thumbs-up"></i>
													<?php esc_html_e('Active', 'apartment_mgt'); ?>
												</a>
											</li>
											<?php
											}
											$view_action = mj_amgt_create_and_verify_nonce('view');
											?>
											<li class="float_left_width_100 ">
												<a href="?page=amgt-member&tab=view_member&action=view&member_id=<?php echo esc_attr($data_member_id); ?>&_wpnonce=<?php echo $view_action; ?>"
													class="float_left_width_100"><i class="fa fa-eye"></i>
													<?php esc_html_e('View', 'apartment_mgt'); ?>
												</a>
											</li>
											<?php
											$edit_action = mj_amgt_create_and_verify_nonce('edit');
											if ($user_access_edit == 1) {
												?>
											<li class="float_left_width_100 border_bottom_item">
												<a href="?page=amgt-member&tab=adduser&action=edit&user_type=<?php echo $page; ?>&member_id=<?php echo esc_attr($data_member_id); ?>&_wpnonce=<?php echo $edit_action; ?>"
													class="float_left_width_100"><i class="fa fa-edit"></i>
													<?php esc_html_e('Edit', 'apartment_mgt'); ?>
												</a>
											</li>
											<?php
											}
											$delete_action = mj_amgt_create_and_verify_nonce('delete');
											if ($user_access_delete == 1) {
												?>
											<li class="float_left_width_100">
												<!-- <a href="?page=amgt-member&tab=memberlist&action=delete&member_id=<?php echo esc_attr($retrieved_data->ID); ?>" id="delete_occupied_unitmember" mem_id=<?php echo esc_attr($retrieved_data->ID); ?> class="float_left_width_100 list_delete_btn" onclick="return confirm('<?php esc_html_e('Are you sure you want to delete this record?', 'apartment_mgt'); ?>');"><i class="fa fa-trash"></i> <?php esc_html_e('Delete', 'apartment_mgt'); ?> </a> -->
																	<a href="?page=amgt-member&tab=memberlist&action=delete&member_id=<?php echo esc_attr($data_member_id); ?>&_wpnonce=<?php echo $delete_action; ?>"
																		id="delete_occupied_unitmember" mem_id=<?php echo esc_attr($retrieved_data->ID); ?>
																		class="float_left_width_100 list_delete_btn"><i
																			class="fa fa-trash"></i>
																		<?php esc_html_e('Delete', 'apartment_mgt'); ?>
																	</a>
																</li>
																<?php
											}
											?>
														</ul>
													</li>
												</ul>
											</div>
										</td>
									</tr>
									<?php
						}
					}
					?>
						</tbody>
					</table>
					<div class="print-button pull-left">
						<button class="btn btn-success btn-sms-color">
							<input type="checkbox" name="id[]" class="select_all"
								value="<?php echo esc_attr($retrieved_data->ID); ?>" style="margin-top: 0px;">
							<label for="checkbox" class="margin_right_5px">
								<?php esc_html_e('Select All', 'apartment_mgt'); ?>
							</label>
						</button>
						<?php
						if ($user_access_delete == 1) {
							?>
							<button data-toggle="tooltip" id="delete_selected_member"
								title="<?php esc_html_e('Delete Selected', 'apartment_mgt'); ?>" name="delete_selected2"
								mem_id=<?php echo esc_attr($retrieved_data->ID); ?> class="delete_selected "><img
									src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" alt=""></button>
							<?php
						}
						if ($user_access_add == 1) {
							?>
							<button data-toggle="tooltip" type="submit" title="<?php esc_html_e('Export CSV', 'apartment_mgt'); ?>"
								name="export_csv" type="button"
								class="member_csv_export_alert member_csv_export_alert view_csv_popup export_import_csv_btn padding_0"><img
									src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/export_csv.png" ?>"
									alt=""></button>
							<button data-toggle="tooltip" title="<?php esc_html_e('Import CSV', 'apartment_mgt'); ?>"
								name="import_csv" type="button"
								class="import_member_csv view_import_student_csv_popup export_import_csv_btn padding_0"><img
									src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/import_csv.png" ?>"
									alt=""></button>
							<?php
						}
						?>
					</div>

				</div>
			</div><!--END PANEL BODY-->
		</form><!--END MEMBER FORM-->
		<?php
	} else {
		?>
		<div class="no_data_list_div">
			<?php
			if ($user_access_add == 1) {
				?>
				<a href="<?php echo admin_url() . 'admin.php?page=amgt-member&tab=adduser&user_type=member'; ?>">
					<img class="width_100px" src="<?php echo get_option('amgt_no_data_img') ?>">
				</a>
				<div class="col-md-12 dashboard_btn margin_top_20px">
					<label class="no_data_list_label">
						<?php esc_html_e('Tap on above icon to add your first Record.', 'apartment_mgt'); ?>
					</label>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	}
}
if ($active_tab == 'addmember') {
	require_once AMS_PLUGIN_DIR . '/admin/member/add_member.php';
}
if ($active_tab == 'viewmember') {
	require_once AMS_PLUGIN_DIR . '/admin/member/view_member.php';
} ?>
<!-- END PAGE INNER DIV -->
<?php ?>