<?php $role = 'member'; ?>
<style>
	.dropdown-menu {
		min-width: 240px;
	}
</style>
<?php
if (!defined('ABSPATH')) {
    exit;
}
$document_option = get_option('amgt_upload_profile_extention'); // Allowed file extensions
$document_type = explode(", ", $document_option);
$document_type_json = json_encode($document_type);
$document_size = get_option('amgt_upload_profile_size'); // File size in MB
$other_document_option = get_option('amgt_upload_document_type'); // Allowed file extensions
$other_document_type = explode(", ", $other_document_option);
$other_document_type_json = json_encode($other_document_type);
?>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		
		var file_frame;
	  	jQuery("body").on("click", "#upload_user_avatar_button", function(event) {
            event.preventDefault();

            if (file_frame) {
                file_frame.open();
                return;
            }

            file_frame = wp.media.frames.file_frame = wp.media({
                title: jQuery(this).data('uploader_title'),
                button: {
                    text: jQuery(this).data('uploader_button_text'),
                },
                multiple: false
            });

            file_frame.on('select', function() {
                var attachment = file_frame.state().get('selection').first().toJSON();

                // Validate file extension
                var file_url = attachment.url;
                var file_extension = file_url.substr(file_url.lastIndexOf('.') + 1).toLowerCase();
                var allowed_extensions = <?php echo $document_type_json; ?>;

                if ($.inArray(file_extension, allowed_extensions) == -1) {
					var allowedFormatsMessage = language_translate.only + allowed_extensions.join(", ") + language_translate.formats_allowed;
                    alert(allowedFormatsMessage);
                    return false;
                }

                // Validate file size (in bytes)
                var file_size_mb = attachment.filesize / (1024 * 1024); // Convert bytes to MB
                var max_size = <?php echo $document_size; ?>;

                if (file_size_mb > max_size) {
					alert(language_translate.larger_file + max_size + language_translate.mb_uploaded);
                    return false;
                }

                // Set image URL and preview
                jQuery("#amgt_user_avatar_url").val(attachment.url);
                $('#upload_user_avatar_preview img').attr('src', attachment.url);
            });

            file_frame.open();
        });
    });
	function fileCheck(obj) {   //FILE VALIDATION
		"use strict";
		var fileExtension = <?php echo $other_document_type_json; ?>;
		if ($.inArray($(obj).val().split('.').pop().toLowerCase(), fileExtension) == -1) {
			alert(language_translate.only + fileExtension.join(", ") + language_translate.formats_allowed);
			$(obj).val('');
		}
	}
</script>
<script type="text/javascript">
	$(document).ready(function ($) {   //MEMBER FORM VALIDATIONENGINE
		"use strict";
		<?php
		if (is_rtl()) {
			?>
			$('#member_form').validationEngine({ promptPosition: "bottomLeft", maxErrorsPerField: 1 });
			<?php
		} else {
			?>
			$('#member_form').validationEngine({ promptPosition: "bottomLeft", maxErrorsPerField: 1 });
			<?php
		}
		?>

		jQuery('#birth_date').datepicker({
			dateFormat: "yy-mm-dd",
			maxDate: 0,
			changeMonth: true,
			changeYear: true,
			yearRange: '-120:+25',
			beforeShow: function (textbox, instance) {
				instance.dpDiv.css({
					marginTop: (-textbox.offsetHeight) + 'px'
				});
			},
			onChangeMonthYear: function (year, month, inst) {
				jQuery(this).val(month + "/" + year);
			}
		});
		jQuery('#family_birth_date').datepicker({
			dateFormat: "yy-mm-dd",
			maxDate: 0,
			changeMonth: true,
			changeYear: true,
			yearRange: '-120:+25',
			beforeShow: function (textbox, instance) {
				instance.dpDiv.css({
					marginTop: (-textbox.offsetHeight) + 'px'
				});
			},
			onChangeMonthYear: function (year, month, inst) {
				jQuery(this).val(month + "/" + year);
			}
		});
		// $.fn.datepicker.defaults.format ="<?php echo MJ_amgt_dateformat_PHP_to_jQueryUI(MJ_amgt_date_formate()); ?>";
		// $.fn.datepicker.defaults.format = "<?php echo MJ_amgt_dateformat_PHP_to_jQueryUI(MJ_amgt_date_formate()); ?>";
		$('#occupied_date').datepicker({
			dateFormat: "yy-mm-dd",
			autoclose: true,
			onSelect: function(selectedDate) {
				// Set the minimum selectable date for end date
				$('#occupied_end_date').datepicker('option', 'minDate', selectedDate);
			}
		});

		$('#occupied_end_date').datepicker({
			dateFormat: "yy-mm-dd",
			autoclose: true
		});


		//USERNAME NOT  ALLOW SPACE VALIDATION
		$('#username').keypress(function (e) {
			"use strict";
			if (e.which === 32)
				return false;
		});
		$('.remove_unused_model').on('click', function (e) {
			$(".modal-backdrop").addClass("background_color_black");
		});

		$('.select_unit_name').multiselect(
			{
				nonSelectedText: language_translate.select_unit_name,
				includeSelectAllOption: true,
				selectAllText: language_translate.select_all,
				allSelectedText: language_translate.all_selected,
				templates: {
					button: '<button class="multiselect btn btn-default dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"><span class="multiselect-selected-text"></span><b class="caret"></b></button>',
				},
				buttonContainer: '<div class="dropdown btn-group_multiselect" />'
			});

	});

</script>

<?php
$member_id = 0;
$edit_family = 0;
if (isset($_REQUEST['member_id']))
	$member_id = intval(Mj_amgt_decrypt_id($_REQUEST['member_id']));
$edit = 0;
if (isset($_REQUEST['action']) && sanitize_text_field($_REQUEST['action']) == 'edit') {
	$edit = 1;

	$result = get_userdata($member_id);
	if ($result->member_type == 'owner_family' || $result->member_type == 'tenant_family' || $result->member_type == 'care_taker') {
		$edit_family = 1;
	}

}
if ($edit_family) {
	?>
	<div class="panel-body padding_0"><!--PANEL BODY-->
		<!---ADD MEMBER FORM--->
	<form name="member_form" action="" method="post" class="form-horizontal" id="member_form"
		enctype="multipart/form-data">
		<?php $action = sanitize_text_field(isset($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'); ?>
		<input id="action" type="hidden" name="action" value="<?php echo esc_attr($action); ?>">
		<input type="hidden" name="user_id" class="user_id" value="<?php echo esc_attr($member_id); ?>" />
		<input type="hidden" name="role" value="<?php echo esc_attr($role); ?>" />
		<input type="hidden" name="allow_member_to_multiple_units" class="allow_member_to_multiple_units"
			value="<?php echo get_option('allow_member_to_multiple_units'); ?>" />
		<div class="header">
			<h3 class="first_hed">
				<?php esc_html_e('Member Information', 'apartment_mgt'); ?>
			</h3>
		</div>
		<div class="form-body user_form"> <!-- user_form Strat-->
				<div class="row">
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="first_name"
									class="form-control validate[required,custom[onlyLetter_specialcharacter]] text-input"
									maxlength="50" type="text" value="<?php if ($edit) {
										echo esc_attr($result->first_name);
									} elseif (isset($_POST['first_name']))
										echo esc_attr($_POST['first_name']); ?>" name="first_name">
								<label class="" for="middle_name">
									<?php esc_html_e('First Name', 'apartment_mgt'); ?><span class="require-field">*</span>
								</label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">

								<script>

								</script>

								<input id="middle_name " class="form-control validate[custom[onlyLetter_specialcharacter]]"
									maxlength="50" type="text" value="<?php if ($edit) {
										echo esc_attr($result->middle_name);
									} elseif (isset($_POST['middle_name']))
										echo esc_attr($_POST['middle_name']); ?>" name="middle_name">
								<label class="" for="middle_name">
									<?php esc_html_e('Middle Name', 'apartment_mgt'); ?>
								</label>

							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="last_name"
									class="form-control validate[required,custom[onlyLetter_specialcharacter]] text-input"
									maxlength="50" type="text" value="<?php if ($edit) {
										echo esc_attr($result->last_name);
									} elseif (isset($_POST['last_name']))
										echo esc_attr($_POST['last_name']); ?>" name="last_name">
								<label class="" for="middle_name">
									<?php esc_html_e('Last Name', 'apartment_mgt'); ?><span class="require-field">*</span>
								</label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="birth_date" class="form-control validate[required] label_overlp"
									autocomplete="off" type="text" name="birth_date" value="<?php if ($edit) {
										echo esc_attr(date("Y-m-d", strtotime($result->birth_date)));
									} elseif (isset($_POST['birth_date']))
										echo esc_attr($_POST['birth_date']); ?>" readonly>
								<label class="birthdate_label active" id="my_label_add" for="middle_name">
									<?php esc_html_e('Date of Birth', 'apartment_mgt'); ?><span
										class="require-field">*</span>
								</label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 res_margin_bottom_20px rtl_margin_top_15px">
						<div class="form-group">
							<div class="col-md-12 form-control">
								<div class="row padding_radio">
									<div class="input-group">
										<label class="custom-top-label" for="gender">
											<?php esc_html_e('Gender', 'apartment_mgt'); ?><span
												class="require-field">*</span>
										</label>
										<div class="d-inline-block gender_line_height_24px">
											<?php $genderval = "male";
											if ($edit) {
												$genderval = $result->gender;
											} elseif (isset($_POST['gender'])) {
												$genderval = $_POST['gender'];
											} ?>
											<label class="radio-inline custom_radio admin_radio">
												<input type="radio" value="male" class="tog" name="gender" <?php checked('male', $genderval); ?> />
												<?php esc_html_e('Male', 'apartment_mgt'); ?>
											</label>
											<label class="radio-inline custom_radio admin_radio">
												<input type="radio" value="female" class="tog" name="gender" <?php checked('female', $genderval); ?> />
												<?php esc_html_e('Female', 'apartment_mgt'); ?>
											</label>

										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="email"
									class="amgt_email_id_validation form-control validate[required,custom[email]] text-input"
									type="text" maxlength="50" name="email" value="<?php if ($edit) {
										echo esc_attr($result->user_email);
									} elseif (isset($_POST['email']))
										echo esc_attr($_POST['email']); ?>">
								<label class="" for="middle_name">
									<?php esc_html_e('Email', 'apartment_mgt'); ?><span class="require-field">*</span>
								</label>
							</div>
							<div class="email_validation_div">
								<div class="formError"
									style="opacity: 0.87; position: absolute; top: 33px; left: 482.5px; margin-top: 0px; display: block;">
									<div class="formErrorArrow formErrorArrowBottom">
										<div class="line1"><!-- --></div>
										<div class="line2"><!-- --></div>
										<div class="line3"><!-- --></div>
										<div class="line4"><!-- --></div>
										<div class="line5"><!-- --></div>
										<div class="line6"><!-- --></div>
										<div class="line7"><!-- --></div>
										<div class="line8"><!-- --></div>
										<div class="line9"><!-- --></div>
										<div class="line10"><!-- --></div>
									</div>
									<div class="formErrorContent">
										<?php esc_html_e('Email id Already Exist.', 'apartment_mgt'); ?><br>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="password" class="form-control <?php if (!$edit)
									echo 'validate[required]'; ?>" type="password" name="password" minlength="8" maxlength="12" value="">
								<label class="" for="middle_name">
									<?php esc_html_e('Password', 'apartment_mgt'); ?>
									<?php if (!$edit) { ?> <span class="require-field">*</span>
									<?php } ?>
								</label>
							</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-4">
								<div class="form-group input margin_bottom_0">
									<div class="col-md-12 form-control">
										<input type="text" readonly
											value="+<?php echo MJ_amgt_get_countery_phonecode(get_option('amgt_contry')); ?>"
											class="form-control" name="phonecode">
										<label for="phonecode" class="pl-2 popup_countery_code_css">
											<?php esc_html_e('Country Code', 'apartment_mgt'); ?><span
												class="required red">*</span>
										</label>
									</div>
								</div>
							</div>
							<div class="col-md-8">
								<div class="form-group input margin_bottom_0">
									<div class="col-md-12 form-control">
										<input id="mobile"
											class="form-control validate[required,custom[phone_number],minSize[6],maxSize[15]]] text-input"
											type="number" min="6" onKeyPress="if(this.value.length==15) return false;"
											name="mobile" value="<?php if ($edit) {
												echo $result->mobile;
											} elseif (isset($_POST['mobile']))
												echo esc_attr($_POST['mobile']); ?>">
										<label class="" for="mobile">
											<?php esc_html_e('Mobile Number', 'apartment_mgt'); ?><span
												class="require-field">*</span>
										</label>
									</div>
								</div>
							</div>
						</div>
					</div>

				</div>

				<div class="header">
					<h3 class="first_hed">
						<?php esc_html_e('Address Information', 'apartment_mgt'); ?>
					</h3>
				</div>
				<div class="form-body user_form"> <!-- user_form Strat-->
					<div class="row"><!--Row Div Strat-->
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="address"
										class="form-control validate[custom[address_description_validation]]" type="text"
										maxlength="150" name="address" value="<?php if ($edit) {
											echo esc_attr($result->address);
										} elseif (isset($_POST['address']))
											echo esc_attr($_POST['address']); ?>">
									<label class="" for="middle_name">
										<?php esc_html_e('Address', 'apartment_mgt'); ?>
									</label>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="city_name"
										class="form-control validate[custom[city_state_country_validation]]" maxlength="50"
										type="text" name="city_name" value="<?php if ($edit) {
											echo esc_attr($result->city_name);
										} elseif (isset($_POST['city_name']))
											echo esc_attr($_POST['city_name']); ?>">
									<label class="" for="middle_name">
										<?php esc_html_e('City', 'apartment_mgt'); ?>
									</label>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input class="form-control validate[custom[city_state_country_validation]]" type="text"
										maxlength="50" name="state_name" value="<?php if ($edit) {
											echo esc_attr($result->state_name);
										} elseif (isset($_POST['state_name']))
											echo esc_attr($_POST['state_name']); ?>">
									<label class="" for="middle_name">
										<?php esc_html_e('State', 'apartment_mgt'); ?>
									</label>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input class="form-control validate[custom[city_state_country_validation]]" type="text"
										maxlength="50" name="country_name" value="<?php if ($edit) {
											echo esc_attr($result->country_name);
										} elseif (isset($_POST['country_name']))
											echo esc_attr($_POST['country_name']); ?>">
									<label class="" for="middle_name">
										<?php esc_html_e('Country', 'apartment_mgt'); ?>
									</label>
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input class="form-control validate[custom[onlyLetterNumber]]" maxlength="15"
										type="text" name="zipcode" value="<?php if ($edit) {
											echo esc_attr($result->zipcode);
										} elseif (isset($_POST['zipcode']))
											echo esc_attr($_POST['zipcode']); ?>">
									<label class="" for="middle_name">
										<?php esc_html_e('Zip Code', 'apartment_mgt'); ?>
									</label>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="header">
					<h3 class="first_hed">
						<?php esc_html_e('Other Information', 'apartment_mgt'); ?>
					</h3>
				</div>
				<div class="form-body user_form"> <!-- user_form Strat-->
					<div class="row"><!--Row Div Strat-->

						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
							<div class="form-group input">
								<div class="col-md-12 form-control upload-profile-image-patient">
									<label class="ustom-control-label custom-top-label ml-2" for="photo">
										<?php esc_html_e('Image', 'apartment_mgt'); ?>
									</label>
									<div class="col-sm-12 display_flex">
										<input type="text" id="amgt_user_avatar_url"
											class="image_path_dots form-control gmgt_user_avatar_url"
											name="amgt_user_avatar" value="<?php if ($edit)
													echo esc_url($result->amgt_user_avatar);
												elseif (isset($_POST['amgt_user_avatar']))
													echo esc_url($_POST['amgt_user_avatar']); ?>"
												readonly />
										<input id="upload_user_avatar_button" type="button"
											class="button upload_image_btn upload_user_avatar_button"
											value="<?php esc_html_e('Upload image', 'apartment_mgt'); ?>" />
									</div>
								</div>
								<div class="clearfix"></div>
								<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
									<div id="upload_user_avatar_preview" class="upload_user_avatar_preview">
										<?php
										if ($edit) {
											if ($result->amgt_user_avatar == "") {
												?>
												<img class="image_preview_css"
													src="<?php echo esc_url(get_option('amgt_member_new_thumb')); ?>">
												<?php
											} else {
												?>
												<img class="image_preview_css" src="<?php if ($edit)
													echo esc_url($result->amgt_user_avatar); ?>" />
												<?php
											}
										} else {
											?>
											<img class="image_preview_css"
												src="<?php echo esc_url(get_option('amgt_member_new_thumb')); ?>">
											<?php
										}
										?>
									</div>
								</div>
							</div>
						</div>

						<?php
						if ($edit) {
							$doc_data = get_user_meta($member_id, 'document', true);
							$data_new = json_decode($doc_data);
							if (!empty($data_new)) {
								$i = 0;
								foreach ($data_new as $data) {
									?>
									<div class="header">
										<h3 class="first_hed">
											<?php esc_html_e('Other Document', 'apartment_mgt'); ?>
										</h3>
									</div>
									<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
										<div class="form-group input">
											<div class="col-md-12 form-control">
												<input id="doc_title" maxlength="50"
													class="form-control  text-input onlyletter_number_space_validation" type="text"
													placeholder="<?php esc_html_e('Title', 'apartment_mgt'); ?>" value="<?php if ($edit)
														   echo esc_attr($data->title); ?>" name="doc_title[]">
												<label class="" for="middle_name">
													<?php esc_html_e('Title', 'apartment_mgt'); ?>
												</label>
											</div>
										</div>
									</div>
									<div
										class="<?php if ($data->value) { ?> col-sm-4 col-md-4 col-lg-4 col-xl-4 <?php } else { ?>  col-sm-6 col-md-6 col-lg-6 col-xl-6 <?php } ?>">
										<div class="form-group input">
											<div class="col-md-12 form-control upload-profile-image-patient">
												<label class="ustom-control-label custom-top-label ml-2" for="photo">
													<?php esc_html_e('Upload Document', 'apartment_mgt'); ?>
												</label>
												<div class="col-sm-12 display_flex">
													<input id="upload_file" onchange="fileCheck(this);" name="upload_file[]" class=""
														type="file" />
												</div>
											</div>
										</div>
									</div>
									<?php
									if (isset($data->value) && $data->value != "") {
										?>
										<div class="col-sm-2 col-md-2 col-lg-2 col-xl-2 padding_right_0px rtl_margin_top_15px mb-3">
											<a download target="blank"
												href="<?php echo esc_url(content_url() . '/uploads/apartment_assets/' . sanitize_file_name($data->value)); ?>"
												class="btn add_btn"><span class="btn_line_height_35px"><i class="fa fa-download"></i>
													<?php esc_html_e('Download', 'apartment_mgt'); ?>
												</span></a>
										</div>
										<?php
									}
									?>
									<input type="hidden" name="hidden_upload_file[]" value="<?php if ($edit) {
										echo $data->value;
									} elseif (isset($_POST['upload_file']))
										echo $_POST['upload_file']; ?>">
									<?php
								}
							}
						} else {
							?>
							<div class="header">
								<h3 class="first_hed">
									<?php esc_html_e('Other Document', 'apartment_mgt'); ?>
								</h3>
							</div>
							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
								<div class="form-group input">
									<div class="col-md-12 form-control">
										<input id="doc_title" maxlength="50"
											class="form-control validate[custom[onlyLetter_specialcharacter]] text-input"
											type="text" value="<?php if ($edit)
												echo esc_url($result->doc_title); ?>" name="doc_title[]">
										<label class="" for="middle_name">
											<?php esc_html_e('Title', 'apartment_mgt'); ?>
										</label>
									</div>
								</div>
							</div>
							<div class="col-sm-5 col-md-5 col-lg-5 col-xl-5 padding_right_0">
								<div class="form-group input">
									<div class="col-md-12 form-control upload-profile-image-patient">
										<label class="ustom-control-label custom-top-label ml-2" for="photo">
											<?php esc_html_e('Upload Document', 'apartment_mgt'); ?>
										</label>
										<div class="col-sm-12 display_flex">
											<input id="upload_file" onchange="fileCheck(this);" name="upload_file[]" type="file"
												<?php if ($edit) { ?>class="" <?php } else { ?>class="margin_left_15_res" <?php } ?> />
										</div>
									</div>
								</div>
							</div>
							<div class="col-md-1 symptoms_deopdown_div mb-3 rtl_margin_top_15px">
								<img src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/Add_new_Button.png" ?>"
									id="add_new_document_entry_member" name="add_new_entry" alt="" class="">
							</div>
							<div id="document_entry_member"></div>
							<?php
						}
						?>


					</div>
				</div>


			</div>

			<?php wp_nonce_field('save_member_nonce'); ?>
			<div class="form-body user_form"> <!-- user_form Strat-->
				<div class="row"><!--Row Div Strat-->
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
						<input type="submit" value="<?php if ($edit) {
							esc_html_e('Save', 'apartment_mgt');
						} else {
							esc_html_e('Add Member', 'apartment_mgt');
						} ?>" name="save_family_member" class="btn save_btn" />
					</div>
				</div>
			</div>
		</form>
	</div>


	<?php
} else {
	?>

	<div class="panel-body padding_0"><!--PANEL BODY-->
		<!---ADD MEMBER FORM--->
	<form name="member_form" action="" method="post" class="form-horizontal" id="member_form"
		enctype="multipart/form-data">
		<?php $action = sanitize_text_field(isset($_REQUEST['action']) ? $_REQUEST['action'] : 'insert'); ?>
		<input id="action" type="hidden" name="action" value="<?php echo esc_attr($action); ?>">
		<input type="hidden" name="user_id" class="user_id" value="<?php echo esc_attr($member_id); ?>" />
		<input type="hidden" name="role" value="<?php echo esc_attr($role); ?>" />
		<input type="hidden" name="allow_member_to_multiple_units" class="allow_member_to_multiple_units"
			value="<?php echo get_option('allow_member_to_multiple_units'); ?>" />

		<!------------------ OCCUPIED INFORMATION ------------------>

		<div class="row mb-1">
			<div class="header col-9 col-md-11">
				<h3 class="first_hed">
					<?php esc_html_e('Building Information', 'apartment_mgt'); ?>
				</h3>
			</div>
		</div>
		<div class="form-body user_form"> <!-- user_form Strat-->
				<div class="row"><!--Row Div Strat-->
					<div class="col-sm-12 col-md-5 col-lg-5 col-xl-5 input">
						<label class="ml-1 custom-top-label top" for="role_type">
							<?php esc_html_e('Building', 'apartment_mgt'); ?><span class="require-field">*</span>
						</label>
						<select class="form-select validate[required] building_category" name="building_id">
							<option value="">
								<?php esc_html_e('Select Building', 'apartment_mgt'); ?>
							</option>
							<?php
							if ($edit) {
								$category = $result->building_id;
							} elseif (isset($_REQUEST['building_id'])) {
								$category = $_REQUEST['building_id'];
							} else {
								$category = "";
							}
							$activity_category = MJ_amgt_get_all_category('building_category');
							if (!empty($activity_category)) {
								foreach ($activity_category as $retrive_data) {
									echo '<option value="' . esc_attr($retrive_data->ID) . '" ' . selected($category, $retrive_data->ID, false) . '>' . esc_html($retrive_data->post_title) . '</option>';

								}
							} ?>
						</select>
					</div>
					<div class="col-sm-12 col-md-1 col-lg-1 col-xl-1 mb-3 rtl_margin_top_15px">
						<button type="button" class="btn remove_unused_model add_btn" data-bs-toggle="modal"
							data-bs-target="#myModal_add_building">
							<?php esc_html_e('Add', 'apartment_mgt'); ?>
						</button>
					</div>
					<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
						<label class="ml-1 custom-top-label top" for="role_type">
							<?php esc_html_e('Unit Category', 'apartment_mgt'); ?><span class="require-field">*</span>
						</label>
						<select class="form-select validate[required] unit_category_for_member unit_category"
							name="unit_cat_id">
							<option value="">
								<?php esc_html_e('Select Unit Category', 'apartment_mgt'); ?>
							</option>
							<?php
							if ($edit)
								$category = $result->unit_cat_id;
							elseif (isset($_REQUEST['unit_cat_id']))
								$category = $_REQUEST['unit_cat_id'];
							else
								$category = "";

							$activity_category = MJ_amgt_get_all_category('unit_category');
							if (!empty($activity_category)) {
								foreach ($activity_category as $retrive_data) {
									echo '<option value="' . esc_attr($retrive_data->ID) . '" ' . selected($category, $retrive_data->ID, false) . '>' . esc_html($retrive_data->post_title) . '</option>';

								}
							}
							?>
						</select>
					</div>

					<?php
					if (get_option('allow_member_to_multiple_units') == "no") { ?>
						<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
							<label class="ml-1 custom-top-label top" for="role_type">
								<?php esc_html_e('Unit', 'apartment_mgt'); ?><span class="require-field">*</span>
							</label>
							<select class="form-select validate[required] unit_name" name="unit_name">
								<option value="">
									<?php esc_html_e('Select Unit Name', 'apartment_mgt'); ?>
								</option>
								<?php
								if ($edit) {
									$unitname = $result->unit_name;
									$building_id = $result->building_id;
									$unit_category = $result->unit_cat_id;
									$unitsarray = $obj_units->MJ_amgt_get_single_cat_units($building_id, $unit_category);
									$all_entry = json_decode($unitsarray);

									$i = 0;

									foreach ($all_entry as $key => $value) {
										$unit_value[] = $value;
									}
									$is_json = is_json($unitname, $return_data = false);
									$unitdata = json_decode($unitname);

									if (!empty($unit_value)) {
										foreach ($all_entry as $key1 => $value1) {
											$selected = "";
											$occupied_status = MJ_amgt_occupied_status_by_unit_for_dropdown($value1->value);

											if ($is_json == "TRUE") {
												$unitname = array();
												foreach ($unitdata as $value) {
													$unitname[] = $value->unit_name;
												}
												if (in_array($value1->value, $unitname)) {
													$selected = "selected";
												}
												?>
												<option value="<?php echo esc_attr($value1->value); ?>" class="<?php if ($occupied_status == "1") {
													   echo "occupied_status_color";
												   } ?>" <?php echo $selected; ?>>
													<?php echo esc_html($value1->value); ?>
													<?php if ($occupied_status == "1") { ?><span>
															<?php echo esc_html_e('(Occupied)', 'apartment_mgt'); ?>
														</span>
													<?php } ?>
												</option>
												<?php
											} else {
												?>
												<option value="<?php echo esc_attr($value1->value); ?>" class="<?php if ($occupied_status == "1") {
													   echo "occupied_status_color";
												   } ?>" <?php selected($unitname, $value1->value); ?>>
													<?php echo esc_attr($value1->value); ?>
													<?php if ($occupied_status == "1") { ?><span>
															<?php echo esc_html_e('(Occupied)', 'apartment_mgt'); ?>
														</span>
													<?php } ?>
												</option>
												<?php
											}
											// $unitdata = json_decode($all_entry);
										}
									}
								} ?>
							</select>
						</div>
						<?php
					} else { ?>

						<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
							<!-- <label class="ml-1 custom-top-label top" for="role_type"><?php esc_html_e('Unit', 'apartment_mgt'); ?><span class="require-field">*</span></label> -->
							<select class="form-select validate[required] unit_name select_unit_name" multiple="multiple"
								name="unit_name[]">
								<?php
								if ($edit) {
									$unitname = $result->unit_name;
									$building_id = $result->building_id;
									$unit_category = $result->unit_cat_id;
									$unitsarray = $obj_units->MJ_amgt_get_single_cat_units($building_id, $unit_category);
									$all_entry = json_decode($unitsarray);

									$i = 0;

									foreach ($all_entry as $key => $value) {
										$unit_value[] = $value;
									}

									$is_json = is_json($unitname, $return_data = false);
									$unitdata = json_decode($unitname);
									if (!empty($unit_value)) {
										foreach ($all_entry as $key1 => $value1) {
											$selected = "";
											$occupied_status = MJ_amgt_occupied_status_by_unit_for_dropdown($value1->value);
											if ($is_json == "TRUE") {
												$unitname = array();
												foreach ($unitdata as $value) {
													$unitname[] = $value->unit_name;
												}
												if (in_array($value1->value, $unitname)) {
													$selected = "selected";
												}
												?>
												<option value="<?php echo esc_attr($value1->value); ?>" class="<?php if ($occupied_status == "1") {
													   echo "occupied_status_color";
												   } ?>" <?php echo $selected; ?>>
													<?php echo esc_html($value1->value); ?>
													<?php if ($occupied_status == "1") { ?><span>
															<?php echo esc_html_e('(Occupied)', 'apartment_mgt'); ?>
														</span>
													<?php } ?>
												</option>
												<?php
											} else {
												?>
												<option value="<?php echo esc_attr($value1->value); ?>" class="<?php if ($occupied_status == "1") {
													   echo "occupied_status_color";
												   } ?>" <?php selected($unitname, $value1->value); ?>>
													<?php echo esc_attr($value1->value); ?>
													<?php if ($occupied_status == "1") { ?><span>
															<?php echo esc_html_e('(Occupied)', 'apartment_mgt'); ?>
														</span>
													<?php } ?>
												</option>
												<?php
											}
										}
									}
								} ?>
							</select>
						</div>
						<?php
					}
					?>

					<!-- <div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
						<label class="ml-1 custom-top-label top" for="role_type">
							<?php esc_html_e('Member Type', 'apartment_mgt'); ?><span class="require-field">*</span>
						</label>
						<select class="form-select validate[required]" name="member_type" id="member_type" disabled>
							<option value="">
								<?php esc_html_e('Select Member Type', 'apartment_mgt'); ?>
							</option>
							<?php
							if ($edit) {
								$category = $result->member_type;
							} elseif (isset($_POST['member_type'])) {
								$category = $_POST['member_type'];
							} else {
								$category = "";
							} ?>
							<option value="Owner" <?php selected($category, 'Owner'); ?>>
							<option value="Owner" <?php selected('Owner', 'Owner'); ?>>
								<?php esc_html_e('Owner', 'apartment_mgt'); ?>
							</option>
							<option value="tenant" <?php selected($category, 'tenant'); ?>>
								<?php esc_html_e('Tenant', 'apartment_mgt'); ?>
							</option>
						</select>
					</div> -->
					<?php
					if ($edit) {
						?>
						<input type="hidden" name="member_type" value="<?php echo $result->member_type; ?>">
						<?php
					}else{
						?>
							<input type="hidden" name="member_type" value="Owner">
						<?php
					} ?>
					<?php
					if ($edit) {
						if ($result->member_type == "Owner" || $result->member_type == "tenant") {
							if (!empty($result->occupied_by)) {
								?>
								
									<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
										<label class="ml-1 custom-top-label top" for="role_type">
											<?php esc_html_e('Occupied By', 'apartment_mgt'); ?><span
												class="require-field">*</span>
										</label>
										<select class="form-select validate[required] allready_occupied" name="occupied_by">
											<option value="">
												<?php esc_html_e('Select Occupied By', 'apartment_mgt'); ?>
											</option>
											<?php
											if ($edit)
												$occupied_by = $result->occupied_by;
											elseif (isset($_POST['occupied_by']))
												$occupied_by = $_POST['occupied_by'];
											else
												$occupied_by = "";
											?>
											<?php $activity_category = MJ_amgt_get_all_category('member_category');
											if (!empty($activity_category)) {
												foreach ($activity_category as $retrive_data) {
													if($retrive_data->post_title == 'Owner')
													echo '<option value="' . $retrive_data->post_title . '" ' . selected($occupied_by, $retrive_data->post_title) . '>' . esc_html__($retrive_data->post_title, 'apartment_mgt') . '</option>';
												}
											} ?>
										</select>
									</div>
									<!-- <div class="col-sm-12 col-md-1 col-lg-1 col-xl-1 mb-3 rtl_margin_top_15px">
										<button type="button" id="addremove" class="btn add_btn" model="member_category">
											<?php esc_html_e('Add', 'apartment_mgt'); ?>
										</button>
									</div> -->
									<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
										<div class="form-group input">
											<div class="col-md-12 form-control">
												<input id="occupied_date" class="form-control validate[required] label_overlp"
													autocomplete="off" type="text" name="occupied_date" value="<?php if ($edit) {
														echo esc_attr(date("Y-m-d", strtotime($result->occupied_date)));
													} elseif (isset($_POST['occupied_date']))
														echo esc_attr($_POST['occupied_date']); ?>">
												<label class="active" id="my_label_add" for="middle_name">
													<?php esc_html_e('Occupied Date', 'apartment_mgt'); ?><span
														class="require-field">*</span>
												</label>
											</div>
										</div>
									</div>
									<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
										<div class="form-group input">
											<div class="col-md-12 form-control">
												<input id="occupied_end_date" class="form-control validate[required] label_overlp"
													autocomplete="off" type="text" name="occupied_end_date" value="<?php if ($edit) {
														echo esc_attr(date("Y-m-d", strtotime($result->occupied_end_date)));
													} elseif (isset($_POST['occupied_end_date']))
														echo esc_attr($_POST['occupied_end_date']); ?>">
												<label class="active" id="my_label_add" for="middle_name">
													<?php esc_html_e('Occupied End Date', 'apartment_mgt'); ?><span
														class="require-field">*</span>
												</label>
											</div>
										</div>
									</div>
								<?php
							} else {
								?>
								<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
									<label class="ml-1 custom-top-label top" for="role_type">
										<?php esc_html_e('Occupied By', 'apartment_mgt'); ?><span class="require-field">*</span>
									</label>
									<select class="form-select validate[required] allready_occupied" name="occupied_by">
										<option value="">
											<?php esc_html_e('Select Occupied By', 'apartment_mgt'); ?>
										</option>
										<?php $activity_category = MJ_amgt_get_all_category('member_category');
										if (!empty($activity_category)) {
											foreach ($activity_category as $retrive_data) {
												if($retrive_data->post_title == 'Owner')
												echo '<option value="' . $retrive_data->post_title . '" ' . selected($category, $retrive_data->ID) . '>' . $retrive_data->post_title . '</option>';
											}
										} ?>
									</select>
								</div>
								<!-- <div class="col-sm-12 col-md-1 col-lg-1 col-xl-1 mb-3 rtl_margin_top_15px">
									<button type="button" id="addremove" class="btn add_btn" model="member_category">
										<?php esc_html_e('Add', 'apartment_mgt'); ?>
									</button>
								</div> -->
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="occupied_date" class="form-control validate[required] label_overlp"
												type="text" name="occupied_date" value="">
											<label class="active" id="my_label_add" for="middle_name">
												<?php esc_html_e('Occupied Date', 'apartment_mgt'); ?><span
													class="require-field">*</span>
											</label>
										</div>
									</div>
								</div>
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="occupied_end_date" class="form-control validate[required] label_overlp"
												type="text" name="occupied_end_date" value="">
											<label class="active" id="my_label_add" for="middle_name">
												<?php esc_html_e('Occupied End Date', 'apartment_mgt'); ?><span
													class="require-field">*</span>
											</label>
										</div>
									</div>
								</div>
								<?php
							}
						}
					} else {
						?>
						<!-- <div class="occupied_div1"> -->
							<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
								<label class="ml-1 custom-top-label top" for="role_type">
									<?php esc_html_e('Occupied By', 'apartment_mgt'); ?><span
										class="require-field">*</span>
								</label>
								<select class="form-select validate[required] allready_occupied" name="occupied_by">
									<option value="">
										<?php esc_html_e('Select Occupied By', 'apartment_mgt'); ?>
									</option>
									<?php
									if ($edit)
										$occupied_by = $result->occupied_by;
									elseif (isset($_POST['occupied_by']))
										$occupied_by = $_POST['occupied_by'];
									else
										$occupied_by = "";
									$activity_category = MJ_amgt_get_all_category('member_category');

									if (!empty($activity_category)) {
										foreach ($activity_category as $retrive_data) {
											if($retrive_data->post_title == 'Owner')
											echo '<option value="' . $retrive_data->post_title . '" ' . selected($category, $retrive_data->ID) . '>' . esc_html__($retrive_data->post_title, 'apartment_mgt') . '</option>';
										}
									} ?>
								</select>
							</div>
							<!-- <div class="col-sm-12 col-md-1 col-lg-1 col-xl-1 mb-3 rtl_margin_top_15px">
								<button type="button" id="addremove" class="btn add_btn" model="member_category">
									<?php esc_html_e('Add', 'apartment_mgt'); ?>
								</button>
							</div> -->
							<style>

							</style>
							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
								<div class="form-group input">
									<div class="col-md-12 form-control">
										<input id="occupied_date" class="form-control validate[required] label_overlp"
											type="text" autocomplete="off" name="occupied_date" value="<?php if ($edit) {
												echo esc_attr(date(MJ_amgt_date_formate(), strtotime($result->occupied_date)));
											} elseif (isset($_POST['occupied_date']))
												echo esc_attr($_POST['occupied_date']); ?>">
										<label class="active" id="my_label_add" for="middle_name">
											<?php esc_html_e('Occupied Date', 'apartment_mgt'); ?><span
												class="require-field">*</span>
										</label>
									</div>
								</div>
							</div>
							<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
								<div class="form-group input">
									<div class="col-md-12 form-control">
										<input id="occupied_end_date" class="form-control validate[required] label_overlp"
											type="text" autocomplete="off" name="occupied_end_date" value="<?php if ($edit) {
												echo esc_attr(date(MJ_amgt_date_formate(), strtotime($result->occupied_end_date)));
											} elseif (isset($_POST['occupied_end_date']))
												echo esc_attr($_POST['occupied_end_date']); ?>">
										<label class="active" id="my_label_add" for="middle_name">
											<?php esc_html_e('Occupied End Date', 'apartment_mgt'); ?><span
												class="require-field">*</span>
										</label>
									</div>
								</div>
							</div>
						<!-- </div> -->
						<?php
					}
					?>
					<!------------------ OCCUPIED INFORMATION ------------------>

					<!------------------ MEMBER INFORMATION ------------------>

					<div class="header">
						<h3 class="first_hed">
							<?php esc_html_e('Member Information', 'apartment_mgt'); ?>
						</h3>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="add_first_name"
									class="form-control validate[required,custom[onlyLetter_specialcharacter]] text-input"
									maxlength="50" type="text" value="<?php if ($edit) {
										echo esc_attr($result->first_name);
									} elseif (isset($_POST['first_name']))
										echo esc_attr($_POST['first_name']); ?>" name="first_name">
								<label class="" for="middle_name">
									<?php esc_html_e('First Name', 'apartment_mgt'); ?><span class="require-field">*</span>
								</label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">

								<script>

								</script>

								<input id="middle_name " class="form-control validate[custom[onlyLetter_specialcharacter]]"
									maxlength="50" type="text" value="<?php if ($edit) {
										echo esc_attr($result->middle_name);
									} elseif (isset($_POST['middle_name']))
										echo esc_attr($_POST['middle_name']); ?>" name="middle_name">
								<label class="" for="middle_name">
									<?php esc_html_e('Middle Name', 'apartment_mgt'); ?>
								</label>

							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="add_last_name"
									class="form-control validate[required,custom[onlyLetter_specialcharacter]] text-input"
									maxlength="50" type="text" value="<?php if ($edit) {
										echo esc_attr($result->last_name);
									} elseif (isset($_POST['last_name']))
										echo esc_attr($_POST['last_name']); ?>" name="last_name">
								<label class="" for="middle_name">
									<?php esc_html_e('Last Name', 'apartment_mgt'); ?><span class="require-field">*</span>
								</label>
							</div>
						</div>
					</div>
					
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="birth_date" class="form-control validate[required] label_overlp"
									autocomplete="off" type="text" name="birth_date" value="<?php if ($edit) {
										if(!empty($result->birth_date))
										echo esc_attr(date("Y-m-d", strtotime($result->birth_date)));
										else
										echo date(MJ_amgt_date_formate());
									} elseif (isset($_POST['birth_date']))
										echo esc_attr($_POST['birth_date']); else echo date(MJ_amgt_date_formate()); ?>" readonly>
								<label class="birthdate_label active" id="my_label_add" for="middle_name">
									<?php esc_html_e('Date of Birth', 'apartment_mgt'); ?><span
										class="require-field">*</span>
								</label>
							</div>
						</div>
					</div>
					<script>
						// $(document).ready(function() {
						// 	$('.label_overlp').click(function() {
						// 		// alert("Hello! I am an alert box!!");
						// 		$('.ui-state-default').click(function() {
						// 		$('#my_label_add').addClass('active');
						// 		});
						// 	});
						// });
					</script>

					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 res_margin_bottom_20px rtl_margin_top_15px">
						<div class="form-group">
							<div class="col-md-12 form-control">
								<div class="row padding_radio">
									<div class="input-group">
										<label class="custom-top-label" for="gender">
											<?php esc_html_e('Gender', 'apartment_mgt'); ?><span
												class="require-field">*</span>
										</label>
										<div class="d-inline-block gender_line_height_24px">
											<?php $genderval = "male";
											if ($edit) {
												if(!empty($result->gender))
												$genderval = $result->gender;
											} elseif (isset($_POST['gender'])) {
												$genderval = $_POST['gender'];
											} ?>
											<label class="radio-inline custom_radio admin_radio">
												<input type="radio" value="male" class="tog" name="gender" <?php checked('male', $genderval); ?> />
												<?php esc_html_e('Male', 'apartment_mgt'); ?>
											</label>
											<label class="radio-inline custom_radio admin_radio">
												<input type="radio" value="female" class="tog" name="gender" <?php checked('female', $genderval); ?> />
												<?php esc_html_e('Female', 'apartment_mgt'); ?>
											</label>

										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="email"
									class="amgt_email_id_validation form-control validate[required,custom[email]] text-input"
									type="text" maxlength="50" name="email" value="<?php if ($edit) {
										echo esc_attr($result->user_email);
									} elseif (isset($_POST['email']))
										echo esc_attr($_POST['email']); ?>">
								<label class="" for="middle_name">
									<?php esc_html_e('Email', 'apartment_mgt'); ?><span class="require-field">*</span>
								</label>
							</div>
							<div class="email_validation_div">
								<div class="formError"
									style="opacity: 0.87; position: absolute; top: 33px; left: 482.5px; margin-top: 0px; display: block;">
									<div class="formErrorArrow formErrorArrowBottom">
										<div class="line1"><!-- --></div>
										<div class="line2"><!-- --></div>
										<div class="line3"><!-- --></div>
										<div class="line4"><!-- --></div>
										<div class="line5"><!-- --></div>
										<div class="line6"><!-- --></div>
										<div class="line7"><!-- --></div>
										<div class="line8"><!-- --></div>
										<div class="line9"><!-- --></div>
										<div class="line10"><!-- --></div>
									</div>
									<div class="formErrorContent">
										<?php esc_html_e('Email id Already Exist.', 'apartment_mgt'); ?><br>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="password" class="form-control <?php if (!$edit)
									echo 'validate[required]'; ?>" type="password" name="password" minlength="8" maxlength="12" value="">
								<label class="" for="middle_name">
									<?php esc_html_e('Password', 'apartment_mgt'); ?>
									<?php if (!$edit) { ?> <span class="require-field">*</span>
									<?php } ?>
								</label>
							</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="row">
							<div class="col-md-4">
								<div class="form-group input margin_bottom_0">
									<div class="col-md-12 form-control">
										<input type="text" readonly
											value="+<?php echo MJ_amgt_get_countery_phonecode(get_option('amgt_contry')); ?>"
											class="form-control" name="phonecode">
										<label for="phonecode" class="pl-2 popup_countery_code_css">
											<?php esc_html_e('Country Code', 'apartment_mgt'); ?><span
												class="required red">*</span>
										</label>
									</div>
								</div>
							</div>
							<div class="col-md-8">
								<div class="form-group input margin_bottom_0">
									<div class="col-md-12 form-control">
										<input id="mobile"
											class="form-control validate[required,custom[phone_number],minSize[6],maxSize[15]]] text-input"
											type="number" min="6" onKeyPress="if(this.value.length==15) return false;"
											name="mobile" value="<?php if ($edit) {
												echo esc_attr($result->mobile);
											} elseif (isset($_POST['mobile']))
												echo esc_attr($_POST['mobile']); ?>">
										<label class="" for="mobile">
											<?php esc_html_e('Mobile Number', 'apartment_mgt'); ?><span
												class="require-field">*</span>
										</label>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 mb-3 rtl_margin_top_15px">
						<div class="form-group">
							<div class="col-md-12 form-control">
								<div class="row padding_radio">
									<div class="margin_bottom_3px">
										<label class="custom-top-label" for="member_convert">
											<?php esc_html_e('Committee Member', 'apartment_mgt'); ?>
										</label>
										<input id="committee_member" class="" type="checkbox" <?php if ($edit == 1 && $result->committee_member == 'yes') {
											echo "checked";
										} ?> name="committee_member"
											value="<?php echo esc_attr('yes'); ?>">
										<?php esc_attr_e('Yes', 'apartment_mgt'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php
					if ($edit == 1 && $result->committee_member == 'yes') {
						?>
						<div id="designaion_area" class="col-md-6 row padding_right_0">
							<div class="col-sm-12 col-md-10 col-lg-10 col-xl-10 input">
								<label class="ml-1 custom-top-label top" for="role_type">
									<?php esc_html_e('Designation', 'apartment_mgt'); ?><span class="require-field">*</span>
								</label>
								<select class="form-select validate[required] designation_cat" name="designation_id">
									<option value="">
										<?php esc_html_e('Select Designation', 'apartment_mgt'); ?>
									</option>
									<?php
									if ($edit)
										$category = $result->designation_id;
									else
										$category = "";

									$activity_category = MJ_amgt_get_all_category('designation_cat');
									if (!empty($activity_category)) {
										foreach ($activity_category as $retrive_data) {
											echo '<option value="' . $retrive_data->ID . '" ' . selected($category, $retrive_data->ID) . '>' . $retrive_data->post_title . '</option>';
										}
									} ?>
								</select>
							</div>
							<div class="col-sm-12 col-md-2 col-lg-2 col-xl-2 mb-3 rtl_margin_top_15px padding_right_0">
								<button type="button" id="addremove" class="btn add_btn" model="designation_cat">
									<?php esc_html_e('Add', 'apartment_mgt'); ?>
								</button>
							</div>
						</div>
						<?php
					} else {
						?>
						<div class="col-md-6" id="designaion_area">
						</div>
						<?php
					}
					?>
				</div>
			</div>
			<!------------------ MEMBER INFORMATION ------------------>


			
			<!--------------------- FAMILY INFORMATION----------------------->

		<div class="row mb-1">
			<div class="header col-9 col-md-11">
				<h3 class="first_hed">
					<?php esc_html_e('Family Information', 'apartment_mgt'); ?>
				</h3>
			</div>
			<div class="col-3 col-md-1 symptoms_deopdown_div mb-3 rtl_margin_top_15px">
				<img src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/Add_new_Button.png" ?>"
					id="add_new_family_member" name="add_new_entry" alt="" class="" />
			</div>

		</div>


		<div class="form-body user_form"> <!-- user_form Strat-->
				<?php
				if ($edit) {
					$user_id = $_REQUEST['member_id'];
					$family_member_id = get_user_meta($user_id, 'family_member_id', true);

					$membersdata = array(); // Initialize an empty array to store all user meta data
					if (!empty($family_member_id)) {
						$total_members = count($family_member_id);
						$current_member = 1;
						foreach ($family_member_id as $family_id) {
							$family_data = get_userdata($family_id);
							$family_meta_data = get_user_meta($family_id);
							?>

							<div class="form-body user_form"> <!-- user_form Start-->
								<div class="row"><!--Row Div Start-->
									<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 ">
										<div class="form-group input">
											<div class="col-md-12 form-control">
												<input id="first_name_<?php echo $family_id; ?>"
													class="form-control validate[custom[onlyLetter_specialcharacter]] text-input"
													maxlength="50" type="text"
													value="<?php echo isset($family_meta_data['first_name'][0]) ? esc_attr($family_meta_data['first_name'][0]) : ''; ?>"
													name="family_first_name[]">
												<label class="" for="middle_name">
													<?php esc_html_e('First Name', 'apartment_mgt'); ?><span
														class="require-field"></span>
												</label>
											</div>
										</div>
									</div>
									<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 ">
										<div class="form-group input">
											<div class="col-md-12 form-control">
												<input id="last_name_<?php echo $family_id; ?>"
													class="form-control validate[custom[onlyLetter_specialcharacter]] text-input"
													maxlength="50" type="text"
													value="<?php echo isset($family_meta_data['last_name'][0]) ? esc_attr($family_meta_data['last_name'][0]) : ''; ?>"
													name="family_last_name[]">
												<label class="" for="middle_name">
													<?php esc_html_e('Last Name', 'apartment_mgt'); ?><span
														class="require-field"></span>
												</label>
											</div>
										</div>
									</div>
									<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 ">
										<div class="form-group input">
											<div class="col-md-12 form-control">
												<input id="family_birth_date_<?php echo $family_id; ?>"
													class="form-control label_overlp" autocomplete="off" type="text"
													name="family_birth_date[]"
													value="<?php echo isset($family_meta_data['birth_date'][0]) ? esc_attr(date("Y-m-d", strtotime($family_meta_data['birth_date'][0]))) : ''; ?>"
													readonly>
												<label class="birthdate_label active" id="my_label_add" for="middle_name">
													<?php esc_html_e('Date of Birth', 'apartment_mgt'); ?><span
														class="require-field"></span>
												</label>
											</div>
										</div>
									</div>
									<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 res_margin_bottom_20px rtl_margin_top_15px">
										<div class="form-group">
											<div class="col-md-12 form-control">
												<div class="row padding_radio">
													<div class="input-group">
														<label class="custom-top-label" for="gender">
															<?php esc_html_e('Gender', 'apartment_mgt'); ?><span
																class="require-field"></span>
														</label>
														<div class="d-inline-block gender_line_height_24px">
															<?php
															$gender_val = isset($family_meta_data['gender'][0]) ? $family_meta_data['gender'][0] : 'male';
															?>
															<label class="radio-inline custom_radio admin_radio">
																<input type="radio" value="male" class="tog"
																	name="family_gender_<?php echo $family_id; ?>" <?php checked('male', $gender_val); ?> />
																<?php esc_html_e('Male', 'apartment_mgt'); ?>
															</label>
															<label class="radio-inline custom_radio admin_radio">
																<input type="radio" value="female" class="tog"
																	name="family_gender_<?php echo $family_id; ?>" <?php checked('female', $gender_val); ?> />
																<?php esc_html_e('Female', 'apartment_mgt'); ?>
															</label>
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>

								<div class="row">
									<div class="col-md-6">
										<div class="row">
											<div class="col-md-4">
												<div class="form-group input margin_bottom_0">
													<div class="col-md-12 form-control">
														<input type="text" readonly
															value="+<?php echo MJ_amgt_get_countery_phonecode(get_option('amgt_contry')); ?>"
															class="form-control" name="phonecode">
														<label for="family_phonecode" class="pl-2 popup_countery_code_css">
															<?php esc_html_e('Country Code', 'apartment_mgt'); ?><span
																class="required red"></span>
														</label>
													</div>
												</div>
											</div>
											<div class="col-md-8">
												<div class="form-group input margin_bottom_0">
													<div class="col-md-12 form-control">
														<input id="family_mobile_<?php echo $family_id; ?>"
															class="form-control validate[custom[phone_number],minSize[6],maxSize[15]]] text-input"
															type="number" min="6" onKeyPress="if(this.value.length==15) return false;"
															name="family_mobile[]"
															value="<?php echo isset($family_meta_data['mobile'][0]) ? esc_attr($family_meta_data['mobile'][0]) : ''; ?>">
														<label class="" for="family_mobile_<?php echo $family_id; ?>">
															<?php esc_html_e('Mobile Number', 'apartment_mgt'); ?><span
																class="require-field"></span>
														</label>
													</div>
												</div>
											</div>
										</div>
									</div>
									<div class="col-sm-12 col-md-5 col-lg-5 col-xl-5 input">
										<label class="ml-1 custom-top-label top" for="role_type">
											<?php esc_html_e('Family Type', 'apartment_mgt'); ?><span class="require-field"></span>
										</label>
										<select class="form-select" name="family_type[]" id="family_type_<?php echo $family_id; ?>">
											<option value="">
												<?php esc_html_e('Select Family Type', 'apartment_mgt'); ?>
											</option>
											<?php
											$category = isset($family_meta_data['member_type'][0]) ? $family_meta_data['member_type'][0] : '';
											?>
											<option value="owner_family" <?php selected($category, 'owner_family'); ?>>
												<?php esc_html_e('Owner Family', 'apartment_mgt'); ?>
											</option>
											<option value="tenant_family" <?php selected($category, 'tenant_family'); ?>>
												<?php esc_html_e('Tenant Family', 'apartment_mgt'); ?>
											</option>
											<option value="care_taker" <?php selected($category, 'care_taker'); ?>>
												<?php esc_html_e('Care Taker', 'apartment_mgt'); ?>
											</option>
										</select>
									</div>
									<div
										class="col-sm-12 col-md-1 col-lg-1 col-xl-1 input symptoms_deopdown_div mb-3 rtl_margin_top_15px">
										<img src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>"
											onclick="deleteformBodyElement(this, '<?php echo $family_id; ?>')" alt="" class="">
									</div>

								</div>
							</div>
							<?php
							if ($current_member < $total_members) {
								echo '<hr/>';
							}
							$current_member++;
						}
					}

				} else {
					?>
					<div class="row"><!--Row Div Strat-->
						<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="family_first_name"
										class="form-control validate[custom[onlyLetter_specialcharacter]] text-input"
										maxlength="50" type="text" value="<?php if ($edit) {
											echo esc_attr($result->family_first_name);
										} elseif (isset($_POST['first_name']))
											echo esc_attr($_POST['first_name']); ?>" name="family_first_name[]">
									<label class="" for="middle_name">
										<?php esc_html_e('First Name', 'apartment_mgt'); ?><span class="require-field"></span>
									</label>
								</div>
							</div>
						</div>
						<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="_last_name"
										class="form-control validate[custom[onlyLetter_specialcharacter]] text-input"
										maxlength="50" type="text" value="<?php if ($edit) {
											echo esc_attr($result->family_last_name);
										} elseif (isset($_POST['last_name']))
											echo esc_attr($_POST['last_name']); ?>" name="family_last_name[]">
									<label class="" for="middle_name">
										<?php esc_html_e('Last Name', 'apartment_mgt'); ?><span class="require-field"></span>
									</label>
								</div>
							</div>
						</div>
						<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="family_birth_date" class="form-control label_overlp" autocomplete="off"
										type="text" name="family_birth_date[]" value="<?php if ($edit) {
											echo esc_attr(date("Y-m-d", strtotime($result->birth_date)));
										} elseif (isset($_POST['birth_date']))
											echo esc_attr($_POST['birth_date']); ?>" readonly>
									<label class="birthdate_label active" id="my_label_add" for="middle_name">
										<?php esc_html_e('Date of Birth', 'apartment_mgt'); ?><span
											class="require-field"></span>
									</label>
								</div>
							</div>
						</div>
						<div class="col-sm-3 col-md-3 col-lg-3 col-xl-3 res_margin_bottom_20px rtl_margin_top_15px">
							<div class="form-group">
								<div class="col-md-12 form-control">
									<div class="row padding_radio">
										<div class="input-group">
											<label class="custom-top-label" for="gender">
												<?php esc_html_e('Gender', 'apartment_mgt'); ?><span
													class="require-field"></span>
											</label>
											<div class="d-inline-block gender_line_height_24px">
												<?php $genderval = "male";
												if ($edit) {
													$genderval = $result->gender;
												} elseif (isset($_POST['gender'])) {
													$genderval = $_POST['gender'];
												} ?>
												<label class="radio-inline custom_radio admin_radio">
													<input type="radio" value="male" class="tog" name="family_gender_0" <?php checked('male', $genderval); ?> />
													<?php esc_html_e('Male', 'apartment_mgt'); ?>
												</label>
												<label class="radio-inline custom_radio admin_radio">
													<input type="radio" value="female" class="tog" name="family_gender_0" <?php checked('female', $genderval); ?> />
													<?php esc_html_e('Female', 'apartment_mgt'); ?>
												</label>

											</div>
										</div>
									</div>
								</div>
							</div>
						</div>

					</div>
					<div class="row">
						<div class="col-md-6">
							<div class="row">
								<div class="col-md-4">
									<div class="form-group input margin_bottom_0">
										<div class="col-md-12 form-control">
											<input type="text" readonly
												value="+<?php echo MJ_amgt_get_countery_phonecode(get_option('amgt_contry')); ?>"
												class="form-control" name="phonecode">
											<label for="family_phonecode" class="pl-2 popup_countery_code_css">
												<?php esc_html_e('Country Code', 'apartment_mgt'); ?><span
													class="required red"></span>
											</label>
										</div>
									</div>
								</div>
								<div class="col-md-8">
									<div class="form-group input margin_bottom_0">
										<div class="col-md-12 form-control">
											<input id="family_mobile"
												class="form-control validate[custom[phone_number],minSize[6],maxSize[15]]] text-input"
												type="number" min="6" onKeyPress="if(this.value.length==15) return false;"
												name="family_mobile[]" value="<?php if ($edit) {
													echo $result->mobile;
												} elseif (isset($_POST['mobile']))
													echo esc_attr($_POST['mobile']); ?>">
											<label class="" for="family_mobile">
												<?php esc_html_e('Mobile Number', 'apartment_mgt'); ?><span
													class="require-field"></span>
											</label>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="col-sm-12 col-md-6 col-lg-6 col-xl-6 input">
							<label class="ml-1 custom-top-label top" for="role_type">
								<?php esc_html_e('Family Type', 'apartment_mgt'); ?><span class="require-field"></span>
							</label>
							<select class="form-select" name="family_type[]" id="family_type">
								<option value="">
									<?php esc_html_e('Select Family Type', 'apartment_mgt'); ?>
								</option>
								<?php
								if ($edit) {
									$category = $result->member_type;
								} elseif (isset($_POST['member_type'])) {
									$category = $_POST['member_type'];
								} else {
									$category = "";
								} ?>
								<option value="owner_family" <?php selected($category, 'owner_family'); ?>>
									<?php esc_html_e('Owner Family', 'apartment_mgt'); ?>
								</option>
								<option value="tenant_family" <?php selected($category, 'tenant_family'); ?>>
									<?php esc_html_e('Tenant Family', 'apartment_mgt'); ?>
								</option>
								<option value="care_taker" <?php selected($category, 'care_taker'); ?>>
									<?php esc_html_e('Care Taker', 'apartment_mgt'); ?>
								</option>
							</select>
						</div>

					</div>
					<?php

				}
				?>
			</div>
			<div id="family_member_entry"></div>
			<!-- ------------------- FAMILY INFORMATION----------------------->
		<!------------------ ADDRESS INFORMATION ------------------>
			<div class="header">
				<h3 class="first_hed">
					<?php esc_html_e('Address Information', 'apartment_mgt'); ?>
				</h3>
			</div>
			<div class="form-body user_form"> <!-- user_form Strat-->
				<div class="row"><!--Row Div Strat-->
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="address" class="form-control validate[custom[address_description_validation]]"
									type="text" maxlength="150" name="address" value="<?php if ($edit) {
										echo esc_attr($result->address);
									} elseif (isset($_POST['address']))
										echo esc_attr($_POST['address']); ?>">
								<label class="" for="middle_name">
									<?php esc_html_e('Address', 'apartment_mgt'); ?>
								</label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="city_name" class="form-control validate[custom[city_state_country_validation]]"
									maxlength="50" type="text" name="city_name" value="<?php if ($edit) {
										echo esc_attr($result->city_name);
									} elseif (isset($_POST['city_name']))
										echo esc_attr($_POST['city_name']); ?>">
								<label class="" for="middle_name">
									<?php esc_html_e('City', 'apartment_mgt'); ?>
								</label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input class="form-control validate[custom[city_state_country_validation]]" type="text"
									maxlength="50" name="state_name" value="<?php if ($edit) {
										echo esc_attr($result->state_name);
									} elseif (isset($_POST['state_name']))
										echo esc_attr($_POST['state_name']); ?>">
								<label class="" for="middle_name">
									<?php esc_html_e('State', 'apartment_mgt'); ?>
								</label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input class="form-control validate[custom[city_state_country_validation]]" type="text"
									maxlength="50" name="country_name" value="<?php if ($edit) {
										echo esc_attr($result->country_name);
									} elseif (isset($_POST['country_name']))
										echo esc_attr($_POST['country_name']); ?>">
								<label class="" for="middle_name">
									<?php esc_html_e('Country', 'apartment_mgt'); ?>
								</label>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input class="form-control validate[custom[onlyLetterNumber]]" maxlength="15" type="text"
									name="zipcode" value="<?php if ($edit) {
										echo esc_attr($result->zipcode);
									} elseif (isset($_POST['zipcode']))
										echo esc_attr($_POST['zipcode']); ?>">
								<label class="" for="middle_name">
									<?php esc_html_e('Zip Code', 'apartment_mgt'); ?>
								</label>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!------------------ ADDRESS INFORMATION ------------------>

			<!------------------ OTHER INFORMATION ------------------>
			<div class="header">
				<h3 class="first_hed">
					<?php esc_html_e('Other Information', 'apartment_mgt'); ?>
				</h3>
			</div>
			<div class="form-body user_form"> <!-- user_form Strat-->
				<div class="row"><!--Row Div Strat-->

					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
						<div class="form-group input">
							<div class="col-md-12 form-control upload-profile-image-patient">
								<label class="ustom-control-label custom-top-label ml-2" for="photo">
									<?php esc_html_e('Image', 'apartment_mgt'); ?>
								</label>
								<div class="col-sm-12 display_flex">
									<input type="text" id="amgt_user_avatar_url"
										class="image_path_dots form-control gmgt_user_avatar_url" name="amgt_user_avatar"
										value="<?php if ($edit)
											echo esc_url($result->amgt_user_avatar);
										elseif (isset($_POST['amgt_user_avatar']))
											echo $_POST['amgt_user_avatar']; ?>" readonly />
									<input id="upload_user_avatar_button" type="button"
										class="button upload_image_btn upload_user_avatar_button"
										value="<?php esc_html_e('Upload image', 'apartment_mgt'); ?>" />
								</div>
							</div>
							<div class="clearfix"></div>
							<div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">
								<div id="upload_user_avatar_preview" class="upload_user_avatar_preview">
									<?php
									if ($edit) {
										if ($result->amgt_user_avatar == "") {
											?>
											<img class="image_preview_css"
												src="<?php echo esc_url(get_option('amgt_member_new_thumb')); ?>">
											<?php
										} else {
											?>
											<img class="image_preview_css" src="<?php if ($edit)
												echo esc_url($result->amgt_user_avatar); ?>" />
											<?php
										}
									} else {
										?>
										<img class="image_preview_css"
											src="<?php echo esc_url(get_option('amgt_member_new_thumb')); ?>">
										<?php
									}
									?>
								</div>
							</div>
						</div>
					</div>
					<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
						<div class="form-group input">
							<div class="col-md-12 form-control">
								<input id="gst_no" class="form-control validate[custom[onlyLetterNumber]] text-input"
									maxlength="15" type="text" value="<?php if ($edit) {
										echo esc_attr($result->gst_no);
									} elseif (isset($_POST['gst_no']))
										echo esc_attr($_POST['gst_no']); ?>" name="gst_no">
								<label class="" for="middle_name">
									<?php esc_html_e('GST Number', 'apartment_mgt'); ?>
								</label>
							</div>
						</div>
					</div>
					<?php
					if ($edit) {
						?>
						<div
							class="<?php if ($result->id_proof_1) { ?> col-sm-4 col-md-4 col-lg-4 col-xl-4 <?php } else { ?> col-sm-6 col-md-6 col-lg-6 col-xl-6 <?php } ?>">
							<div class="form-group input">
								<div class="col-md-12 form-control upload-profile-image-patient">
									<label class="ustom-control-label custom-top-label ml-2" for="photo">
										<?php esc_html_e('Member ID Proof-1', 'apartment_mgt'); ?>
									</label>
									<div class="col-sm-12 display_flex">
										<input id="upload_file" onchange="fileCheck(this);" name="id_proof_1" value=""
											type="file" />
										<input type="hidden" name="hidden_id_proof_1" value="<?php if ($edit) {
											echo $result->id_proof_1;
										} elseif (isset($_POST['id_proof_1']))
											echo $_POST['id_proof_1']; ?>">
									</div>
								</div>
							</div>
						</div>
						<?php
						if (isset($result->id_proof_1) && $result->id_proof_1 != "") {
							?>
							<div class="col-sm-2 col-md-2 col-lg-2 col-xl-2 padding_right_0px rtl_margin_top_15px mb-3">
								<a download target="blank"
									href="<?php echo esc_url(content_url() . '/uploads/apartment_assets/' . sanitize_file_name($result->id_proof_1)); ?>"
									class="btn add_btn"><span class="btn_line_height_35px"><i class="fa fa-download"></i>
										<?php esc_html_e('Download', 'apartment_mgt'); ?>
									</span></a>
							</div>
							<?php
						}
					} else {
						?>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
							<div class="form-group input">
								<div class="col-md-12 form-control upload-profile-image-patient">
									<label class="ustom-control-label custom-top-label ml-2" for="photo">
										<?php esc_html_e('Member ID Proof-1', 'apartment_mgt'); ?>
									</label>
									<div class="col-sm-12 display_flex">
										<input id="upload_file" onchange="fileCheck(this);" name="id_proof_1" type="file" />
									</div>
								</div>
							</div>
						</div>
						<?php
					}
					if ($edit) {
						?>
						<div
							class="<?php if ($result->id_proof_2) { ?> col-sm-4 col-md-4 col-lg-4 col-xl-4 <?php } else { ?> col-sm-6 col-md-6 col-lg-6 col-xl-6 <?php } ?>">
							<div class="form-group input">
								<div class="col-md-12 form-control upload-profile-image-patient">
									<label class="ustom-control-label custom-top-label ml-2" for="photo">
										<?php esc_html_e('Lease Agreement', 'apartment_mgt'); ?>
									</label>
									<div class="col-sm-12 display_flex">
										<input type="hidden" name="hidden_id_proof_2" value="<?php if ($edit) {
											echo $result->id_proof_2;
										} elseif (isset($_POST['id_proof_2']))
											echo $_POST['id_proof_2']; ?>">
										<input id="upload_file" onchange="fileCheck(this);" name="id_proof_2" value=""
											type="file" />
									</div>
								</div>
							</div>
						</div>
						<?php
						if (isset($result->id_proof_2) && $result->id_proof_2 != "") {
							?>
							<div class="col-sm-2 col-md-2 col-lg-2 col-xl-2 padding_right_0px rtl_margin_top_15px mb-3">
								<a download target="blank"
									href="<?php echo esc_url(content_url() . '/uploads/apartment_assets/' . sanitize_file_name($result->id_proof_2)); ?>"
									class="btn add_btn"><span class="btn_line_height_35px"><i class="fa fa-download"></i>
										<?php esc_html_e('Download', 'apartment_mgt'); ?>
									</span></a>
							</div>
							<?php
						}
					} else {
						?>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6">
							<div class="form-group input">
								<div class="col-md-12 form-control upload-profile-image-patient">
									<label class="ustom-control-label custom-top-label ml-2" for="photo">
										<?php esc_html_e('Lease Agreement', 'apartment_mgt'); ?>
									</label>
									<div class="col-sm-12 display_flex">
										<input id="upload_file" onchange="fileCheck(this);" name="id_proof_2" type="file" />
									</div>
								</div>
							</div>
						</div>
						<?php
					}

					?>


					<?php
					if ($edit) {
						$doc_data = get_user_meta($member_id, 'document', true);
						$data_new = json_decode($doc_data);
						if (!empty($data_new)) {
							$i = 0;
							foreach ($data_new as $data) {
								?>
								<div class="header">
									<h3 class="first_hed">
										<?php esc_html_e('Other Document', 'apartment_mgt'); ?>
									</h3>
								</div>
								<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
									<div class="form-group input">
										<div class="col-md-12 form-control">
											<input id="doc_title" maxlength="50"
												class="form-control  text-input onlyletter_number_space_validation" type="text"
												placeholder="<?php esc_html_e('Title', 'apartment_mgt'); ?>" value="<?php if ($edit)
													   echo esc_attr($data->title); ?>" name="doc_title[]">
											<label class="" for="middle_name">
												<?php esc_html_e('Title', 'apartment_mgt'); ?>
											</label>
										</div>
									</div>
								</div>
								<div
									class="<?php if ($data->value) { ?> col-sm-4 col-md-4 col-lg-4 col-xl-4 <?php } else { ?>  col-sm-6 col-md-6 col-lg-6 col-xl-6 <?php } ?>">
									<div class="form-group input">
										<div class="col-md-12 form-control upload-profile-image-patient">
											<label class="ustom-control-label custom-top-label ml-2" for="photo">
												<?php esc_html_e('Upload Document', 'apartment_mgt'); ?>
											</label>
											<div class="col-sm-12 display_flex">
												<input id="upload_file" onchange="fileCheck(this);" name="upload_file[]" class=""
													type="file" />
											</div>
										</div>
									</div>
								</div>
								<?php
								if (isset($data->value) && $data->value != "") {
									?>
									<div class="col-sm-2 col-md-2 col-lg-2 col-xl-2 padding_right_0px rtl_margin_top_15px mb-3">
										<a download target="blank"
											href="<?php echo esc_url(content_url() . '/uploads/apartment_assets/' . sanitize_file_name($data->value)); ?>"
											class="btn add_btn"><span class="btn_line_height_35px"><i class="fa fa-download"></i>
												<?php esc_html_e('Download', 'apartment_mgt'); ?>
											</span></a>
									</div>
									<?php
								}
								?>
								<input type="hidden" name="hidden_upload_file[]" value="<?php if ($edit) {
									echo $data->value;
								} elseif (isset($_POST['upload_file']))
									echo $_POST['upload_file']; ?>">
								<?php
							}
						}
					} else {
						?>
						<div class="header">
							<h3 class="first_hed">
								<?php esc_html_e('Other Document', 'apartment_mgt'); ?>
							</h3>
						</div>
						<div class="col-sm-6 col-md-6 col-lg-6 col-xl-6 ">
							<div class="form-group input">
								<div class="col-md-12 form-control">
									<input id="doc_title" maxlength="50"
										class="form-control validate[custom[onlyLetter_specialcharacter]] text-input"
										type="text" value="<?php if ($edit)
											echo esc_attr($result->doc_title); ?>" name="doc_title[]">
									<label class="" for="middle_name">
										<?php esc_html_e('Title', 'apartment_mgt'); ?>
									</label>
								</div>
							</div>
						</div>
						<div class="col-sm-5 col-md-5 col-lg-5 col-xl-5 padding_right_0">
							<div class="form-group input">
								<div class="col-md-12 form-control upload-profile-image-patient">
									<label class="ustom-control-label custom-top-label ml-2" for="photo">
										<?php esc_html_e('Upload Document', 'apartment_mgt'); ?>
									</label>
									<div class="col-sm-12 display_flex">
										<input id="upload_file" onchange="fileCheck(this);" name="upload_file[]" type="file"
											<?php if ($edit) { ?>class="" <?php } else { ?>class="margin_left_15_res" <?php } ?> />
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-1 symptoms_deopdown_div mb-3 rtl_margin_top_15px">
							<img src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/Add_new_Button.png" ?>"
								id="add_new_document_entry_member" name="add_new_entry" alt="" class="">
						</div>
						<div id="document_entry_member"></div>
						<?php
					}
					?>


				</div>
			</div>
			<!------------------ OTHER INFORMATION ------------------>




			<?php wp_nonce_field('save_member_nonce'); ?>
			<div class="form-body user_form"> <!-- user_form Strat-->
				<div class="row"><!--Row Div Strat-->
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
						<input type="submit" value="<?php if ($edit) {
							esc_html_e('Save', 'apartment_mgt');
						} else {
							esc_html_e('Add Member', 'apartment_mgt');
						} ?>" name="save_member" class="btn save_btn" />
					</div>
				</div>
			</div>
		</form><!---END ADD MEMBER FORM--->
</div><!--END PANEL BODY-->
	<?php
}
//}                                                     ?>
<!----------Add_unit_form---------------------->
<div class="modal fade overflow_scroll" id="myModal_add_building" tabindex="-1" aria-labelledby="myModal_add_building"
	role="dialog" aria-modal="true">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header float_left_width_100 mb-3 pop_btn_bg"><!--MODAL HEADER--->
				<h3 class="modal-title float_left">
					<?php esc_html_e('Add Building', 'apartment_mgt'); ?>
				</h3>
				<button type="button" class="close float_right" data-bs-dismiss="modal" aria-label="Close"><img
						src="<?php echo AMS_PLUGIN_URL . "/assets/images/dashboard_icon/Close.png" ?>" alt=""></button>
			</div>
			<div class="modal-body"><!--MODAL BODY-->
				<script type="text/javascript">
					$(document).ready(function () {
						//UNIT FORM VALIDATION
						"use strict";
						$('#unit_form').validationEngine({ promptPosition: "bottomLeft", maxErrorsPerField: 1 });
						$('.onlyletter_number_space_validation').keypress(function (e) {
							var regex = new RegExp("^[0-9a-zA-Z \b]+$");
							var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
							if (!regex.test(key)) {
								event.preventDefault();
								return false;
							}
						});

					});
				</script>
				<!---UNIT FORM --->
				<form name="unit_form" method="post" action="<?php echo admin_url('admin-ajax.php'); ?>"
					class="form-horizontal" id="unit_form">
					<input id="" type="hidden" name="action" value="MJ_amgt_add_unit_popup">

					<div class="form-body user_form"> <!-- user_form Strat-->
						<div class="row"><!--Row Div Strat-->

							<div class="col-sm-12 col-md-4 col-lg-4 col-xl-4 input">
								<label class="ml-1 custom-top-label top" for="activity_category">
									<?php esc_html_e('Compound', 'apartment_mgt'); ?><span
										class="require-field">*</span>
								</label>
								<select class="form-select validate[required] building_category" name="building_id"
									id="add_building_id">
									<option value="">
										<?php esc_html_e('Select Compound', 'apartment_mgt'); ?>
									</option>
									<?php
									$activity_category = MJ_amgt_get_all_category('building_category');
									if (!empty($activity_category)) {
										foreach ($activity_category as $retrive_data) {
											echo '<option value="' . $retrive_data->ID . '">' . $retrive_data->post_title . '</option>';
										}
									} ?>
								</select>
							</div>
							<div class="col-sm-12 col-md-2 col-lg-2 col-xl-2 mb-3 rtl_margin_top_15px">
								<button class="btn add_btn" id="addremove" model="building_category">
									<?php esc_html_e('Add', 'apartment_mgt'); ?>
								</button>
							</div>

							<!----UNIT CATEGORY--->
							<div class="col-sm-12 col-md-4 col-lg-4 col-xl-4 input">
								<label class="ml-1 custom-top-label top" for="activity_category">
									<?php esc_html_e('Unit Category', 'apartment_mgt'); ?><span
										class="require-field">*</span>
								</label>
								<select class="form-select validate[required] unit_category" name="unit_cat_id" id="add_unit_category">
									<option value="">
										<?php esc_html_e('Select Unit Category', 'apartment_mgt'); ?>
									</option>
									<?php
									$activity_category = MJ_amgt_get_all_category('unit_category');
									if (!empty($activity_category)) {
										foreach ($activity_category as $retrive_data) {
											echo '<option value="' . $retrive_data->ID . '">' . $retrive_data->post_title . '</option>';
										}
									} ?>
								</select>
							</div>
							<div class="col-sm-12 col-md-2 col-lg-2 col-xl-2 mb-3 rtl_margin_top_15px">
								<button class="btn add_btn" id="addremove" model="unit_category">
									<?php esc_html_e('Add', 'apartment_mgt'); ?>
								</button>
							</div>

							<?php
							if (isset($_POST['unit_names'])) {
								$all_data = $obj_units->MJ_amgt_get_entry_records($_POST);
								$all_entry = json_decode($all_data);
							}
							?>
							<div class="add_more_time_entry" id="unit_name_entry"><!---UNIT NAME ENTRY---->
								<div class="time_entry">
									<div class="form-body user_form my_unit_div">
										<div class="row">

											<div class="col-md-6">
												<div class="form-group input">
													<div class="col-md-12 form-control">
														<input
															class="onlyletter_number_space_validation form-control validate[required] text-input unit_name"
															type="text" value="" maxlength="30" name="unit_names[]"
															placeholder="<?php esc_html_e('Unit Name', 'apartment_mgt'); ?>">
														<label class="" for="unit_entry">
															<?php esc_html_e('Unit Name', 'apartment_mgt'); ?><span
																class="require-field">*</span>
														</label>
													</div>
												</div>
											</div>

											<div class="col-md-5">
												<div class="form-group input">
													<div class="col-md-12 form-control">
														<?php $unit_measerment_type = get_option('amgt_unit_measerment_type'); ?>
														<input class="form-control validate[required] text-input"
															type="number" value="" min="0" name="unit_size[]"
															onKeyPress="if(this.value.length==6) return false;"
															placeholder="<?php esc_html_e('Unit Size', 'apartment_mgt'); ?>">
														<label class="" for="unit_entry">
															<?php esc_html_e('Unit Size', 'apartment_mgt'); ?>(
															<?php if ($unit_measerment_type == 'square_meter') {
																echo esc_html_e('square meter', 'apartment_mgt');
															} else {
																echo esc_attr($unit_measerment_type);
															}

															?>)<span class="require-field">*</span>
														</label>
													</div>
												</div>
											</div>

											<div class="col-md-1 symptoms_deopdown_div mb-3 rtl_margin_top_15px">
												<img src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/Add_new_Button.png" ?>"
													onclick="add_entry123()" alt="" name="add_new_entry" class=""
													id="add_new_entry">
											</div>
										</div>
									</div>
								</div>
							</div>

						</div><!--Row Div End-->
					</div><!-- user_form End-->
					<!----------   save btn    -------------->
					<div class="form-body user_form"> <!-- user_form Strat-->
						<div class="row"><!--Row Div Strat-->
							<div class="col-md-6 col-sm-6 col-xs-12">
								<?php $unit_type = get_option('amgt_apartment_type'); ?>
								<input type="submit"
									value="<?php esc_html_e('Add ' . $unit_type . ' Unit', 'apartment_mgt'); ?>"
									name="save_residential_unit" class="btn save_btn" />
							</div>
						</div><!--Row Div End-->
					</div><!-- user_form End-->
				</form><!---END UNIT FORM--->
			</div>
			<div class="modal-footer"><!---MODAL FOOTER--->
			</div>
		</div>
	</div>
</div>

<script>
	// CREATING BLANK INVOICE ENTRY
	var blank_income_entry = '';
	$(document).ready(function () {
		blank_expense_entry = $('#unit_name_entry').html();
	});

	function add_entry123() {
		$(".add_more_time_entry").append('<div class="form-body user_form my_unit_div"><div class="row"><div class="col-md-6"><div class="form-group input"><div class="col-md-12 form-control"><input class="onlyletter_number_space_validation form-control validate[required] text-input unit_name" type="text" value="" maxlength="30" name="unit_names[]" placeholder="<?php esc_html_e('Unit Name', 'apartment_mgt'); ?>" ><label class="active" for="unit_entry"><?php esc_html_e('Unit Name', 'apartment_mgt'); ?><span class="require-field">*</span></label></div></div></div><div class="col-md-5"><div class="form-group input"><div class="col-md-12 form-control"><?php $unit_measerment_type = get_option('amgt_unit_measerment_type'); ?><input  class="form-control validate[required] text-input" type="number" value="" min="0" name="unit_size[]" onKeyPress="if(this.value.length==6) return false;" placeholder="<?php esc_html_e('Unit Size', 'apartment_mgt'); ?>" ><label class="active" for="unit_entry"><?php esc_html_e('Unit Size', 'apartment_mgt'); ?>(<?php if ($unit_measerment_type == 'square_meter') {
							echo esc_html_e('square meter', 'apartment_mgt');
						} else {
							echo esc_attr($unit_measerment_type);
						} ?>) <span class="require-field">*</span></label ></div ></div ></div > <div class="col-sm-1 symptoms_deopdown_div rtl_margin_top_15px mb-3"><img src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>" onclick="deleteParentElement(this)" class="entypo-trash" alt=""></div></div ></div > ');
	}


	// REMOVING INVOICE ENTRY
	function deleteParentElement(n) {

		if (confirm(language_translate.add_remove)) {
			n.parentNode.parentNode.parentNode.removeChild(n.parentNode.parentNode);
		}
	}
	function deleteformBodyElement(n, member_id) {
		if (confirm(language_translate.add_remove)) {
			// Store the member_id in a hidden input field
			$('<input>').attr({
				type: 'hidden',
				name: 'deleted_members[]',
				value: member_id
			}).appendTo('form');

			// Remove the entire form-body element
			$(n).closest('.form-body.user_form').remove();
		}
	}


</script>
<?php ?>