<?php
$active_tab_1 = sanitize_text_field(isset($_GET['tab_1'])?$_GET['tab_1']:'graph');
?>
<ul class="nav nav-tabs amgt_report_tab panel_tabs margin_left_1per list-unstyled mailbox-nav  flex-nowrap overflow-auto">
	<li <?php if(isset($_REQUEST['tab_1']) && $_REQUEST['tab_1'] == 'graph'){?>class="active"<?php }?>>
		<a href="?page=amgt-report&tab=income&tab_1=graph" class="padding_left_0 tab <?php echo esc_html($active_tab_1) == 'graph' ? 'nav-tab-active' : ''; ?>">
			<?php echo esc_html__('Graph', 'apartment_mgt'); ?>
		</a>
	<li>
	<li <?php if(isset($_REQUEST['tab_1']) && $_REQUEST['tab_1'] == 'datatable'){?>class="active"<?php }?>>
		<a href="?page=amgt-report&tab=income&tab_1=datatable" class="padding_left_0 tab <?php echo esc_html($active_tab_1) == 'datatable' ? 'nav-tab-active' : ''; ?>">
			<?php echo esc_html__('Datatable', 'apartment_mgt'); ?>
		</a>
	<li>
</ul>
<?php
if($_REQUEST['tab_1'] == 'graph')
{
	$invoice_data= $obj_account->MJ_amgt_get_all_invoice();
	foreach($invoice_data as $retrieved_data)
	{
		$datetime = DateTime::createFromFormat('Y-m-d',$retrieved_data->start_date);
		$year_new = $datetime->format('Y');
		$year =isset($year_new)?$year_new:date('Y');
	}
	$current_year = Date("Y");
	$month =array('1'=>esc_html__('Jan','apartment_mgt'),'2'=>esc_html__('Feb','apartment_mgt'),'3'=>esc_html__('Mar','apartment_mgt'),'4'=>esc_html__('Apr','apartment_mgt'),'5'=>esc_html__('May','apartment_mgt'),'6'=>esc_html__('Jun','apartment_mgt'),'7'=>esc_html__('Jul','apartment_mgt'),'8'=>esc_html__('Aug','apartment_mgt'),'9'=>esc_html__('Sep','apartment_mgt'),'10'=>esc_html__('Oct','apartment_mgt'),'11'=>esc_html__('Nov','apartment_mgt'),'12'=>esc_html__('Dec','apartment_mgt'),);
	$result = array();
	$dataPoints_2 = array();
	//array_push($dataPoints_2, array('Month','Income','Expense'));
	array_push($dataPoints_2, array(esc_html__('Month','apartment_mgt'),esc_html__('Income','apartment_mgt')));
	$dataPoints_1 = array();
	$currency_symbol = MJ_amgt_get_currency_symbol(get_option( 'apartment_currency_code' ));
	foreach($month as $key=>$value)
	{
		global $wpdb;
		$table_name = $wpdb->prefix."amgt_created_invoice_list";

		$q = $wpdb->prepare("SELECT SUM(total_amount) as amount FROM $table_name WHERE YEAR(start_date) = %d AND MONTH(start_date) = %d",$year, $key);
        $result = $wpdb->get_results($q);        
		$income_amount = $wpdb->prepare("SELECT SUM(total_amount) as amount FROM $table_name WHERE YEAR(start_date) = %d",$year);        
        $result_income=$wpdb->get_results($income_amount);
        
		array_push($dataPoints_2, array($value,$result[0]->amount));
	}

	$new_array = json_encode($dataPoints_2);

	if(!empty($result_income))
	{
		$new_currency_symbol = html_entity_decode($currency_symbol);
		?>
		
		<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
		<script type="text/javascript">
			google.charts.load('current', {'packages':['bar']});
			google.charts.setOnLoadCallback(drawChart);

			function drawChart() {
				var data = google.visualization.arrayToDataTable(<?php echo $new_array; ?>);

				var options = {
				
					bars: 'vertical', // Required for Material Bar Charts.
					colors: ['#104B73', '#FF9054'],
					
				};
			
				var chart = new google.charts.Bar(document.getElementById('barchart_material'));

				chart.draw(data, google.charts.Bar.convertOptions(options));
			}
		</script>
		<div id="barchart_material" style="width:100%;height: 430px; padding:20px;"></div>
		<?php
	}
	else
	{
		?>
		<div class="calendar-event-new"> 
			<img class="no_data_img" src="<?php echo AMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
		</div>
		<?php	
	}
}
if($_REQUEST['tab_1'] == 'datatable')
{
    ?>
    <script type="text/javascript">
		$(document).ready(function() 
		{
			"use strict";
			var table = jQuery('#tbleincome').DataTable(
			{
				"order": [[ 0, "Desc" ]],
				dom: 'lifrtp',
                buttons:[
                    {
                        extend: 'csv',
                        text:'<?php esc_html_e('CSV', 'apartment_mgt') ?>',
                        title: 'Monthly Report',
                    },
                    {
                        extend: 'print',
						text:'<?php esc_html_e('Print', 'apartment_mgt') ?>',
                        title: 'Monthly Report',
                    },
                ],
				"aoColumns":[
					{"bSortable": false},
					{"bSortable": true},
					{"bSortable": true},
					{"bSortable": true},
					{"bSortable": true}
				],
				language:<?php echo MJ_amgt_datatable_multi_language();?>		   
			});
            $('.btn-place').html(table.buttons().container()); 
			$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'apartment_mgt') ?>");
		} );
	</script>
   
    <div class="panel-body clearfix margin_top_20px">
        <form method="post" id="income_payment">  
            <div class="form-body user_form">
                <div class="row">
                    <div class="col-md-3 mb-3 input">
                        <label class="ml-1 custom-top-label top" for="class_id"><?php esc_attr_e('Date Type','apartment_mgt');?><span class="require-field">*</span></label>			
                            <select class="line_height_30px form-control date_type validate[required]" name="date_type" autocomplete="off">
                               <option value=""><?php esc_attr_e('Select','apartment_mgt');?></option>
                                <option value="today"><?php esc_attr_e('Today','apartment_mgt');?></option>
                                <option value="this_week"><?php esc_attr_e('This Week','apartment_mgt');?></option>
                                <option value="last_week"><?php esc_attr_e('Last Week','apartment_mgt');?></option>
                                <option value="this_month"><?php esc_attr_e('This Month','apartment_mgt');?></option>
                                <option value="last_month"><?php esc_attr_e('Last Month','apartment_mgt');?></option>
                                <option value="last_3_month"><?php esc_attr_e('Last 3 Months','apartment_mgt');?></option>
                                <option value="last_6_month"><?php esc_attr_e('Last 6 Months','apartment_mgt');?></option>
                                <option value="last_12_month"><?php esc_attr_e('Last 12 Months','apartment_mgt');?></option>
                                <option value="this_year"><?php esc_attr_e('This Year','apartment_mgt');?></option>
                                <option value="last_year"><?php esc_attr_e('Last Year','apartment_mgt');?></option>
                                <option value="period"><?php esc_attr_e('Period','apartment_mgt');?></option>
                            </select>
                    </div>
                    <div id="date_type_div" class="date_type_div_none row col-md-6 mb-2"></div>	
                    <div class="col-md-3 mb-2">
                        <input type="submit" name="income_payment" Value="<?php esc_attr_e('Go','apartment_mgt');?>"  class="btn btn-info save_btn"/>
                    </div>
                </div>
            </div>
        </form> 
    </div>	
    <?php
    if(isset($_REQUEST['income_payment']))
    {
        $date_type = $_POST['date_type'];
        if($date_type=="period")
        {
            $start_date = $_REQUEST['start_date'];
            $end_date = $_REQUEST['end_date'];
        }
        else
        {
            $result =  mj_amgt_all_date_type_value($date_type);
    
            $response =  json_decode($result);
            $start_date = $response[0];
            $end_date = $response[1];
        }
    }
    else
    {
        $start_date = date('Y-m-d');
        $end_date= date('Y-m-d');
    }
    global $wpdb;
    $table_name=$wpdb->prefix.'amgt_invoice_payment_history';
    $result = $wpdb->get_results(
        $wpdb->prepare("SELECT * FROM $table_name WHERE date BETWEEN %s AND %s",$start_date, $end_date)
    );
    
    if(!empty($_POST['date_type']))
    {
        ?>
        <div class="btn-place"></div>
        <form name="wcwm_report" action="" method="post"><!--EXPENSE LIST FORM START-->
            <table id="tbleincome" class="display" cellspacing="0" width="100%"><!--EXPENSE LIST TABLE START-->
                <thead>
                    <tr>
                        <th><?php esc_html_e('Image','apartment_mgt'); ?></th>
                        <th><?php esc_html_e('Id','apartment_mgt'); ?></th>
                        <th><?php esc_html_e('Member Name','apartment_mgt'); ?></th>
                        <th><?php esc_html_e('Date','apartment_mgt'); ?></th>
                        <th><?php esc_html_e('Amount','apartment_mgt'); ?></th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th><?php esc_html_e('Image','apartment_mgt'); ?></th>
                        <th><?php esc_html_e('Id','apartment_mgt'); ?></th>
                        <th><?php esc_html_e('Member Name','apartment_mgt'); ?></th>
                        <th><?php esc_html_e('Date','apartment_mgt'); ?></th>
                        <th><?php esc_html_e('Amount','apartment_mgt'); ?></th>
                    </tr>
                </tfoot>
                <tbody>
                    <?php 
                    if(!empty($result))
                    {
                        $i=1;
                        foreach ($result as $retrieved_data)
                        { 
                            if($i == 10)
                            {
                                $i=0;
                            }
                            if($i == 0)
                            {
                                $color_class='smgt_class_color0';
                            }
                            elseif($i == 1)
                            {
                                $color_class='smgt_class_color1';
                            }
                            elseif($i == 2)
                            {
                                $color_class='smgt_class_color2';
                            }
                            elseif($i == 3)
                            {
                                $color_class='smgt_class_color3';
                            }
                            elseif($i == 4)
                            {
                                $color_class='smgt_class_color4';
                            }
                            elseif($i == 5)
                            {
                                $color_class='smgt_class_color5';
                            }
                            elseif($i == 6)
                            {
                                $color_class='smgt_class_color6';
                            }
                            elseif($i == 7)
                            {
                                $color_class='smgt_class_color7';
                            }
                            elseif($i == 8)
                            {
                                $color_class='smgt_class_color8';
                            }
                            elseif($i == 9)
                            {
                                $color_class='smgt_class_color9';
                            }
                            ?>
                            <tr>
                                <td class="user_image width_50px profile_image_prescription padding_left_0">	
                                    <p class="prescription_tag padding_15px margin_bottom_0px <?php echo $color_class; ?>">	
                                        <img src="<?php echo  AMS_PLUGIN_URL."/assets/images/Sidemenu/Account-white.png"?>" alt="" class="massage_image center image_icon_height_25px margin_top_3px">
                                    </p>
                                </td>
                                <td class="end_date"><?php echo esc_html($i); ?> </td>
                                <td class="end_date"><?php echo esc_html(MJ_amgt_apartment_get_display_name($retrieved_data->member_id)); ?> </td>
                                <td class="end_date"><?php echo esc_html($retrieved_data->date); ?> </td>
                                <td class="end_date"><?php echo esc_html($retrieved_data->amount); ?> </td>
                            </tr>
                            <?php
                            $i++;
                        }
                    }
                ?>
                </tbody>
            </table><!--EXPENSE LIST TABLE END-->
        </form><!--EXPENSE LIST FORM END-->
        <?php
    }
    else
    {
        ?>
        <div class="calendar-event-new"> 
            <img class="no_data_img" src="<?php echo AMS_PLUGIN_URL."/assets/images/dashboard_icon/no_data_img.png"?>" >
        </div>	
        <?php
    }
    ?>
   
    <?php
}
?>