<?php
if (!defined('ABSPATH')) {
    exit;
}
$active_tab = sanitize_text_field(isset ($_GET['tab']) ? $_GET['tab'] : 'sloat-list');
$obj_parking = new MJ_amgt_Parking;
$obj_units = new MJ_amgt_ResidentialUnit;
?>
<!-- user redirect url enter -->
<?php
$user_access = MJ_amgt_add_check_access_for_view('slot');
if ($user_access == 'administrator') {
	$user_access_add = 1;
	$user_access_edit = 1;
	$user_access_delete = 1;
	$user_access_view = 1;
} else {
	$user_access_view = $user_access['view'];
	$user_access_add = $user_access['add'];
	$user_access_edit = $user_access['edit'];
	$user_access_delete = $user_access['delete'];

	if (isset ($_REQUEST['page'])) {
		if ($user_access_view == '0') {
			mj_amgt_access_right_page_not_access_message_admin_side();
			die;
		}
		if (!empty ($_REQUEST['action'])) {
			if ('slot' == $user_access['page_link'] && $_REQUEST['action'] == 'edit') {
				if ($user_access_edit == '0') {
					mj_amgt_access_right_page_not_access_message_admin_side();
					die;
				}
			}
			if ('slot' == $user_access['page_link'] && $_REQUEST['action'] == 'add') {
				if ($user_access_add == '0') {
					mj_amgt_access_right_page_not_access_message_admin_side();
					die;
				}
			}
			if ('slot' == $user_access['page_link'] && $_REQUEST['action'] == 'delete') {
				if ($user_access_delete == '0') {
					mj_amgt_access_right_page_not_access_message_admin_side();
					die;
				}
			}
		}
	}
}
?>
<!-- user redirect url enter code end -->

<script type="text/javascript">
	$(document).ready(function () {
		//SLOT LIST DATATABLE
		"use strict";
		jQuery('#sloat_list').DataTable(
			{
				// "responsive": true,
				dom: 'lifrtp',
				"order": [[2, "desc"]],
				"aoColumns": [
					{ "bSortable": false },
					{ "bSortable": false },
					{ "bSortable": true },
					{ "bSortable": true },
					{ "bSortable": true },
					{ "bSortable": true },
					{ "bSortable": false }],
				language: <?php echo MJ_amgt_datatable_multi_language(); ?>,
				responsive: {
					details: {
						display: $.fn.dataTable.Responsive.display.modal({
							header: function (row) {
								var data = row.data();
								return 'Details for ' + data[2];
							}
						}),
						renderer: $.fn.dataTable.Responsive.renderer.tableAll()
					}
				}
			});
		$('.dataTables_filter input').attr("placeholder", "<?php esc_html_e('Search...', 'apartment_mgt') ?>");
	});

	$(document).ready(function () {
		"use strict";
		jQuery('.select_all').on('click', function (e) {
			if ($(this).is(':checked', true)) {
				$(".sub_chk").prop('checked', true);
				$(".select_all").prop('checked', true);
			}
			else {
				$(".sub_chk").prop('checked', false);
				$(".select_all").prop('checked', false);
			}
		});
		$("body").on("change", ".sub_chk", function () {
			if (false == $(this).prop("checked")) {
				$(".select_all").prop('checked', false);
			}
			if ($('.sub_chk:checked').length == $('.sub_chk').length) {
				$(".select_all").prop('checked', true);
			}
		});
		$("#delete_selected11").on('click', function () {

			if ($('.select-checkbox:checked').length == 0) {
				alert(language_translate.select_atleast_one_record);
				return false;
			}
			else {
				var alert_msg = confirm("<?php esc_js('Are you sure you want to delete this record?', 'apartment_mgt') ?>");
				if (alert_msg == false) {
					return false;
				}
				else {
					return true;
				}
			}
		});
	});
</script>

<div class="page-inner min_height_1088"><!---PAGE INNER---->
	<?php
	if (isset ($_POST['save_sloat']))	//SAVE SLOT	
	{
		$nonce = sanitize_text_field($_POST['_wpnonce']);
		if (wp_verify_nonce($nonce, 'save_sloat_nonce')) {
			if (isset ($_REQUEST['action']) && $_REQUEST['action'] == 'edit') {
				if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'edit_action')) {
					$result = $obj_parking->MJ_amgt_add_sloat($_POST);
					// if ($result) {
						wp_redirect(admin_url() . 'admin.php?page=amgt-parking-mgt&tab=sloat-list&message=2');
					// }
				} else {
					wp_die('Security check failed!');
				}
			} else {
				$result = $obj_parking->MJ_amgt_add_sloat($_POST);
				if ($result) {
					wp_redirect(admin_url() . 'admin.php?page=amgt-parking-mgt&tab=sloat-list&message=1');
				}
			}
		}
	}
	if (isset ($_POST['assign_sloat']))//ASSIGN SLOT	
	{
		$nonce = sanitize_text_field($_POST['_wpnonce']);
		if (wp_verify_nonce($nonce, 'assign_sloat_nonce')) {
			$slaot_id = $_POST['sloat_id'];
			$from_date = MJ_amgt_get_format_for_db($_POST['from_date']);
			$to_date = MJ_amgt_get_format_for_db($_POST['to_date']);

			if (isset ($_REQUEST['action']) && $_REQUEST['action'] == 'edit') {
				if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'edit_action')) {
					global $wpdb;
					$table_name = $wpdb->prefix . 'amgt_parking';

					$sloat_assign_id = $_POST['sloat_assign_id'];
						$query = $wpdb->prepare(
						"SELECT * FROM $table_name 
						WHERE sloat_id = %d 
						AND (
							(from_date BETWEEN %s AND %s AND to_date BETWEEN %s AND %s) 
							OR (%s BETWEEN from_date AND to_date) 
							OR (%s BETWEEN from_date AND to_date)
						) 
						AND id <> %d",
						$slaot_id,
						$from_date, $to_date, $from_date, $to_date,
						$from_date, $to_date,
						$sloat_assign_id
					);
					$result_allready_assigned = $wpdb->get_results($query);


					if (!empty ($result_allready_assigned)) {
						wp_redirect(admin_url() . 'admin.php?page=amgt-parking-mgt&tab=assign_sloat&action=edit&sloat_assign_id=' . $_REQUEST['sloat_assign_id'] . '&message=4');
					} else {
						$result = $obj_parking->MJ_amgt_assign_sloat($_POST);
						// if ($result) {
							wp_redirect(admin_url() . 'admin.php?page=amgt-parking-mgt&tab=assigned-sloat-list&message=6');
						// }
					}
				} else {
					wp_die('Security check failed!');
				}
			} else {
				global $wpdb;
				$table_name = $wpdb->prefix . 'amgt_parking';
				$query = $wpdb->prepare(
					"SELECT * FROM $table_name 
					WHERE sloat_id = %d 
					AND (
						(from_date BETWEEN %s AND %s AND to_date BETWEEN %s AND %s) 
						OR (%s BETWEEN from_date AND to_date) 
						OR (%s BETWEEN from_date AND to_date)
					)",
					$slaot_id,
					$from_date, $to_date, $from_date, $to_date,
					$from_date, $to_date
				);

				$result_allready_assigned = $wpdb->get_results($query);


				if (!empty ($result_allready_assigned)) {
					wp_redirect(admin_url() . 'admin.php?page=amgt-parking-mgt&tab=assign_sloat&message=4');
				} else {
					$result = $obj_parking->MJ_amgt_assign_sloat($_POST);
					if ($result) {
						wp_redirect(admin_url() . 'admin.php?page=amgt-parking-mgt&tab=assigned-sloat-list&message=5');
					}
				}
			}
		}
	}
	if (isset ($_REQUEST['action']) && $_REQUEST['action'] == 'delete')//DELETE SLOT
	{
		if (isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'delete_action')) {
			if (isset ($_REQUEST['sloat_id'])) {
				$result = $obj_parking->MJ_amgt_delete_sloat(Mj_amgt_decrypt_id($_REQUEST['sloat_id']));
				if ($result) {
					wp_redirect(admin_url() . 'admin.php?page=amgt-parking-mgt&tab=sloat-list&message=3');
				}
			}
			if (isset ($_REQUEST['sloat_assign_id'])) {
				$result = $obj_parking->MJ_amgt_delete_assigned_sloat(Mj_amgt_decrypt_id($_REQUEST['sloat_assign_id']));
				if ($result) {
					wp_redirect(admin_url() . 'admin.php?page=amgt-parking-mgt&tab=assigned-sloat-list&message=3');
				}
			}
		} else {
			wp_die('Security check failed!');
		}

	}

	if (isset ($_REQUEST['slot_list_delete'])) {
		if (!isset($_POST['bulk_delete_nonce']) || !wp_verify_nonce($_POST['bulk_delete_nonce'], 'bulk_delete_calls_action')) {
        wp_die('Security check failed.'); // or handle the error gracefully
    }	
		if (isset ($_REQUEST['selected_id'])) {
			foreach ($_REQUEST['selected_id'] as $id) {
				$result = $obj_parking->MJ_amgt_delete_sloat($id);

			}
			if ($result) {
				wp_redirect(admin_url() . 'admin.php?page=amgt-parking-mgt&tab=sloat-list&message=3');
			}
		}
		if (isset ($_REQUEST['sloat_assign_id'])) {
			foreach ($_REQUEST['sloat_assign_id'] as $id) {
				$result = $obj_parking->MJ_amgt_delete_assigned_sloat($id);

			}
			if ($result) {
				wp_redirect(admin_url() . 'admin.php?page=amgt-parking-mgt&tab=assigned-sloat-list&message=3');
			}
		} else {
			echo '<script language="javascript">';
			echo 'alert("' . esc_html__('Please select at least one record.', 'apartment_mgt') . '")';
			echo '</script>';

		}

	}

	if (isset ($_REQUEST['message']))//MESSAGE
	{
		$message = $_REQUEST['message'];
		if ($message == 1) { ?>
			<div id="message" class="updated below-h2 notice is-dismissible">
				<p>
					<?php
					esc_html_e('Slot inserted successfully', 'apartment_mgt');
					?>
				</p>
			</div>
			<?php

		} elseif ($message == 2) { ?>
			<div id="message" class="updated below-h2 notice is-dismissible">
				<p>
					<?php
					esc_html_e("Slot updated successfully.", 'apartment_mgt');
					?>
				</p>
			</div>
		<?php

		} elseif ($message == 3) { ?>
			<div id="message" class="updated below-h2 notice is-dismissible">
				<p>
					<?php
					esc_html_e('Slot deleted successfully', 'apartment_mgt'); ?>
			</div>
			</p>
			<?php

		} elseif ($message == 4) { ?>
			<div id="message" class="updated below-h2 notice is-dismissible">
				<p>
					<?php
					esc_html_e('This Parking Slot Already Assigned', 'apartment_mgt'); ?>
			</div>
			</p>
			<?php

		}
		if ($message == 5) { ?>
			<div id="message" class="updated below-h2 notice is-dismissible">
				<p>
					<?php
					esc_html_e('Slot Assign inserted successfully', 'apartment_mgt');
					?>
				</p>
			</div>
			<?php

		} elseif ($message == 6) { ?>
			<div id="message" class="updated below-h2 notice is-dismissible">
				<p>
					<?php
					esc_html_e("Slot Assign updated successfully.", 'apartment_mgt');
					?>
				</p>
			</div>
		<?php

		}

	} ?>
	<div id="" class="ams_main_list"><!--MAIN-WRAPPER-->
		<div class="row">
			<div class="padding_left_8px"><!--PANEL-WHITE-->
				<div class="panel-body padding_0"><!--PANEL BODY-->
					<!--END NAV TAB WRAPPER-->
					<?php
					//SLOT LIST TAB
					if ($active_tab == 'sloat-list') {
						$sloatdata = $obj_parking->MJ_amgt_get_all_sloats();
						if (!empty ($sloatdata)) {
							?>
							<div class="panel-body padding_0"><!--PANEL BODY-->
								<div class="table-responsive"><!---TABLE-RESPONSIVE--->
							<form action="" method="post">
								<?php wp_nonce_field('bulk_delete_calls_action', 'bulk_delete_nonce'); ?>
								<table id="sloat_list" class="display" cellspacing="0" width="100%">
									<!---SLOT LIST TABLE--->
									<thead class="<?php echo MJ_amgt_datatable_heder(); ?>">
										<tr>
											<th class="padding_0"><input type="checkbox" class="select_all"
													id="select_all"></th>
											<th>
												<?php esc_html_e('Image', 'apartment_mgt'); ?>
											</th>
											<th>
												<?php esc_html_e('Slot Name', 'apartment_mgt'); ?>
											</th>
											<th>
												<?php esc_html_e('Slot Type', 'apartment_mgt'); ?>
											</th>
											<th>
												<?php esc_html_e('Status', 'apartment_mgt'); ?>
											</th>
											<th>
												<?php esc_html_e('Allotted Start to End Date', 'apartment_mgt'); ?>
											</th>
											<th class="text_align_end">
												<?php esc_html_e('Action', 'apartment_mgt'); ?>
											</th>
										</tr>
									</thead>
									<tfoot>
										<tr>
											<th class="padding_0"><input type="checkbox" class="select_all"
													id="select_all"></th>
											<th>
												<?php esc_html_e('Image', 'apartment_mgt'); ?>
											</th>
											<th>
												<?php esc_html_e('Slot Name', 'apartment_mgt'); ?>
											</th>
											<th>
												<?php esc_html_e('Slot Type', 'apartment_mgt'); ?>
											</th>
											<th>
												<?php esc_html_e('Status', 'apartment_mgt'); ?>
											</th>
											<th>
												<?php esc_html_e('Allotted Start to End Date', 'apartment_mgt'); ?>
											</th>
											<th class="text_align_end">
												<?php esc_html_e('Action', 'apartment_mgt'); ?>
											</th>
										</tr>
									</tfoot>
									<tbody>
										<?php
										$i = 0;
										//$sloatdata=$obj_parking->MJ_amgt_get_all_sloats();
										if (!empty ($sloatdata)) {
											foreach ($sloatdata as $retrieved_data) {
												if ($i == 10) {
													$i = 0;
												}
												if ($i == 0) {
													$color_class = 'smgt_class_color0';
												} elseif ($i == 1) {
													$color_class = 'smgt_class_color1';
												} elseif ($i == 2) {
													$color_class = 'smgt_class_color2';
												} elseif ($i == 3) {
													$color_class = 'smgt_class_color3';
												} elseif ($i == 4) {
													$color_class = 'smgt_class_color4';
												} elseif ($i == 5) {
													$color_class = 'smgt_class_color5';
												} elseif ($i == 6) {
													$color_class = 'smgt_class_color6';
												} elseif ($i == 7) {
													$color_class = 'smgt_class_color7';
												} elseif ($i == 8) {
													$color_class = 'smgt_class_color8';
												} elseif ($i == 9) {
													$color_class = 'smgt_class_color9';
												}
												?>
										<tr>
											<td class="checkbox_width_10px">
												<input type="checkbox" name="selected_id[]"
													class="smgt_sub_chk select-checkbox sub_chk"
													value="<?php echo esc_attr($retrieved_data->id); ?>">
											</td>
											<td class="user_image width_50px profile_image_prescription padding_left_0">
												<p
													class="prescription_tag padding_15px margin_bottom_0px <?php echo $color_class; ?>">
													<a href="#" class="view-slot float_left_width_100"
														id="<?php echo esc_attr($retrieved_data->id); ?>">
														<img src="<?php echo AMS_PLUGIN_URL . "/assets/images/Sidemenu/Parking-white.png" ?>"
															alt=""
															class="massage_image center image_icon_height_25px margin_top_3px">
													</a>
												</p>
											</td>
											<?php
											$data_sloat_id = Mj_amgt_retrived_data_id($retrieved_data->id);
											$edit_action = mj_amgt_create_and_verify_nonce('edit');
											?>
											<td class="sloatname">
												<a
													href="?page=amgt-parking-mgt&tab=add_sloat&action=edit&sloat_id=<?php echo esc_attr($data_sloat_id); ?>&_wpnonce=<?php echo $edit_action; ?>" class="title_name">
													<?php echo esc_html($retrieved_data->sloat_name); ?>
												</a>
											</td>
											<td class="sloattype">
												<?php
												if ($retrieved_data->sloat_type == 'Staff') {
													echo esc_html__('Staff Member', 'apartment_mgt');
												} else {
													echo esc_html__('Member', 'apartment_mgt');
												} ?>
											</td>
											<td class="to">
												<?php

												$status = MJ_amgt_get_parking_record($retrieved_data->id);
												if (!empty ($status)) {
													$user_info = get_userdata($status->member_id);
												}

												?>
												<?php
												if (!empty ($status) && $status->status == 'alloted') {
													$user_info = get_userdata($status->member_id);
													if ($user_info && isset ($user_info->display_name)) {
														echo '<span class="occupied_status_color">' . esc_html__('Allotted', 'apartment_mgt') . '<a href="admin.php?page=amgt-member&tab=view_member&action=view&member_id=' . $status->member_id . '" class="member_name_status_color">' . "(" . esc_html($user_info->display_name) . ")" . '</a></span>';
													} else {
														echo '<span class="occupied_status_color">' . esc_html__('Allotted', 'apartment_mgt') . '</span>';
													}
												} else {
													echo '<span class="unoccupied_status_color">';
													echo esc_html__('Unallocated', 'apartment_mgt');
													echo '</span>';
												} ?>
											</td>
											<td class="to">
												<?php $status = MJ_amgt_get_parking_record($retrieved_data->id);
												if ($status) {
													?>
												<?php echo esc_html(date(MJ_amgt_date_formate(), strtotime($status->from_date))); ?>
												<?php _e('To', 'apartment_mgt'); ?>
												<?php echo esc_html(date(MJ_amgt_date_formate(), strtotime($status->to_date)));
												} else {
													echo "N/A";
												}
												?>
											</td>
											<td class="action">
												<div class="amgt-user-dropdown">
													<ul class="" style="margin-bottom: 0px !important;">
														<li class="">
															<a class="" href="#" data-bs-toggle="dropdown"
																aria-expanded="false">
																<img
																	src="<?php echo esc_url(AMS_PLUGIN_URL . "/assets/images/listpage_icon/More.png") ?>">
															</a>
															<ul class="dropdown-menu heder-dropdown-menu action_dropdawn"
																aria-labelledby="dropdownMenuLink">
																<li class="float_left_width_100">
																	<a href="#" class="view-slot float_left_width_100"
																		id="<?php echo $retrieved_data->id; ?>"><i
																			class="fa fa-eye"></i>
																		<?php esc_html_e('View', 'apartment_mgt'); ?>
																	</a>
																</li>
																<?php
																$edit_action = mj_amgt_create_and_verify_nonce('edit');
																if ($user_access_edit == 1) {
																	?>
																<li class="float_left_width_100 border_bottom_item">
																	<a href="?page=amgt-parking-mgt&tab=add_sloat&action=edit&sloat_id=<?php echo esc_attr($data_sloat_id); ?>&_wpnonce=<?php echo $edit_action; ?>"
																		class="float_left_width_100">
																		<i class="fa fa-edit"></i>
																		<?php esc_html_e('Edit', 'apartment_mgt'); ?>
																	</a>
																	</a>
																</li>
																<?php
																}
																$delete_action = mj_amgt_create_and_verify_nonce('delete');
																if ($user_access_delete == 1) {
																	?>
																<li class="float_left_width_100">
																	<a href="?page=amgt-parking-mgt&ab=sloat-list&action=delete&sloat_id=<?php echo esc_attr($data_sloat_id); ?>&_wpnonce=<?php echo $delete_action; ?>"
																		class="float_left_width_100 list_delete_btn"
																		onclick="return confirm('<?php esc_html_e('Do you really want to delete this record?', 'apartment_mgt'); ?>');">
																		<i class="fa fa-trash"></i>
																		<?php esc_html_e('Delete', 'apartment_mgt'); ?>
																	</a>
																</li>
																<?php
																}
																?>
															</ul>
														</li>
													</ul>
												</div>
											</td>
										</tr>
										<?php
										$i++;
											}

										} ?>
									</tbody>
								</table><!---END SLOT LIST TABLE--->
								<div class="print-button pull-left">
									<button class="btn btn-success btn-sms-color">
										<input type="checkbox" name="id[]" class="select_all"
											value="<?php echo esc_attr($retrieved_data->id); ?>"
											style="margin-top: 0px;">
										<label for="checkbox" class="margin_right_5px">
											<?php esc_html_e('Select All', 'apartment_mgt'); ?>
										</label>
									</button>
									<?php
									if ($user_access_delete == 1) {
										?>
									<button data-toggle="tooltip" id="delete_selected11"
										title="<?php esc_html_e('Delete Selected', 'apartment_mgt'); ?>"
										name="slot_list_delete" class="delete_selected">
										<img src="<?php echo AMS_PLUGIN_URL . "/assets/images/listpage_icon/Delete.png" ?>"
											alt="">
									</button>
									<?php
									}
									?>
								</div>
							</form>
						</div>
					</div><!---END PANEL BODY--->
					<?php
						} else {
							?>
					<div class="no_data_list_div">
						<?php
						if ($user_access_add == 1) {
							?>
						<a href="<?php echo admin_url() . 'admin.php?page=amgt-parking-mgt&tab=add_sloat'; ?>">
							<img class="width_100px" src="<?php echo get_option('amgt_no_data_img') ?>">
						</a>
						<div class="col-md-12 dashboard_btn margin_top_20px">
							<label class="no_data_list_label">
								<?php esc_html_e('Tap on above icon to add your first Record.', 'apartment_mgt'); ?>
							</label>
						</div>
						<?php
						}
						?>
					</div>
					<?php
						}
					}
					if ($active_tab == 'add_sloat') {
						require_once AMS_PLUGIN_DIR . '/admin/parking/add-sloat.php';
					}

					if ($active_tab == 'assigned-sloat-list') {
						require_once AMS_PLUGIN_DIR . '/admin/parking/assigned-sloat-list.php';
					}

					if ($active_tab == 'assign_sloat') {
						require_once AMS_PLUGIN_DIR . '/admin/parking/assign-sloat.php';
					} ?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php ?>