<?php
add_action( 'admin_menu', 'apartment_system_menu' );
function apartment_system_menu()
{
	$user_roles = MJ_amgt_get_user_role(get_current_user_id());
	
	if (!is_array($user_roles)) {
		$user_roles = array($user_roles); // Convert to array if it's a string
	}
	if (in_array('management', $user_roles))
	{
		add_menu_page(esc_html__('Apartment Management','apartment_mgt'),esc_html__('Apartment Management','apartment_mgt'),'management','amgt-apartment_system','apartment_system_dashboard',plugins_url('apartment-management/assets/images/apartment-management-3.png' ));
		
			if($_SESSION['amgt_verify'] == '')
			{
				add_submenu_page('amgt-apartment_system','Licence Settings',__('Licence Settings', 'apartment_mgt' ),'management','amgt-amgt_setup','apartment_system_dashboard');
			}
			
			add_submenu_page('amgt-apartment_system', esc_html__('Dashboard', 'apartment_mgt' ), esc_html__('Dashboard', 'apartment_mgt' ), 'management', 'amgt-apartment_system', 'apartment_system_dashboard');
			
			$unit_type=get_option( 'amgt_apartment_type' );
			
			if(MJ_amgt_add_check_access_for_view_add('resident_unit','view') == 1)
			{	
				if($unit_type == 'Residential')
				{	
					add_submenu_page('amgt-apartment_system', esc_html__('Residential Unit', 'apartment_mgt'), esc_html__('Residential Unit ', 'apartment_mgt'), 'management', 'amgt-residential_unit', 'apartment_system_dashboard');
				}
			}
			else
			{
				add_submenu_page('amgt-apartment_system', esc_html__('Residential Unit', 'apartment_mgt'), esc_html__('Commercial Unit ', 'apartment_mgt'), 'management', 'amgt-residential_unit', 'apartment_system_dashboard');
			}
									
			add_submenu_page('amgt-apartment_system', esc_html__('All User', 'apartment_mgt' ), esc_html__('All User', 'apartment_mgt' ), 'management', 'amgt-member', 'apartment_system_dashboard');

			if(MJ_amgt_add_check_access_for_view_add('committee-member','view') == 1)
			{	
				add_submenu_page('amgt-apartment_system', esc_html__('Committee Members', 'apartment_mgt' ), esc_html__('Committee Members', 'apartment_mgt' ), 'management', 'amgt-committee-member', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('managegate','view') == 1)
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Visitor Management', 'apartment_mgt' ), esc_html__('Visitor Management', 'apartment_mgt' ), 'management', 'amgt-visiter-manage', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('notice','view') == 1)
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Notice And Event', 'apartment_mgt' ), esc_html__('Notice And Event', 'apartment_mgt' ), 'management', 'amgt-notice-event', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('complaint','view') == 1)
			{
			add_submenu_page('amgt-apartment_system',esc_html__('Complaint', 'apartment_mgt' ), esc_html__('Complaint', 'apartment_mgt' ), 'management', 'amgt-complaint', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('slot','view') == 1)
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Parking Manager', 'apartment_mgt' ), esc_html__('Parking Manager', 'apartment_mgt' ), 'management', 'amgt-parking-mgt', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('service','view') == 1)
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Services', 'apartment_mgt' ), esc_html__('Services', 'apartment_mgt' ), 'management', 'amgt-service-mgt', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('facility','view') == 1)
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Facility', 'apartment_mgt' ), esc_html__('Facility', 'apartment_mgt' ), 'management', 'amgt-facility-mgt', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('tax','view') == 1)
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Tax', 'apartment_mgt' ), esc_html__('Tax', 'apartment_mgt' ), 'management', 'amgt-tax', 'apartment_system_dashboard');
			}
			if((MJ_amgt_add_check_access_for_view_add('tax','view') == 1) || (MJ_amgt_add_check_access_for_view_add('invoice','view') == 1) || (MJ_amgt_add_check_access_for_view_add('charges','view') == 1) || (MJ_amgt_add_check_access_for_view_add('expense','view') == 1))
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Accounts', 'apartment_mgt' ) , esc_html__('Accounts', 'apartment_mgt' ), 'management', 'amgt-accounts', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('documents','view') == 1)
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Documents', 'apartment_mgt' ), esc_html__('Documents', 'apartment_mgt' ), 'management', 'amgt-legal-documents', 'apartment_system_dashboard');
			}
			if((MJ_amgt_add_check_access_for_view_add('asset','view') == 1) ||(MJ_amgt_add_check_access_for_view_add('inventory','view') == 1))
			{
			add_submenu_page('amgt-apartment_system',  esc_html__('Asset/ Inventory Tracker', 'apartment_mgt' ), esc_html__('Asset/ Inventory Tracker', 'apartment_mgt' ), 'management', 'amgt-assets-inventory', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('emailtemplate','view') == 1)
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Mail Templates', 'apartment_mgt' ), esc_html__('Mail Templates', 'apartment_mgt' ), 'management', 'amgt-notification-templates', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('message','view') == 1)
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Message', 'apartment_mgt' ), esc_html__('Message', 'apartment_mgt' ), 'management', 'amgt-message', 'apartment_system_dashboard');
			}
			if((MJ_amgt_add_check_access_for_view_add('unitbuilding','view') == 1) || 
			(MJ_amgt_add_check_access_for_view_add('memberbuilding','view') == 1) || 
			(MJ_amgt_add_check_access_for_view_add('financepayment','view') == 1) || 
			(MJ_amgt_add_check_access_for_view_add('reportcomplaint','view') == 1) )
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Report', 'apartment_mgt' ), esc_html__('Report', 'apartment_mgt' ), 'management', 'amgt-report', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('generalsetting','view') == 1)
			{
			add_submenu_page('amgt-apartment_system', esc_html__('General Setting', 'apartment_mgt' ), esc_html__('General Setting', 'apartment_mgt' ), 'management', 'amgt-general_settings', 'apartment_system_dashboard');
			}
			if(MJ_amgt_add_check_access_for_view_add('accessright','view') == 1)
			{
			add_submenu_page('amgt-apartment_system', esc_html__('Access Right', 'apartment_mgt' ), esc_html__('Access Right', 'apartment_mgt' ), 'management', 'amgt-access_right', 'apartment_system_dashboard');
			}
			
	}  
	else
	{ 		      
		if (function_exists('amgt_setup'))  
		{
			add_menu_page(esc_html__('Apartment Management','apartment_mgt'), esc_html__('Apartment Management','apartment_mgt'),'manage_options','amgt-apartment_system','apartment_system_dashboard',plugins_url('apartment-management/assets/images/apartment-management-3.png' )); 
		
			if($_SESSION['amgt_verify'] == '')
			{
				add_submenu_page('amgt-apartment_system','Licence Settings',esc_html__('Licence Settings', 'apartment_mgt' ),'administrator','amgt-amgt_setup','apartment_system_dashboard');
			}
			add_submenu_page('amgt-apartment_system', esc_html__('Dashboard', 'apartment_mgt' ), esc_html__('Dashboard', 'apartment_mgt' ), 'administrator', 'amgt-apartment_system', 'apartment_system_dashboard');
			$unit_type=get_option( 'amgt_apartment_type' );
			
			if($unit_type == 'Residential')
			{	

				add_submenu_page('amgt-apartment_system', esc_html__('Residential Unit', 'apartment_mgt'), esc_html__('Residential Unit ', 'apartment_mgt'), 'administrator', 'amgt-residential_unit', 'apartment_system_dashboard');
			}
			else
			{
				
				add_submenu_page('amgt-apartment_system', esc_html__('Residential Unit', 'apartment_mgt'), esc_html__('Commercial Unit ', 'apartment_mgt'), 'administrator', 'amgt-residential_unit', 'apartment_system_dashboard');
			}
									
			add_submenu_page('amgt-apartment_system', esc_html__('All User', 'apartment_mgt' ), esc_html__('All User', 'apartment_mgt' ), 'administrator', 'amgt-member', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Committee Members', 'apartment_mgt' ), esc_html__('Committee Members', 'apartment_mgt' ), 'administrator', 'amgt-committee-member', 'apartment_system_dashboard');
				
			add_submenu_page('amgt-apartment_system', esc_html__('Visitor Management', 'apartment_mgt' ), esc_html__('Visitor Management', 'apartment_mgt' ), 'administrator', 'amgt-visiter-manage', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Notice And Event', 'apartment_mgt' ), esc_html__('Notice And Event', 'apartment_mgt' ), 'administrator', 'amgt-notice-event', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system',esc_html__('Complaint', 'apartment_mgt' ), esc_html__('Complaint', 'apartment_mgt' ), 'administrator', 'amgt-complaint', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Parking Manager', 'apartment_mgt' ), esc_html__('Parking Manager', 'apartment_mgt' ), 'administrator', 'amgt-parking-mgt', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Services', 'apartment_mgt' ), esc_html__('Services', 'apartment_mgt' ), 'administrator', 'amgt-service-mgt', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Facility', 'apartment_mgt' ), esc_html__('Facility', 'apartment_mgt' ), 'administrator', 'amgt-facility-mgt', 'apartment_system_dashboard');
				
			add_submenu_page('amgt-apartment_system', esc_html__('Tax', 'apartment_mgt' ), esc_html__('Tax', 'apartment_mgt' ), 'administrator', 'amgt-tax', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Accounts', 'apartment_mgt' ) , esc_html__('Accounts', 'apartment_mgt' ), 'administrator', 'amgt-accounts', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Documents', 'apartment_mgt' ), esc_html__('Documents', 'apartment_mgt' ), 'administrator', 'amgt-legal-documents', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system',  esc_html__('Asset/ Inventory Tracker', 'apartment_mgt' ), esc_html__('Asset/ Inventory Tracker', 'apartment_mgt' ), 'administrator', 'amgt-assets-inventory', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Mail Templates', 'apartment_mgt' ), esc_html__('Mail Templates', 'apartment_mgt' ), 'administrator', 'amgt-notification-templates', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Message', 'apartment_mgt' ), esc_html__('Message', 'apartment_mgt' ), 'administrator', 'amgt-message', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Report', 'apartment_mgt' ), esc_html__('Report', 'apartment_mgt' ), 'administrator', 'amgt-report', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('General Setting', 'apartment_mgt' ), esc_html__('General Setting', 'apartment_mgt' ), 'administrator', 'amgt-general_settings', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Access Right', 'apartment_mgt' ), esc_html__('Access Right', 'apartment_mgt' ), 'administrator', 'amgt-access_right', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('SMS Setting', 'apartment_mgt' ), esc_html__('SMS Setting', 'apartment_mgt' ), 'administrator', 'amgt-sms_setting', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('How To Videos', 'apartment_mgt' ), esc_html__('How To Videos', 'apartment_mgt' ), 'administrator', 'amgt-system_video', 'apartment_system_dashboard');
			
			add_submenu_page('amgt-apartment_system', esc_html__('Addons', 'apartment_mgt' ), esc_html__('Addons', 'apartment_mgt' ), 'administrator', 'amgt-system_addon', 'apartment_system_dashboard');
		}
	}
}
function apartment_system_dashboard()

{

	require_once AMS_PLUGIN_DIR. '/admin/dasboard.php';

}

function amgt_access_right_manage()
{
	require_once CMS_PLUGIN_DIR. '/admin/access_right/index.php';
}
?>